-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;
with SPARK_IO;
with SPARK_XML;

--# inherit E_Strings,
--#         FileSystem,
--#         SPARK_IO,
--#         SPARK_XML,
--#         SystemErrors;

package XMLReport
--# own State;
is

   type Sections is (
                     S_Report,
                     S_Prologue,
                     S_Commandline,
                     S_Compiler_Data,
                     S_Cyclic_Requirements,
                     S_Indexes,
                     S_Target_Config,
                     S_Messages,
                     S_Meta_Files,
                     S_Units_Not_Found,
                     S_Warnings_Config,
                     S_Results,
                     S_Listing,
                     S_Units_In_File,
                     S_Justifications,
                     S_Full_Justifications);

   Max_Meta_File_Depth : constant Integer := 50;

   subtype Meta_File_Id is SPARK_XML.Tag_Depth;

   procedure Init;
   --# global out State;
   --# derives State from ;

   -- Producers for simple container tags.
   -- These have no attributes of their own and only contain other tags.
   -- The only exception is the Listing tag, which contains large amounts of text,
   -- and is also included.

   procedure Start_Section (Section : in Sections;
                            Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State &
   --#         State             from *,
   --#                                Section;

   procedure End_Section (Section : in Sections;
                          Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State &
   --#         State             from *,
   --#                                Section;

   -- Simple tags, ones whose opening and closing tags are generated
   -- at the same time.  E.g. <filename>file.txt</filename>
   procedure Filename (Plain_Output : in     Boolean;
                       File         : in out E_Strings.T);
   --# global in out State;
   --# derives File  from *,
   --#                    Plain_Output,
   --#                    State &
   --#         State from *;

   procedure Index (Plain_Output : in     Boolean;
                    Idx          : in out E_Strings.T);
   --# global in out State;
   --# derives Idx   from *,
   --#                    Plain_Output,
   --#                    State &
   --#         State from *;

   procedure Compiler_Item (Item   : in E_Strings.T;
                            Val    : in E_Strings.T;
                            Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Val &
   --#         State             from *,
   --#                                Item;

   procedure Suppressed (Item : in out E_Strings.T);
   --# global in out State;
   --# derives Item,
   --#         State from *,
   --#                    State;

   procedure Suppressed_Pragma (Item : in out E_Strings.T);
   --# global in out State;
   --# derives Item,
   --#         State from *,
   --#                    State;

   procedure Option (Opt : in out E_Strings.T);
   --# global in out State;
   --# derives Opt,
   --#         State from *,
   --#                    State;

   procedure Unit (Name   : in E_Strings.T;
                   Typ    : in E_Strings.T;
                   Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State,
   --#                                Typ &
   --#         State             from *,
   --#                                Name,
   --#                                Typ;

   -- Ada Units in a file.
   procedure Ada_Unit
     (Name        : in E_Strings.T;
      Typ         : in E_Strings.T;
      Unit_Status : in E_Strings.T;
      Report      : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State,
   --#                                Typ,
   --#                                Unit_Status &
   --#         State             from *,
   --#                                Name,
   --#                                Typ,
   --#                                Unit_Status;

   -- Message construction.

   procedure Start_Message
     (Class  : in E_Strings.T;
      Code   : in Integer;
      Line   : in Integer;
      Offset : in Integer;
      Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Class,
   --#                                Code,
   --#                                Line,
   --#                                Offset,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Class,
   --#                                Code,
   --#                                Line,
   --#                                Offset;

   procedure Symbol (Sym     : in E_Strings.T;
                     Sym_Num : in Integer;
                     Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Sym,
   --#                                Sym_Num &
   --#         State             from *,
   --#                                Sym_Num;

   procedure End_Message (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   -- Metafile contruction

   procedure Start_Meta_File (Name   : in E_Strings.T;
                              Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Name;

   procedure End_Meta_File (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   -- Results Section contents

   procedure Start_File (Plain_Output : in Boolean;
                         F_Name       : in E_Strings.T;
                         Report       : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                F_Name,
   --#                                Plain_Output,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                F_Name,
   --#                                Plain_Output;

   procedure End_File (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Brief_Justifications (Matched   : in Natural;
                                   Unmatched : in Natural;
                                   Report    : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Matched,
   --#                                Report,
   --#                                State,
   --#                                Unmatched &
   --#         State             from *,
   --#                                Matched,
   --#                                Unmatched;

   procedure Start_Full_Justification
     (Class      : in E_Strings.T;
      Code       : in Integer;
      Line_From  : in Integer;
      Line_To    : in E_Strings.T;
      Match_No   : in Integer;
      Match_Line : in Integer;
      Report     : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Class,
   --#                                Code,
   --#                                Line_From,
   --#                                Line_To,
   --#                                Match_Line,
   --#                                Match_No,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Class,
   --#                                Code,
   --#                                Line_From,
   --#                                Line_To,
   --#                                Match_Line,
   --#                                Match_No;

   procedure End_Full_Justification (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

end XMLReport;
