# IndieAuth Server Example

This example demonstrates a **complete IndieAuth server implementation** using
the indieweb Rust library. It serves as both an **IndieAuth identity provider**
(server) and **client** for testing against both local and remote IndieAuth
servers.

## Overview

The example includes comprehensive server and client functionality for IndieAuth authentication and authorization.

### Server Functionality

The server provides a complete IndieAuth authorization server implementation with these features:

- **Authorization Endpoint** (`/auth`) - Authenticates users and generates authorization codes
- **Token Endpoint** (`/token`) - Exchanges codes for access tokens with PKCE verification
- **Metadata Endpoint** (`/.well-known/oauth-authorization-server`) - Server discovery endpoint
- **UserInfo Endpoint** (`/userinfo`) - Returns user profile information
- **Demo Users** - 4 different user profiles showcasing various configurations

### Client Functionality

The example also includes a fully functional IndieAuth client for testing:

- **Client Interface** (`/client`) - Test authentication against any IndieAuth server
- **Token Discovery** - Automatically finds IndieAuth endpoints from profile URLs
- **PKCE Support** - Full Proof Key for Code Exchange implementation
- **Profile Display** - Shows authenticated user information

## Quick Start

To get the server running:

```bash
# 1. Ensure Rust is installed (see rust-toolchain.toml for version)
# 2. Navigate to this directory
cd examples/indieauth/client-server

# 3. Build the project
cargo build

# 4. Run the server
cargo run
```

The server will start on `http://localhost:8080` with comprehensive logging showing the bound address and available demo users.

## Demo Users

The server includes 4 demo users with different profile configurations:

| Username  | Password  | Profile Type | Features                                |
| --------- | --------- | ------------ | --------------------------------------- |
| `alice`   | `alice`   | Basic        | Name only                               |
| `bob`     | `bob`     | Full Profile | Name, email, avatar image               |
| `charlie` | `charlie` | External URL | External identity URL, email, identicon |
| `demo`    | `demo`    | Simple       | Name, email, bot avatar                 |

### Profile Features Demonstrated

The demo profiles showcase various profile configurations:

- **Basic Profile** - Minimal information (Alice) - only a name field
- **Avatar Images** - Uses the DiceBear API for placeholder images (Bob, Demo)
- **Email Addresses** - Different email formats and domains
- **External URLs** - Charlie's profile uses an external identity URL
- **Scope-based Access** - Profile information filtered based on granted scopes

## Testing the Server

### Test Local Server (Self-Authentication)

To test the server against itself:

1. Visit `http://localhost:8080/client`
2. Enter your local server URL: `http://localhost:8080/`
3. Choose a demo user and enter credentials
4. Complete the authorization flow

### Test Against Remote Servers

To test against remote IndieAuth servers:

1. Visit `http://localhost:8080/client`
2. Enter any IndieAuth-enabled profile URL (e.g., `https://example.com/`)
3. The client will discover the remote server's endpoints
4. Complete authentication on the remote server

## Server Endpoints

The following endpoints are available:

- **`/`** - GET - Landing page with server information
- **`/.well-known/oauth-authorization-server`** - GET - Server metadata (discovery)
- **`/auth`** - GET, POST - Authorization endpoint (login/consent)
- **`/auth/confirm`** - POST - Authorization confirmation
- **`/token`** - POST - Token endpoint (code exchange)
- **`/userinfo`** - GET - UserInfo endpoint (profile data)
- **`/introspect`** - POST - Token introspection
- **`/client`** - GET - Client interface for testing

### Key Files

| File                     | Purpose                                       |
| ------------------------ | --------------------------------------------- |
| `src/main.rs`            | Application entry point, router configuration |
| `src/state.rs`           | Application state, demo users, storage        |
| `src/server/auth.rs`     | Authorization endpoint handlers               |
| `src/server/token.rs`    | Token endpoint, PKCE verification             |
| `src/server/userinfo.rs` | UserInfo and introspection handlers           |
| `src/server/metadata.rs` | Server metadata discovery                     |
| `src/server/types.rs`    | Shared types (codes, tokens, claims)          |
| `src/client.rs`          | Client implementation for testing             |
| `src/templates/*.html`   | HTML templates for UI                         |
| `Cargo.toml`             | Project dependencies and metadata             |

### Important Constants

| Constant           | Value                 |
| ------------------ | --------------------- |
| Bind Address       | `0.0.0.0:8080`        |
| Code Expiry        | 600 seconds (10 min)  |
| Token Expiry       | 3600 seconds (1 hour) |
| Signing Key Length | 32 bytes (256 bits)   |
| Token Prefix       | `"token_"`            |
| Code Prefix        | `"auth_"`             |
| PKCE Methods       | `S256`, `plain`       |
| Supported Scopes   | `profile`, `email`    |
