% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/install.R
\name{stri_install_check}
\alias{stri_install_check}
\alias{stri_install_icudt}
\title{Installation-Related Utilities [DEPRECATED]}
\usage{
stri_install_check(silent = FALSE)

stri_install_icudt(check = TRUE, outpath = NULL, inpath = NULL)
}
\arguments{
\item{silent}{suppress diagnostic messages}

\item{check}{enable \code{stri_install_check()} tests}

\item{outpath}{path to install icudt to. If \code{NULL}, then
\code{file.path(path.package("stringi"), "libs")} will be used.}

\item{inpath}{path to search icudt archive in.
If \code{NULL}, then only stringi mirror servers will be used.
Mainly of interest to system admins and software developers.}
}
\value{
These functions return a logical value, invisibly.
\code{TRUE} denotes that the requested operation has been completed
successfully.
}
\description{
These functions are responsible for checking and guaranteeing
that the ICU data library (icudt) is available and that \pkg{stringi}
is ready to use.

These functions are deprecated and will no longer be available
in future \pkg{stringi} releases.
}
\details{
ICU makes use of a wide variety of data tables to provide many
of its services. Examples include converter mapping tables,
collation rules, transliteration rules, break iterator rules
and dictionaries, and other locale data.

Without the ICU data library (icudt) many \pkg{stringi} features
will not be available. icudt size is approx. 10-30 MB.

\code{stri_install_check()} tests whether some ICU services
are available. If they are not, it is most likely due to
unavailable ICU data library.

\code{stri_install_icudt()} downloads and installs the ICU data library
specific for your platform (little/big-endian). The downloaded
file will be decompressed into the directory where the package has been
installed, see \code{\link{find.package}}, so make sure
you have sufficient write permissions.
}
\examples{
stri_install_check()
}
\references{
\emph{ICU Data} -- ICU User Guide,
\url{http://userguide.icu-project.org/icudata}
}

