# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.edgeorder import EdgeOrderManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEdgeOrderManagement(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EdgeOrderManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_operations(self, resource_group):
        response = self.client.list_operations(
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_addresses_at_subscription_level(self, resource_group):
        response = self.client.list_addresses_at_subscription_level(
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_product_families(self, resource_group):
        response = self.client.list_product_families(
            product_families_request={
                "filterableProperties": {"str": [{"supportedValues": ["str"], "type": "str"}]},
                "customerSubscriptionDetails": {
                    "quotaId": "str",
                    "locationPlacementId": "str",
                    "registeredFeatures": [{"name": "str", "state": "str"}],
                },
            },
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_configurations(self, resource_group):
        response = self.client.list_configurations(
            configurations_request={
                "configurationFilters": [
                    {
                        "hierarchyInformation": {
                            "configurationName": "str",
                            "productFamilyName": "str",
                            "productLineName": "str",
                            "productName": "str",
                        },
                        "filterableProperty": [{"supportedValues": ["str"], "type": "str"}],
                    }
                ],
                "customerSubscriptionDetails": {
                    "quotaId": "str",
                    "locationPlacementId": "str",
                    "registeredFeatures": [{"name": "str", "state": "str"}],
                },
            },
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_product_families_metadata(self, resource_group):
        response = self.client.list_product_families_metadata(
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_at_subscription_level(self, resource_group):
        response = self.client.list_order_at_subscription_level(
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_items_at_subscription_level(self, resource_group):
        response = self.client.list_order_items_at_subscription_level(
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_addresses_at_resource_group_level(self, resource_group):
        response = self.client.list_addresses_at_resource_group_level(
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_address_by_name(self, resource_group):
        response = self.client.get_address_by_name(
            address_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_address(self, resource_group):
        response = self.client.begin_create_address(
            address_name="str",
            resource_group_name=resource_group.name,
            address_resource={
                "contactDetails": {
                    "contactName": "str",
                    "emailList": ["str"],
                    "phone": "str",
                    "mobile": "str",
                    "phoneExtension": "str",
                },
                "location": "str",
                "addressValidationStatus": "str",
                "id": "str",
                "name": "str",
                "shippingAddress": {
                    "country": "str",
                    "streetAddress1": "str",
                    "addressType": "str",
                    "city": "str",
                    "companyName": "str",
                    "postalCode": "str",
                    "stateOrProvince": "str",
                    "streetAddress2": "str",
                    "streetAddress3": "str",
                    "zipExtendedCode": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete_address_by_name(self, resource_group):
        response = self.client.begin_delete_address_by_name(
            address_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update_address(self, resource_group):
        response = self.client.begin_update_address(
            address_name="str",
            resource_group_name=resource_group.name,
            address_update_parameter={
                "contactDetails": {
                    "contactName": "str",
                    "emailList": ["str"],
                    "phone": "str",
                    "mobile": "str",
                    "phoneExtension": "str",
                },
                "shippingAddress": {
                    "country": "str",
                    "streetAddress1": "str",
                    "addressType": "str",
                    "city": "str",
                    "companyName": "str",
                    "postalCode": "str",
                    "stateOrProvince": "str",
                    "streetAddress2": "str",
                    "streetAddress3": "str",
                    "zipExtendedCode": "str",
                },
                "tags": {"str": "str"},
            },
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_at_resource_group_level(self, resource_group):
        response = self.client.list_order_at_resource_group_level(
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_order_by_name(self, resource_group):
        response = self.client.get_order_by_name(
            order_name="str",
            resource_group_name=resource_group.name,
            location="str",
            api_version="2021-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_order_items_at_resource_group_level(self, resource_group):
        response = self.client.list_order_items_at_resource_group_level(
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_order_item_by_name(self, resource_group):
        response = self.client.get_order_item_by_name(
            order_item_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_order_item(self, resource_group):
        response = self.client.begin_create_order_item(
            order_item_name="str",
            resource_group_name=resource_group.name,
            order_item_resource={
                "addressDetails": {
                    "forwardAddress": {
                        "contactDetails": {
                            "contactName": "str",
                            "emailList": ["str"],
                            "phone": "str",
                            "mobile": "str",
                            "phoneExtension": "str",
                        },
                        "addressValidationStatus": "str",
                        "shippingAddress": {
                            "country": "str",
                            "streetAddress1": "str",
                            "addressType": "str",
                            "city": "str",
                            "companyName": "str",
                            "postalCode": "str",
                            "stateOrProvince": "str",
                            "streetAddress2": "str",
                            "streetAddress3": "str",
                            "zipExtendedCode": "str",
                        },
                    },
                    "returnAddress": {
                        "contactDetails": {
                            "contactName": "str",
                            "emailList": ["str"],
                            "phone": "str",
                            "mobile": "str",
                            "phoneExtension": "str",
                        },
                        "addressValidationStatus": "str",
                        "shippingAddress": {
                            "country": "str",
                            "streetAddress1": "str",
                            "addressType": "str",
                            "city": "str",
                            "companyName": "str",
                            "postalCode": "str",
                            "stateOrProvince": "str",
                            "streetAddress2": "str",
                            "streetAddress3": "str",
                            "zipExtendedCode": "str",
                        },
                    },
                },
                "location": "str",
                "orderId": "str",
                "orderItemDetails": {
                    "orderItemType": "str",
                    "productDetails": {
                        "hierarchyInformation": {
                            "configurationName": "str",
                            "productFamilyName": "str",
                            "productLineName": "str",
                            "productName": "str",
                        },
                        "count": 0,
                        "deviceDetails": [
                            {"managementResourceId": "str", "managementResourceTenantId": "str", "serialNumber": "str"}
                        ],
                        "displayInfo": {"configurationDisplayName": "str", "productFamilyDisplayName": "str"},
                        "productDoubleEncryptionStatus": "str",
                    },
                    "cancellationReason": "str",
                    "cancellationStatus": "str",
                    "currentStage": {
                        "displayName": "str",
                        "stageName": "str",
                        "stageStatus": "str",
                        "startTime": "2020-02-20 00:00:00",
                    },
                    "deletionStatus": "str",
                    "error": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "forwardShippingDetails": {
                        "carrierDisplayName": "str",
                        "carrierName": "str",
                        "trackingId": "str",
                        "trackingUrl": "str",
                    },
                    "managementRpDetails": {"resourceProviderNamespace": "str"},
                    "managementRpDetailsList": [{"resourceProviderNamespace": "str"}],
                    "notificationEmailList": ["str"],
                    "orderItemStageHistory": [
                        {
                            "displayName": "str",
                            "stageName": "str",
                            "stageStatus": "str",
                            "startTime": "2020-02-20 00:00:00",
                        }
                    ],
                    "preferences": {
                        "encryptionPreferences": {"doubleEncryptionStatus": "str"},
                        "managementResourcePreferences": {"preferredManagementResourceId": "str"},
                        "notificationPreferences": [{"sendNotification": bool, "stageName": "str"}],
                        "transportPreferences": {"preferredShipmentType": "str"},
                    },
                    "returnReason": "str",
                    "returnStatus": "str",
                    "reverseShippingDetails": {
                        "carrierDisplayName": "str",
                        "carrierName": "str",
                        "sasKeyForLabel": "str",
                        "trackingId": "str",
                        "trackingUrl": "str",
                    },
                },
                "id": "str",
                "name": "str",
                "startTime": "2020-02-20 00:00:00",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete_order_item_by_name(self, resource_group):
        response = self.client.begin_delete_order_item_by_name(
            order_item_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update_order_item(self, resource_group):
        response = self.client.begin_update_order_item(
            order_item_name="str",
            resource_group_name=resource_group.name,
            order_item_update_parameter={
                "forwardAddress": {
                    "contactDetails": {
                        "contactName": "str",
                        "emailList": ["str"],
                        "phone": "str",
                        "mobile": "str",
                        "phoneExtension": "str",
                    },
                    "addressValidationStatus": "str",
                    "shippingAddress": {
                        "country": "str",
                        "streetAddress1": "str",
                        "addressType": "str",
                        "city": "str",
                        "companyName": "str",
                        "postalCode": "str",
                        "stateOrProvince": "str",
                        "streetAddress2": "str",
                        "streetAddress3": "str",
                        "zipExtendedCode": "str",
                    },
                },
                "notificationEmailList": ["str"],
                "preferences": {
                    "encryptionPreferences": {"doubleEncryptionStatus": "str"},
                    "managementResourcePreferences": {"preferredManagementResourceId": "str"},
                    "notificationPreferences": [{"sendNotification": bool, "stageName": "str"}],
                    "transportPreferences": {"preferredShipmentType": "str"},
                },
                "tags": {"str": "str"},
            },
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cancel_order_item(self, resource_group):
        response = self.client.cancel_order_item(
            order_item_name="str",
            resource_group_name=resource_group.name,
            cancellation_reason={"reason": "str"},
            api_version="2021-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_return_order_item(self, resource_group):
        response = self.client.begin_return_order_item(
            order_item_name="str",
            resource_group_name=resource_group.name,
            return_order_item_details={
                "returnReason": "str",
                "returnAddress": {
                    "contactDetails": {
                        "contactName": "str",
                        "emailList": ["str"],
                        "phone": "str",
                        "mobile": "str",
                        "phoneExtension": "str",
                    },
                    "addressValidationStatus": "str",
                    "shippingAddress": {
                        "country": "str",
                        "streetAddress1": "str",
                        "addressType": "str",
                        "city": "str",
                        "companyName": "str",
                        "postalCode": "str",
                        "stateOrProvince": "str",
                        "streetAddress2": "str",
                        "streetAddress3": "str",
                        "zipExtendedCode": "str",
                    },
                },
                "serviceTag": "str",
                "shippingBoxRequired": False,
            },
            api_version="2021-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
