# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._event_hub_management_client_enums import *


class AccessKeys(msrest.serialization.Model):
    """Namespace/EventHub Connection String.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_connection_string: Primary connection string of the created namespace
     AuthorizationRule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the created namespace
     AuthorizationRule.
    :vartype secondary_connection_string: str
    :ivar alias_primary_connection_string: Primary connection string of the alias if GEO DR is
     enabled.
    :vartype alias_primary_connection_string: str
    :ivar alias_secondary_connection_string: Secondary  connection string of the alias if GEO DR is
     enabled.
    :vartype alias_secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the AuthorizationRule.
    :vartype key_name: str
    """

    _validation = {
        'primary_connection_string': {'readonly': True},
        'secondary_connection_string': {'readonly': True},
        'alias_primary_connection_string': {'readonly': True},
        'alias_secondary_connection_string': {'readonly': True},
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
    }

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'alias_primary_connection_string': {'key': 'aliasPrimaryConnectionString', 'type': 'str'},
        'alias_secondary_connection_string': {'key': 'aliasSecondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessKeys, self).__init__(**kwargs)
        self.primary_connection_string = None
        self.secondary_connection_string = None
        self.alias_primary_connection_string = None
        self.alias_secondary_connection_string = None
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ArmDisasterRecovery(Resource):
    """Single item in List or Get Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Alias(Disaster Recovery configuration) -
     possible values 'Accepted' or 'Succeeded' or 'Failed'. Possible values include: "Accepted",
     "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.ProvisioningStateDR
    :param partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is
     part of GEO DR pairing.
    :type partner_namespace: str
    :param alternate_name: Alternate name specified when alias and namespace names are same.
    :type alternate_name: str
    :ivar role: role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating'
     or 'Secondary'. Possible values include: "Primary", "PrimaryNotReplicating", "Secondary".
    :vartype role: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.RoleDisasterRecovery
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'role': {'readonly': True},
        'pending_replication_operations_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_namespace': {'key': 'properties.partnerNamespace', 'type': 'str'},
        'alternate_name': {'key': 'properties.alternateName', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'pending_replication_operations_count': {'key': 'properties.pendingReplicationOperationsCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        partner_namespace: Optional[str] = None,
        alternate_name: Optional[str] = None,
        **kwargs
    ):
        super(ArmDisasterRecovery, self).__init__(**kwargs)
        self.provisioning_state = None
        self.partner_namespace = partner_namespace
        self.alternate_name = alternate_name
        self.role = None
        self.pending_replication_operations_count = None


class ArmDisasterRecoveryListResult(msrest.serialization.Model):
    """The result of the List Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Alias(Disaster Recovery configurations).
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.ArmDisasterRecovery]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Alias(Disaster Recovery configuration).
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ArmDisasterRecovery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ArmDisasterRecovery"]] = None,
        **kwargs
    ):
        super(ArmDisasterRecoveryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AuthorizationRule(Resource):
    """Single item in a List or Get AuthorizationRule operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param rights: The rights associated with the rule.
    :type rights: list[str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.AccessRights]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        rights: Optional[List[Union[str, "AccessRights"]]] = None,
        **kwargs
    ):
        super(AuthorizationRule, self).__init__(**kwargs)
        self.rights = rights


class AuthorizationRuleListResult(msrest.serialization.Model):
    """The response from the List namespace operation.

    :param value: Result of the List Authorization Rules operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.AuthorizationRule]
    :param next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of Authorization Rules.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AuthorizationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AuthorizationRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailableCluster(msrest.serialization.Model):
    """Pre-provisioned and readily available Event Hubs Cluster count per region.

    :param location: Location fo the Available Cluster.
    :type location: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(AvailableCluster, self).__init__(**kwargs)
        self.location = location


class AvailableClustersList(msrest.serialization.Model):
    """The response of the List Available Clusters operation.

    :param value: The count of readily available and pre-provisioned Event Hubs Clusters per
     region.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.AvailableCluster]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableCluster]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AvailableCluster"]] = None,
        **kwargs
    ):
        super(AvailableClustersList, self).__init__(**kwargs)
        self.value = value


class CaptureDescription(msrest.serialization.Model):
    """Properties to configure capture description for eventhub.

    :param enabled: A value that indicates whether capture description is enabled.
    :type enabled: bool
    :param encoding: Enumerates the possible values for the encoding format of capture description.
     Note: 'AvroDeflate' will be deprecated in New API Version. Possible values include: "Avro",
     "AvroDeflate".
    :type encoding: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.EncodingCaptureDescription
    :param interval_in_seconds: The time window allows you to set the frequency with which the
     capture to Azure Blobs will happen, value should between 60 to 900 seconds.
    :type interval_in_seconds: int
    :param size_limit_in_bytes: The size window defines the amount of data built up in your Event
     Hub before an capture operation, value should be between 10485760 to 524288000 bytes.
    :type size_limit_in_bytes: int
    :param destination: Properties of Destination where capture will be stored. (Storage Account,
     Blob Names).
    :type destination: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Destination
    :param skip_empty_archives: A value that indicates whether to Skip Empty Archives.
    :type skip_empty_archives: bool
    """

    _validation = {
        'interval_in_seconds': {'maximum': 900, 'minimum': 60},
        'size_limit_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'encoding': {'key': 'encoding', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
        'size_limit_in_bytes': {'key': 'sizeLimitInBytes', 'type': 'int'},
        'destination': {'key': 'destination', 'type': 'Destination'},
        'skip_empty_archives': {'key': 'skipEmptyArchives', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        encoding: Optional[Union[str, "EncodingCaptureDescription"]] = None,
        interval_in_seconds: Optional[int] = None,
        size_limit_in_bytes: Optional[int] = None,
        destination: Optional["Destination"] = None,
        skip_empty_archives: Optional[bool] = None,
        **kwargs
    ):
        super(CaptureDescription, self).__init__(**kwargs)
        self.enabled = enabled
        self.encoding = encoding
        self.interval_in_seconds = interval_in_seconds
        self.size_limit_in_bytes = size_limit_in_bytes
        self.destination = destination
        self.skip_empty_archives = skip_empty_archives


class CheckNameAvailabilityParameter(msrest.serialization.Model):
    """Parameter supplied to check Namespace name availability operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name to check the namespace name availability.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameAvailabilityParameter, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The Result of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: The detailed info regarding the reason associated with the Namespace.
    :vartype message: str
    :param name_available: Value indicating Namespace is availability, true if the Namespace is
     available; otherwise, false.
    :type name_available: bool
    :param reason: The reason for unavailability of a Namespace. Possible values include: "None",
     "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown",
     "TooManyNamespaceInCurrentSubscription".
    :type reason: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.UnavailableReason
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "UnavailableReason"]] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.message = None
        self.name_available = name_available
        self.reason = reason


class TrackedResource(Resource):
    """Definition of resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class Cluster(TrackedResource):
    """Single Event Hubs Cluster resource in List or Get operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Properties of the cluster SKU.
    :type sku: ~azure.mgmt.eventhub.v2018_01_01_preview.models.ClusterSku
    :ivar created_at: The UTC time when the Event Hubs Cluster was created.
    :vartype created_at: str
    :ivar updated_at: The UTC time when the Event Hubs Cluster was last updated.
    :vartype updated_at: str
    :ivar metric_id: The metric ID of the cluster resource. Provided by the service and not
     modifiable by the user.
    :vartype metric_id: str
    :ivar status: Status of the Cluster resource.
    :vartype status: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'metric_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'created_at': {'key': 'properties.createdAt', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ClusterSku"] = None,
        **kwargs
    ):
        super(Cluster, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.created_at = None
        self.updated_at = None
        self.metric_id = None
        self.status = None


class ClusterListResult(msrest.serialization.Model):
    """The response of the List Event Hubs Clusters operation.

    :param value: The Event Hubs Clusters present in the List Event Hubs operation results.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Cluster]
    :param next_link: Link to the next set of results. Empty unless the value parameter contains an
     incomplete list of Event Hubs Clusters.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Cluster"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ClusterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterQuotaConfigurationProperties(msrest.serialization.Model):
    """Contains all settings for the cluster.

    :param settings: All possible Cluster settings - a collection of key/value paired settings
     which apply to quotas and configurations imposed on the cluster.
    :type settings: dict[str, str]
    """

    _attribute_map = {
        'settings': {'key': 'settings', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        settings: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ClusterQuotaConfigurationProperties, self).__init__(**kwargs)
        self.settings = settings


class ClusterSku(msrest.serialization.Model):
    """SKU parameters particular to a cluster instance.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of this SKU. Possible values include: "Dedicated".
    :type name: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.ClusterSkuName
    :param capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "ClusterSkuName"],
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(ClusterSku, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class ConnectionState(msrest.serialization.Model):
    """ConnectionState information.

    :param status: Status of the connection. Possible values include: "Pending", "Approved",
     "Rejected", "Disconnected".
    :type status: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateLinkConnectionStatus
    :param description: Description of the connection state.
    :type description: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateLinkConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description


class ConsumerGroup(Resource):
    """Single item in List or Get Consumer group operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :param user_metadata: User Metadata is a placeholder to store user-defined string data with
     maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and
     their contact information also user-defined configuration settings can be stored.
    :type user_metadata: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_metadata: Optional[str] = None,
        **kwargs
    ):
        super(ConsumerGroup, self).__init__(**kwargs)
        self.created_at = None
        self.updated_at = None
        self.user_metadata = user_metadata


class ConsumerGroupListResult(msrest.serialization.Model):
    """The result to the List Consumer Group operation.

    :param value: Result of the List Consumer Group operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.ConsumerGroup]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Consumer Group.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConsumerGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ConsumerGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConsumerGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Destination(msrest.serialization.Model):
    """Capture storage details for capture description.

    :param name: Name for capture destination.
    :type name: str
    :param storage_account_resource_id: Resource id of the storage account to be used to create the
     blobs.
    :type storage_account_resource_id: str
    :param blob_container: Blob container Name.
    :type blob_container: str
    :param archive_name_format: Blob naming convention for archive, e.g.
     {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all
     the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order.
    :type archive_name_format: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'blob_container': {'key': 'properties.blobContainer', 'type': 'str'},
        'archive_name_format': {'key': 'properties.archiveNameFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        blob_container: Optional[str] = None,
        archive_name_format: Optional[str] = None,
        **kwargs
    ):
        super(Destination, self).__init__(**kwargs)
        self.name = name
        self.storage_account_resource_id = storage_account_resource_id
        self.blob_container = blob_container
        self.archive_name_format = archive_name_format


class EHNamespace(TrackedResource):
    """Single Namespace item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Properties of sku resource.
    :type sku: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Sku
    :param identity: Properties of BYOK Identity description.
    :type identity: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Identity
    :ivar provisioning_state: Provisioning state of the Namespace.
    :vartype provisioning_state: str
    :ivar status: Status of the Namespace.
    :vartype status: str
    :ivar created_at: The time the Namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the Namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :param cluster_arm_id: Cluster ARM ID of the Namespace.
    :type cluster_arm_id: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :param is_auto_inflate_enabled: Value that indicates whether AutoInflate is enabled for
     eventhub namespace.
    :type is_auto_inflate_enabled: bool
    :param maximum_throughput_units: Upper limit of throughput units when AutoInflate is enabled,
     value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true).
    :type maximum_throughput_units: int
    :param kafka_enabled: Value that indicates whether Kafka is enabled for eventhub namespace.
    :type kafka_enabled: bool
    :param zone_redundant: Enabling this property creates a Standard Event Hubs Namespace in
     regions supported availability zones.
    :type zone_redundant: bool
    :param encryption: Properties of BYOK Encryption description.
    :type encryption: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Encryption
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'service_bus_endpoint': {'readonly': True},
        'metric_id': {'readonly': True},
        'maximum_throughput_units': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'cluster_arm_id': {'key': 'properties.clusterArmId', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'is_auto_inflate_enabled': {'key': 'properties.isAutoInflateEnabled', 'type': 'bool'},
        'maximum_throughput_units': {'key': 'properties.maximumThroughputUnits', 'type': 'int'},
        'kafka_enabled': {'key': 'properties.kafkaEnabled', 'type': 'bool'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        identity: Optional["Identity"] = None,
        cluster_arm_id: Optional[str] = None,
        is_auto_inflate_enabled: Optional[bool] = None,
        maximum_throughput_units: Optional[int] = None,
        kafka_enabled: Optional[bool] = None,
        zone_redundant: Optional[bool] = None,
        encryption: Optional["Encryption"] = None,
        **kwargs
    ):
        super(EHNamespace, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.provisioning_state = None
        self.status = None
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.cluster_arm_id = cluster_arm_id
        self.metric_id = None
        self.is_auto_inflate_enabled = is_auto_inflate_enabled
        self.maximum_throughput_units = maximum_throughput_units
        self.kafka_enabled = kafka_enabled
        self.zone_redundant = zone_redundant
        self.encryption = encryption


class EHNamespaceIdContainer(msrest.serialization.Model):
    """The full ARM ID of an Event Hubs Namespace.

    :param id: id parameter.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(EHNamespaceIdContainer, self).__init__(**kwargs)
        self.id = id


class EHNamespaceIdListResult(msrest.serialization.Model):
    """The response of the List Namespace IDs operation.

    :param value: Result of the List Namespace IDs operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.EHNamespaceIdContainer]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EHNamespaceIdContainer]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EHNamespaceIdContainer"]] = None,
        **kwargs
    ):
        super(EHNamespaceIdListResult, self).__init__(**kwargs)
        self.value = value


class EHNamespaceListResult(msrest.serialization.Model):
    """The response of the List Namespace operation.

    :param value: Result of the List Namespace operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.EHNamespace]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of namespaces.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EHNamespace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EHNamespace"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EHNamespaceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Encryption(msrest.serialization.Model):
    """Properties to configure Encryption.

    :param key_vault_properties: Properties of KeyVault.
    :type key_vault_properties:
     list[~azure.mgmt.eventhub.v2018_01_01_preview.models.KeyVaultProperties]
    :param key_source: Enumerates the possible value of keySource for Encryption. The only
     acceptable values to pass in are None and "Microsoft.KeyVault". The default value is
     "Microsoft.KeyVault".
    :type key_source: str
    """

    _attribute_map = {
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': '[KeyVaultProperties]'},
        'key_source': {'key': 'keySource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional[List["KeyVaultProperties"]] = None,
        key_source: Optional[str] = "Microsoft.KeyVault",
        **kwargs
    ):
        super(Encryption, self).__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.key_source = key_source


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Event Hub service is not able to process the incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Eventhub(Resource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :param message_retention_in_days: Number of days to retain the events for this Event Hub, value
     should be 1 to 7 days.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for the Event Hub, allowed values are from
     1 to 32 partitions.
    :type partition_count: long
    :param status: Enumerates the possible values for the status of the Event Hub. Possible values
     include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", "Unknown".
    :type status: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.EntityStatus
    :param capture_description: Properties of capture description.
    :type capture_description: ~azure.mgmt.eventhub.v2018_01_01_preview.models.CaptureDescription
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partition_ids': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'message_retention_in_days': {'minimum': 1},
        'partition_count': {'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'capture_description': {'key': 'properties.captureDescription', 'type': 'CaptureDescription'},
    }

    def __init__(
        self,
        *,
        message_retention_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        status: Optional[Union[str, "EntityStatus"]] = None,
        capture_description: Optional["CaptureDescription"] = None,
        **kwargs
    ):
        super(Eventhub, self).__init__(**kwargs)
        self.partition_ids = None
        self.created_at = None
        self.updated_at = None
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.status = status
        self.capture_description = capture_description


class EventHubListResult(msrest.serialization.Model):
    """The result of the List EventHubs operation.

    :param value: Result of the List EventHubs operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Eventhub]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of EventHubs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Eventhub]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Eventhub"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EventHubListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Identity(msrest.serialization.Model):
    """Properties to configure Identity for Bring your Own Keys.

    :param principal_id: ObjectId from the KeyVault.
    :type principal_id: str
    :param tenant_id: TenantId from the KeyVault.
    :type tenant_id: str
    :param type: Enumerates the possible value Identity type, which currently supports only
     'SystemAssigned'. The only acceptable values to pass in are None and "SystemAssigned". The
     default value is "SystemAssigned".
    :type type: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        type: Optional[str] = "SystemAssigned",
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.type = type


class IpFilterRule(Resource):
    """Single item in a List or Get IpFilterRules operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param ip_mask: IP Mask.
    :type ip_mask: str
    :param action: The IP Filter Action. Possible values include: "Accept", "Reject".
    :type action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.IPAction
    :param filter_name: IP Filter name.
    :type filter_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ip_mask': {'key': 'properties.ipMask', 'type': 'str'},
        'action': {'key': 'properties.action', 'type': 'str'},
        'filter_name': {'key': 'properties.filterName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "IPAction"]] = None,
        filter_name: Optional[str] = None,
        **kwargs
    ):
        super(IpFilterRule, self).__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action
        self.filter_name = filter_name


class IpFilterRuleListResult(msrest.serialization.Model):
    """The response from the List namespace operation.

    :param value: Result of the List IpFilter Rules operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.IpFilterRule]
    :param next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of IpFilter Rules.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IpFilterRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IpFilterRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IpFilterRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class KeyVaultProperties(msrest.serialization.Model):
    """Properties to configure keyVault Properties.

    :param key_name: Name of the Key from KeyVault.
    :type key_name: str
    :param key_vault_uri: Uri of KeyVault.
    :type key_vault_uri: str
    :param key_version: Key Version.
    :type key_version: str
    """

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        key_version: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = key_name
        self.key_vault_uri = key_vault_uri
        self.key_version = key_version


class MessagingRegions(TrackedResource):
    """Messaging Region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: Properties of Messaging Region.
    :type properties: ~azure.mgmt.eventhub.v2018_01_01_preview.models.MessagingRegionsProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'MessagingRegionsProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["MessagingRegionsProperties"] = None,
        **kwargs
    ):
        super(MessagingRegions, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class MessagingRegionsListResult(msrest.serialization.Model):
    """The response of the List MessagingRegions operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Result of the List MessagingRegions type.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.MessagingRegions]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of MessagingRegions.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MessagingRegions]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MessagingRegions"]] = None,
        **kwargs
    ):
        super(MessagingRegionsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class MessagingRegionsProperties(msrest.serialization.Model):
    """Properties of Messaging Region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Region code.
    :vartype code: str
    :ivar full_name: Full name of the region.
    :vartype full_name: str
    """

    _validation = {
        'code': {'readonly': True},
        'full_name': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'full_name': {'key': 'fullName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MessagingRegionsProperties, self).__init__(**kwargs)
        self.code = None
        self.full_name = None


class NetworkRuleSet(Resource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
     Enabled or not.
    :type trusted_service_access_enabled: bool
    :param default_action: Default Action for Network Rule Set. Possible values include: "Allow",
     "Deny".
    :type default_action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.DefaultAction
    :param virtual_network_rules: List VirtualNetwork Rules.
    :type virtual_network_rules:
     list[~azure.mgmt.eventhub.v2018_01_01_preview.models.NWRuleSetVirtualNetworkRules]
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.NWRuleSetIpRules]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'trusted_service_access_enabled': {'key': 'properties.trustedServiceAccessEnabled', 'type': 'bool'},
        'default_action': {'key': 'properties.defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[NWRuleSetVirtualNetworkRules]'},
        'ip_rules': {'key': 'properties.ipRules', 'type': '[NWRuleSetIpRules]'},
    }

    def __init__(
        self,
        *,
        trusted_service_access_enabled: Optional[bool] = None,
        default_action: Optional[Union[str, "DefaultAction"]] = None,
        virtual_network_rules: Optional[List["NWRuleSetVirtualNetworkRules"]] = None,
        ip_rules: Optional[List["NWRuleSetIpRules"]] = None,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.trusted_service_access_enabled = trusted_service_access_enabled
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules


class NWRuleSetIpRules(msrest.serialization.Model):
    """The response from the List namespace operation.

    :param ip_mask: IP Mask.
    :type ip_mask: str
    :param action: The IP Filter Action. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.NetworkRuleIPAction
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "NetworkRuleIPAction"]] = None,
        **kwargs
    ):
        super(NWRuleSetIpRules, self).__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class NWRuleSetVirtualNetworkRules(msrest.serialization.Model):
    """The response from the List namespace operation.

    :param subnet: Subnet properties.
    :type subnet: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Subnet
    :param ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing
     Vnet Service Endpoint.
    :type ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'Subnet'},
        'ignore_missing_vnet_service_endpoint': {'key': 'ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        subnet: Optional["Subnet"] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs
    ):
        super(NWRuleSetVirtualNetworkRules, self).__init__(**kwargs)
        self.subnet = subnet
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint


class Operation(msrest.serialization.Model):
    """A Event Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.eventhub.v2018_01_01_preview.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.EventHub.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Event Hub operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Event Hub operations supported by the Microsoft.EventHub resource
     provider.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(msrest.serialization.Model):
    """PrivateEndpoint information.

    :param id: The ARM identifier for Private Endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Resource):
    """Properties of the PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The Private Endpoint resource for this Connection.
    :type private_endpoint: ~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateEndpoint
    :param private_link_service_connection_state: Details about the state of the connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.ConnectionState
    :param provisioning_state: Provisioning state of the Private Endpoint Connection. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.EndPointProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "EndPointProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :param value: A collection of private endpoint connection resources.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateEndpointConnection]
    :param next_link: A link for the next page of private endpoint connection resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(msrest.serialization.Model):
    """Information of the private link resource.

    :param id: Fully qualified identifier of the resource.
    :type id: str
    :param name: Name of the resource.
    :type name: str
    :param type: Type of the resource.
    :type type: str
    :param group_id: The private link resource group id.
    :type group_id: str
    :param required_members: The private link resource required member names.
    :type required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(msrest.serialization.Model):
    """Result of the List private link resources operation.

    :param value: A collection of private link resources.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateLinkResource]
    :param next_link: A link for the next page of private link resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegenerateAccessKeyParameters(msrest.serialization.Model):
    """Parameters supplied to the Regenerate Authorization Rule operation, specifies which key needs to be reset.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The access key to regenerate. Possible values include: "PrimaryKey",
     "SecondaryKey".
    :type key_type: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.KeyType
    :param key: Optional, if the key value provided, is set for KeyType or autogenerated Key value
     set for keyType.
    :type key: str
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_type: Union[str, "KeyType"],
        key: Optional[str] = None,
        **kwargs
    ):
        super(RegenerateAccessKeyParameters, self).__init__(**kwargs)
        self.key_type = key_type
        self.key = key


class Sku(msrest.serialization.Model):
    """SKU parameters supplied to the create namespace operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of this SKU. Possible values include: "Basic", "Standard".
    :type name: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.SkuName
    :param tier: The billing tier of this particular SKU. Possible values include: "Basic",
     "Standard".
    :type tier: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.SkuTier
    :param capacity: The Event Hubs throughput units, value should be 0 to 20 throughput units.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        tier: Optional[Union[str, "SkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class Subnet(msrest.serialization.Model):
    """Properties supplied for Subnet.

    :param id: Resource ID of Virtual Network Subnet.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(Subnet, self).__init__(**kwargs)
        self.id = id


class VirtualNetworkRule(Resource):
    """Single item in a List or Get VirtualNetworkRules operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param virtual_network_subnet_id: ARM ID of Virtual Network Subnet.
    :type virtual_network_subnet_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_subnet_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = virtual_network_subnet_id


class VirtualNetworkRuleListResult(msrest.serialization.Model):
    """The response from the List namespace operation.

    :param value: Result of the List VirtualNetwork Rules operation.
    :type value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.VirtualNetworkRule]
    :param next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of VirtualNetwork Rules.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
