#!/usr/bin/env python
# -*- coding: utf8 -*-
#
#    Project: Azimuthal integration 
#             https://forge.epn-campus.eu/projects/azimuthal
#
#    File: "$Id$"
#
#    Copyright (C) European Synchrotron Radiation Facility, Grenoble, France
#
#    Principal author:       Jérôme Kieffer (Jerome.Kieffer@ESRF.eu)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"test suite for Geometric Refinement class"

__author__ = "Jérôme Kieffer"
__contact__ = "Jerome.Kieffer@ESRF.eu"
__license__ = "GPLv3+"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"
__date__ = "06/07/2011"


import unittest
import os
import numpy
import logging
logger = logging.getLogger(os.path.basename(__file__))
import sys

for opts in sys.argv[1:]:
    if opts in ["-d", "--debug"]:
        logging.basicConfig(level=logging.DEBUG)
        sys.argv.pop(sys.argv.index(opts))
    elif opts in ["-i", "--info"]:
        logging.basicConfig(level=logging.INFO)
        sys.argv.pop(sys.argv.index(opts))

try:
    logger.debug("tests loaded from file: %s" % __file__)
except:
    __file__ = os.getcwd()

from utilstest import UtilsTest
from pyFAI.geometryRefinement import GeometryRefinement

class test_geometryRefinement(unittest.TestCase):
    """ tests geometric refinements with or without spline"""

    def test_noSpline(self):
        """tests geometric refinements without spline"""

        pixelSize = [1.5e-5, 1.5e-5]
        data = [
[1585.9999996029055, 2893.9999991192408, 0.53005649383067788],
[1853.9999932086102, 2873.0000001637909, 0.53005649383067788],
[2163.9999987531855, 2854.9999987738884, 0.53005649383067788],
[2699.9999977914931, 2893.9999985831755, 0.53005649383067788],
[3186.9999966428777, 3028.9999985930604, 0.53005649383067788],
[3595.0000039534661, 3167.0000022967461, 0.53005649383067788],
[3835.0000007197755, 3300.0000002536408, 0.53005649383067788],
[1252.0000026881371, 2984.0000056421914, 0.53005649383067788],
[576.99992486352289, 3220.0000014469815, 0.53005649383067788],
[52.999989546760531, 3531.9999975314959, 0.53005649383067788],
[520.99999862452842, 2424.0000005943775, 0.65327673902147754],
[1108.0000045189499, 2239.9999793751085, 0.65327673902147754],
[2022.0000098770186, 2136.9999921020726, 0.65327673902147754],
[2436.000002384907, 2137.0000034435734, 0.65327673902147754],
[2797.9999973906524, 2169.9999849019205, 0.65327673902147754],
[3516.0000041508365, 2354.0000059814265, 0.65327673902147754],
[3870.9999995625412, 2464.9999964079757, 0.65327673902147754],
[3735.9999952703465, 2417.9999888223151, 0.65327673902147754],
[3374.0001428680412, 2289.9999885080188, 0.65327673902147754],
[1709.99999872134, 2165.0000006693272, 0.65327673902147754],
[2004.0000081015958, 1471.0000012076148, 0.7592182246175333],
[2213.0000015244159, 1464.0000243454842, 0.7592182246175333],
[2115.9999952456633, 1475.0000015176133, 0.7592182246175333],
[2242.0000023736206, 1477.0000046142911, 0.7592182246175333],
[2463.9999967564663, 1464.0000011704756, 0.7592182246175333],
[2986.000011249705, 1540.9999994523619, 0.7592182246175333],
[2760.0000031761901, 1514.0000002442944, 0.7592182246175333],
[3372.0000025298395, 1617.9999995345927, 0.7592182246175333],
[3187.0000005152106, 1564.9999952212884, 0.7592182246175333],
[3952.0000062252166, 1765.0000234029771, 0.7592182246175333],
[200.99999875941003, 1190.0000046393075, 0.85451320177642376],
[463.00000674257342, 1121.9999956648539, 0.85451320177642376],
[1455.0000001416358, 936.99999830341949, 0.85451320177642376],
[1673.9999958962637, 927.99999934328309, 0.85451320177642376],
[2492.0000021823594, 922.00000383122256, 0.85451320177642376],
[2639.9999948599761, 936.00000247819059, 0.85451320177642376],
[3476.9999490636446, 1027.9999838362451, 0.85451320177642376],
[3638.9999965727247, 1088.0000258143732, 0.85451320177642376],
[4002.0000051610787, 1149.9999925115812, 0.85451320177642376],
[2296.9999822277705, 908.00000939182382, 0.85451320177642376],
[266.00000015817864, 576.00000049157074, 0.94195419730133967],
[364.00001493127616, 564.00000136247968, 0.94195419730133967],
[752.99999958240187, 496.9999948653093, 0.94195419730133967],
[845.99999758606646, 479.00000730401808, 0.94195419730133967],
[1152.0000082161678, 421.9999937722655, 0.94195419730133967],
[1215.0000019951258, 431.00019867504369, 0.94195419730133967],
[1728.0000096657914, 368.00000247754218, 0.94195419730133967],
[2095.9999932673395, 365.99999862304219, 0.94195419730133967],
[2194.0000006543587, 356.99999967534075, 0.94195419730133967],
[2598.0000021676074, 386.99999979901884, 0.94195419730133967],
[2959.9998766657627, 410.00000323183838, 0.94195419730133967],
]
        r = GeometryRefinement(data, dist=0.1, poni1=0.00, poni2=0.00, pixel1=pixelSize[0], pixel2=pixelSize[1])
        r.refine2(10000000)

        ref = numpy.array([0.089652, 0.030970, 0.027668, -0.699407 , 0.010067  , 0.000001])
        assert abs(numpy.array(r.param) - ref).max() < 1e-3


    def test_Spline(self):
        """tests geometric refinements with spline"""
        splineFine = os.path.join(os.path.dirname(__file__), "example.sp")
        data = [[795, 288, 0.3490658503988659],
        [890, 260, 0.3490658503988659],
        [948, 249, 0.3490658503988659],
        [710, 325, 0.3490658503988659],
        [601, 392, 0.3490658503988659],
        [1167, 248, 0.3490658503988659],
        [1200, 340, 0.3490658503988659],
        [1319, 285, 0.3490658503988659],
        [1362, 302, 0.3490658503988659],
        [1436, 338, 0.3490658503988659],
        [1526, 397, 0.3490658503988659],
        [1560, 424, 0.3490658503988659],
        [1615, 476, 0.3490658503988659],
        [1662, 529, 0.3490658503988659],
        [1742, 650, 0.3490658503988659],
        [1778, 727, 0.3490658503988659],
        [1824, 891, 0.3490658503988659],
        [1831, 947, 0.3490658503988659],
        [1832, 1063, 0.3490658503988659],
        [1828, 1106, 0.3490658503988659],
        [1828, 1106, 0.3490658503988659],
        [1810, 1202, 0.3490658503988659],
        [1775, 1307, 0.3490658503988659],
        [1724, 1407, 0.3490658503988659],
        [1655, 1502, 0.3490658503988659],
        [1489, 1649, 0.3490658503988659],
        [1397, 1700, 0.3490658503988659],
        [1251, 1752, 0.3490658503988659],
        [1126, 1772, 0.3490658503988659],
        [984, 1770, 0.3490658503988659],
        [907, 1758, 0.3490658503988659],
        [801, 1728, 0.3490658503988659],
        [696, 1681, 0.3490658503988659],
        [634, 1644, 0.3490658503988659],
        [568, 1596, 0.3490658503988659],
        [520, 1553, 0.3490658503988659],
        [453, 1479, 0.3490658503988659],
        [403, 1408, 0.3490658503988659],
        [403, 1408, 0.3490658503988659],
        [363, 1337, 0.3490658503988659],
        [320, 1228, 0.3490658503988659],
        [303, 1161, 0.3490658503988659],
        [287, 1023, 0.3490658503988659],
        [287, 993, 0.3490658503988659],
        [304, 846, 0.3490658503988659],
        [329, 758, 0.3490658503988659],
        [341, 726, 0.3490658503988659],
        [402, 606, 0.3490658503988659],
        [437, 555, 0.3490658503988659],
        [513, 467, 0.3490658503988659]]
        r2 = GeometryRefinement(data, dist=0.1, poni1=0.00, poni2=0.00, splineFile=splineFine)
        r2.rot1_max = 0
        r2.rot1_min = -0
        r2.rot2_max = 0
        r2.rot2_min = -0
        r2.rot3_max = 0.1
        r2.rot3_min = -0.1
        r2.refine2(10000000)
#        r2.rot1_max = 1
#        r2.rot1_min = -1
#        r2.rot2_max = 1
#        r2.rot2_min = -1
#        r2.rot3_max = 1
#        r2.rot3_min = -1
#        r2.refine2(10000000)
        ref2 = numpy.array([0.1, 4.917310e-02, 4.722438e-02, 0 , 0.  , 0.00000])
        assert abs(numpy.array(r2.param) - ref2).max() < 1e-3

def test_suite_all_GeometryRefinement():
    testSuite = unittest.TestSuite()
    testSuite.addTest(test_geometryRefinement("test_noSpline"))
    testSuite.addTest(test_geometryRefinement("test_Spline"))
    return testSuite

if __name__ == '__main__':

    mysuite = test_suite_all_GeometryRefinement()
    runner = unittest.TextTestRunner()
    runner.run(mysuite)

