/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
#include "conv_common.hpp"

template <class T>
struct conv3d_driver : conv_driver<T>
{
    conv3d_driver() : conv_driver<T>()
    {
        this->add(this->input_dims, "input");
        this->add(this->weight_tensor_dims, "weights");
        this->add(this->batch_size,
                  "batch_size",
                  this->generate_data_limited(this->get_batch_sizes(), 1, {8}));
        this->add(this->input_channels,
                  "input_channels",
                  this->generate_data_limited(this->get_input_channels(), 1, {32}));
        this->add(this->output_channels,
                  "output_channels",
                  this->generate_data_limited(this->get_output_channels(), 1, {32}));
        this->add(this->spatial_dim_elements,
                  "spatial_dim_elements",
                  this->generate_data_limited(this->get_3d_spatial_dims(), 1, {16, 16, 16}));
        this->add(this->filter_dims,
                  "filter_dims",
                  this->generate_data_limited(this->get_3d_filter_dims(), 2, {3, 3, 3}));
        this->add(this->pads_strides_dilations,
                  "pads_strides_dilations",
                  this->generate_data_limited(this->get_3d_pads_strides_dilations(), 2));
        this->add(this->trans_output_pads,
                  "trans_output_pads",
                  this->generate_data_limited(this->get_3d_trans_output_pads(), 1));
        this->add(this->in_layout, "in_layout", this->generate_data({"NCDHW"}));
        this->add(this->fil_layout, "fil_layout", this->generate_data({"NCDHW"}));
        this->add(this->out_layout, "out_layout", this->generate_data({"NCDHW"}));
        this->add(this->deterministic, "deterministic", this->generate_data({false}));
        this->add(this->tensor_vect, "tensor_vect", this->generate_data({0}));
        this->add(this->vector_length, "vector_length", this->generate_data({1}));
        // Only valid for int8 input and weights
        this->add(this->output_type, "output_type", this->generate_data({"int32"}));
        this->add(this->int8_vectorize, "int8_vectorize", this->generate_data({false}));
    }
};
