#include "sw-core-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_core_iface_object_info;

struct _SwCoreIfaceClass {
    GTypeInterface parent_class;
    sw_core_iface_get_services_impl get_services;
    sw_core_iface_is_online_impl is_online;
};

enum {
    SIGNAL_CORE_IFACE_OnlineChanged,
    N_CORE_IFACE_SIGNALS
};
static guint core_iface_signals[N_CORE_IFACE_SIGNALS] = {0};

static void sw_core_iface_base_init (gpointer klass);

GType
sw_core_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwCoreIfaceClass),
        sw_core_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwCoreIface", &info, 0);
    }

  return type;
}

/**
 * sw_core_iface_get_services_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetServices on interface com.meego.libsocialweb.
 */
static void
sw_core_iface_get_services (SwCoreIface *self,
    DBusGMethodInvocation *context)
{
  sw_core_iface_get_services_impl impl = (SW_CORE_IFACE_GET_CLASS (self)->get_services);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_core_iface_implement_get_services:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetServices D-Bus method
 *
 * Register an implementation for the GetServices method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_core_iface_implement_get_services (SwCoreIfaceClass *klass, sw_core_iface_get_services_impl impl)
{
  klass->get_services = impl;
}

/**
 * sw_core_iface_is_online_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * IsOnline on interface com.meego.libsocialweb.
 */
static void
sw_core_iface_is_online (SwCoreIface *self,
    DBusGMethodInvocation *context)
{
  sw_core_iface_is_online_impl impl = (SW_CORE_IFACE_GET_CLASS (self)->is_online);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_core_iface_implement_is_online:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the IsOnline D-Bus method
 *
 * Register an implementation for the IsOnline method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_core_iface_implement_is_online (SwCoreIfaceClass *klass, sw_core_iface_is_online_impl impl)
{
  klass->is_online = impl;
}

/**
 * sw_core_iface_emit_online_changed:
 * @instance: The object implementing this interface
 * @arg_online: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * OnlineChanged signal on interface com.meego.libsocialweb.
 */
void
sw_core_iface_emit_online_changed (gpointer instance,
    gboolean arg_online)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_CORE_IFACE));
  g_signal_emit (instance,
      core_iface_signals[SIGNAL_CORE_IFACE_OnlineChanged],
      0,
      arg_online);
}

static inline void
sw_core_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_core_iface_get_type (),
      &_sw_core_iface_object_info);

  /**
   * SwCoreIface::online-changed:
   * @arg_online: gboolean  (FIXME, generate documentation)
   *
   * The OnlineChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  core_iface_signals[SIGNAL_CORE_IFACE_OnlineChanged] =
  g_signal_new ("online-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOOLEAN,
      G_TYPE_NONE,
      1,
      G_TYPE_BOOLEAN);

}
static void
sw_core_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_core_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_core_iface_methods[] = {
  { (GCallback) sw_core_iface_get_services, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) sw_core_iface_is_online, g_cclosure_marshal_VOID__POINTER, 56 },
};

static const DBusGObjectInfo _sw_core_iface_object_info = {
  0,
  _sw_core_iface_methods,
  2,
"com.meego.libsocialweb\0GetServices\0A\0services\0O\0F\0N\0as\0\0com.meego.libsocialweb\0IsOnline\0A\0online\0O\0F\0N\0b\0\0\0",
"com.meego.libsocialweb\0OnlineChanged\0\0",
"\0\0",
};


