#!/bin/sh

# Copyright (C) 2002  Andres Salomon <dilinger@voxel.net>
#
# Template for setup-chrootdir-XX.sh scripts

PATH="/usr/local/sbin:/usr/sbin:/sbin:/usr/local/bin:/bin:/usr/bin"
# Directories to include in the chroot go here
DIRECTORIES="bin dev "
# Files to copy over to the chroot are included here
FILES="bin/false lib/libc.so.6 lib/ld-linux.so.2"

if test -z "$1"; then
	echo "Usage: $0 <directory>" 1>&2
	exit 1
fi

id=`id -u`
if test "$id" -gt 0; then
	echo "Error: this script requires root (for mknod)!" 1>&2
	exit 1
fi

dir=$1
curdir=`pwd`

# Create directory structure
mkdir -p $dir
cd $dir
for d in $DIRECTORIES; do
	mkdir -p $d
done

# Add files
for f in $FILES; do
	cp /$f $f
done

# And devices..
if test -d dev; then
	cp /dev/MAKEDEV dev
	cd dev && ./MAKEDEV std && rm -f MAKEDEV
fi


cd $curdir

exit 0
