package org.jboss.cache.marshall;

import org.jboss.cache.Fqn;
import org.jboss.cache.commands.ReplicableCommand;

/**
 * A regionalized MethodCall object, created when {@link Marshaller#regionalizedMethodCallFromByteBuffer(byte[])} or
 * {@link org.jboss.cache.marshall.Marshaller#regionalizedMethodCallFromObjectStream(java.io.ObjectInputStream)} is called.
 * <p/>
 * Specifically used by the {@link org.jboss.cache.marshall.InactiveRegionAwareRpcDispatcher} so that the region used to unmarshall
 * the method call is known, and can be used to marshall a result to return to the remote caller.
 * <p/>
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.1.1
 */
public class RegionalizedMethodCall
{
   public ReplicableCommand command;
   public Fqn region;
}
