/***************************************************************************
                           cpluginmanager.h  -  description
                             -------------------
    begin                : Fri Sep 27 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPLUGINMANAGER_H
#define CPLUGINMANAGER_H

/**
  *@author Mathias Küster
  *
  * It loads plugins. Plugins have unrestricted access to dclib's
  * public functions, they are essentially just extra dclib code
  * but not included in the source.
  *
  * The only known plugin is the plugin for remote access via
  * http, which cannot do very much.
  *
  * In addition, the design of dclib doesn't appear to allow
  * for a stable API or ABI, but no version information is
  * stored so forgetting to recompile the plugin will cause a crash.
  */

#include <dclib/dcos.h>
#include <dclib/core/cplugin.h>
#include <dclib/core/clist.h>
#include <dclib/core/csingleton.h>

class CPluginObject {
public:
	/** */
	CPluginObject() {};
	/** */
	~CPluginObject() {};

	/** Store filename loaded */
	CString m_sFileName;
	/** */
	ePluginStruct * m_ePluginStruct;
	/** */
#ifndef WIN32
	void * m_Handle;
#else
	HINSTANCE m_Handle;
#endif
};

class CPluginManager : public CSingleton<CPluginManager> {
public:
	/** */
	CPluginManager();
	/** */
	virtual ~CPluginManager();

	/** */
	void Load( CString path = CString() );
	/** */
	void InitPlugins();
	/** */
	void DeInitPlugins();
	/** */
	virtual bool Init( CPluginObject * plugin );

private:
	/** */
	CList<CPluginObject> * m_pPluginList;
};

#endif
