/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.Vector;
import jd.xml.util.XmlUtil;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.axis.ChildAxis;
import jd.xml.xpath.axis.NodeTypeTest;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.NodeSetExpression;
import jd.xml.xpath.expr.path.LocationStep;
import jd.xml.xpath.expr.path.SimpleLocationStep;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xslt.AttributeValue;
import jd.xml.xslt.expr.TextContentExpression;
import jd.xml.xslt.extension.jd.TryCatchTemplate;
import jd.xml.xslt.format.AnyLevelNumbering;
import jd.xml.xslt.format.MultiLevelNumbering;
import jd.xml.xslt.format.Numbering;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.format.SingleLevelNumbering;
import jd.xml.xslt.format.Sort;
import jd.xml.xslt.format.ValueNumbering;
import jd.xml.xslt.parser.AttributeIterator;
import jd.xml.xslt.parser.ParseListener;
import jd.xml.xslt.parser.Parser;
import jd.xml.xslt.parser.PatternParser;
import jd.xml.xslt.parser.TextContentBuilder;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.pattern.Pattern;
import jd.xml.xslt.template.ApplyImports;
import jd.xml.xslt.template.ApplyTemplates;
import jd.xml.xslt.template.ApplyTemplatesIterated;
import jd.xml.xslt.template.ApplyTemplatesToChildren;
import jd.xml.xslt.template.AttributeSet;
import jd.xml.xslt.template.CallTemplate;
import jd.xml.xslt.template.Choose;
import jd.xml.xslt.template.Condition;
import jd.xml.xslt.template.Copy;
import jd.xml.xslt.template.CopyOf;
import jd.xml.xslt.template.CreateAttribute;
import jd.xml.xslt.template.CreateComment;
import jd.xml.xslt.template.CreateElement;
import jd.xml.xslt.template.CreateElementEnd;
import jd.xml.xslt.template.CreatePi;
import jd.xml.xslt.template.CreateText;
import jd.xml.xslt.template.CreateTextUnescaped;
import jd.xml.xslt.template.DocumentTemplate;
import jd.xml.xslt.template.Fallback;
import jd.xml.xslt.template.ForEach;
import jd.xml.xslt.template.LiteralAttribute;
import jd.xml.xslt.template.LiteralElement;
import jd.xml.xslt.template.Message;
import jd.xml.xslt.template.NumberTemplate;
import jd.xml.xslt.template.OutputFormatTemplate;
import jd.xml.xslt.template.Template;
import jd.xml.xslt.template.TemplateRuleList;
import jd.xml.xslt.template.Unknown;
import jd.xml.xslt.template.ValueOf;
import jd.xml.xslt.template.ValueOfUnescaped;
import jd.xml.xslt.template.Variable;
import jd.xml.xslt.template.VariableBind;

public class TemplateParser
extends Parser {
    private static final int LEVEL_SINGLE = 0;
    private static final int LEVEL_MULTIPLE = 1;
    private static final int LEVEL_ANY = 2;
    private ParseListener parseListener_;
    private TextContentBuilder textContentBuilder_ = new TextContentBuilder();

    public TemplateParser(PatternParser patternParser) {
        super(patternParser);
    }

    public void setParseListener(ParseListener parseListener) {
        this.parseListener_ = parseListener;
    }

    public synchronized Template parse(XPathNode xPathNode) throws XsltParseException {
        if ((xPathNode = this.getStylesheetNode(xPathNode)) == null) {
            return null;
        }
        this.context_.startParseTemplateLevel();
        Template template = null;
        Template template2 = null;
        while (xPathNode != null) {
            Template template3;
            block53: {
                block52: {
                    template3 = null;
                    if (this.isStylesheetElement(xPathNode)) break block52;
                    switch (xPathNode.getType()) {
                        case 0: {
                            template3 = this.parseLiteralElement(xPathNode);
                            break block53;
                        }
                        case 1: {
                            template3 = new CreateText(xPathNode.getValue());
                            break block53;
                        }
                        default: {
                            throw new Error("invalid node type: " + xPathNode);
                        }
                    }
                }
                XPathNode xPathNode2 = xPathNode;
                String string = xPathNode2.getLocalName();
                AttributeIterator attributeIterator = this.setCurrentElement(xPathNode2);
                if (string.equals("apply-templates")) {
                    template3 = this.parseApplyTemplates(xPathNode2, attributeIterator);
                } else if (string.equals("value-of")) {
                    template3 = this.parseValueOf(xPathNode2, attributeIterator);
                } else if (string.equals("call-template")) {
                    template3 = this.parseCallTemplate(xPathNode2, attributeIterator);
                } else if (string.equals("for-each")) {
                    template3 = this.parseForEach(xPathNode2, attributeIterator);
                } else if (string.equals("choose")) {
                    template3 = this.parseChoose(xPathNode2, attributeIterator);
                } else if (string.equals("text")) {
                    template3 = this.parseText(xPathNode2, attributeIterator);
                } else if (string.equals("variable")) {
                    template3 = new VariableBind(this.parseVariable(xPathNode2, 0, attributeIterator));
                } else if (string.equals("copy")) {
                    template3 = this.parseCopy(xPathNode2, attributeIterator);
                } else if (string.equals("copy-of")) {
                    template3 = this.parseCopyOf(xPathNode2, attributeIterator);
                } else if (string.equals("element")) {
                    template3 = this.parseCreateElement(xPathNode2, attributeIterator);
                } else if (string.equals("attribute")) {
                    template3 = this.parseAttribute(xPathNode2, attributeIterator);
                } else if (string.equals("comment")) {
                    template3 = this.parseComment(xPathNode2, attributeIterator);
                } else if (string.equals("apply-imports")) {
                    template3 = this.parseApplyImports(xPathNode2, attributeIterator);
                } else if (string.equals("fallback")) {
                    template3 = this.parseFallback(xPathNode2, attributeIterator);
                } else if (string.equals("if")) {
                    template3 = this.parseCondition(xPathNode2, attributeIterator);
                } else if (string.equals("message")) {
                    template3 = this.parseMessage(xPathNode2, attributeIterator);
                } else if (string.equals("number")) {
                    template3 = this.parseNumber(xPathNode2, attributeIterator);
                } else if (string.equals("processing-instruction")) {
                    template3 = this.parsePi(xPathNode2, attributeIterator);
                } else if (string.equals("document")) {
                    template3 = this.parseDocument(xPathNode2, attributeIterator);
                } else if (string.equals("with-param") || string.equals("param") || string.equals("otherwise") || string.equals("when") || string.equals("sort")) {
                    this.throwException("element is not allowed at this place");
                } else if (this.context_.processForwardsCompatible()) {
                    template3 = this.parseUnknown(xPathNode2, attributeIterator);
                } else {
                    this.throwException("unknown instruction '" + string + "'");
                }
            }
            if (template3 != null) {
                if (this.parseListener_ != null) {
                    template3 = this.parseListener_.templateParsed(this.context_, template3);
                }
                if (template == null) {
                    template = template3;
                }
                if (template2 != null) {
                    template2.addNext(template3);
                }
                template2 = template3;
            }
            xPathNode = this.getNextStylesheetSibling(xPathNode);
        }
        this.context_.endParseTemplateLevel();
        return template;
    }

    private void parseElementChildren(Template template, XPathNode xPathNode) throws XsltParseException {
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        if (xPathNode2 != null) {
            template.addNext(this.parse(xPathNode2));
        }
        CreateElementEnd createElementEnd = new CreateElementEnd();
        template.addNext(createElementEnd);
    }

    private Template parseApplyImports(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        TemplateRuleList templateRuleList;
        if (attributeIterator.next()) {
            attributeIterator.reportInvalidAttribute();
        }
        if ((templateRuleList = this.context_.getCurrentTemplateRules()) == null) {
            this.throwException("cannot apply imports: no current template rule set");
        }
        return new ApplyImports(templateRuleList, this.parseWithParams(xPathNode), this.context_.getImportPrecedence() - 1);
    }

    private Template parseApplyTemplates(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Object object;
        Expression expression = null;
        String string = null;
        Sort sort = null;
        Vector vector = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("select")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            if (attributeIterator.match("mode")) {
                string = attributeIterator.getExpandedName();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        while (xPathNode2 != null) {
            boolean bl = false;
            if (this.isStylesheetElement(xPathNode2)) {
                object = xPathNode2.getLocalName();
                if (((String)object).equals("sort")) {
                    bl = true;
                    sort = this.parseSort(sort, xPathNode2);
                } else if (((String)object).equals("with-param")) {
                    bl = true;
                    vector = this.parseVariable(xPathNode2, 2, vector);
                }
            }
            if (!bl) {
                this.reportInvalidChild(xPathNode2, true);
            }
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
        Variable[] variableArray = this.getVariableArray(vector);
        object = this.context_.getRuleList(string);
        if (sort == null) {
            NodeSetExpression nodeSetExpression;
            if (expression == null) {
                return new ApplyTemplatesToChildren((TemplateRuleList)object, variableArray);
            }
            if (expression instanceof SimpleLocationStep && ((LocationStep)(nodeSetExpression = (SimpleLocationStep)expression)).getAxis() == ChildAxis.INSTANCE && ((LocationStep)nodeSetExpression).getNodeTest() == NodeTypeTest.ALL) {
                return new ApplyTemplatesToChildren((TemplateRuleList)object, variableArray);
            }
            if (expression instanceof NodeSetExpression && (nodeSetExpression = (NodeSetExpression)expression).canCreateModelWalker() && (!(expression instanceof SimpleLocationStep) || nodeSetExpression.getMaxResultSize() != 1)) {
                return new ApplyTemplatesIterated((TemplateRuleList)object, nodeSetExpression, variableArray);
            }
        }
        return new ApplyTemplates((TemplateRuleList)object, expression, sort, variableArray);
    }

    CreateAttribute parseAttribute(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        AttributeValue attributeValue = null;
        AttributeValue attributeValue2 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                attributeValue = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("namespace")) {
                attributeValue2 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (attributeValue == null) {
            this.reportMissingAttribute("name");
        }
        Template template = null;
        String string = null;
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        if (xPathNode2 != null) {
            if (xPathNode2.getType() == 1 && this.getNextStylesheetSibling(xPathNode2) == null) {
                string = xPathNode2.getValue();
            } else {
                template = this.parse(xPathNode2);
            }
        }
        return new CreateAttribute(this.context_.getNamespaceContext(), attributeValue, attributeValue2, template, string);
    }

    private Template parseCallTemplate(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        String string = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                string = attributeIterator.getExpandedName();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("name");
        }
        boolean bl = string.equals(this.context_.getCurrentParsedTemplateName());
        CallTemplate callTemplate = new CallTemplate(string, this.parseWithParams(xPathNode), bl);
        this.context_.addCallTemplate(callTemplate, xPathNode);
        return callTemplate;
    }

    private Condition parseCondition(XPathNode xPathNode) throws XsltParseException {
        AttributeIterator attributeIterator = this.setCurrentElement(xPathNode);
        return this.parseCondition(xPathNode, attributeIterator);
    }

    private Condition parseCondition(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Expression expression = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("test")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (expression == null) {
            this.reportMissingAttribute("test");
        }
        Template template = null;
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        if (xPathNode2 != null) {
            template = this.parse(xPathNode2);
        }
        return new Condition(expression, template);
    }

    private Template parseChoose(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        XPathNode xPathNode2;
        if (attributeIterator.next()) {
            attributeIterator.reportInvalidAttribute();
        }
        if ((xPathNode2 = this.getFirstStylesheetChild(xPathNode)) == null) {
            this.throwException("no when instructions defined");
        }
        Template template = null;
        Vector<Condition> vector = new Vector<Condition>();
        while (xPathNode2 != null) {
            boolean bl = false;
            if (this.isStylesheetElement(xPathNode2)) {
                String string = xPathNode2.getLocalName();
                if (string.equals("when")) {
                    if (template != null) {
                        this.throwException("otherwise must be last instruction");
                    }
                    vector.addElement(this.parseCondition(xPathNode2));
                    bl = true;
                } else if (string.equals("otherwise")) {
                    template = this.parseOtherwise(xPathNode2);
                    bl = true;
                }
            }
            if (!bl) {
                this.reportInvalidChild(xPathNode2, true);
            }
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
        Object[] objectArray = new Condition[vector.size()];
        vector.copyInto(objectArray);
        return new Choose((Condition[])objectArray, template);
    }

    private Template parseComment(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        if (attributeIterator.next()) {
            attributeIterator.reportInvalidAttribute();
        }
        return new CreateComment(this.parse(xPathNode.getFirstChild()));
    }

    private Template parseCopy(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        AttributeSet[] attributeSetArray = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("use-attribute-sets")) {
                attributeSetArray = this.getAttributeSets(attributeIterator.getExpandedNames());
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        return new Copy(attributeSetArray, this.parse(xPathNode.getFirstChild()));
    }

    private Template parseCopyOf(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        XPathNode xPathNode2;
        Expression expression = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("select")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (expression == null) {
            this.reportMissingAttribute("select");
        }
        if ((xPathNode2 = this.getFirstStylesheetChild(xPathNode)) != null) {
            this.reportInvalidChild(xPathNode2, false);
        }
        return new CopyOf(expression);
    }

    private Template parseCreateElement(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        AttributeValue attributeValue = null;
        AttributeValue attributeValue2 = null;
        AttributeSet[] attributeSetArray = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                attributeValue = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("namespace")) {
                attributeValue2 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("use-attribute-sets")) {
                attributeSetArray = this.getAttributeSets(attributeIterator.getExpandedNames());
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (attributeValue == null) {
            this.reportMissingAttribute("name");
        }
        CreateElement createElement = new CreateElement(this.context_.getNamespaceContext(), attributeValue, attributeValue2, attributeSetArray);
        this.parseElementChildren(createElement, xPathNode);
        return createElement;
    }

    private Template parseLiteralElement(XPathNode xPathNode) throws XsltParseException {
        Object object;
        Object object2;
        boolean bl = this.context_.processForwardsCompatible();
        AttributeIterator attributeIterator = this.setCurrentElement(xPathNode, false);
        LiteralAttribute literalAttribute = null;
        AttributeSet[] attributeSetArray = null;
        while (attributeIterator.next()) {
            object2 = attributeIterator.getAttribute();
            if (!this.isStylesheetNode((XPathNode)object2)) continue;
            if (attributeIterator.match("version")) {
                this.context_.setVersion(object2.getValue());
                continue;
            }
            if (attributeIterator.match("exclude-result-prefixes")) {
                this.parseExcludeResultPrefixes((XPathNode)object2);
                continue;
            }
            if (attributeIterator.match("extension-element-prefixes")) {
                this.parseExtensionElementPrefixes((XPathNode)object2);
                continue;
            }
            if (attributeIterator.match("use-attribute-sets")) {
                attributeSetArray = this.getAttributeSets(attributeIterator.getExpandedNames());
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        object2 = xPathNode.getNamespaceUri();
        if (object2 != null && this.context_.isExtensionNamespaceUri((String)object2)) {
            attributeIterator.start();
            return this.parseExtensionElement(xPathNode, attributeIterator);
        }
        attributeIterator.start();
        while (attributeIterator.next()) {
            object = attributeIterator.getAttribute();
            if (this.isStylesheetNode((XPathNode)object)) continue;
            if (object.getNamespaceUri() != null) {
                this.context_.checkLiteralNamespace(object.getPrefix(), object.getNamespaceUri());
            }
            literalAttribute = LiteralAttribute.add(object.getName(), object.getNamespaceUri(), object.getPrefix(), this.parseAttributeValue((XPathNode)object), literalAttribute);
        }
        if (xPathNode.getNamespaceUri() != null) {
            this.context_.checkLiteralNamespace(xPathNode.getPrefix(), xPathNode.getNamespaceUri());
        }
        object = new LiteralElement(xPathNode.getNodeName(), this.context_.getResultNamespaceContext(), literalAttribute, attributeSetArray);
        this.parseElementChildren((Template)object, xPathNode);
        this.context_.setProcessingMode(bl);
        return object;
    }

    private Template parseDocument(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        OutputFormatTemplate outputFormatTemplate = new OutputFormatTemplate();
        AttributeValue attributeValue = this.parseOutputFormat(attributeIterator, outputFormatTemplate, false);
        Template template = this.parse(xPathNode.getFirstChild());
        return new DocumentTemplate(this.context_.getBaseUri(), attributeValue, outputFormatTemplate, template);
    }

    private Template parseFallback(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        if (attributeIterator.next()) {
            attributeIterator.reportInvalidAttribute();
        }
        return new Fallback(this.parse(xPathNode.getFirstChild()));
    }

    private Template parseForEach(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Expression expression = null;
        Sort sort = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("select")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (expression == null) {
            this.reportMissingAttribute("select");
        }
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        while (xPathNode2 != null && this.isStylesheetElement(xPathNode2, "sort")) {
            sort = this.parseSort(sort, xPathNode2);
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
        TemplateRuleList templateRuleList = this.context_.setCurrentTemplateRules(null);
        Template template = this.parse(xPathNode2);
        this.context_.setCurrentTemplateRules(templateRuleList);
        return new ForEach(expression, sort, template);
    }

    private Template parseMessage(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        boolean bl = false;
        while (attributeIterator.next()) {
            if (attributeIterator.match("terminate")) {
                bl = attributeIterator.getBoolean("yes", "no", bl);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        if (xPathNode2 == null) {
            this.throwException("no message template defined");
        }
        return new Message(this.parse(xPathNode2), bl);
    }

    private Template parseNumber(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Object object;
        int n = 0;
        Pattern pattern = null;
        Pattern pattern2 = null;
        Expression expression = null;
        AttributeValue attributeValue = null;
        AttributeValue attributeValue2 = null;
        AttributeValue attributeValue3 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("level")) {
                object = attributeIterator.getValue();
                if (((String)object).equals("single")) {
                    n = 0;
                    continue;
                }
                if (((String)object).equals("multiple")) {
                    n = 1;
                    continue;
                }
                if (((String)object).equals("any")) {
                    n = 2;
                    continue;
                }
                attributeIterator.reportInvalidAttributeValue();
                continue;
            }
            if (attributeIterator.match("count")) {
                pattern = attributeIterator.getPattern();
                continue;
            }
            if (attributeIterator.match("from")) {
                pattern2 = attributeIterator.getPattern();
                continue;
            }
            if (attributeIterator.match("value")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            if (attributeIterator.match("format")) {
                attributeValue = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("lang") || attributeIterator.match("letter-value")) continue;
            if (attributeIterator.match("grouping-separator")) {
                attributeValue2 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("grouping-size")) {
                attributeValue3 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (expression != null) {
            object = new ValueNumbering(expression);
        } else {
            switch (n) {
                case 0: {
                    object = new SingleLevelNumbering(pattern, pattern2);
                    break;
                }
                case 1: {
                    object = new MultiLevelNumbering(pattern, pattern2);
                    break;
                }
                default: {
                    object = new AnyLevelNumbering(pattern, pattern2);
                }
            }
        }
        ((Numbering)object).setFormat(attributeValue, attributeValue2, attributeValue3);
        return new NumberTemplate((Numbering)object);
    }

    private Template parseOtherwise(XPathNode xPathNode) throws XsltParseException {
        XPathNode xPathNode2;
        AttributeIterator attributeIterator = this.setCurrentElement(xPathNode);
        if (attributeIterator.next()) {
            attributeIterator.reportInvalidAttribute();
        }
        return (xPathNode2 = this.getFirstStylesheetChild(xPathNode)) != null ? this.parse(xPathNode2) : null;
    }

    private Template parsePi(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        AttributeValue attributeValue = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                attributeValue = this.parseAttributeValue(attributeIterator);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (attributeValue == null) {
            this.reportMissingAttribute("name");
        }
        Template template = this.parse(xPathNode.getFirstChild());
        return new CreatePi(attributeValue, template);
    }

    private Sort parseSort(Sort sort, XPathNode xPathNode) throws XsltParseException {
        AttributeIterator attributeIterator = this.setCurrentElement(xPathNode);
        if (this.getFirstStylesheetChild(xPathNode) != null) {
            this.throwException("sort element cannot have content");
        }
        Expression expression = null;
        AttributeValue attributeValue = null;
        AttributeValue attributeValue2 = null;
        AttributeValue attributeValue3 = null;
        AttributeValue attributeValue4 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("select")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            if (attributeIterator.match("lang")) {
                attributeValue = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("order")) {
                attributeValue2 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("case-order")) {
                attributeValue3 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("data-type")) {
                attributeValue4 = this.parseAttributeValue(attributeIterator);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        Sort sort2 = new Sort(expression, attributeValue, attributeValue4, attributeValue2, attributeValue3);
        if (sort != null) {
            sort.addNext(sort2);
        } else {
            sort = sort2;
        }
        return sort;
    }

    private Template parseText(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        boolean bl = false;
        while (attributeIterator.next()) {
            if (attributeIterator.match("disable-output-escaping")) {
                bl = attributeIterator.getBoolean("yes", "no", bl);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        Template template = null;
        for (XPathNode xPathNode2 = xPathNode.getFirstChild(); xPathNode2 != null; xPathNode2 = xPathNode2.getNextSibling()) {
            if (xPathNode2.getType() == 1 && template == null) {
                String string = xPathNode2.getValue();
                if (bl) {
                    template = new CreateTextUnescaped(string);
                    continue;
                }
                template = new CreateText(string);
                continue;
            }
            if (xPathNode2.getType() != 0) continue;
            this.throwException("xsl:text must not have child elements");
        }
        return template;
    }

    private Template parseUnknown(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Template template = this.parse(xPathNode.getFirstChild());
        return new Unknown(xPathNode.getName(), template);
    }

    private Template parseValueOf(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Expression expression = null;
        boolean bl = false;
        while (attributeIterator.next()) {
            if (attributeIterator.match("select")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            if (attributeIterator.match("disable-output-escaping")) {
                bl = attributeIterator.getBoolean("yes", "no", bl);
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (expression == null) {
            this.reportMissingAttribute("select");
        }
        if (bl) {
            return new ValueOfUnescaped(expression);
        }
        return new ValueOf(expression);
    }

    Variable parseVariable(XPathNode xPathNode, int n, AttributeIterator attributeIterator) throws XsltParseException {
        return this.parseVariable(xPathNode, n, attributeIterator, false);
    }

    Variable parseVariable(XPathNode xPathNode, int n, AttributeIterator attributeIterator, boolean bl) throws XsltParseException {
        XPathNode xPathNode2;
        String string = null;
        Expression expression = null;
        Template template = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                string = attributeIterator.getValue();
                if (XmlUtil.isQName(string)) continue;
                throw this.context_.createException("variable name '" + string + "' is not a valid QName", attributeIterator.getAttribute());
            }
            if (attributeIterator.match("select")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("name");
        }
        if ((xPathNode2 = this.getFirstStylesheetChild(xPathNode)) != null) {
            if (expression != null) {
                this.throwException("variable cannot have a select attribute and content");
            }
            if (bl) {
                this.context_.startParseTemplate(null, 0);
                template = this.parse(xPathNode2);
                this.context_.endParseTemplate();
            } else {
                template = this.parse(xPathNode2);
            }
            this.textContentBuilder_.buildText(template);
            if (this.textContentBuilder_.hasCompleteText() && !this.textContentBuilder_.hasNonTextContent()) {
                expression = new TextContentExpression(this.textContentBuilder_.getText());
                template = null;
                if (this.parseListener_ != null) {
                    expression = this.parseListener_.expressionParsed(this.context_, expression, ((Object)expression).toString());
                }
            }
        }
        VariableName variableName = this.context_.addVariableName(string, n);
        return new Variable(variableName, expression, template, n);
    }

    Vector parseVariable(XPathNode xPathNode, int n, Vector vector) throws XsltParseException {
        if (vector == null) {
            vector = new Vector<Variable>();
        }
        AttributeIterator attributeIterator = this.setCurrentElement(xPathNode);
        vector.addElement(this.parseVariable(xPathNode, n, attributeIterator));
        return vector;
    }

    private Variable[] parseWithParams(XPathNode xPathNode) throws XsltParseException {
        Vector vector = null;
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        while (xPathNode2 != null) {
            if (this.isStylesheetElement(xPathNode2, "with-param")) {
                vector = this.parseVariable(xPathNode2, 2, vector);
            } else {
                this.reportInvalidChild(xPathNode2, true);
            }
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
        return this.getVariableArray(vector);
    }

    Variable[] getVariableArray(Vector vector) {
        int n;
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            Object[] objectArray = new Variable[n];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    AttributeValue parseOutputFormat(AttributeIterator attributeIterator, OutputFormatTemplate outputFormatTemplate, boolean bl) throws XsltParseException {
        AttributeValue attributeValue = null;
        outputFormatTemplate.setNamespaceContext(this.context_.getNamespaceContext());
        while (attributeIterator.next()) {
            if (attributeIterator.match("href") && !bl) {
                attributeValue = this.parseAttributeValue(attributeIterator);
                continue;
            }
            if (attributeIterator.match("cdata-section-elements")) {
                if (!bl) {
                    this.throwException("'cdata-section-elements' attribute not supported for xsl:document instruction");
                }
                this.context_.addCDataSectionElements(attributeIterator.getValue(), outputFormatTemplate);
                continue;
            }
            int n = OutputFormat.getOptionIndex(attributeIterator.getName());
            if (n != -1) {
                outputFormatTemplate.setOption(n, this.parseAttributeValue(attributeIterator));
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (!bl && attributeValue == null) {
            this.reportMissingAttribute("href");
        }
        return attributeValue;
    }

    private Template parseExtensionElement(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        String string;
        String string2 = xPathNode.getNamespaceUri();
        if ("http://www.aztecrider.com/xslt".equals(string2) && (string = xPathNode.getLocalName()).equals("trycatch")) {
            return this.parseExtensionTryCatch(xPathNode, attributeIterator);
        }
        return this.parseUnknown(xPathNode, attributeIterator);
    }

    private Template parseExtensionTryCatch(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        while (attributeIterator.next()) {
            if (this.isStylesheetNode(attributeIterator.getAttribute()) && attributeIterator.match("extension-element-prefixes")) continue;
            attributeIterator.reportInvalidAttribute();
        }
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        this.expectExtensionElement(xPathNode, xPathNode2, "http://www.aztecrider.com/xslt", "try");
        Template template = this.parse(xPathNode2.getFirstChild());
        xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        this.expectExtensionElement(xPathNode, xPathNode2, "http://www.aztecrider.com/xslt", "catch");
        Template template2 = this.parse(xPathNode2.getFirstChild());
        xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        if (xPathNode2 != null) {
            throw this.context_.createException("unexpected node", xPathNode2);
        }
        return new TryCatchTemplate(template, template2);
    }

    protected void expectExtensionElement(XPathNode xPathNode, XPathNode xPathNode2, String string, String string2) throws XsltParseException {
        if (xPathNode2 == null || xPathNode2.getType() != 0 || !string.equals(xPathNode2.getNamespaceUri()) || !string2.equals(xPathNode2.getLocalName())) {
            XPathNode xPathNode3 = xPathNode2 == null ? xPathNode : xPathNode2;
            throw this.context_.createException("expected extension-element '" + string2 + "'", xPathNode3);
        }
    }

    private AttributeSet[] getAttributeSets(String[] stringArray) {
        AttributeSet[] attributeSetArray = null;
        if (stringArray != null) {
            attributeSetArray = new AttributeSet[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                attributeSetArray[i] = this.context_.getAttributeSet(stringArray[i]);
            }
        }
        return attributeSetArray;
    }

    private AttributeValue parseAttributeValue(AttributeIterator attributeIterator) throws XsltParseException {
        return this.parseAttributeValue(attributeIterator.getAttribute());
    }

    private AttributeValue parseAttributeValue(XPathNode xPathNode) throws XsltParseException {
        try {
            return this.patternParser_.parseAttributeValue(xPathNode.getValue());
        }
        catch (Exception exception) {
            throw this.context_.createException("cannot parse attribute value", xPathNode, exception);
        }
    }
}

