/* graphmodel.c generated by valac 0.14.2, the Vala compiler
 * generated from graphmodel.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_GRAPH_MODEL (graph_model_get_type ())
#define GRAPH_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPH_MODEL, GraphModel))
#define GRAPH_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPH_MODEL, GraphModelClass))
#define IS_GRAPH_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPH_MODEL))
#define IS_GRAPH_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPH_MODEL))
#define GRAPH_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPH_MODEL, GraphModelClass))

typedef struct _GraphModel GraphModel;
typedef struct _GraphModelClass GraphModelClass;
typedef struct _GraphModelPrivate GraphModelPrivate;

#define TYPE_PROVIDERS (providers_get_type ())
#define PROVIDERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROVIDERS, Providers))
#define PROVIDERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROVIDERS, ProvidersClass))
#define IS_PROVIDERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROVIDERS))
#define IS_PROVIDERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROVIDERS))
#define PROVIDERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROVIDERS, ProvidersClass))

typedef struct _Providers Providers;
typedef struct _ProvidersClass ProvidersClass;

#define TYPE_EXPRESSION_CACHE (expression_cache_get_type ())
#define EXPRESSION_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_CACHE, ExpressionCache))
#define EXPRESSION_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_CACHE, ExpressionCacheClass))
#define IS_EXPRESSION_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_CACHE))
#define IS_EXPRESSION_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_CACHE))
#define EXPRESSION_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_CACHE, ExpressionCacheClass))

typedef struct _ExpressionCache ExpressionCache;
typedef struct _ExpressionCacheClass ExpressionCacheClass;

#define TYPE_TRACE_MODEL (trace_model_get_type ())
#define TRACE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACE_MODEL, TraceModel))
#define TRACE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACE_MODEL, TraceModelClass))
#define IS_TRACE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACE_MODEL))
#define IS_TRACE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACE_MODEL))
#define TRACE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACE_MODEL, TraceModelClass))

typedef struct _TraceModel TraceModel;
typedef struct _TraceModelClass TraceModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GraphModel {
	GObject parent_instance;
	GraphModelPrivate * priv;
};

struct _GraphModelClass {
	GObjectClass parent_class;
};

struct _GraphModelPrivate {
	guint smoothvalue;
	gdouble* scalerhistory;
	gint scalerhistory_length1;
	gint _scalerhistory_size_;
	gchar* _id;
	Providers* _providers;
	ExpressionCache* _minimum;
	ExpressionCache* _maximum;
	gchar* _smooth;
	GdkColor _background_color;
	guint _alpha;
	gboolean _enabled;
	gchar** _traces;
	gint _traces_length1;
	gint __traces_size_;
	gdouble _scale;
	TraceModel** _tracemodels;
	gint _tracemodels_length1;
	gint __tracemodels_size_;
};


static gpointer graph_model_parent_class = NULL;

GType graph_model_get_type (void) G_GNUC_CONST;
GType providers_get_type (void) G_GNUC_CONST;
GType expression_cache_get_type (void) G_GNUC_CONST;
GType trace_model_get_type (void) G_GNUC_CONST;
#define GRAPH_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GRAPH_MODEL, GraphModelPrivate))
enum  {
	GRAPH_MODEL_DUMMY_PROPERTY,
	GRAPH_MODEL_ID,
	GRAPH_MODEL_PROVIDERS,
	GRAPH_MODEL_MINIMUM,
	GRAPH_MODEL_MAXIMUM,
	GRAPH_MODEL_SMOOTH,
	GRAPH_MODEL_BACKGROUND_COLOR,
	GRAPH_MODEL_ALPHA,
	GRAPH_MODEL_ENABLED,
	GRAPH_MODEL_TRACES,
	GRAPH_MODEL_SCALE
};
GraphModel* graph_model_new (const gchar* id, Providers* providers);
GraphModel* graph_model_construct (GType object_type, const gchar* id, Providers* providers);
ExpressionCache* expression_cache_new (Providers* providers, const gchar* expression);
ExpressionCache* expression_cache_construct (GType object_type, Providers* providers, const gchar* expression);
void graph_model_update (GraphModel* self, guint trace_length);
TraceModel** graph_model_get_tracemodels (GraphModel* self, int* result_length1);
void trace_model_set_values_length (TraceModel* self, guint length);
ExpressionCache* trace_model_get_expression (TraceModel* self);
void expression_cache_update (ExpressionCache* self);
void trace_model_add_value (TraceModel* self, gdouble value);
gchar* expression_cache_label (ExpressionCache* self);
ExpressionCache* graph_model_get_minimum (GraphModel* self);
ExpressionCache* graph_model_get_maximum (GraphModel* self);
static void graph_model_update_scale (GraphModel* self, gdouble scalerminimum, gdouble scalermaximum, guint trace_length);
gboolean trace_model_get_enabled (TraceModel* self);
gdouble* trace_model_get_values (TraceModel* self, int* result_length1);
gdouble utils_max (gdouble* data, int data_length1);
gdouble utils_mean (gdouble* data, int data_length1);
static void graph_model_set_scale (GraphModel* self, gdouble value);
void graph_model_set_source_color (GraphModel* self, cairo_t* ctx);
void graph_model_get_background_color (GraphModel* self, GdkColor* result);
guint graph_model_get_alpha (GraphModel* self);
const gchar* graph_model_get_id (GraphModel* self);
static void graph_model_set_id (GraphModel* self, const gchar* value);
Providers* graph_model_get_providers (GraphModel* self);
static void graph_model_set_providers (GraphModel* self, Providers* value);
static void graph_model_set_minimum (GraphModel* self, ExpressionCache* value);
static void graph_model_set_maximum (GraphModel* self, ExpressionCache* value);
const gchar* graph_model_get_smooth (GraphModel* self);
void graph_model_set_smooth (GraphModel* self, const gchar* value);
void graph_model_set_background_color (GraphModel* self, GdkColor* value);
void graph_model_set_alpha (GraphModel* self, guint value);
gboolean graph_model_get_enabled (GraphModel* self);
void graph_model_set_enabled (GraphModel* self, gboolean value);
gchar** graph_model_get_traces (GraphModel* self, int* result_length1);
void graph_model_set_traces (GraphModel* self, gchar** value, int value_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gdouble graph_model_get_scale (GraphModel* self);
static void graph_model_set_tracemodels (GraphModel* self, TraceModel** value, int value_length1);
static TraceModel** _vala_array_dup9 (TraceModel** self, int length);
static GObject * graph_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _graph_model___lambda0_ (GraphModel* self);
static void __graph_model___lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _graph_model___lambda1_ (GraphModel* self);
TraceModel* trace_model_new (Providers* providers);
TraceModel* trace_model_construct (GType object_type, Providers* providers);
static void _vala_array_add10 (TraceModel*** array, int* length, int* size, TraceModel* value);
static TraceModel** _vala_array_dup10 (TraceModel** self, int length);
static void __graph_model___lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void graph_model_finalize (GObject* obj);
static void _vala_graph_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_graph_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GraphModel* graph_model_construct (GType object_type, const gchar* id, Providers* providers) {
	GraphModel * self = NULL;
	const gchar* _tmp0_;
	Providers* _tmp1_;
	Providers* _tmp2_;
	ExpressionCache* _tmp3_;
	ExpressionCache* _tmp4_;
	Providers* _tmp5_;
	ExpressionCache* _tmp6_;
	ExpressionCache* _tmp7_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (IS_PROVIDERS (providers), NULL);
	_tmp0_ = id;
	_tmp1_ = providers;
	_tmp2_ = providers;
	_tmp3_ = expression_cache_new (_tmp2_, "");
	_tmp4_ = _tmp3_;
	_tmp5_ = providers;
	_tmp6_ = expression_cache_new (_tmp5_, "");
	_tmp7_ = _tmp6_;
	self = (GraphModel*) g_object_new (object_type, "id", _tmp0_, "providers", _tmp1_, "minimum", _tmp4_, "maximum", _tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	return self;
}


GraphModel* graph_model_new (const gchar* id, Providers* providers) {
	return graph_model_construct (TYPE_GRAPH_MODEL, id, providers);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


void graph_model_update (GraphModel* self, guint trace_length) {
	TraceModel** _tmp0_;
	gint _tmp0__length1;
	TraceModel** _tmp1_;
	gint _tmp1__length1;
	ExpressionCache* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_;
	gdouble scalerminimum;
	ExpressionCache* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_;
	gdouble scalermaximum;
	guint _tmp25_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = graph_model_get_tracemodels (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	{
		TraceModel** tracemodel_collection = NULL;
		gint tracemodel_collection_length1 = 0;
		gint _tracemodel_collection_size_ = 0;
		gint tracemodel_it = 0;
		tracemodel_collection = _tmp1_;
		tracemodel_collection_length1 = _tmp1__length1;
		for (tracemodel_it = 0; tracemodel_it < _tmp1__length1; tracemodel_it = tracemodel_it + 1) {
			TraceModel* _tmp2_;
			TraceModel* tracemodel = NULL;
			_tmp2_ = _g_object_ref0 (tracemodel_collection[tracemodel_it]);
			tracemodel = _tmp2_;
			{
				TraceModel* _tmp3_;
				guint _tmp4_;
				TraceModel* _tmp5_;
				ExpressionCache* _tmp6_;
				ExpressionCache* _tmp7_;
				TraceModel* _tmp8_;
				TraceModel* _tmp9_;
				ExpressionCache* _tmp10_;
				ExpressionCache* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gdouble _tmp14_ = 0.0;
				_tmp3_ = tracemodel;
				_tmp4_ = trace_length;
				trace_model_set_values_length (_tmp3_, _tmp4_);
				_tmp5_ = tracemodel;
				_tmp6_ = trace_model_get_expression (_tmp5_);
				_tmp7_ = _tmp6_;
				expression_cache_update (_tmp7_);
				_tmp8_ = tracemodel;
				_tmp9_ = tracemodel;
				_tmp10_ = trace_model_get_expression (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = expression_cache_label (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = double_parse (_tmp13_);
				trace_model_add_value (_tmp8_, _tmp14_);
				_g_free0 (_tmp13_);
				_g_object_unref0 (tracemodel);
			}
		}
	}
	_tmp15_ = self->priv->_minimum;
	_tmp16_ = expression_cache_label (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = double_parse (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	scalerminimum = _tmp19_;
	_tmp20_ = self->priv->_maximum;
	_tmp21_ = expression_cache_label (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = double_parse (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	scalermaximum = _tmp24_;
	_tmp25_ = trace_length;
	graph_model_update_scale (self, scalerminimum, scalermaximum, _tmp25_);
}


static void graph_model_update_scale (GraphModel* self, gdouble scalerminimum, gdouble scalermaximum, guint trace_length) {
	gdouble _tmp0_;
	gdouble currentpeak;
	gdouble _tmp22_;
	gdouble* _tmp26_;
	gint _tmp26__length1;
	gdouble* _tmp38_;
	gint _tmp38__length1;
	gdouble _tmp39_ = 0.0;
	gdouble historymaximum;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble* _tmp64_;
	gint _tmp64__length1;
	gdouble* _tmp65_;
	gint _tmp65__length1;
	gdouble _tmp66_;
	gdouble _tmp67_;
	gdouble* _tmp68_;
	gint _tmp68__length1;
	gdouble _tmp69_ = 0.0;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = scalerminimum;
	currentpeak = _tmp0_;
	{
		guint i;
		guint _tmp1_;
		guint isize;
		i = (guint) 0;
		_tmp1_ = trace_length;
		isize = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				guint _tmp5_;
				guint _tmp6_;
				gdouble currentvalue;
				TraceModel** _tmp7_;
				gint _tmp7__length1;
				TraceModel** _tmp8_;
				gint _tmp8__length1;
				gdouble _tmp19_;
				gdouble _tmp20_;
				gdouble _tmp21_ = 0.0;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = isize;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				currentvalue = (gdouble) 0;
				_tmp7_ = graph_model_get_tracemodels (self, &_tmp7__length1);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _tmp7__length1;
				{
					TraceModel** tracemodel_collection = NULL;
					gint tracemodel_collection_length1 = 0;
					gint _tracemodel_collection_size_ = 0;
					gint tracemodel_it = 0;
					tracemodel_collection = _tmp8_;
					tracemodel_collection_length1 = _tmp8__length1;
					for (tracemodel_it = 0; tracemodel_it < _tmp8__length1; tracemodel_it = tracemodel_it + 1) {
						TraceModel* _tmp9_;
						TraceModel* tracemodel = NULL;
						_tmp9_ = _g_object_ref0 (tracemodel_collection[tracemodel_it]);
						tracemodel = _tmp9_;
						{
							TraceModel* _tmp10_;
							gboolean _tmp11_;
							gboolean _tmp12_;
							_tmp10_ = tracemodel;
							_tmp11_ = trace_model_get_enabled (_tmp10_);
							_tmp12_ = _tmp11_;
							if (_tmp12_) {
								gdouble _tmp13_;
								TraceModel* _tmp14_;
								gdouble* _tmp15_;
								gint _tmp15__length1;
								gdouble* _tmp16_;
								gint _tmp16__length1;
								guint _tmp17_;
								gdouble _tmp18_;
								_tmp13_ = currentvalue;
								_tmp14_ = tracemodel;
								_tmp15_ = trace_model_get_values (_tmp14_, &_tmp15__length1);
								_tmp16_ = _tmp15_;
								_tmp16__length1 = _tmp15__length1;
								_tmp17_ = i;
								_tmp18_ = _tmp16_[_tmp17_];
								currentvalue = _tmp13_ + _tmp18_;
							}
							_g_object_unref0 (tracemodel);
						}
					}
				}
				_tmp19_ = currentpeak;
				_tmp20_ = currentvalue;
				_tmp21_ = MAX (_tmp19_, _tmp20_);
				currentpeak = _tmp21_;
			}
		}
	}
	_tmp22_ = scalermaximum;
	if (_tmp22_ != ((gdouble) 0)) {
		gdouble _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_ = 0.0;
		_tmp23_ = currentpeak;
		_tmp24_ = scalermaximum;
		_tmp25_ = MIN (_tmp23_, _tmp24_);
		currentpeak = _tmp25_;
	}
	_tmp26_ = self->priv->scalerhistory;
	_tmp26__length1 = self->priv->scalerhistory_length1;
	if (_tmp26__length1 == 0) {
		guint _tmp27_;
		gdouble* _tmp28_ = NULL;
		_tmp27_ = self->priv->smoothvalue;
		_tmp28_ = g_new0 (gdouble, _tmp27_);
		self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
		self->priv->scalerhistory = _tmp28_;
		self->priv->scalerhistory_length1 = _tmp27_;
		self->priv->_scalerhistory_size_ = self->priv->scalerhistory_length1;
		{
			guint i;
			i = (guint) 0;
			{
				gboolean _tmp29_;
				_tmp29_ = TRUE;
				while (TRUE) {
					gboolean _tmp30_;
					guint _tmp32_;
					guint _tmp33_;
					gdouble* _tmp34_;
					gint _tmp34__length1;
					guint _tmp35_;
					gdouble _tmp36_;
					gdouble _tmp37_;
					_tmp30_ = _tmp29_;
					if (!_tmp30_) {
						guint _tmp31_;
						_tmp31_ = i;
						i = _tmp31_ + 1;
					}
					_tmp29_ = FALSE;
					_tmp32_ = i;
					_tmp33_ = self->priv->smoothvalue;
					if (!(_tmp32_ < _tmp33_)) {
						break;
					}
					_tmp34_ = self->priv->scalerhistory;
					_tmp34__length1 = self->priv->scalerhistory_length1;
					_tmp35_ = i;
					_tmp36_ = scalerminimum;
					_tmp34_[_tmp35_] = _tmp36_;
					_tmp37_ = _tmp34_[_tmp35_];
				}
			}
		}
	}
	_tmp38_ = self->priv->scalerhistory;
	_tmp38__length1 = self->priv->scalerhistory_length1;
	_tmp39_ = utils_max (_tmp38_, _tmp38__length1);
	historymaximum = _tmp39_;
	_tmp40_ = currentpeak;
	_tmp41_ = historymaximum;
	if (_tmp40_ < _tmp41_) {
		{
			guint i;
			gdouble* _tmp42_;
			gint _tmp42__length1;
			guint isize;
			i = (guint) 0;
			_tmp42_ = self->priv->scalerhistory;
			_tmp42__length1 = self->priv->scalerhistory_length1;
			isize = (guint) _tmp42__length1;
			{
				gboolean _tmp43_;
				_tmp43_ = TRUE;
				while (TRUE) {
					gboolean _tmp44_;
					guint _tmp46_;
					guint _tmp47_;
					gdouble* _tmp48_;
					gint _tmp48__length1;
					guint _tmp49_;
					gdouble* _tmp50_;
					gint _tmp50__length1;
					guint _tmp51_;
					gdouble _tmp52_;
					gdouble _tmp53_;
					_tmp44_ = _tmp43_;
					if (!_tmp44_) {
						guint _tmp45_;
						_tmp45_ = i;
						i = _tmp45_ + 1;
					}
					_tmp43_ = FALSE;
					_tmp46_ = i;
					_tmp47_ = isize;
					if (!((_tmp46_ + 1) < _tmp47_)) {
						break;
					}
					_tmp48_ = self->priv->scalerhistory;
					_tmp48__length1 = self->priv->scalerhistory_length1;
					_tmp49_ = i;
					_tmp50_ = self->priv->scalerhistory;
					_tmp50__length1 = self->priv->scalerhistory_length1;
					_tmp51_ = i;
					_tmp52_ = _tmp50_[_tmp51_ + 1];
					_tmp48_[_tmp49_] = _tmp52_;
					_tmp53_ = _tmp48_[_tmp49_];
				}
			}
		}
	} else {
		{
			guint i;
			gdouble* _tmp54_;
			gint _tmp54__length1;
			guint isize;
			i = (guint) 0;
			_tmp54_ = self->priv->scalerhistory;
			_tmp54__length1 = self->priv->scalerhistory_length1;
			isize = (guint) _tmp54__length1;
			{
				gboolean _tmp55_;
				_tmp55_ = TRUE;
				while (TRUE) {
					gboolean _tmp56_;
					guint _tmp58_;
					guint _tmp59_;
					gdouble* _tmp60_;
					gint _tmp60__length1;
					guint _tmp61_;
					gdouble _tmp62_;
					gdouble _tmp63_;
					_tmp56_ = _tmp55_;
					if (!_tmp56_) {
						guint _tmp57_;
						_tmp57_ = i;
						i = _tmp57_ + 1;
					}
					_tmp55_ = FALSE;
					_tmp58_ = i;
					_tmp59_ = isize;
					if (!((_tmp58_ + 1) < _tmp59_)) {
						break;
					}
					_tmp60_ = self->priv->scalerhistory;
					_tmp60__length1 = self->priv->scalerhistory_length1;
					_tmp61_ = i;
					_tmp62_ = currentpeak;
					_tmp60_[_tmp61_] = _tmp62_;
					_tmp63_ = _tmp60_[_tmp61_];
				}
			}
		}
	}
	_tmp64_ = self->priv->scalerhistory;
	_tmp64__length1 = self->priv->scalerhistory_length1;
	_tmp65_ = self->priv->scalerhistory;
	_tmp65__length1 = self->priv->scalerhistory_length1;
	_tmp66_ = currentpeak;
	_tmp64_[_tmp65__length1 - 1] = _tmp66_;
	_tmp67_ = _tmp64_[_tmp65__length1 - 1];
	_tmp68_ = self->priv->scalerhistory;
	_tmp68__length1 = self->priv->scalerhistory_length1;
	_tmp69_ = utils_mean (_tmp68_, _tmp68__length1);
	graph_model_set_scale (self, _tmp69_);
}


void graph_model_set_source_color (GraphModel* self, cairo_t* ctx) {
	cairo_t* _tmp0_;
	GdkColor _tmp1_;
	guint16 _tmp2_;
	GdkColor _tmp3_;
	guint16 _tmp4_;
	GdkColor _tmp5_;
	guint16 _tmp6_;
	guint _tmp7_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = self->priv->_background_color;
	_tmp2_ = _tmp1_.red;
	_tmp3_ = self->priv->_background_color;
	_tmp4_ = _tmp3_.green;
	_tmp5_ = self->priv->_background_color;
	_tmp6_ = _tmp5_.blue;
	_tmp7_ = self->priv->_alpha;
	cairo_set_source_rgba (_tmp0_, _tmp2_ / 65535.0, _tmp4_ / 65565.0, _tmp6_ / 65565.0, _tmp7_ / 65565.0);
}


const gchar* graph_model_get_id (GraphModel* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void graph_model_set_id (GraphModel* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


Providers* graph_model_get_providers (GraphModel* self) {
	Providers* result;
	Providers* _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_providers;
	result = _tmp0_;
	return result;
}


static void graph_model_set_providers (GraphModel* self, Providers* value) {
	Providers* _tmp0_;
	Providers* _tmp1_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_providers);
	self->priv->_providers = _tmp1_;
	g_object_notify ((GObject *) self, "providers");
}


ExpressionCache* graph_model_get_minimum (GraphModel* self) {
	ExpressionCache* result;
	ExpressionCache* _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_minimum;
	result = _tmp0_;
	return result;
}


static void graph_model_set_minimum (GraphModel* self, ExpressionCache* value) {
	ExpressionCache* _tmp0_;
	ExpressionCache* _tmp1_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_minimum);
	self->priv->_minimum = _tmp1_;
	g_object_notify ((GObject *) self, "minimum");
}


ExpressionCache* graph_model_get_maximum (GraphModel* self) {
	ExpressionCache* result;
	ExpressionCache* _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_maximum;
	result = _tmp0_;
	return result;
}


static void graph_model_set_maximum (GraphModel* self, ExpressionCache* value) {
	ExpressionCache* _tmp0_;
	ExpressionCache* _tmp1_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_maximum);
	self->priv->_maximum = _tmp1_;
	g_object_notify ((GObject *) self, "maximum");
}


const gchar* graph_model_get_smooth (GraphModel* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_smooth;
	result = _tmp0_;
	return result;
}


void graph_model_set_smooth (GraphModel* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_smooth);
	self->priv->_smooth = _tmp1_;
	g_object_notify ((GObject *) self, "smooth");
}


void graph_model_get_background_color (GraphModel* self, GdkColor* result) {
	GdkColor _tmp0_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = self->priv->_background_color;
	*result = _tmp0_;
	return;
}


void graph_model_set_background_color (GraphModel* self, GdkColor* value) {
	GdkColor _tmp0_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = *value;
	self->priv->_background_color = _tmp0_;
	g_object_notify ((GObject *) self, "background-color");
}


guint graph_model_get_alpha (GraphModel* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), 0U);
	_tmp0_ = self->priv->_alpha;
	result = _tmp0_;
	return result;
}


void graph_model_set_alpha (GraphModel* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	self->priv->_alpha = _tmp0_;
	g_object_notify ((GObject *) self, "alpha");
}


gboolean graph_model_get_enabled (GraphModel* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), FALSE);
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


void graph_model_set_enabled (GraphModel* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	self->priv->_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "enabled");
}


gchar** graph_model_get_traces (GraphModel* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_traces;
	_tmp0__length1 = self->priv->_traces_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void graph_model_set_traces (GraphModel* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_traces = (_vala_array_free (self->priv->_traces, self->priv->_traces_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_traces = _tmp1_;
	self->priv->_traces_length1 = _tmp1__length1;
	self->priv->__traces_size_ = self->priv->_traces_length1;
	g_object_notify ((GObject *) self, "traces");
}


gdouble graph_model_get_scale (GraphModel* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), 0.0);
	_tmp0_ = self->priv->_scale;
	result = _tmp0_;
	return result;
}


static void graph_model_set_scale (GraphModel* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	self->priv->_scale = _tmp0_;
	g_object_notify ((GObject *) self, "scale");
}


TraceModel** graph_model_get_tracemodels (GraphModel* self, int* result_length1) {
	TraceModel** result;
	TraceModel** _tmp0_;
	gint _tmp0__length1;
	TraceModel** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (IS_GRAPH_MODEL (self), NULL);
	_tmp0_ = self->priv->_tracemodels;
	_tmp0__length1 = self->priv->_tracemodels_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static TraceModel** _vala_array_dup9 (TraceModel** self, int length) {
	TraceModel** result;
	int i;
	result = g_new0 (TraceModel*, length + 1);
	for (i = 0; i < length; i++) {
		TraceModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void graph_model_set_tracemodels (GraphModel* self, TraceModel** value, int value_length1) {
	TraceModel** _tmp0_;
	gint _tmp0__length1;
	TraceModel** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (IS_GRAPH_MODEL (self));
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup9 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_tracemodels = (_vala_array_free (self->priv->_tracemodels, self->priv->_tracemodels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_tracemodels = _tmp1_;
	self->priv->_tracemodels_length1 = _tmp1__length1;
	self->priv->__tracemodels_size_ = self->priv->_tracemodels_length1;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void _graph_model___lambda0_ (GraphModel* self) {
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	_tmp0_ = self->priv->_smooth;
	_tmp1_ = uint64_parse (_tmp0_);
	self->priv->smoothvalue = (guint) _tmp1_;
	self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
	self->priv->scalerhistory = NULL;
	self->priv->scalerhistory_length1 = 0;
	self->priv->_scalerhistory_size_ = self->priv->scalerhistory_length1;
}


static void __graph_model___lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_graph_model___lambda0_ (self);
}


static void _vala_array_add10 (TraceModel*** array, int* length, int* size, TraceModel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TraceModel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static TraceModel** _vala_array_dup10 (TraceModel** self, int length) {
	TraceModel** result;
	int i;
	result = g_new0 (TraceModel*, length + 1);
	for (i = 0; i < length; i++) {
		TraceModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _graph_model___lambda1_ (GraphModel* self) {
	TraceModel** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	TraceModel** _tmp7_;
	gint _tmp7__length1;
	while (TRUE) {
		TraceModel** _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		TraceModel** _tmp2_;
		gint _tmp2__length1;
		Providers* _tmp3_;
		TraceModel* _tmp4_;
		_tmp0_ = self->priv->_tracemodels;
		_tmp0__length1 = self->priv->_tracemodels_length1;
		_tmp1_ = self->priv->_traces;
		_tmp1__length1 = self->priv->_traces_length1;
		if (!(_tmp0__length1 < _tmp1__length1)) {
			break;
		}
		_tmp2_ = self->priv->_tracemodels;
		_tmp2__length1 = self->priv->_tracemodels_length1;
		_tmp3_ = self->priv->_providers;
		_tmp4_ = trace_model_new (_tmp3_);
		_vala_array_add10 (&self->priv->_tracemodels, &self->priv->_tracemodels_length1, &self->priv->__tracemodels_size_, _tmp4_);
	}
	_tmp5_ = self->priv->_tracemodels;
	_tmp5__length1 = self->priv->_tracemodels_length1;
	_tmp6_ = self->priv->_traces;
	_tmp6__length1 = self->priv->_traces_length1;
	_tmp7_ = ((_tmp5_ + 0) != NULL) ? _vala_array_dup10 (_tmp5_ + 0, _tmp6__length1 - 0) : ((gpointer) (_tmp5_ + 0));
	_tmp7__length1 = _tmp6__length1 - 0;
	self->priv->_tracemodels = (_vala_array_free (self->priv->_tracemodels, self->priv->_tracemodels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_tracemodels = _tmp7_;
	self->priv->_tracemodels_length1 = _tmp7__length1;
	self->priv->__tracemodels_size_ = self->priv->_tracemodels_length1;
}


static void __graph_model___lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_graph_model___lambda1_ (self);
}


static GObject * graph_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GraphModel * self;
	parent_class = G_OBJECT_CLASS (graph_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GRAPH_MODEL (obj);
	g_signal_connect_object (G_OBJECT (self), "notify::smooth", (GCallback) __graph_model___lambda0__g_object_notify, self, 0);
	g_signal_connect_object (G_OBJECT (self), "notify::traces", (GCallback) __graph_model___lambda1__g_object_notify, self, 0);
	return obj;
}


static void graph_model_class_init (GraphModelClass * klass) {
	graph_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GraphModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_graph_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graph_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = graph_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = graph_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_PROVIDERS, g_param_spec_object ("providers", "providers", "providers", TYPE_PROVIDERS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_MINIMUM, g_param_spec_object ("minimum", "minimum", "minimum", TYPE_EXPRESSION_CACHE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_MAXIMUM, g_param_spec_object ("maximum", "maximum", "maximum", TYPE_EXPRESSION_CACHE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_SMOOTH, g_param_spec_string ("smooth", "smooth", "smooth", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", GDK_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_ALPHA, g_param_spec_uint ("alpha", "alpha", "alpha", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_TRACES, g_param_spec_boxed ("traces", "traces", "traces", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPH_MODEL_SCALE, g_param_spec_double ("scale", "scale", "scale", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void graph_model_instance_init (GraphModel * self) {
	self->priv = GRAPH_MODEL_GET_PRIVATE (self);
	self->priv->_scale = (gdouble) 1;
}


static void graph_model_finalize (GObject* obj) {
	GraphModel * self;
	self = GRAPH_MODEL (obj);
	self->priv->scalerhistory = (g_free (self->priv->scalerhistory), NULL);
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->_providers);
	_g_object_unref0 (self->priv->_minimum);
	_g_object_unref0 (self->priv->_maximum);
	_g_free0 (self->priv->_smooth);
	self->priv->_traces = (_vala_array_free (self->priv->_traces, self->priv->_traces_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_tracemodels = (_vala_array_free (self->priv->_tracemodels, self->priv->_tracemodels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (graph_model_parent_class)->finalize (obj);
}


/******************************************************************************
 * Copyright (C) 2011  Michael Hofmann <mh21@piware.de>                       *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType graph_model_get_type (void) {
	static volatile gsize graph_model_type_id__volatile = 0;
	if (g_once_init_enter (&graph_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GraphModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graph_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphModel), 0, (GInstanceInitFunc) graph_model_instance_init, NULL };
		GType graph_model_type_id;
		graph_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GraphModel", &g_define_type_info, 0);
		g_once_init_leave (&graph_model_type_id__volatile, graph_model_type_id);
	}
	return graph_model_type_id__volatile;
}


static void _vala_graph_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GraphModel * self;
	self = GRAPH_MODEL (object);
	switch (property_id) {
		case GRAPH_MODEL_ID:
		g_value_set_string (value, graph_model_get_id (self));
		break;
		case GRAPH_MODEL_PROVIDERS:
		g_value_set_object (value, graph_model_get_providers (self));
		break;
		case GRAPH_MODEL_MINIMUM:
		g_value_set_object (value, graph_model_get_minimum (self));
		break;
		case GRAPH_MODEL_MAXIMUM:
		g_value_set_object (value, graph_model_get_maximum (self));
		break;
		case GRAPH_MODEL_SMOOTH:
		g_value_set_string (value, graph_model_get_smooth (self));
		break;
		case GRAPH_MODEL_BACKGROUND_COLOR:
		{
			GdkColor boxed;
			graph_model_get_background_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case GRAPH_MODEL_ALPHA:
		g_value_set_uint (value, graph_model_get_alpha (self));
		break;
		case GRAPH_MODEL_ENABLED:
		g_value_set_boolean (value, graph_model_get_enabled (self));
		break;
		case GRAPH_MODEL_TRACES:
		{
			int length;
			g_value_set_boxed (value, graph_model_get_traces (self, &length));
		}
		break;
		case GRAPH_MODEL_SCALE:
		g_value_set_double (value, graph_model_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_graph_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GraphModel * self;
	self = GRAPH_MODEL (object);
	switch (property_id) {
		case GRAPH_MODEL_ID:
		graph_model_set_id (self, g_value_get_string (value));
		break;
		case GRAPH_MODEL_PROVIDERS:
		graph_model_set_providers (self, g_value_get_object (value));
		break;
		case GRAPH_MODEL_MINIMUM:
		graph_model_set_minimum (self, g_value_get_object (value));
		break;
		case GRAPH_MODEL_MAXIMUM:
		graph_model_set_maximum (self, g_value_get_object (value));
		break;
		case GRAPH_MODEL_SMOOTH:
		graph_model_set_smooth (self, g_value_get_string (value));
		break;
		case GRAPH_MODEL_BACKGROUND_COLOR:
		graph_model_set_background_color (self, g_value_get_boxed (value));
		break;
		case GRAPH_MODEL_ALPHA:
		graph_model_set_alpha (self, g_value_get_uint (value));
		break;
		case GRAPH_MODEL_ENABLED:
		graph_model_set_enabled (self, g_value_get_boolean (value));
		break;
		case GRAPH_MODEL_TRACES:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			graph_model_set_traces (self, boxed, g_strv_length (boxed));
		}
		break;
		case GRAPH_MODEL_SCALE:
		graph_model_set_scale (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



