module ExampleStocks where
import Data.Time.Calendar
import Data.Time.LocalTime

mkDate :: Integer -> LocalTime
mkDate jday =
  LocalTime (ModifiedJulianDay jday) midnight

-- Price data imported from Yahoo: low, open, close, high

pricesAAPL :: [(LocalTime,(Double,Double,Double,Double))]
pricesMSFT :: [(LocalTime,(Double,Double,Double,Double))]
pricesARMH :: [(LocalTime,(Double,Double,Double,Double))]

pricesAAPL = 
    [ (mkDate 55105,(180.7,185.35,180.86,186.22))
    , (mkDate 55104,(182.61,186.13,185.35,186.45))
    , (mkDate 55103,(184.31,186.73,185.38,187.4))
    , (mkDate 55102,(183.33,183.87,186.15,186.68))
    , (mkDate 55099,(181.44,182.01,182.37,185.5))
    , (mkDate 55098,(182.77,187.2,183.82,187.7))
    , (mkDate 55097,(185.03,185.4,185.5,188.9))
    , (mkDate 55096,(182.85,185.19,184.48,185.38))
    , (mkDate 55095,(181.62,184.29,184.02,185.16))
    , (mkDate 55092,(184.76,185.83,185.02,186.55))
    , (mkDate 55091,(181.97,181.98,184.55,186.79))
    , (mkDate 55090,(177.88,177.99,181.87,182.75))
    , (mkDate 55089,(173.59,174.04,175.16,175.65))
    , (mkDate 55088,(170.25,170.83,173.72,173.9))
    , (mkDate 55085,(170.87,172.91,172.16,173.18))
    , (mkDate 55084,(170.81,172.06,172.56,173.25))
    , (mkDate 55083,(169.7,172.78,171.14,174.47))
    , (mkDate 55082,(172.0,172.98,172.93,173.14))
    , (mkDate 55078,(167.09,167.28,170.31,170.7))
    , (mkDate 55077,(165.0,166.44,166.55,167.1))
    , (mkDate 55076,(164.11,164.62,165.18,167.61))
    , (mkDate 55075,(164.94,167.99,165.3,170.0))
    , (mkDate 55074,(166.5,168.16,168.21,168.85))
    , (mkDate 55071,(168.53,172.27,170.05,172.49))
    , (mkDate 55070,(164.83,168.75,169.45,169.57))
    , (mkDate 55069,(166.76,168.92,167.41,169.55))
    , (mkDate 55068,(169.13,169.46,169.4,170.94))
    , (mkDate 55067,(168.27,170.12,169.06,170.71))
    , (mkDate 55064,(166.8,167.65,169.22,169.37))
    , (mkDate 55063,(164.61,164.98,166.33,166.72))
    , (mkDate 55062,(162.45,162.75,164.6,165.3))
    , (mkDate 55061,(161.41,161.63,164.0,164.24))
    , (mkDate 55060,(159.42,163.55,159.59,163.59))
    , (mkDate 55057,(165.53,167.94,166.78,168.23))
    , (mkDate 55056,(166.5,166.65,168.42,168.67))
    , (mkDate 55055,(162.46,162.55,165.31,166.71))
    , (mkDate 55054,(161.88,163.69,162.83,164.38))
    , (mkDate 55053,(163.66,165.66,164.72,166.6))
    , (mkDate 55050,(164.8,165.49,165.51,166.6))
    , (mkDate 55049,(163.09,165.58,163.91,166.51))
    , (mkDate 55048,(164.21,165.75,165.11,167.39))
    , (mkDate 55047,(164.21,164.93,165.55,165.57))
    , (mkDate 55046,(164.87,165.21,166.43,166.64))
    , (mkDate 55043,(162.91,162.99,163.39,165.0))
    , (mkDate 55042,(161.5,161.7,162.79,164.72))
    , (mkDate 55041,(158.25,158.9,160.03,160.45))
    , (mkDate 55040,(157.6,158.88,160.0,160.1))
    , (mkDate 55039,(157.26,160.17,160.1,160.88))
    , (mkDate 55036,(156.5,156.95,159.99,160.0))
    , (mkDate 55035,(155.56,156.63,157.82,158.44))
    , (mkDate 55034,(156.11,157.79,156.74,158.73))
    , (mkDate 55033,(149.75,153.29,151.51,153.43))
    , (mkDate 55032,(150.89,153.27,152.91,155.04))
    , (mkDate 55029,(148.63,149.08,151.75,152.02))
    , (mkDate 55028,(145.57,145.76,147.52,148.02))
    , (mkDate 55027,(144.32,145.04,146.88,147.0))
    , (mkDate 55026,(141.16,142.03,142.27,143.18))
    , (mkDate 55025,(137.53,139.54,142.34,142.34))
    , (mkDate 55022,(136.32,136.34,138.52,138.97))
    , (mkDate 55021,(135.93,137.76,136.36,137.99))
    , (mkDate 55020,(134.42,135.92,137.22,138.04))
    , (mkDate 55019,(135.18,138.48,135.4,139.68))
    , (mkDate 55018,(136.25,138.7,138.61,138.99))
    , (mkDate 55014,(139.79,141.25,140.02,142.83))
    , (mkDate 55013,(142.52,143.5,142.83,144.66))
    ]

pricesMSFT = 
    [ (mkDate 55105,(24.8,25.41,24.88,25.47))
    , (mkDate 55104,(25.38,25.76,25.72,25.99))
    , (mkDate 55103,(25.69,25.91,25.75,25.96))
    , (mkDate 55102,(25.6,25.6,25.83,26.16))
    , (mkDate 55099,(25.52,25.69,25.55,25.82))
    , (mkDate 55098,(25.66,25.92,25.94,26.11))
    , (mkDate 55097,(25.64,25.92,25.71,26.25))
    , (mkDate 55096,(25.29,25.4,25.77,25.82))
    , (mkDate 55095,(25.1,25.11,25.3,25.37))
    , (mkDate 55092,(25.1,25.46,25.26,25.48))
    , (mkDate 55091,(25.06,25.06,25.3,25.38))
    , (mkDate 55090,(24.95,25.25,25.2,25.35))
    , (mkDate 55089,(24.86,24.97,25.2,25.27))
    , (mkDate 55088,(24.64,24.65,25.0,25.09))
    , (mkDate 55085,(24.81,24.93,24.86,25.17))
    , (mkDate 55084,(24.65,24.8,25.0,25.05))
    , (mkDate 55083,(24.67,24.74,24.78,24.95))
    , (mkDate 55082,(24.41,24.62,24.82,24.84))
    , (mkDate 55078,(24.08,24.09,24.62,24.8))
    , (mkDate 55077,(23.76,23.91,24.11,24.14))
    , (mkDate 55076,(23.78,23.82,23.86,24.14))
    , (mkDate 55075,(23.9,24.35,24.0,24.74))
    , (mkDate 55074,(24.29,24.57,24.65,24.85))
    , (mkDate 55071,(24.61,25.07,24.68,25.49))
    , (mkDate 55070,(24.3,24.41,24.69,24.78))
    , (mkDate 55069,(24.42,24.59,24.55,24.75))
    , (mkDate 55068,(24.46,24.6,24.64,24.82))
    , (mkDate 55067,(24.28,24.41,24.64,24.73))
    , (mkDate 55064,(23.77,23.93,24.41,24.42))
    , (mkDate 55063,(23.54,23.6,23.67,23.87))
    , (mkDate 55062,(23.25,23.25,23.65,23.72))
    , (mkDate 55061,(23.27,23.29,23.58,23.65))
    , (mkDate 55060,(23.23,23.32,23.25,23.6))
    , (mkDate 55057,(23.51,23.62,23.69,23.8))
    , (mkDate 55056,(23.4,23.63,23.62,23.85))
    , (mkDate 55055,(23.03,23.13,23.53,23.9))
    , (mkDate 55054,(23.05,23.32,23.13,23.4))
    , (mkDate 55053,(23.3,23.46,23.42,23.55))
    , (mkDate 55050,(23.5,23.75,23.56,23.82))
    , (mkDate 55049,(23.27,23.93,23.46,23.98))
    , (mkDate 55048,(23.79,23.84,23.81,24.25))
    , (mkDate 55047,(23.53,23.68,23.77,23.79))
    , (mkDate 55046,(23.5,23.82,23.83,23.86))
    , (mkDate 55043,(23.5,23.77,23.52,24.07))
    , (mkDate 55042,(23.71,24.2,23.81,24.43))
    , (mkDate 55041,(23.34,23.73,23.8,23.91))
    , (mkDate 55040,(22.9,22.99,23.47,23.55))
    , (mkDate 55039,(22.9,23.44,23.11,23.45))
    , (mkDate 55036,(22.81,23.61,23.45,23.89))
    , (mkDate 55035,(24.84,24.93,25.56,25.72))
    , (mkDate 55034,(24.51,24.7,24.8,24.9))
    , (mkDate 55033,(24.37,24.69,24.83,24.83))
    , (mkDate 55032,(24.15,24.44,24.53,24.53))
    , (mkDate 55029,(24.1,24.4,24.29,24.45))
    , (mkDate 55028,(23.86,23.93,24.44,24.44))
    , (mkDate 55027,(23.56,23.75,24.12,24.12))
    , (mkDate 55026,(22.86,23.2,23.11,23.22))
    , (mkDate 55025,(22.14,22.42,23.23,23.29))
    , (mkDate 55022,(22.15,22.19,22.39,22.54))
    , (mkDate 55021,(22.37,22.65,22.44,22.81))
    , (mkDate 55020,(22.0,22.31,22.56,22.69))
    , (mkDate 55019,(22.46,23.08,22.53,23.14))
    , (mkDate 55018,(22.87,23.21,23.2,23.28))
    , (mkDate 55014,(23.21,23.76,23.37,24.04))
    , (mkDate 55013,(23.96,24.05,24.04,24.3))
    ]

pricesARMH = 
    [ (mkDate 55105,(6.65,6.83,6.65,6.86))
    , (mkDate 55104,(6.87,7.0,7.0,7.02))
    , (mkDate 55103,(6.88,6.92,6.95,6.97))
    , (mkDate 55102,(6.62,6.63,6.81,6.82))
    , (mkDate 55099,(6.69,6.88,6.72,6.88))
    , (mkDate 55098,(6.55,6.69,6.64,6.88))
    , (mkDate 55097,(6.8,6.87,6.8,6.94))
    , (mkDate 55096,(6.67,6.68,6.74,6.78))
    , (mkDate 55095,(6.62,6.67,6.7,6.77))
    , (mkDate 55092,(6.63,6.71,6.7,6.76))
    , (mkDate 55091,(6.64,6.7,6.67,6.76))
    , (mkDate 55090,(6.76,6.84,6.77,6.85))
    , (mkDate 55089,(6.69,6.73,6.84,6.9))
    , (mkDate 55088,(6.73,6.74,6.8,6.81))
    , (mkDate 55085,(6.84,7.05,6.87,7.07))
    , (mkDate 55084,(6.65,6.7,6.94,6.97))
    , (mkDate 55083,(6.65,6.71,6.7,6.75))
    , (mkDate 55082,(6.56,6.58,6.65,6.68))
    , (mkDate 55078,(6.16,6.18,6.39,6.41))
    , (mkDate 55077,(6.11,6.19,6.21,6.24))
    , (mkDate 55076,(6.03,6.07,6.09,6.14))
    , (mkDate 55075,(6.14,6.22,6.24,6.31))
    , (mkDate 55074,(6.3,6.45,6.35,6.45))
    , (mkDate 55071,(6.4,6.5,6.47,6.56))
    , (mkDate 55070,(6.13,6.18,6.35,6.39))
    , (mkDate 55069,(6.1,6.12,6.16,6.2))
    , (mkDate 55068,(6.14,6.3,6.17,6.3))
    , (mkDate 55067,(6.19,6.29,6.21,6.34))
    , (mkDate 55064,(6.25,6.32,6.3,6.38))
    , (mkDate 55063,(6.18,6.2,6.25,6.27))
    , (mkDate 55062,(6.09,6.11,6.19,6.22))
    , (mkDate 55061,(6.14,6.14,6.23,6.28))
    , (mkDate 55060,(5.91,6.02,5.98,6.04))
    , (mkDate 55057,(6.04,6.15,6.2,6.21))
    , (mkDate 55056,(6.1,6.18,6.22,6.26))
    , (mkDate 55055,(6.07,6.07,6.22,6.3))
    , (mkDate 55054,(6.09,6.23,6.14,6.23))
    , (mkDate 55053,(6.19,6.39,6.23,6.4))
    , (mkDate 55050,(6.25,6.31,6.32,6.41))
    , (mkDate 55049,(6.2,6.42,6.24,6.42))
    , (mkDate 55048,(6.4,6.55,6.46,6.55))
    , (mkDate 55047,(6.5,6.52,6.67,6.7))
    , (mkDate 55046,(6.5,6.51,6.58,6.6))
    , (mkDate 55043,(6.3,6.34,6.39,6.43))
    , (mkDate 55042,(6.42,6.47,6.46,6.64))
    , (mkDate 55041,(6.14,6.37,6.22,6.49))
    , (mkDate 55040,(6.28,6.32,6.52,6.56))
    , (mkDate 55039,(6.41,6.47,6.49,6.63))
    , (mkDate 55036,(6.27,6.36,6.44,6.44))
    , (mkDate 55035,(6.47,6.48,6.52,6.55))
    , (mkDate 55034,(6.38,6.41,6.47,6.51))
    , (mkDate 55033,(6.27,6.45,6.41,6.46))
    , (mkDate 55032,(6.32,6.44,6.45,6.48))
    , (mkDate 55029,(6.23,6.25,6.37,6.45))
    , (mkDate 55028,(6.24,6.29,6.35,6.39))
    , (mkDate 55027,(6.37,6.53,6.45,6.6))
    , (mkDate 55026,(6.12,6.13,6.19,6.23))
    , (mkDate 55025,(5.98,6.02,6.12,6.13))
    , (mkDate 55022,(5.93,5.96,6.08,6.12))
    , (mkDate 55021,(5.74,5.8,5.97,6.0))
    , (mkDate 55020,(5.61,5.74,5.69,5.82))
    , (mkDate 55019,(5.68,5.82,5.69,5.84))
    , (mkDate 55018,(5.77,5.84,5.91,5.93))
    , (mkDate 55014,(5.89,6.03,5.94,6.06))
    , (mkDate 55013,(5.93,5.98,5.95,6.03))
    ]


