{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/camellia.h>

module Bindings.Nettle.Cipher.Camellia where
#strict_import

#num CAMELLIA_BLOCK_SIZE
#num CAMELLIA_MIN_KEY_SIZE
#num CAMELLIA_MAX_KEY_SIZE
#num CAMELLIA_KEY_SIZE

#starttype struct camellia_ctx
#stoptype

#ccall camellia_set_encrypt_key , Ptr <struct camellia_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia_set_decrypt_key , Ptr <struct camellia_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall camellia_invert_key , Ptr <struct camellia_ctx> -> Ptr <struct camellia_ctx> -> IO ()
#ccall camellia_crypt , Ptr <struct camellia_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()

