-------------------------------------------------------------------------------
--                                                                           --
--                     GNADE  : GNat Ada Database Environment                --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/samples/esql/dynamic_connect.ads,v $
--  Description     : Small interface to ODBC for the ESQL translator        --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 08-March-2003                                            --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2003/03/09 15:18:34 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2003 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This is an example which demonstrates how to divert the error output     --
--  of the ESQL support into a file.                                         --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  //1// - (Second Informal Review Draft) ISO/IEC 9075:1992, Database       --
--  Language SQL- July 30, 1992                                              --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                               use Ada.Text_IO;
with GNU.DB.ESQL_Support.ODBC;
use  GNU.DB.ESQL_Support;

package Dynamic_Connect is

   type My_Connect_Type is new ODBC.Connection_Type with record
         null;
      end record;

   procedure Error(
      C : in My_Connect_Type;
      T : in String );

   procedure Warning(
      C : in My_Connect_Type;
      T : in String );

   function Connect(
      Source     : in String;
      UserName   : in String;
      Password   : in String  ) return ODBC.Connection_Handle;

end Dynamic_Connect;
