with Ada.Text_IO;			use Ada.Text_IO;

with TAM.Persistent;			use TAM.Persistent;
with Persistent;			use Persistent;
with Account;				use Account;
with Objects;				use Objects;

package body Account_Transaction is

   Transaction_Number : Natural := 0;

   ---------
   -- Add --
   ---------
   procedure Add(
      Acct  : in out Account.Object;
      Value : in Integer ) is
      T     : Object;
   begin
      T.Value := Value;
      T.ID := Transaction_Number;
      Put_Object(T);

      Relate( Acct, T, "Has_Transaction" );

      Acct.Ballance := Acct.Ballance + Value;

      Put_Object( Acct );
   end Add;

   -------------------------
   -- Display_Tranactions --
   -------------------------
   procedure Display_Transactions(
      Acct   : in Account.Object ) is
      Tids   : OID_Array_Type( 1..1000);
      Length : Integer := 0;
   begin
      Get_Related( OID(Acct), "Has_Transaction", Tids, Length );

      for i in 1..Length loop
         declare
            T : Object;
         begin
            OID( T, Tids(i) );
            Get_Object( T );

            Put_Line( Integer'Image( T.ID ) & " " & Integer'Image(T.Value));
         end ;
      end loop;
   end Display_Transactions;


end Account_Transaction;
