/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>

#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>



#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
//#include <FL/Fl_PNG_Image.H>

#include <get_nist_file.hpp>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>

/*
#include <openbabel/mol.h>
#include <openbabel/obconversion.h>

using namespace OpenBabel;

#include <immagine_babel.hpp>
*/

#include <immagine_mol.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <util.hpp>



#include <fetch_nist_database.hpp>

extern finestra_pr* MainWindow;

extern Preferences  __pref;

extern bool __close;




/**
 *Un plugin deve avere :
 *
 *una funzione  bool (*need_group)()  che ritorna true  se il  plugin ha
 *bisogno di conoscre quali atomi sono selezionati;
 *
 *una funzione  bool (*need_leg)()  che ritorna true  se il  plugin ha
 *bisogno di conoscere quali legami sono selezionati;
 *
 *una funzione  bool (*act)()  che computa quello  per cui il  plugin e'
 *stato scritto
 *
 */



fetch_nist_database::fetch_nist_database(immagine* image,string libpath)
  :bist_plugin(image,libpath),
   _has_to_act(true),
   _has_acted(false)
  
{
  _progressw=new Fl_Window(410,60,"getting file..");
  _progressw->set_modal();
  Fl_Progress* progress_bar=new Fl_Progress(5,5,400,50);
  _progressw->add(progress_bar);
  _progressw->end();

}


void fetch_nist_database::inizialize(){

 _the_image->elimina_elem_selected();
 _the_image->elimina_legami_selected();
 _progressw->show();

 const char * fetched=fl_input("insert name:");
 
 // sleep(1);

 if(fetched!=NULL){
   string molfile=get_molfile::get_web_molfile(fetched,_progressw);
   if(molfile!=""){
     immagine_mol mol;
     mol.start_from_string(molfile);
     gruppo pp=mol.ritorna_gruppo(0);
     vector<atomo>::iterator in=pp.iniz_atom();
     vector<atomo>::iterator fin=pp.fin_atom();
       
     if(in!=fin){
       vector<legame>::iterator f_leg=(*in).primo_leg();
       atomo* sec= pp.find_atomo_id((*f_leg).id_atomo());
       if(sec!=0){
	 float ix=(*in).phys_pos_x();
	 float iy=(*in).phys_pos_y();
	 float fx=sec->phys_pos_x();
	 float fy=sec->phys_pos_y();
	 float dx=ix-fx;
	 float dy=iy-fy;
	 float displ=sqrt( pow(dx,2) + pow(dy,2) );
	 float max_displ=__pref.getBond_fixedlength();
	 
	 //std::cout << "max_displ_" << max_displ << std::endl;
	 while(displ<max_displ){
	   // std::cout << "max_displ " << displ << std::endl;
	   // 	   std::cout << "max_displ x " << ix << std::endl;
	   // 	   std::cout << "max_displ x2 " << fx << std::endl;
	   ix=(*in).phys_pos_x();
	   iy=(*in).phys_pos_y();
	   fx=sec->phys_pos_x();
	   fy=sec->phys_pos_y();
	   dx=ix-fx;
	   dy=iy-fy;
	   displ=sqrt( pow(dx,2) + pow(dy,2) );
	   pp.scale(1.0001);
	 }
	 pp.trasla(pp.w()/2,pp.h()/2);
	 _the_image->aggiungi_gruppo(pp);
       }
     }
   }else{
     fl_alert("%s not found",fetched);
   }

 }
 _has_to_act=false;
 _progressw->hide();
}





bool fetch_nist_database::need_atom(){
  return false;
}

bool fetch_nist_database::need_leg(){
  return false;
}

bool fetch_nist_database::act(int e){

  return _has_to_act;
}


fetch_nist_database::~fetch_nist_database(){
  delete _progressw;
  cout << "fetch nist database distruzione!!! " << _the_image <<endl;
}

void fetch_nist_database::register_plugin(){

}

 
bool fetch_nist_database::time_to_act(){
  return _has_to_act;
}
    

string fetch_nist_database::libpath(){
  return _lib;
}

std::string fetch_nist_database::menu_path(){
  return "template/";
}


/**************fine metodi di classe**********************************/




extern "C" bist_plugin* create_plugin(immagine* imm, string libpath){
  return new fetch_nist_database(imm, libpath);
}

extern "C" void destroy_plugin(bist_plugin* j){
  cout << "distruzione plugin: " << j <<  endl;
  delete j;
  cout << "riuscita" << endl;
}


