// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateActivity = "CreateActivity"

// CreateActivityRequest generates a "aws/request.Request" representing the
// client's request for the CreateActivity operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActivity for more information on using the CreateActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActivityRequest method.
//    req, resp := client.CreateActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity
func (c *SFN) CreateActivityRequest(input *CreateActivityInput) (req *request.Request, output *CreateActivityOutput) {
	op := &request.Operation{
		Name:       opCreateActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivityInput{}
	}

	output = &CreateActivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActivity API operation for AWS Step Functions.
//
// Creates an activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation CreateActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActivityLimitExceeded "ActivityLimitExceeded"
//   The maximum number of activities has been reached. Existing activities must
//   be deleted before a new activity can be created.
//
//   * ErrCodeInvalidName "InvalidName"
//   The provided name is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity
func (c *SFN) CreateActivity(input *CreateActivityInput) (*CreateActivityOutput, error) {
	req, out := c.CreateActivityRequest(input)
	return out, req.Send()
}

// CreateActivityWithContext is the same as CreateActivity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) CreateActivityWithContext(ctx aws.Context, input *CreateActivityInput, opts ...request.Option) (*CreateActivityOutput, error) {
	req, out := c.CreateActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStateMachine = "CreateStateMachine"

// CreateStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the CreateStateMachine operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStateMachine for more information on using the CreateStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStateMachineRequest method.
//    req, resp := client.CreateStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine
func (c *SFN) CreateStateMachineRequest(input *CreateStateMachineInput) (req *request.Request, output *CreateStateMachineOutput) {
	op := &request.Operation{
		Name:       opCreateStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStateMachineInput{}
	}

	output = &CreateStateMachineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStateMachine API operation for AWS Step Functions.
//
// Creates a state machine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation CreateStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidDefinition "InvalidDefinition"
//   The provided Amazon States Language definition is invalid.
//
//   * ErrCodeInvalidName "InvalidName"
//   The provided name is invalid.
//
//   * ErrCodeStateMachineAlreadyExists "StateMachineAlreadyExists"
//   A state machine with the same name but a different definition or role ARN
//   already exists.
//
//   * ErrCodeStateMachineDeleting "StateMachineDeleting"
//   The specified state machine is being deleted.
//
//   * ErrCodeStateMachineLimitExceeded "StateMachineLimitExceeded"
//   The maximum number of state machines has been reached. Existing state machines
//   must be deleted before a new state machine can be created.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine
func (c *SFN) CreateStateMachine(input *CreateStateMachineInput) (*CreateStateMachineOutput, error) {
	req, out := c.CreateStateMachineRequest(input)
	return out, req.Send()
}

// CreateStateMachineWithContext is the same as CreateStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) CreateStateMachineWithContext(ctx aws.Context, input *CreateStateMachineInput, opts ...request.Option) (*CreateStateMachineOutput, error) {
	req, out := c.CreateStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActivity = "DeleteActivity"

// DeleteActivityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActivity operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActivity for more information on using the DeleteActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActivityRequest method.
//    req, resp := client.DeleteActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity
func (c *SFN) DeleteActivityRequest(input *DeleteActivityInput) (req *request.Request, output *DeleteActivityOutput) {
	op := &request.Operation{
		Name:       opDeleteActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteActivityInput{}
	}

	output = &DeleteActivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteActivity API operation for AWS Step Functions.
//
// Deletes an activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DeleteActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity
func (c *SFN) DeleteActivity(input *DeleteActivityInput) (*DeleteActivityOutput, error) {
	req, out := c.DeleteActivityRequest(input)
	return out, req.Send()
}

// DeleteActivityWithContext is the same as DeleteActivity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DeleteActivityWithContext(ctx aws.Context, input *DeleteActivityInput, opts ...request.Option) (*DeleteActivityOutput, error) {
	req, out := c.DeleteActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStateMachine = "DeleteStateMachine"

// DeleteStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStateMachine operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStateMachine for more information on using the DeleteStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStateMachineRequest method.
//    req, resp := client.DeleteStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine
func (c *SFN) DeleteStateMachineRequest(input *DeleteStateMachineInput) (req *request.Request, output *DeleteStateMachineOutput) {
	op := &request.Operation{
		Name:       opDeleteStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStateMachineInput{}
	}

	output = &DeleteStateMachineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStateMachine API operation for AWS Step Functions.
//
// Deletes a state machine. This is an asynchronous operation-- it sets the
// state machine's status to "DELETING" and begins the delete process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DeleteStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine
func (c *SFN) DeleteStateMachine(input *DeleteStateMachineInput) (*DeleteStateMachineOutput, error) {
	req, out := c.DeleteStateMachineRequest(input)
	return out, req.Send()
}

// DeleteStateMachineWithContext is the same as DeleteStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DeleteStateMachineWithContext(ctx aws.Context, input *DeleteStateMachineInput, opts ...request.Option) (*DeleteStateMachineOutput, error) {
	req, out := c.DeleteStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActivity = "DescribeActivity"

// DescribeActivityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivity operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActivity for more information on using the DescribeActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActivityRequest method.
//    req, resp := client.DescribeActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity
func (c *SFN) DescribeActivityRequest(input *DescribeActivityInput) (req *request.Request, output *DescribeActivityOutput) {
	op := &request.Operation{
		Name:       opDescribeActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActivityInput{}
	}

	output = &DescribeActivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActivity API operation for AWS Step Functions.
//
// Describes an activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActivityDoesNotExist "ActivityDoesNotExist"
//   The specified activity does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity
func (c *SFN) DescribeActivity(input *DescribeActivityInput) (*DescribeActivityOutput, error) {
	req, out := c.DescribeActivityRequest(input)
	return out, req.Send()
}

// DescribeActivityWithContext is the same as DescribeActivity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeActivityWithContext(ctx aws.Context, input *DescribeActivityInput, opts ...request.Option) (*DescribeActivityOutput, error) {
	req, out := c.DescribeActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExecution = "DescribeExecution"

// DescribeExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExecution for more information on using the DescribeExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExecutionRequest method.
//    req, resp := client.DescribeExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution
func (c *SFN) DescribeExecutionRequest(input *DescribeExecutionInput) (req *request.Request, output *DescribeExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExecutionInput{}
	}

	output = &DescribeExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExecution API operation for AWS Step Functions.
//
// Describes an execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution
func (c *SFN) DescribeExecution(input *DescribeExecutionInput) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	return out, req.Send()
}

// DescribeExecutionWithContext is the same as DescribeExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeExecutionWithContext(ctx aws.Context, input *DescribeExecutionInput, opts ...request.Option) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStateMachine = "DescribeStateMachine"

// DescribeStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStateMachine operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStateMachine for more information on using the DescribeStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStateMachineRequest method.
//    req, resp := client.DescribeStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine
func (c *SFN) DescribeStateMachineRequest(input *DescribeStateMachineInput) (req *request.Request, output *DescribeStateMachineOutput) {
	op := &request.Operation{
		Name:       opDescribeStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStateMachineInput{}
	}

	output = &DescribeStateMachineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStateMachine API operation for AWS Step Functions.
//
// Describes a state machine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine
func (c *SFN) DescribeStateMachine(input *DescribeStateMachineInput) (*DescribeStateMachineOutput, error) {
	req, out := c.DescribeStateMachineRequest(input)
	return out, req.Send()
}

// DescribeStateMachineWithContext is the same as DescribeStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeStateMachineWithContext(ctx aws.Context, input *DescribeStateMachineInput, opts ...request.Option) (*DescribeStateMachineOutput, error) {
	req, out := c.DescribeStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetActivityTask = "GetActivityTask"

// GetActivityTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetActivityTask operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActivityTask for more information on using the GetActivityTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetActivityTaskRequest method.
//    req, resp := client.GetActivityTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask
func (c *SFN) GetActivityTaskRequest(input *GetActivityTaskInput) (req *request.Request, output *GetActivityTaskOutput) {
	op := &request.Operation{
		Name:       opGetActivityTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActivityTaskInput{}
	}

	output = &GetActivityTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActivityTask API operation for AWS Step Functions.
//
// Used by workers to retrieve a task (with the specified activity ARN) scheduled
// for execution by a running state machine. This initiates a long poll, where
// the service holds the HTTP connection open and responds as soon as a task
// becomes available (i.e. an execution of a task of this type is needed.) The
// maximum time the service holds on to the request before responding is 60
// seconds. If no task is available within 60 seconds, the poll will return
// an empty result, that is, the taskToken returned is an empty string.
//
// Workers should set their client side socket timeout to at least 65 seconds
// (5 seconds higher than the maximum time the service may hold the poll request).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation GetActivityTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActivityDoesNotExist "ActivityDoesNotExist"
//   The specified activity does not exist.
//
//   * ErrCodeActivityWorkerLimitExceeded "ActivityWorkerLimitExceeded"
//   The maximum number of workers concurrently polling for activity tasks has
//   been reached.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask
func (c *SFN) GetActivityTask(input *GetActivityTaskInput) (*GetActivityTaskOutput, error) {
	req, out := c.GetActivityTaskRequest(input)
	return out, req.Send()
}

// GetActivityTaskWithContext is the same as GetActivityTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetActivityTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) GetActivityTaskWithContext(ctx aws.Context, input *GetActivityTaskInput, opts ...request.Option) (*GetActivityTaskOutput, error) {
	req, out := c.GetActivityTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExecutionHistory = "GetExecutionHistory"

// GetExecutionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetExecutionHistory operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExecutionHistory for more information on using the GetExecutionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExecutionHistoryRequest method.
//    req, resp := client.GetExecutionHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory
func (c *SFN) GetExecutionHistoryRequest(input *GetExecutionHistoryInput) (req *request.Request, output *GetExecutionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetExecutionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExecutionHistoryInput{}
	}

	output = &GetExecutionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExecutionHistory API operation for AWS Step Functions.
//
// Returns the history of the specified execution as a list of events. By default,
// the results are returned in ascending order of the timeStamp of the events.
// Use the reverseOrder parameter to get the latest events first. The results
// may be split into multiple pages. To retrieve subsequent pages, make the
// call again using the nextToken returned by the previous call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation GetExecutionHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory
func (c *SFN) GetExecutionHistory(input *GetExecutionHistoryInput) (*GetExecutionHistoryOutput, error) {
	req, out := c.GetExecutionHistoryRequest(input)
	return out, req.Send()
}

// GetExecutionHistoryWithContext is the same as GetExecutionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetExecutionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) GetExecutionHistoryWithContext(ctx aws.Context, input *GetExecutionHistoryInput, opts ...request.Option) (*GetExecutionHistoryOutput, error) {
	req, out := c.GetExecutionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetExecutionHistoryPages iterates over the pages of a GetExecutionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetExecutionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetExecutionHistory operation.
//    pageNum := 0
//    err := client.GetExecutionHistoryPages(params,
//        func(page *GetExecutionHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) GetExecutionHistoryPages(input *GetExecutionHistoryInput, fn func(*GetExecutionHistoryOutput, bool) bool) error {
	return c.GetExecutionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetExecutionHistoryPagesWithContext same as GetExecutionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) GetExecutionHistoryPagesWithContext(ctx aws.Context, input *GetExecutionHistoryInput, fn func(*GetExecutionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetExecutionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetExecutionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetExecutionHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListActivities = "ListActivities"

// ListActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListActivities operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActivities for more information on using the ListActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActivitiesRequest method.
//    req, resp := client.ListActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities
func (c *SFN) ListActivitiesRequest(input *ListActivitiesInput) (req *request.Request, output *ListActivitiesOutput) {
	op := &request.Operation{
		Name:       opListActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActivitiesInput{}
	}

	output = &ListActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActivities API operation for AWS Step Functions.
//
// Lists the existing activities. The results may be split into multiple pages.
// To retrieve subsequent pages, make the call again using the nextToken returned
// by the previous call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListActivities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities
func (c *SFN) ListActivities(input *ListActivitiesInput) (*ListActivitiesOutput, error) {
	req, out := c.ListActivitiesRequest(input)
	return out, req.Send()
}

// ListActivitiesWithContext is the same as ListActivities with the addition of
// the ability to pass a context and additional request options.
//
// See ListActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListActivitiesWithContext(ctx aws.Context, input *ListActivitiesInput, opts ...request.Option) (*ListActivitiesOutput, error) {
	req, out := c.ListActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActivitiesPages iterates over the pages of a ListActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListActivities operation.
//    pageNum := 0
//    err := client.ListActivitiesPages(params,
//        func(page *ListActivitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) ListActivitiesPages(input *ListActivitiesInput, fn func(*ListActivitiesOutput, bool) bool) error {
	return c.ListActivitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActivitiesPagesWithContext same as ListActivitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListActivitiesPagesWithContext(ctx aws.Context, input *ListActivitiesInput, fn func(*ListActivitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActivitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActivitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListActivitiesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListExecutions = "ListExecutions"

// ListExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExecutions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExecutions for more information on using the ListExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExecutionsRequest method.
//    req, resp := client.ListExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions
func (c *SFN) ListExecutionsRequest(input *ListExecutionsInput) (req *request.Request, output *ListExecutionsOutput) {
	op := &request.Operation{
		Name:       opListExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExecutionsInput{}
	}

	output = &ListExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExecutions API operation for AWS Step Functions.
//
// Lists the executions of a state machine that meet the filtering criteria.
// The results may be split into multiple pages. To retrieve subsequent pages,
// make the call again using the nextToken returned by the previous call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions
func (c *SFN) ListExecutions(input *ListExecutionsInput) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	return out, req.Send()
}

// ListExecutionsWithContext is the same as ListExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListExecutionsWithContext(ctx aws.Context, input *ListExecutionsInput, opts ...request.Option) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExecutionsPages iterates over the pages of a ListExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExecutions operation.
//    pageNum := 0
//    err := client.ListExecutionsPages(params,
//        func(page *ListExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) ListExecutionsPages(input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool) error {
	return c.ListExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExecutionsPagesWithContext same as ListExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListExecutionsPagesWithContext(ctx aws.Context, input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListExecutionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListStateMachines = "ListStateMachines"

// ListStateMachinesRequest generates a "aws/request.Request" representing the
// client's request for the ListStateMachines operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStateMachines for more information on using the ListStateMachines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStateMachinesRequest method.
//    req, resp := client.ListStateMachinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines
func (c *SFN) ListStateMachinesRequest(input *ListStateMachinesInput) (req *request.Request, output *ListStateMachinesOutput) {
	op := &request.Operation{
		Name:       opListStateMachines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStateMachinesInput{}
	}

	output = &ListStateMachinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStateMachines API operation for AWS Step Functions.
//
// Lists the existing state machines. The results may be split into multiple
// pages. To retrieve subsequent pages, make the call again using the nextToken
// returned by the previous call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListStateMachines for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines
func (c *SFN) ListStateMachines(input *ListStateMachinesInput) (*ListStateMachinesOutput, error) {
	req, out := c.ListStateMachinesRequest(input)
	return out, req.Send()
}

// ListStateMachinesWithContext is the same as ListStateMachines with the addition of
// the ability to pass a context and additional request options.
//
// See ListStateMachines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListStateMachinesWithContext(ctx aws.Context, input *ListStateMachinesInput, opts ...request.Option) (*ListStateMachinesOutput, error) {
	req, out := c.ListStateMachinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStateMachinesPages iterates over the pages of a ListStateMachines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStateMachines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStateMachines operation.
//    pageNum := 0
//    err := client.ListStateMachinesPages(params,
//        func(page *ListStateMachinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) ListStateMachinesPages(input *ListStateMachinesInput, fn func(*ListStateMachinesOutput, bool) bool) error {
	return c.ListStateMachinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStateMachinesPagesWithContext same as ListStateMachinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListStateMachinesPagesWithContext(ctx aws.Context, input *ListStateMachinesInput, fn func(*ListStateMachinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStateMachinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStateMachinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListStateMachinesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSendTaskFailure = "SendTaskFailure"

// SendTaskFailureRequest generates a "aws/request.Request" representing the
// client's request for the SendTaskFailure operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTaskFailure for more information on using the SendTaskFailure
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTaskFailureRequest method.
//    req, resp := client.SendTaskFailureRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure
func (c *SFN) SendTaskFailureRequest(input *SendTaskFailureInput) (req *request.Request, output *SendTaskFailureOutput) {
	op := &request.Operation{
		Name:       opSendTaskFailure,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskFailureInput{}
	}

	output = &SendTaskFailureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendTaskFailure API operation for AWS Step Functions.
//
// Used by workers to report that the task identified by the taskToken failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation SendTaskFailure for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTaskDoesNotExist "TaskDoesNotExist"
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeTaskTimedOut "TaskTimedOut"
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure
func (c *SFN) SendTaskFailure(input *SendTaskFailureInput) (*SendTaskFailureOutput, error) {
	req, out := c.SendTaskFailureRequest(input)
	return out, req.Send()
}

// SendTaskFailureWithContext is the same as SendTaskFailure with the addition of
// the ability to pass a context and additional request options.
//
// See SendTaskFailure for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) SendTaskFailureWithContext(ctx aws.Context, input *SendTaskFailureInput, opts ...request.Option) (*SendTaskFailureOutput, error) {
	req, out := c.SendTaskFailureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTaskHeartbeat = "SendTaskHeartbeat"

// SendTaskHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the SendTaskHeartbeat operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTaskHeartbeat for more information on using the SendTaskHeartbeat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTaskHeartbeatRequest method.
//    req, resp := client.SendTaskHeartbeatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat
func (c *SFN) SendTaskHeartbeatRequest(input *SendTaskHeartbeatInput) (req *request.Request, output *SendTaskHeartbeatOutput) {
	op := &request.Operation{
		Name:       opSendTaskHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskHeartbeatInput{}
	}

	output = &SendTaskHeartbeatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendTaskHeartbeat API operation for AWS Step Functions.
//
// Used by workers to report to the service that the task represented by the
// specified taskToken is still making progress. This action resets the Heartbeat
// clock. The Heartbeat threshold is specified in the state machine's Amazon
// States Language definition. This action does not in itself create an event
// in the execution history. However, if the task times out, the execution history
// will contain an ActivityTimedOut event.
//
// The Timeout of a task, defined in the state machine's Amazon States Language
// definition, is its maximum allowed duration, regardless of the number of
// SendTaskHeartbeat requests received.
//
// This operation is only useful for long-lived tasks to report the liveliness
// of the task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation SendTaskHeartbeat for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTaskDoesNotExist "TaskDoesNotExist"
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeTaskTimedOut "TaskTimedOut"
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat
func (c *SFN) SendTaskHeartbeat(input *SendTaskHeartbeatInput) (*SendTaskHeartbeatOutput, error) {
	req, out := c.SendTaskHeartbeatRequest(input)
	return out, req.Send()
}

// SendTaskHeartbeatWithContext is the same as SendTaskHeartbeat with the addition of
// the ability to pass a context and additional request options.
//
// See SendTaskHeartbeat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) SendTaskHeartbeatWithContext(ctx aws.Context, input *SendTaskHeartbeatInput, opts ...request.Option) (*SendTaskHeartbeatOutput, error) {
	req, out := c.SendTaskHeartbeatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTaskSuccess = "SendTaskSuccess"

// SendTaskSuccessRequest generates a "aws/request.Request" representing the
// client's request for the SendTaskSuccess operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTaskSuccess for more information on using the SendTaskSuccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTaskSuccessRequest method.
//    req, resp := client.SendTaskSuccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess
func (c *SFN) SendTaskSuccessRequest(input *SendTaskSuccessInput) (req *request.Request, output *SendTaskSuccessOutput) {
	op := &request.Operation{
		Name:       opSendTaskSuccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskSuccessInput{}
	}

	output = &SendTaskSuccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendTaskSuccess API operation for AWS Step Functions.
//
// Used by workers to report that the task identified by the taskToken completed
// successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation SendTaskSuccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTaskDoesNotExist "TaskDoesNotExist"
//
//   * ErrCodeInvalidOutput "InvalidOutput"
//   The provided JSON output data is invalid.
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeTaskTimedOut "TaskTimedOut"
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess
func (c *SFN) SendTaskSuccess(input *SendTaskSuccessInput) (*SendTaskSuccessOutput, error) {
	req, out := c.SendTaskSuccessRequest(input)
	return out, req.Send()
}

// SendTaskSuccessWithContext is the same as SendTaskSuccess with the addition of
// the ability to pass a context and additional request options.
//
// See SendTaskSuccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) SendTaskSuccessWithContext(ctx aws.Context, input *SendTaskSuccessInput, opts ...request.Option) (*SendTaskSuccessOutput, error) {
	req, out := c.SendTaskSuccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExecution = "StartExecution"

// StartExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExecution for more information on using the StartExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExecutionRequest method.
//    req, resp := client.StartExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution
func (c *SFN) StartExecutionRequest(input *StartExecutionInput) (req *request.Request, output *StartExecutionOutput) {
	op := &request.Operation{
		Name:       opStartExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExecutionInput{}
	}

	output = &StartExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExecution API operation for AWS Step Functions.
//
// Starts a state machine execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation StartExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionLimitExceeded "ExecutionLimitExceeded"
//   The maximum number of running executions has been reached. Running executions
//   must end or be stopped before a new execution can be started.
//
//   * ErrCodeExecutionAlreadyExists "ExecutionAlreadyExists"
//   An execution with the same name already exists.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidExecutionInput "InvalidExecutionInput"
//   The provided JSON input data is invalid.
//
//   * ErrCodeInvalidName "InvalidName"
//   The provided name is invalid.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
//   * ErrCodeStateMachineDeleting "StateMachineDeleting"
//   The specified state machine is being deleted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution
func (c *SFN) StartExecution(input *StartExecutionInput) (*StartExecutionOutput, error) {
	req, out := c.StartExecutionRequest(input)
	return out, req.Send()
}

// StartExecutionWithContext is the same as StartExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) StartExecutionWithContext(ctx aws.Context, input *StartExecutionInput, opts ...request.Option) (*StartExecutionOutput, error) {
	req, out := c.StartExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopExecution = "StopExecution"

// StopExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopExecution for more information on using the StopExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopExecutionRequest method.
//    req, resp := client.StopExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution
func (c *SFN) StopExecutionRequest(input *StopExecutionInput) (req *request.Request, output *StopExecutionOutput) {
	op := &request.Operation{
		Name:       opStopExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopExecutionInput{}
	}

	output = &StopExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopExecution API operation for AWS Step Functions.
//
// Stops an execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation StopExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution
func (c *SFN) StopExecution(input *StopExecutionInput) (*StopExecutionOutput, error) {
	req, out := c.StopExecutionRequest(input)
	return out, req.Send()
}

// StopExecutionWithContext is the same as StopExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) StopExecutionWithContext(ctx aws.Context, input *StopExecutionInput, opts ...request.Option) (*StopExecutionOutput, error) {
	req, out := c.StopExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivityFailedEventDetails
type ActivityFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s ActivityFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ActivityFailedEventDetails) SetCause(v string) *ActivityFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ActivityFailedEventDetails) SetError(v string) *ActivityFailedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivityListItem
type ActivityListItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name of the activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivityListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityListItem) GoString() string {
	return s.String()
}

// SetActivityArn sets the ActivityArn field's value.
func (s *ActivityListItem) SetActivityArn(v string) *ActivityListItem {
	s.ActivityArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ActivityListItem) SetCreationDate(v time.Time) *ActivityListItem {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActivityListItem) SetName(v string) *ActivityListItem {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivityScheduleFailedEventDetails
type ActivityScheduleFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s ActivityScheduleFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityScheduleFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ActivityScheduleFailedEventDetails) SetCause(v string) *ActivityScheduleFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ActivityScheduleFailedEventDetails) SetError(v string) *ActivityScheduleFailedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivityScheduledEventDetails
type ActivityScheduledEventDetails struct {
	_ struct{} `type:"structure"`

	// The maximum allowed duration between two heartbeats for the activity task.
	HeartbeatInSeconds *int64 `locationName:"heartbeatInSeconds" type:"long"`

	// The JSON data input to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled activity.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The maximum allowed duration of the activity task.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s ActivityScheduledEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityScheduledEventDetails) GoString() string {
	return s.String()
}

// SetHeartbeatInSeconds sets the HeartbeatInSeconds field's value.
func (s *ActivityScheduledEventDetails) SetHeartbeatInSeconds(v int64) *ActivityScheduledEventDetails {
	s.HeartbeatInSeconds = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ActivityScheduledEventDetails) SetInput(v string) *ActivityScheduledEventDetails {
	s.Input = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *ActivityScheduledEventDetails) SetResource(v string) *ActivityScheduledEventDetails {
	s.Resource = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *ActivityScheduledEventDetails) SetTimeoutInSeconds(v int64) *ActivityScheduledEventDetails {
	s.TimeoutInSeconds = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivityStartedEventDetails
type ActivityStartedEventDetails struct {
	_ struct{} `type:"structure"`

	// The name of the worker that the task was assigned to. These names are provided
	// by the workers when calling GetActivityTask.
	WorkerName *string `locationName:"workerName" type:"string"`
}

// String returns the string representation
func (s ActivityStartedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityStartedEventDetails) GoString() string {
	return s.String()
}

// SetWorkerName sets the WorkerName field's value.
func (s *ActivityStartedEventDetails) SetWorkerName(v string) *ActivityStartedEventDetails {
	s.WorkerName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivitySucceededEventDetails
type ActivitySucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data output by the activity task.
	Output *string `locationName:"output" type:"string"`
}

// String returns the string representation
func (s ActivitySucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivitySucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ActivitySucceededEventDetails) SetOutput(v string) *ActivitySucceededEventDetails {
	s.Output = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ActivityTimedOutEventDetails
type ActivityTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the timeout.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s ActivityTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ActivityTimedOutEventDetails) SetCause(v string) *ActivityTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ActivityTimedOutEventDetails) SetError(v string) *ActivityTimedOutEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivityInput
type CreateActivityInput struct {
	_ struct{} `type:"structure"`

	// The name of the activity to create. This name must be unique for your AWS
	// account and region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateActivityInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateActivityInput) SetName(v string) *CreateActivityInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivityOutput
type CreateActivityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the created activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s CreateActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivityOutput) GoString() string {
	return s.String()
}

// SetActivityArn sets the ActivityArn field's value.
func (s *CreateActivityOutput) SetActivityArn(v string) *CreateActivityOutput {
	s.ActivityArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateActivityOutput) SetCreationDate(v time.Time) *CreateActivityOutput {
	s.CreationDate = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachineInput
type CreateStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon States Language definition of the state machine.
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true"`

	// The name of the state machine. This name must be unique for your AWS account
	// and region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStateMachineInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Definition != nil && len(*s.Definition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Definition", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *CreateStateMachineInput) SetDefinition(v string) *CreateStateMachineInput {
	s.Definition = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStateMachineInput) SetName(v string) *CreateStateMachineInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateStateMachineInput) SetRoleArn(v string) *CreateStateMachineInput {
	s.RoleArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachineOutput
type CreateStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date the state machine was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the created state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStateMachineOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateStateMachineOutput) SetCreationDate(v time.Time) *CreateStateMachineOutput {
	s.CreationDate = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *CreateStateMachineOutput) SetStateMachineArn(v string) *CreateStateMachineOutput {
	s.StateMachineArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivityInput
type DeleteActivityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to delete.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteActivityInput"}
	if s.ActivityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityArn sets the ActivityArn field's value.
func (s *DeleteActivityInput) SetActivityArn(v string) *DeleteActivityInput {
	s.ActivityArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivityOutput
type DeleteActivityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivityOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineInput
type DeleteStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the state machine to delete.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStateMachineInput"}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DeleteStateMachineInput) SetStateMachineArn(v string) *DeleteStateMachineInput {
	s.StateMachineArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineOutput
type DeleteStateMachineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStateMachineOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivityInput
type DescribeActivityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to describe.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActivityInput"}
	if s.ActivityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityArn sets the ActivityArn field's value.
func (s *DescribeActivityInput) SetActivityArn(v string) *DescribeActivityInput {
	s.ActivityArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivityOutput
type DescribeActivityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name of the activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityOutput) GoString() string {
	return s.String()
}

// SetActivityArn sets the ActivityArn field's value.
func (s *DescribeActivityOutput) SetActivityArn(v string) *DescribeActivityOutput {
	s.ActivityArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeActivityOutput) SetCreationDate(v time.Time) *DescribeActivityOutput {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeActivityOutput) SetName(v string) *DescribeActivityOutput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecutionInput
type DescribeExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the execution to describe.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExecutionInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *DescribeExecutionInput) SetExecutionArn(v string) *DescribeExecutionInput {
	s.ExecutionArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecutionOutput
type DescribeExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The JSON input data of the execution.
	//
	// Input is a required field
	Input *string `locationName:"input" type:"string" required:"true"`

	// The name of the execution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The JSON output data of the execution.
	Output *string `locationName:"output" type:"string"`

	// The date the execution was started.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the executed stated machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the execution.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ExecutionStatus"`

	// If the execution has already ended, the date the execution stopped.
	StopDate *time.Time `locationName:"stopDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DescribeExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *DescribeExecutionOutput) SetExecutionArn(v string) *DescribeExecutionOutput {
	s.ExecutionArn = &v
	return s
}

// SetInput sets the Input field's value.
func (s *DescribeExecutionOutput) SetInput(v string) *DescribeExecutionOutput {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeExecutionOutput) SetName(v string) *DescribeExecutionOutput {
	s.Name = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *DescribeExecutionOutput) SetOutput(v string) *DescribeExecutionOutput {
	s.Output = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DescribeExecutionOutput) SetStartDate(v time.Time) *DescribeExecutionOutput {
	s.StartDate = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeExecutionOutput) SetStateMachineArn(v string) *DescribeExecutionOutput {
	s.StateMachineArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeExecutionOutput) SetStatus(v string) *DescribeExecutionOutput {
	s.Status = &v
	return s
}

// SetStopDate sets the StopDate field's value.
func (s *DescribeExecutionOutput) SetStopDate(v time.Time) *DescribeExecutionOutput {
	s.StopDate = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineInput
type DescribeStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the state machine to describe.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStateMachineInput"}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeStateMachineInput) SetStateMachineArn(v string) *DescribeStateMachineInput {
	s.StateMachineArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineOutput
type DescribeStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date the state machine was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon States Language definition of the state machine.
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true"`

	// The name of the state machine.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used for executing this state
	// machine.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the state machine.
	Status *string `locationName:"status" type:"string" enum:"StateMachineStatus"`
}

// String returns the string representation
func (s DescribeStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStateMachineOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeStateMachineOutput) SetCreationDate(v time.Time) *DescribeStateMachineOutput {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *DescribeStateMachineOutput) SetDefinition(v string) *DescribeStateMachineOutput {
	s.Definition = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeStateMachineOutput) SetName(v string) *DescribeStateMachineOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeStateMachineOutput) SetRoleArn(v string) *DescribeStateMachineOutput {
	s.RoleArn = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeStateMachineOutput) SetStateMachineArn(v string) *DescribeStateMachineOutput {
	s.StateMachineArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeStateMachineOutput) SetStatus(v string) *DescribeStateMachineOutput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionAbortedEventDetails
type ExecutionAbortedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s ExecutionAbortedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionAbortedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ExecutionAbortedEventDetails) SetCause(v string) *ExecutionAbortedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ExecutionAbortedEventDetails) SetError(v string) *ExecutionAbortedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionFailedEventDetails
type ExecutionFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s ExecutionFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ExecutionFailedEventDetails) SetCause(v string) *ExecutionFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ExecutionFailedEventDetails) SetError(v string) *ExecutionFailedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionListItem
type ExecutionListItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The name of the execution.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The date the execution started.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the executed state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the execution.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ExecutionStatus"`

	// If the execution already ended, the date the execution stopped.
	StopDate *time.Time `locationName:"stopDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ExecutionListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionListItem) GoString() string {
	return s.String()
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *ExecutionListItem) SetExecutionArn(v string) *ExecutionListItem {
	s.ExecutionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExecutionListItem) SetName(v string) *ExecutionListItem {
	s.Name = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ExecutionListItem) SetStartDate(v time.Time) *ExecutionListItem {
	s.StartDate = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *ExecutionListItem) SetStateMachineArn(v string) *ExecutionListItem {
	s.StateMachineArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExecutionListItem) SetStatus(v string) *ExecutionListItem {
	s.Status = &v
	return s
}

// SetStopDate sets the StopDate field's value.
func (s *ExecutionListItem) SetStopDate(v time.Time) *ExecutionListItem {
	s.StopDate = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionStartedEventDetails
type ExecutionStartedEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data input to the execution.
	Input *string `locationName:"input" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda
	// tasks.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s ExecutionStartedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionStartedEventDetails) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *ExecutionStartedEventDetails) SetInput(v string) *ExecutionStartedEventDetails {
	s.Input = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExecutionStartedEventDetails) SetRoleArn(v string) *ExecutionStartedEventDetails {
	s.RoleArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionSucceededEventDetails
type ExecutionSucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data output by the execution.
	Output *string `locationName:"output" type:"string"`
}

// String returns the string representation
func (s ExecutionSucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionSucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ExecutionSucceededEventDetails) SetOutput(v string) *ExecutionSucceededEventDetails {
	s.Output = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionTimedOutEventDetails
type ExecutionTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the timeout.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s ExecutionTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ExecutionTimedOutEventDetails) SetCause(v string) *ExecutionTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ExecutionTimedOutEventDetails) SetError(v string) *ExecutionTimedOutEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTaskInput
type GetActivityTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to retrieve tasks from.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// An arbitrary name may be provided in order to identify the worker that the
	// task is assigned to. This name will be used when it is logged in the execution
	// history.
	WorkerName *string `locationName:"workerName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetActivityTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActivityTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetActivityTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetActivityTaskInput"}
	if s.ActivityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityArn", 1))
	}
	if s.WorkerName != nil && len(*s.WorkerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityArn sets the ActivityArn field's value.
func (s *GetActivityTaskInput) SetActivityArn(v string) *GetActivityTaskInput {
	s.ActivityArn = &v
	return s
}

// SetWorkerName sets the WorkerName field's value.
func (s *GetActivityTaskInput) SetWorkerName(v string) *GetActivityTaskInput {
	s.WorkerName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTaskOutput
type GetActivityTaskOutput struct {
	_ struct{} `type:"structure"`

	// The JSON input data for the task.
	Input *string `locationName:"input" type:"string"`

	// A token that identifies the scheduled task. This token must be copied and
	// included in subsequent calls to SendTaskHeartbeat, SendTaskSuccess or SendTaskFailure
	// in order to report the progress or completion of the task.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetActivityTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActivityTaskOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *GetActivityTaskOutput) SetInput(v string) *GetActivityTaskOutput {
	s.Input = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *GetActivityTaskOutput) SetTaskToken(v string) *GetActivityTaskOutput {
	s.TaskToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistoryInput
type GetExecutionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The maximum number of results that will be returned per call. nextToken can
	// be used to obtain further pages of results. The default is 100 and the maximum
	// allowed page size is 1000.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If a nextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Lists events in descending order of their timeStamp.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s GetExecutionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExecutionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExecutionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExecutionHistoryInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *GetExecutionHistoryInput) SetExecutionArn(v string) *GetExecutionHistoryInput {
	s.ExecutionArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExecutionHistoryInput) SetMaxResults(v int64) *GetExecutionHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExecutionHistoryInput) SetNextToken(v string) *GetExecutionHistoryInput {
	s.NextToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *GetExecutionHistoryInput) SetReverseOrder(v bool) *GetExecutionHistoryInput {
	s.ReverseOrder = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistoryOutput
type GetExecutionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of events that occurred in the execution.
	//
	// Events is a required field
	Events []*HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If a nextToken is returned, there are more results available. To retrieve
	// the next page of results, make the call again using the returned token in
	// nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetExecutionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExecutionHistoryOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *GetExecutionHistoryOutput) SetEvents(v []*HistoryEvent) *GetExecutionHistoryOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExecutionHistoryOutput) SetNextToken(v string) *GetExecutionHistoryOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/HistoryEvent
type HistoryEvent struct {
	_ struct{} `type:"structure"`

	ActivityFailedEventDetails *ActivityFailedEventDetails `locationName:"activityFailedEventDetails" type:"structure"`

	ActivityScheduleFailedEventDetails *ActivityScheduleFailedEventDetails `locationName:"activityScheduleFailedEventDetails" type:"structure"`

	ActivityScheduledEventDetails *ActivityScheduledEventDetails `locationName:"activityScheduledEventDetails" type:"structure"`

	ActivityStartedEventDetails *ActivityStartedEventDetails `locationName:"activityStartedEventDetails" type:"structure"`

	ActivitySucceededEventDetails *ActivitySucceededEventDetails `locationName:"activitySucceededEventDetails" type:"structure"`

	ActivityTimedOutEventDetails *ActivityTimedOutEventDetails `locationName:"activityTimedOutEventDetails" type:"structure"`

	ExecutionAbortedEventDetails *ExecutionAbortedEventDetails `locationName:"executionAbortedEventDetails" type:"structure"`

	ExecutionFailedEventDetails *ExecutionFailedEventDetails `locationName:"executionFailedEventDetails" type:"structure"`

	ExecutionStartedEventDetails *ExecutionStartedEventDetails `locationName:"executionStartedEventDetails" type:"structure"`

	ExecutionSucceededEventDetails *ExecutionSucceededEventDetails `locationName:"executionSucceededEventDetails" type:"structure"`

	ExecutionTimedOutEventDetails *ExecutionTimedOutEventDetails `locationName:"executionTimedOutEventDetails" type:"structure"`

	// The id of the event. Events are numbered sequentially, starting at one.
	//
	// Id is a required field
	Id *int64 `locationName:"id" type:"long" required:"true"`

	LambdaFunctionFailedEventDetails *LambdaFunctionFailedEventDetails `locationName:"lambdaFunctionFailedEventDetails" type:"structure"`

	LambdaFunctionScheduleFailedEventDetails *LambdaFunctionScheduleFailedEventDetails `locationName:"lambdaFunctionScheduleFailedEventDetails" type:"structure"`

	LambdaFunctionScheduledEventDetails *LambdaFunctionScheduledEventDetails `locationName:"lambdaFunctionScheduledEventDetails" type:"structure"`

	LambdaFunctionStartFailedEventDetails *LambdaFunctionStartFailedEventDetails `locationName:"lambdaFunctionStartFailedEventDetails" type:"structure"`

	LambdaFunctionSucceededEventDetails *LambdaFunctionSucceededEventDetails `locationName:"lambdaFunctionSucceededEventDetails" type:"structure"`

	LambdaFunctionTimedOutEventDetails *LambdaFunctionTimedOutEventDetails `locationName:"lambdaFunctionTimedOutEventDetails" type:"structure"`

	// The id of the previous event.
	PreviousEventId *int64 `locationName:"previousEventId" type:"long"`

	StateEnteredEventDetails *StateEnteredEventDetails `locationName:"stateEnteredEventDetails" type:"structure"`

	StateExitedEventDetails *StateExitedEventDetails `locationName:"stateExitedEventDetails" type:"structure"`

	// The date the event occured.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The type of the event.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"HistoryEventType"`
}

// String returns the string representation
func (s HistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryEvent) GoString() string {
	return s.String()
}

// SetActivityFailedEventDetails sets the ActivityFailedEventDetails field's value.
func (s *HistoryEvent) SetActivityFailedEventDetails(v *ActivityFailedEventDetails) *HistoryEvent {
	s.ActivityFailedEventDetails = v
	return s
}

// SetActivityScheduleFailedEventDetails sets the ActivityScheduleFailedEventDetails field's value.
func (s *HistoryEvent) SetActivityScheduleFailedEventDetails(v *ActivityScheduleFailedEventDetails) *HistoryEvent {
	s.ActivityScheduleFailedEventDetails = v
	return s
}

// SetActivityScheduledEventDetails sets the ActivityScheduledEventDetails field's value.
func (s *HistoryEvent) SetActivityScheduledEventDetails(v *ActivityScheduledEventDetails) *HistoryEvent {
	s.ActivityScheduledEventDetails = v
	return s
}

// SetActivityStartedEventDetails sets the ActivityStartedEventDetails field's value.
func (s *HistoryEvent) SetActivityStartedEventDetails(v *ActivityStartedEventDetails) *HistoryEvent {
	s.ActivityStartedEventDetails = v
	return s
}

// SetActivitySucceededEventDetails sets the ActivitySucceededEventDetails field's value.
func (s *HistoryEvent) SetActivitySucceededEventDetails(v *ActivitySucceededEventDetails) *HistoryEvent {
	s.ActivitySucceededEventDetails = v
	return s
}

// SetActivityTimedOutEventDetails sets the ActivityTimedOutEventDetails field's value.
func (s *HistoryEvent) SetActivityTimedOutEventDetails(v *ActivityTimedOutEventDetails) *HistoryEvent {
	s.ActivityTimedOutEventDetails = v
	return s
}

// SetExecutionAbortedEventDetails sets the ExecutionAbortedEventDetails field's value.
func (s *HistoryEvent) SetExecutionAbortedEventDetails(v *ExecutionAbortedEventDetails) *HistoryEvent {
	s.ExecutionAbortedEventDetails = v
	return s
}

// SetExecutionFailedEventDetails sets the ExecutionFailedEventDetails field's value.
func (s *HistoryEvent) SetExecutionFailedEventDetails(v *ExecutionFailedEventDetails) *HistoryEvent {
	s.ExecutionFailedEventDetails = v
	return s
}

// SetExecutionStartedEventDetails sets the ExecutionStartedEventDetails field's value.
func (s *HistoryEvent) SetExecutionStartedEventDetails(v *ExecutionStartedEventDetails) *HistoryEvent {
	s.ExecutionStartedEventDetails = v
	return s
}

// SetExecutionSucceededEventDetails sets the ExecutionSucceededEventDetails field's value.
func (s *HistoryEvent) SetExecutionSucceededEventDetails(v *ExecutionSucceededEventDetails) *HistoryEvent {
	s.ExecutionSucceededEventDetails = v
	return s
}

// SetExecutionTimedOutEventDetails sets the ExecutionTimedOutEventDetails field's value.
func (s *HistoryEvent) SetExecutionTimedOutEventDetails(v *ExecutionTimedOutEventDetails) *HistoryEvent {
	s.ExecutionTimedOutEventDetails = v
	return s
}

// SetId sets the Id field's value.
func (s *HistoryEvent) SetId(v int64) *HistoryEvent {
	s.Id = &v
	return s
}

// SetLambdaFunctionFailedEventDetails sets the LambdaFunctionFailedEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionFailedEventDetails(v *LambdaFunctionFailedEventDetails) *HistoryEvent {
	s.LambdaFunctionFailedEventDetails = v
	return s
}

// SetLambdaFunctionScheduleFailedEventDetails sets the LambdaFunctionScheduleFailedEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionScheduleFailedEventDetails(v *LambdaFunctionScheduleFailedEventDetails) *HistoryEvent {
	s.LambdaFunctionScheduleFailedEventDetails = v
	return s
}

// SetLambdaFunctionScheduledEventDetails sets the LambdaFunctionScheduledEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionScheduledEventDetails(v *LambdaFunctionScheduledEventDetails) *HistoryEvent {
	s.LambdaFunctionScheduledEventDetails = v
	return s
}

// SetLambdaFunctionStartFailedEventDetails sets the LambdaFunctionStartFailedEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionStartFailedEventDetails(v *LambdaFunctionStartFailedEventDetails) *HistoryEvent {
	s.LambdaFunctionStartFailedEventDetails = v
	return s
}

// SetLambdaFunctionSucceededEventDetails sets the LambdaFunctionSucceededEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionSucceededEventDetails(v *LambdaFunctionSucceededEventDetails) *HistoryEvent {
	s.LambdaFunctionSucceededEventDetails = v
	return s
}

// SetLambdaFunctionTimedOutEventDetails sets the LambdaFunctionTimedOutEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionTimedOutEventDetails(v *LambdaFunctionTimedOutEventDetails) *HistoryEvent {
	s.LambdaFunctionTimedOutEventDetails = v
	return s
}

// SetPreviousEventId sets the PreviousEventId field's value.
func (s *HistoryEvent) SetPreviousEventId(v int64) *HistoryEvent {
	s.PreviousEventId = &v
	return s
}

// SetStateEnteredEventDetails sets the StateEnteredEventDetails field's value.
func (s *HistoryEvent) SetStateEnteredEventDetails(v *StateEnteredEventDetails) *HistoryEvent {
	s.StateEnteredEventDetails = v
	return s
}

// SetStateExitedEventDetails sets the StateExitedEventDetails field's value.
func (s *HistoryEvent) SetStateExitedEventDetails(v *StateExitedEventDetails) *HistoryEvent {
	s.StateExitedEventDetails = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *HistoryEvent) SetTimestamp(v time.Time) *HistoryEvent {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *HistoryEvent) SetType(v string) *HistoryEvent {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/LambdaFunctionFailedEventDetails
type LambdaFunctionFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionFailedEventDetails) SetCause(v string) *LambdaFunctionFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionFailedEventDetails) SetError(v string) *LambdaFunctionFailedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/LambdaFunctionScheduleFailedEventDetails
type LambdaFunctionScheduleFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionScheduleFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionScheduleFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionScheduleFailedEventDetails) SetCause(v string) *LambdaFunctionScheduleFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionScheduleFailedEventDetails) SetError(v string) *LambdaFunctionScheduleFailedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/LambdaFunctionScheduledEventDetails
type LambdaFunctionScheduledEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data input to the lambda function.
	Input *string `locationName:"input" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled lambda function.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The maximum allowed duration of the lambda function.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s LambdaFunctionScheduledEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionScheduledEventDetails) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *LambdaFunctionScheduledEventDetails) SetInput(v string) *LambdaFunctionScheduledEventDetails {
	s.Input = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *LambdaFunctionScheduledEventDetails) SetResource(v string) *LambdaFunctionScheduledEventDetails {
	s.Resource = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *LambdaFunctionScheduledEventDetails) SetTimeoutInSeconds(v int64) *LambdaFunctionScheduledEventDetails {
	s.TimeoutInSeconds = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/LambdaFunctionStartFailedEventDetails
type LambdaFunctionStartFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionStartFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionStartFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionStartFailedEventDetails) SetCause(v string) *LambdaFunctionStartFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionStartFailedEventDetails) SetError(v string) *LambdaFunctionStartFailedEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/LambdaFunctionSucceededEventDetails
type LambdaFunctionSucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data output by the lambda function.
	Output *string `locationName:"output" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionSucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionSucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *LambdaFunctionSucceededEventDetails) SetOutput(v string) *LambdaFunctionSucceededEventDetails {
	s.Output = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/LambdaFunctionTimedOutEventDetails
type LambdaFunctionTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the timeout.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionTimedOutEventDetails) SetCause(v string) *LambdaFunctionTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionTimedOutEventDetails) SetError(v string) *LambdaFunctionTimedOutEventDetails {
	s.Error = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivitiesInput
type ListActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that will be returned per call. nextToken can
	// be used to obtain further pages of results. The default is 100 and the maximum
	// allowed page size is 1000.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If a nextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActivitiesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListActivitiesInput) SetMaxResults(v int64) *ListActivitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActivitiesInput) SetNextToken(v string) *ListActivitiesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivitiesOutput
type ListActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The list of activities.
	//
	// Activities is a required field
	Activities []*ActivityListItem `locationName:"activities" type:"list" required:"true"`

	// If a nextToken is returned, there are more results available. To retrieve
	// the next page of results, make the call again using the returned token in
	// nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *ListActivitiesOutput) SetActivities(v []*ActivityListItem) *ListActivitiesOutput {
	s.Activities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActivitiesOutput) SetNextToken(v string) *ListActivitiesOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutionsInput
type ListExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that will be returned per call. nextToken can
	// be used to obtain further pages of results. The default is 100 and the maximum
	// allowed page size is 1000.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If a nextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the state machine whose executions will
	// be listed.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// If specified, only list the executions whose current execution status matches
	// the given filter.
	StatusFilter *string `locationName:"statusFilter" type:"string" enum:"ExecutionStatus"`
}

// String returns the string representation
func (s ListExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExecutionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExecutionsInput) SetMaxResults(v int64) *ListExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsInput) SetNextToken(v string) *ListExecutionsInput {
	s.NextToken = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *ListExecutionsInput) SetStateMachineArn(v string) *ListExecutionsInput {
	s.StateMachineArn = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListExecutionsInput) SetStatusFilter(v string) *ListExecutionsInput {
	s.StatusFilter = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutionsOutput
type ListExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of matching executions.
	//
	// Executions is a required field
	Executions []*ExecutionListItem `locationName:"executions" type:"list" required:"true"`

	// If a nextToken is returned, there are more results available. To retrieve
	// the next page of results, make the call again using the returned token in
	// nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExecutionsOutput) GoString() string {
	return s.String()
}

// SetExecutions sets the Executions field's value.
func (s *ListExecutionsOutput) SetExecutions(v []*ExecutionListItem) *ListExecutionsOutput {
	s.Executions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsOutput) SetNextToken(v string) *ListExecutionsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachinesInput
type ListStateMachinesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that will be returned per call. nextToken can
	// be used to obtain further pages of results. The default is 100 and the maximum
	// allowed page size is 1000.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If a nextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListStateMachinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStateMachinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStateMachinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStateMachinesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStateMachinesInput) SetMaxResults(v int64) *ListStateMachinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStateMachinesInput) SetNextToken(v string) *ListStateMachinesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachinesOutput
type ListStateMachinesOutput struct {
	_ struct{} `type:"structure"`

	// If a nextToken is returned, there are more results available. To retrieve
	// the next page of results, make the call again using the returned token in
	// nextToken. Keep all other arguments unchanged.
	//
	// The configured maxResults determines how many results can be returned in
	// a single call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// StateMachines is a required field
	StateMachines []*StateMachineListItem `locationName:"stateMachines" type:"list" required:"true"`
}

// String returns the string representation
func (s ListStateMachinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStateMachinesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStateMachinesOutput) SetNextToken(v string) *ListStateMachinesOutput {
	s.NextToken = &v
	return s
}

// SetStateMachines sets the StateMachines field's value.
func (s *ListStateMachinesOutput) SetStateMachines(v []*StateMachineListItem) *ListStateMachinesOutput {
	s.StateMachines = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailureInput
type SendTaskFailureInput struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// An arbitrary error code that identifies the cause of the failure.
	Error *string `locationName:"error" type:"string"`

	// The token that represents this task. Task tokens are generated by the service
	// when the tasks are assigned to a worker (see GetActivityTask::taskToken).
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskFailureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskFailureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskFailureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTaskFailureInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCause sets the Cause field's value.
func (s *SendTaskFailureInput) SetCause(v string) *SendTaskFailureInput {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *SendTaskFailureInput) SetError(v string) *SendTaskFailureInput {
	s.Error = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *SendTaskFailureInput) SetTaskToken(v string) *SendTaskFailureInput {
	s.TaskToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailureOutput
type SendTaskFailureOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskFailureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskFailureOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeatInput
type SendTaskHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The token that represents this task. Task tokens are generated by the service
	// when the tasks are assigned to a worker (see GetActivityTask::taskToken).
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTaskHeartbeatInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskToken sets the TaskToken field's value.
func (s *SendTaskHeartbeatInput) SetTaskToken(v string) *SendTaskHeartbeatInput {
	s.TaskToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeatOutput
type SendTaskHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskHeartbeatOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccessInput
type SendTaskSuccessInput struct {
	_ struct{} `type:"structure"`

	// The JSON output of the task.
	//
	// Output is a required field
	Output *string `locationName:"output" type:"string" required:"true"`

	// The token that represents this task. Task tokens are generated by the service
	// when the tasks are assigned to a worker (see GetActivityTask::taskToken).
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskSuccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskSuccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskSuccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTaskSuccessInput"}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutput sets the Output field's value.
func (s *SendTaskSuccessInput) SetOutput(v string) *SendTaskSuccessInput {
	s.Output = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *SendTaskSuccessInput) SetTaskToken(v string) *SendTaskSuccessInput {
	s.TaskToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccessOutput
type SendTaskSuccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskSuccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskSuccessOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecutionInput
type StartExecutionInput struct {
	_ struct{} `type:"structure"`

	// The JSON input data for the execution.
	Input *string `locationName:"input" type:"string"`

	// The name of the execution. This name must be unique for your AWS account
	// and region.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the state machine to execute.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExecutionInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *StartExecutionInput) SetInput(v string) *StartExecutionInput {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartExecutionInput) SetName(v string) *StartExecutionInput {
	s.Name = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *StartExecutionInput) SetStateMachineArn(v string) *StartExecutionInput {
	s.StateMachineArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecutionOutput
type StartExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The date the execution was started.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s StartExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *StartExecutionOutput) SetExecutionArn(v string) *StartExecutionOutput {
	s.ExecutionArn = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *StartExecutionOutput) SetStartDate(v time.Time) *StartExecutionOutput {
	s.StartDate = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StateEnteredEventDetails
type StateEnteredEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON input data to the state.
	Input *string `locationName:"input" type:"string"`

	// The name of the state.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StateEnteredEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateEnteredEventDetails) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *StateEnteredEventDetails) SetInput(v string) *StateEnteredEventDetails {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *StateEnteredEventDetails) SetName(v string) *StateEnteredEventDetails {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StateExitedEventDetails
type StateExitedEventDetails struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The JSON output data of the state.
	Output *string `locationName:"output" type:"string"`
}

// String returns the string representation
func (s StateExitedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateExitedEventDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StateExitedEventDetails) SetName(v string) *StateExitedEventDetails {
	s.Name = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *StateExitedEventDetails) SetOutput(v string) *StateExitedEventDetails {
	s.Output = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StateMachineListItem
type StateMachineListItem struct {
	_ struct{} `type:"structure"`

	// The date the state machine was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name of the state machine.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StateMachineListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateMachineListItem) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *StateMachineListItem) SetCreationDate(v time.Time) *StateMachineListItem {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *StateMachineListItem) SetName(v string) *StateMachineListItem {
	s.Name = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *StateMachineListItem) SetStateMachineArn(v string) *StateMachineListItem {
	s.StateMachineArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecutionInput
type StopExecutionInput struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the termination.
	Cause *string `locationName:"cause" type:"string"`

	// An arbitrary error code that identifies the cause of the termination.
	Error *string `locationName:"error" type:"string"`

	// The Amazon Resource Name (ARN) of the execution to stop.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopExecutionInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCause sets the Cause field's value.
func (s *StopExecutionInput) SetCause(v string) *StopExecutionInput {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *StopExecutionInput) SetError(v string) *StopExecutionInput {
	s.Error = &v
	return s
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *StopExecutionInput) SetExecutionArn(v string) *StopExecutionInput {
	s.ExecutionArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecutionOutput
type StopExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The date the execution was stopped.
	//
	// StopDate is a required field
	StopDate *time.Time `locationName:"stopDate" type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s StopExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopExecutionOutput) GoString() string {
	return s.String()
}

// SetStopDate sets the StopDate field's value.
func (s *StopExecutionOutput) SetStopDate(v time.Time) *StopExecutionOutput {
	s.StopDate = &v
	return s
}

const (
	// ExecutionStatusRunning is a ExecutionStatus enum value
	ExecutionStatusRunning = "RUNNING"

	// ExecutionStatusSucceeded is a ExecutionStatus enum value
	ExecutionStatusSucceeded = "SUCCEEDED"

	// ExecutionStatusFailed is a ExecutionStatus enum value
	ExecutionStatusFailed = "FAILED"

	// ExecutionStatusTimedOut is a ExecutionStatus enum value
	ExecutionStatusTimedOut = "TIMED_OUT"

	// ExecutionStatusAborted is a ExecutionStatus enum value
	ExecutionStatusAborted = "ABORTED"
)

const (
	// HistoryEventTypeActivityFailed is a HistoryEventType enum value
	HistoryEventTypeActivityFailed = "ActivityFailed"

	// HistoryEventTypeActivityScheduleFailed is a HistoryEventType enum value
	HistoryEventTypeActivityScheduleFailed = "ActivityScheduleFailed"

	// HistoryEventTypeActivityScheduled is a HistoryEventType enum value
	HistoryEventTypeActivityScheduled = "ActivityScheduled"

	// HistoryEventTypeActivityStarted is a HistoryEventType enum value
	HistoryEventTypeActivityStarted = "ActivityStarted"

	// HistoryEventTypeActivitySucceeded is a HistoryEventType enum value
	HistoryEventTypeActivitySucceeded = "ActivitySucceeded"

	// HistoryEventTypeActivityTimedOut is a HistoryEventType enum value
	HistoryEventTypeActivityTimedOut = "ActivityTimedOut"

	// HistoryEventTypeChoiceStateEntered is a HistoryEventType enum value
	HistoryEventTypeChoiceStateEntered = "ChoiceStateEntered"

	// HistoryEventTypeChoiceStateExited is a HistoryEventType enum value
	HistoryEventTypeChoiceStateExited = "ChoiceStateExited"

	// HistoryEventTypeExecutionFailed is a HistoryEventType enum value
	HistoryEventTypeExecutionFailed = "ExecutionFailed"

	// HistoryEventTypeExecutionStarted is a HistoryEventType enum value
	HistoryEventTypeExecutionStarted = "ExecutionStarted"

	// HistoryEventTypeExecutionSucceeded is a HistoryEventType enum value
	HistoryEventTypeExecutionSucceeded = "ExecutionSucceeded"

	// HistoryEventTypeExecutionAborted is a HistoryEventType enum value
	HistoryEventTypeExecutionAborted = "ExecutionAborted"

	// HistoryEventTypeExecutionTimedOut is a HistoryEventType enum value
	HistoryEventTypeExecutionTimedOut = "ExecutionTimedOut"

	// HistoryEventTypeFailStateEntered is a HistoryEventType enum value
	HistoryEventTypeFailStateEntered = "FailStateEntered"

	// HistoryEventTypeLambdaFunctionFailed is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionFailed = "LambdaFunctionFailed"

	// HistoryEventTypeLambdaFunctionScheduleFailed is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionScheduleFailed = "LambdaFunctionScheduleFailed"

	// HistoryEventTypeLambdaFunctionScheduled is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionScheduled = "LambdaFunctionScheduled"

	// HistoryEventTypeLambdaFunctionStartFailed is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionStartFailed = "LambdaFunctionStartFailed"

	// HistoryEventTypeLambdaFunctionStarted is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionStarted = "LambdaFunctionStarted"

	// HistoryEventTypeLambdaFunctionSucceeded is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionSucceeded = "LambdaFunctionSucceeded"

	// HistoryEventTypeLambdaFunctionTimedOut is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionTimedOut = "LambdaFunctionTimedOut"

	// HistoryEventTypeSucceedStateEntered is a HistoryEventType enum value
	HistoryEventTypeSucceedStateEntered = "SucceedStateEntered"

	// HistoryEventTypeSucceedStateExited is a HistoryEventType enum value
	HistoryEventTypeSucceedStateExited = "SucceedStateExited"

	// HistoryEventTypeTaskStateEntered is a HistoryEventType enum value
	HistoryEventTypeTaskStateEntered = "TaskStateEntered"

	// HistoryEventTypeTaskStateExited is a HistoryEventType enum value
	HistoryEventTypeTaskStateExited = "TaskStateExited"

	// HistoryEventTypePassStateEntered is a HistoryEventType enum value
	HistoryEventTypePassStateEntered = "PassStateEntered"

	// HistoryEventTypePassStateExited is a HistoryEventType enum value
	HistoryEventTypePassStateExited = "PassStateExited"

	// HistoryEventTypeParallelStateEntered is a HistoryEventType enum value
	HistoryEventTypeParallelStateEntered = "ParallelStateEntered"

	// HistoryEventTypeParallelStateExited is a HistoryEventType enum value
	HistoryEventTypeParallelStateExited = "ParallelStateExited"

	// HistoryEventTypeWaitStateEntered is a HistoryEventType enum value
	HistoryEventTypeWaitStateEntered = "WaitStateEntered"

	// HistoryEventTypeWaitStateExited is a HistoryEventType enum value
	HistoryEventTypeWaitStateExited = "WaitStateExited"
)

const (
	// StateMachineStatusActive is a StateMachineStatus enum value
	StateMachineStatusActive = "ACTIVE"

	// StateMachineStatusDeleting is a StateMachineStatus enum value
	StateMachineStatusDeleting = "DELETING"
)
