/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import picard.PicardException;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;

public class BclIndexReader {
    private static final int BCI_HEADER_SIZE = 8;
    private static final int BCI_VERSION = 0;
    private final BinaryFileIterator<Long> bciIterator;
    private final int numTiles;
    private final File bciFile;
    private int nextRecordNumber = 0;

    public BclIndexReader(File bclFile) {
        this.bciFile = new File(bclFile.getAbsolutePath() + ".bci");
        this.bciIterator = MMapBackedIteratorFactory.getLongIterator(8, this.bciFile);
        ByteBuffer headerBytes = this.bciIterator.getHeaderBytes();
        int actualVersion = headerBytes.getInt();
        if (actualVersion != 0) {
            throw new PicardException(String.format("Unexpected version number %d in %s", actualVersion, this.bciFile.getAbsolutePath()));
        }
        this.numTiles = headerBytes.getInt();
    }

    public int getNumTiles() {
        return this.numTiles;
    }

    public long get(int recordNumber) {
        if (recordNumber < this.nextRecordNumber) {
            throw new IllegalArgumentException("Can only read forward");
        }
        if (recordNumber > this.nextRecordNumber) {
            this.bciIterator.skipElements(recordNumber - this.nextRecordNumber);
            this.nextRecordNumber = recordNumber;
        }
        ++this.nextRecordNumber;
        return this.bciIterator.getElement();
    }

    public File getBciFile() {
        return this.bciFile;
    }
}

