/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleMulticaster;
import org.jhotdraw.draw.HandleTracker;

public class DefaultHandleTracker
extends AbstractTool
implements HandleTracker {
    private Handle masterHandle;
    private HandleMulticaster multicaster;
    private LinkedList<Handle> hoverHandles = new LinkedList();
    private Figure hoverFigure = null;

    public DefaultHandleTracker(Handle handle) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(handle);
    }

    public DefaultHandleTracker(Handle handle, Collection<Handle> collection) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(collection);
    }

    public DefaultHandleTracker() {
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.hoverHandles.size() > 0 && !this.getView().isFigureSelected(this.hoverFigure)) {
            for (Handle handle : this.hoverHandles) {
                handle.draw(graphics2D);
            }
        }
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.getView().setCursor(this.masterHandle.getCursor());
        this.getView().setActiveHandle(this.masterHandle);
        this.clearHoverHandles();
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        this.getView().setActiveHandle(null);
        this.clearHoverHandles();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.multicaster.keyPressed(keyEvent);
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.multicaster.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.multicaster.keyTyped(keyEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.multicaster.trackDoubleClick(new Point(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiersEx(), this.getView());
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.multicaster.trackStep(this.anchor, new Point(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiersEx(), this.getView());
        this.clearHoverHandles();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        DrawingView drawingView = this.editor.findView((Container)mouseEvent.getSource());
        this.updateHoverHandles(drawingView, null);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), point);
        DrawingView drawingView = this.editor.findView((Container)mouseEvent.getSource());
        this.updateCursor(drawingView, point);
        if (drawingView == null || this.editor.getActiveView() != drawingView) {
            this.clearHoverHandles();
        } else {
            Figure figure = null;
            Point2D.Double double_ = drawingView.viewToDrawing(point);
            for (Figure figure2 : drawingView.getSelectedFigures()) {
                if (!figure2.contains(double_)) continue;
                figure = figure2;
            }
            if (figure == null) {
                figure = drawingView.findFigure(point);
                Drawing drawing = drawingView.getDrawing();
                while (figure != null && !figure.isSelectable()) {
                    figure = drawing.findFigureBehind(double_, figure);
                }
            }
            this.updateHoverHandles(drawingView, figure);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.anchor = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.multicaster.trackStart(this.anchor, mouseEvent.getModifiersEx(), this.getView());
        this.clearHoverHandles();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.multicaster.trackEnd(this.anchor, new Point(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiersEx(), this.getView());
        this.fireToolDone();
    }

    protected void clearHoverHandles() {
        this.updateHoverHandles(null, null);
    }

    protected void updateHoverHandles(DrawingView drawingView, Figure figure) {
        if (figure != this.hoverFigure) {
            Rectangle rectangle = null;
            if (this.hoverFigure != null && this.hoverFigure.isSelectable()) {
                for (Handle handle : this.hoverHandles) {
                    if (rectangle == null) {
                        rectangle = handle.getDrawingArea();
                    } else {
                        rectangle.add(handle.getDrawingArea());
                    }
                    handle.setView(null);
                    handle.dispose();
                }
                this.hoverHandles.clear();
            }
            this.hoverFigure = figure;
            if (this.hoverFigure != null) {
                this.hoverHandles.addAll(this.hoverFigure.createHandles(-1));
                for (Handle handle : this.hoverHandles) {
                    handle.setView(drawingView);
                    if (rectangle == null) {
                        rectangle = handle.getDrawingArea();
                        continue;
                    }
                    rectangle.add(handle.getDrawingArea());
                }
            }
            if (rectangle != null) {
                rectangle.grow(1, 1);
                this.fireAreaInvalidated(rectangle);
            }
        }
    }

    @Override
    public void setHandles(Handle handle, Collection<Handle> collection) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(handle);
    }
}

