//========================================================================
//
// annot_stamp_not_for_public_release.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_NOT_FOR_PUBLIC_RELEASE_H
#define ANNOT_STAMP_NOT_FOR_PUBLIC_RELEASE_H

#include "PDFDoc.h"
#include "Dict.h"
#include "Object.h"

static const double ANNOT_STAMP_NOT_FOR_PUBLIC_RELEASE_WIDTH = 268.008179;
static const double ANNOT_STAMP_NOT_FOR_PUBLIC_RELEASE_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_NOT_FOR_PUBLIC_RELEASE = "1 0 0 -1 0 26.484741 cm\n"
                                                        "q\n"
                                                        "1 1 1 rg /a0 gs\n"
                                                        "3.406 2.129 m 264.617 2.129 l 265.316 2.129 265.887 2.828 265.887 3.398\n"
                                                        " c 265.887 23.09 l 265.887 23.789 265.32 24.359 264.617 24.359 c 3.406 24.359\n"
                                                        " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                                        " 2.129 3.406 2.129 c h\n"
                                                        "3.406 2.129 m f\n"
                                                        "0.74902 0 0 rg /a1 gs\n"
                                                        "1 1 1 RG 0.531496 w\n"
                                                        "0 J\n"
                                                        "0 j\n"
                                                        "[] 0.0 d\n"
                                                        "4 M q 1 0 0 1 0 0 cm\n"
                                                        "24.195 20.828 m 17.484 8.973 l 17.52 9.293 17.555 9.613 17.582 9.934 c \n"
                                                        "17.609 10.211 17.633 10.508 17.648 10.828 c 17.672 11.148 17.68 11.453 17.68\n"
                                                        " 11.746 c 17.68 20.828 l 14.82 20.828 l 14.82 5.434 l 18.504 5.434 l 25.312\n"
                                                        " 17.387 l 25.277 17.082 25.242 16.762 25.215 16.426 c 25.188 16.141 25.16\n"
                                                        " 15.82 25.137 15.465 c 25.121 15.109 25.113 14.746 25.113 14.383 c 25.113\n"
                                                        " 5.434 l 27.977 5.434 l 27.977 20.828 l 24.195 20.828 l 42.289 14.906 m \n"
                                                        "42.289 15.809 42.16 16.637 41.906 17.387 c 41.66 18.137 41.285 18.785 40.781\n"
                                                        " 19.332 c 40.277 19.871 39.652 20.293 38.902 20.598 c 38.152 20.895 37.277\n"
                                                        " 21.047 36.281 21.047 c 35.32 21.047 34.473 20.898 33.734 20.598 c 33 20.301\n"
                                                        " 32.379 19.879 31.875 19.34 c 31.379 18.801 31.004 18.156 30.75 17.406 c\n"
                                                        " 30.496 16.648 30.367 15.816 30.367 14.902 c 30.367 14.02 30.488 13.207 \n"
                                                        "30.727 12.465 c 30.973 11.715 31.348 11.066 31.84 10.52 c 32.336 9.973 32.957\n"
                                                        " 9.547 33.707 9.242 c 34.457 8.938 35.336 8.785 36.34 8.785 c 37.402 8.785\n"
                                                        " 38.309 8.938 39.062 9.242 c 39.812 9.547 40.426 9.973 40.898 10.52 c 41.379\n"
                                                        " 11.059 41.73 11.703 41.949 12.453 c 42.176 13.195 42.289 14.012 42.289 \n"
                                                        "14.902 c 39.078 14.902 m 39.078 13.496 38.848 12.477 38.391 11.844 c 37.934\n"
                                                        " 11.211 37.266 10.895 36.391 10.895 c 35.488 10.895 34.797 11.215 34.316\n"
                                                        " 11.855 c 33.836 12.496 33.594 13.512 33.594 14.902 c 33.594 15.609 33.656\n"
                                                        " 16.219 33.781 16.727 c 33.914 17.238 34.094 17.656 34.328 17.984 c 34.562\n"
                                                        " 18.312 34.84 18.555 35.168 18.715 c 35.496 18.867 35.855 18.945 36.25 18.945\n"
                                                        " c 36.703 18.945 37.102 18.867 37.453 18.715 c 37.809 18.555 38.109 18.312\n"
                                                        " 38.348 17.984 c 38.59 17.656 38.77 17.238 38.895 16.727 c 39.02 16.215 \n"
                                                        "39.082 15.609 39.082 14.902 c 47.77 21.02 m 46.867 21.02 46.172 20.777 45.684\n"
                                                        " 20.289 c 45.195 19.793 44.953 19.047 44.953 18.051 c 44.953 11.078 l 43.449\n"
                                                        " 11.082 l 43.449 9.008 l 45.098 9.008 l 46.059 6.23 l 47.98 6.23 l 47.98\n"
                                                        " 9.008 l 50.219 9.008 l 50.219 11.082 l 47.98 11.082 l 47.98 17.223 l 47.98\n"
                                                        " 17.797 48.09 18.223 48.309 18.5 c 48.527 18.77 48.867 18.906 49.324 18.902\n"
                                                        " c 49.512 18.902 49.684 18.887 49.836 18.859 c 49.988 18.832 50.16 18.793\n"
                                                        " 50.348 18.75 c 50.348 20.652 l 49.969 20.777 49.566 20.867 49.145 20.926\n"
                                                        " c 48.723 20.992 48.258 21.023 47.758 21.023 c 61.57 7.922 m 61.57 12.688\n"
                                                        " l 69.449 12.688 l 69.449 15.18 l 61.574 15.18 l 61.574 20.828 l 58.352 \n"
                                                        "20.828 l 58.352 5.434 l 69.703 5.434 l 69.703 7.926 l 61.574 7.926 l 83.328\n"
                                                        " 14.906 m 83.328 15.809 83.199 16.637 82.945 17.387 c 82.699 18.137 82.324\n"
                                                        " 18.785 81.82 19.332 c 81.316 19.871 80.691 20.293 79.941 20.598 c 79.191\n"
                                                        " 20.895 78.316 21.047 77.32 21.047 c 76.359 21.047 75.512 20.898 74.773 \n"
                                                        "20.598 c 74.039 20.301 73.418 19.879 72.914 19.34 c 72.418 18.801 72.043\n"
                                                        " 18.156 71.789 17.406 c 71.535 16.648 71.406 15.816 71.406 14.902 c 71.406\n"
                                                        " 14.02 71.527 13.207 71.766 12.465 c 72.012 11.715 72.387 11.066 72.879 \n"
                                                        "10.52 c 73.375 9.973 73.996 9.547 74.746 9.242 c 75.496 8.938 76.375 8.785\n"
                                                        " 77.379 8.785 c 78.441 8.785 79.348 8.938 80.102 9.242 c 80.852 9.547 81.465\n"
                                                        " 9.973 81.938 10.52 c 82.418 11.059 82.77 11.703 82.988 12.453 c 83.215 \n"
                                                        "13.195 83.328 14.012 83.328 14.902 c 80.117 14.902 m 80.117 13.496 79.887\n"
                                                        " 12.477 79.43 11.844 c 78.973 11.211 78.305 10.895 77.43 10.895 c 76.527\n"
                                                        " 10.895 75.836 11.215 75.355 11.855 c 74.875 12.496 74.633 13.512 74.633\n"
                                                        " 14.902 c 74.633 15.609 74.695 16.219 74.82 16.727 c 74.953 17.238 75.133\n"
                                                        " 17.656 75.367 17.984 c 75.602 18.312 75.879 18.555 76.207 18.715 c 76.535\n"
                                                        " 18.867 76.895 18.945 77.289 18.945 c 77.742 18.945 78.141 18.867 78.492\n"
                                                        " 18.715 c 78.848 18.555 79.148 18.312 79.387 17.984 c 79.629 17.656 79.809\n"
                                                        " 17.238 79.934 16.727 c 80.059 16.215 80.121 15.609 80.121 14.902 c 85.781\n"
                                                        " 20.824 m 85.781 11.777 l 85.781 11.523 85.777 11.254 85.77 10.969 c 85.77\n"
                                                        " 10.684 85.762 10.414 85.746 10.16 c 85.738 9.898 85.73 9.664 85.723 9.461\n"
                                                        " c 85.715 9.25 85.703 9.098 85.691 9.004 c 88.621 9.004 l 88.637 9.09 88.648\n"
                                                        " 9.246 88.664 9.461 c 88.68 9.672 88.691 9.906 88.707 10.16 c 88.723 10.414\n"
                                                        " 88.734 10.672 88.738 10.926 c 88.754 11.172 88.762 11.375 88.762 11.527\n"
                                                        " c 88.805 11.527 l 88.957 11.098 89.109 10.715 89.262 10.379 c 89.414 10.035\n"
                                                        " 89.594 9.75 89.797 9.516 c 90.008 9.273 90.258 9.094 90.551 8.969 c 90.844\n"
                                                        " 8.836 91.203 8.773 91.633 8.773 c 91.816 8.773 91.992 8.793 92.168 8.828\n"
                                                        " c 92.352 8.855 92.488 8.895 92.582 8.938 c 92.582 11.504 l 92.387 11.461\n"
                                                        " 92.184 11.422 91.98 11.395 c 91.785 11.359 91.547 11.34 91.27 11.34 c 90.504\n"
                                                        " 11.34 89.906 11.648 89.477 12.27 c 89.055 12.891 88.844 13.805 88.844 15.023\n"
                                                        " c 88.844 20.824 l 85.773 20.824 l 113.277 10.301 m 113.277 10.965 113.164\n"
                                                        " 11.605 112.938 12.223 c 112.719 12.836 112.379 13.379 111.922 13.852 c \n"
                                                        "111.465 14.324 110.879 14.703 110.172 14.988 c 109.465 15.266 108.629 15.402\n"
                                                        " 107.66 15.402 c 103.836 15.402 l 103.836 20.82 l 100.613 20.82 l 100.613\n"
                                                        " 5.426 l 107.531 5.426 l 108.516 5.426 109.367 5.547 110.09 5.785 c 110.812\n"
                                                        " 6.02 111.41 6.352 111.883 6.781 c 112.355 7.211 112.707 7.727 112.934 8.32\n"
                                                        " c 113.168 8.918 113.285 9.578 113.285 10.297 c 110.039 10.352 m 110.039\n"
                                                        " 9.559 109.797 8.957 109.316 8.547 c 108.844 8.133 108.129 7.926 107.176\n"
                                                        " 7.926 c 103.844 7.926 l 103.844 12.918 l 107.266 12.918 l 107.746 12.918\n"
                                                        " 108.156 12.855 108.5 12.73 c 108.852 12.605 109.137 12.434 109.363 12.207\n"
                                                        " c 109.598 11.98 109.766 11.711 109.875 11.398 c 109.984 11.078 110.039 \n"
                                                        "10.727 110.039 10.348 c 118.527 8.992 m 118.527 15.625 l 118.527 16.082 \n"
                                                        "118.562 16.508 118.637 16.891 c 118.711 17.27 118.828 17.598 118.996 17.875\n"
                                                        " c 119.164 18.145 119.379 18.355 119.641 18.508 c 119.91 18.66 120.238 18.738\n"
                                                        " 120.625 18.738 c 120.996 18.738 121.332 18.656 121.629 18.496 c 121.934\n"
                                                        " 18.328 122.195 18.094 122.414 17.797 c 122.633 17.492 122.801 17.129 122.918\n"
                                                        " 16.715 c 123.043 16.293 123.105 15.828 123.105 15.328 c 123.105 8.992 l\n"
                                                        " 126.176 8.992 l 126.176 18.172 l 126.176 18.418 126.176 18.684 126.176 \n"
                                                        "18.957 c 126.184 19.227 126.191 19.484 126.199 19.734 c 126.215 19.977 126.227\n"
                                                        " 20.191 126.23 20.391 c 126.246 20.578 126.258 20.723 126.262 20.816 c 123.332\n"
                                                        " 20.816 l 123.324 20.73 123.309 20.59 123.289 20.402 c 123.273 20.207 123.262\n"
                                                        " 19.992 123.246 19.758 c 123.238 19.523 123.227 19.293 123.215 19.059 c \n"
                                                        "123.207 18.824 123.203 18.629 123.203 18.469 c 123.148 18.469 l 122.742 \n"
                                                        "19.363 122.219 20.016 121.586 20.426 c 120.961 20.832 120.211 21.039 119.348\n"
                                                        " 21.039 c 118.641 21.039 118.039 20.922 117.543 20.688 c 117.047 20.453 \n"
                                                        "116.645 20.137 116.332 19.738 c 116.027 19.332 115.805 18.848 115.664 18.297\n"
                                                        " c 115.527 17.742 115.457 17.145 115.457 16.504 c 115.457 8.996 l 118.527\n"
                                                        " 8.996 l 140.5 14.863 m 140.5 15.758 140.41 16.586 140.227 17.344 c 140.051\n"
                                                        " 18.094 139.777 18.746 139.406 19.301 c 139.035 19.848 138.562 20.273 137.984\n"
                                                        " 20.578 c 137.418 20.883 136.742 21.035 135.965 21.035 c 135.613 21.035 \n"
                                                        "135.266 21 134.914 20.926 c 134.562 20.852 134.234 20.734 133.918 20.566\n"
                                                        " c 133.605 20.398 133.316 20.18 133.055 19.91 c 132.793 19.641 132.566 19.309\n"
                                                        " 132.379 18.914 c 132.355 18.914 l 132.355 19.066 132.348 19.242 132.332\n"
                                                        " 19.438 c 132.324 19.633 132.312 19.828 132.301 20.016 c 132.285 20.199 \n"
                                                        "132.27 20.363 132.246 20.508 c 132.23 20.652 132.219 20.754 132.203 20.812\n"
                                                        " c 129.219 20.812 l 129.242 20.559 129.258 20.195 129.273 19.73 c 129.297\n"
                                                        " 19.258 129.305 18.719 129.305 18.113 c 129.305 4.598 l 132.375 4.598 l \n"
                                                        "132.375 9.121 l 132.375 9.355 132.371 9.582 132.363 9.809 c 132.363 10.027\n"
                                                        " 132.359 10.23 132.352 10.422 c 132.344 10.641 132.336 10.848 132.328 11.043\n"
                                                        " c 132.371 11.043 l 132.742 10.227 133.254 9.645 133.902 9.293 c 134.551\n"
                                                        " 8.941 135.301 8.77 136.152 8.77 c 136.91 8.77 137.562 8.922 138.109 9.227\n"
                                                        " c 138.656 9.523 139.105 9.949 139.453 10.492 c 139.809 11.031 140.074 11.672\n"
                                                        " 140.238 12.414 c 140.406 13.156 140.488 13.969 140.488 14.852 c 137.285\n"
                                                        " 14.852 m 137.285 13.512 137.09 12.516 136.695 11.867 c 136.301 11.219 135.695\n"
                                                        " 10.895 134.871 10.895 c 134.559 10.895 134.25 10.957 133.941 11.082 c 133.637\n"
                                                        " 11.207 133.363 11.426 133.121 11.738 c 132.879 12.043 132.688 12.461 132.543\n"
                                                        " 12.984 c 132.398 13.5 132.324 14.156 132.324 14.953 c 132.324 15.727 132.398\n"
                                                        " 16.367 132.543 16.875 c 132.688 17.387 132.879 17.793 133.109 18.098 c \n"
                                                        "133.344 18.402 133.613 18.617 133.918 18.742 c 134.223 18.867 134.535 18.93\n"
                                                        " 134.848 18.93 c 135.629 18.93 136.227 18.609 136.652 17.969 c 137.074 17.32\n"
                                                        " 137.285 16.281 137.285 14.855 c 142.977 20.812 m 142.977 4.598 l 146.047\n"
                                                        " 4.598 l 146.047 20.812 l 142.977 20.812 l 149.184 6.859 m 149.184 4.598\n"
                                                        " l 152.254 4.598 l 152.254 6.859 l 149.184 6.859 l 149.184 20.812 m 149.184\n"
                                                        " 8.988 l 152.254 8.988 l 152.254 20.812 l 149.184 20.812 l 160.316 21.031\n"
                                                        " m 159.375 21.031 158.555 20.887 157.848 20.594 c 157.148 20.301 156.566\n"
                                                        " 19.891 156.098 19.359 c 155.633 18.828 155.281 18.191 155.047 17.445 c \n"
                                                        "154.812 16.695 154.695 15.867 154.695 14.965 c 154.695 13.98 154.824 13.105\n"
                                                        " 155.078 12.344 c 155.332 11.57 155.699 10.922 156.184 10.398 c 156.664 \n"
                                                        "9.867 157.254 9.461 157.953 9.188 c 158.66 8.91 159.461 8.773 160.355 8.773\n"
                                                        " c 161.121 8.773 161.797 8.875 162.387 9.078 c 162.984 9.281 163.496 9.562\n"
                                                        " 163.926 9.918 c 164.355 10.27 164.703 10.684 164.965 11.164 c 165.234 11.645\n"
                                                        " 165.422 12.16 165.523 12.715 c 162.43 12.867 l 162.344 12.262 162.125 11.781\n"
                                                        " 161.773 11.426 c 161.422 11.062 160.93 10.879 160.289 10.879 c 159.465 \n"
                                                        "10.879 158.863 11.219 158.484 11.895 c 158.105 12.57 157.918 13.555 157.918\n"
                                                        " 14.844 c 157.918 17.566 158.723 18.93 160.332 18.93 c 160.914 18.93 161.402\n"
                                                        " 18.746 161.797 18.383 c 162.191 18.012 162.434 17.461 162.527 16.734 c \n"
                                                        "165.609 16.875 l 165.535 17.422 165.367 17.945 165.105 18.449 c 164.852 \n"
                                                        "18.945 164.5 19.387 164.055 19.77 c 163.617 20.148 163.086 20.453 162.461\n"
                                                        " 20.688 c 161.836 20.914 161.117 21.027 160.309 21.027 c 184.555 20.809 \n"
                                                        "m 180.98 14.961 l 177.199 14.961 l 177.199 20.809 l 173.977 20.809 l 173.977\n"
                                                        " 5.414 l 181.668 5.414 l 182.629 5.414 183.469 5.523 184.18 5.742 c 184.902\n"
                                                        " 5.953 185.5 6.258 185.984 6.66 c 186.465 7.055 186.82 7.535 187.055 8.102\n"
                                                        " c 187.297 8.664 187.414 9.297 187.414 10.004 c 187.414 10.578 187.328 11.109\n"
                                                        " 187.152 11.59 c 186.984 12.062 186.746 12.484 186.441 12.855 c 186.145 \n"
                                                        "13.227 185.785 13.539 185.371 13.797 c 184.957 14.043 184.504 14.227 184.016\n"
                                                        " 14.344 c 188.18 20.812 l 184.551 20.812 l 184.168 10.137 m 184.168 9.387\n"
                                                        " 183.922 8.828 183.426 8.465 c 182.938 8.102 182.238 7.918 181.328 7.918\n"
                                                        " c 177.199 7.918 l 177.199 12.465 l 181.418 12.465 l 181.898 12.465 182.309\n"
                                                        " 12.41 182.652 12.301 c 183.004 12.184 183.285 12.023 183.504 11.82 c 183.73\n"
                                                        " 11.609 183.898 11.363 184.008 11.078 c 184.117 10.793 184.172 10.48 184.172\n"
                                                        " 10.137 c 195.055 21.031 m 194.203 21.031 193.434 20.906 192.75 20.66 c \n"
                                                        "192.074 20.406 191.492 20.023 191.012 19.512 c 190.531 18.996 190.164 18.352\n"
                                                        " 189.906 17.578 c 189.652 16.797 189.523 15.887 189.523 14.848 c 189.523\n"
                                                        " 13.719 189.672 12.77 189.973 11.996 c 190.277 11.223 190.688 10.602 191.195\n"
                                                        " 10.129 c 191.711 9.648 192.305 9.301 192.977 9.09 c 193.648 8.879 194.352\n"
                                                        " 8.773 195.098 8.773 c 196.031 8.773 196.824 8.938 197.48 9.266 c 198.145\n"
                                                        " 9.586 198.688 10.039 199.109 10.621 c 199.531 11.203 199.84 11.902 200.039\n"
                                                        " 12.719 c 200.234 13.527 200.336 14.422 200.336 15.406 c 200.336 15.492 \n"
                                                        "l 192.754 15.492 l 192.754 15.988 192.797 16.449 192.887 16.879 c 192.973\n"
                                                        " 17.301 193.117 17.668 193.312 17.984 c 193.508 18.289 193.766 18.535 194.078\n"
                                                        " 18.715 c 194.391 18.891 194.77 18.977 195.215 18.977 c 195.754 18.977 196.195\n"
                                                        " 18.863 196.535 18.637 c 196.879 18.402 197.121 18.047 197.266 17.566 c \n"
                                                        "200.16 17.816 l 200.027 18.152 199.844 18.508 199.602 18.887 c 199.367 19.266\n"
                                                        " 199.055 19.613 198.66 19.938 c 198.266 20.25 197.773 20.512 197.184 20.723\n"
                                                        " c 196.602 20.926 195.891 21.027 195.055 21.027 c 195.055 10.703 m 194.742\n"
                                                        " 10.703 194.445 10.758 194.168 10.867 c 193.898 10.969 193.66 11.137 193.457\n"
                                                        " 11.371 c 193.262 11.598 193.102 11.891 192.977 12.258 c 192.852 12.621 \n"
                                                        "192.785 13.059 192.77 13.57 c 197.359 13.57 l 197.301 12.617 197.07 11.902\n"
                                                        " 196.672 11.43 c 196.27 10.949 195.73 10.707 195.055 10.707 c 202.672 20.812\n"
                                                        " m 202.672 4.598 l 205.742 4.598 l 205.742 20.812 l 202.672 20.812 l 213.719\n"
                                                        " 21.031 m 212.867 21.031 212.098 20.906 211.414 20.66 c 210.738 20.406 210.156\n"
                                                        " 20.023 209.676 19.512 c 209.195 18.996 208.828 18.352 208.57 17.578 c 208.316\n"
                                                        " 16.797 208.188 15.887 208.188 14.848 c 208.188 13.719 208.336 12.77 208.637\n"
                                                        " 11.996 c 208.941 11.223 209.352 10.602 209.859 10.129 c 210.375 9.648 210.969\n"
                                                        " 9.301 211.641 9.09 c 212.312 8.879 213.016 8.773 213.762 8.773 c 214.695\n"
                                                        " 8.773 215.488 8.938 216.145 9.266 c 216.809 9.586 217.352 10.039 217.773\n"
                                                        " 10.621 c 218.195 11.203 218.504 11.902 218.703 12.719 c 218.898 13.527 \n"
                                                        "219 14.422 219 15.406 c 219 15.492 l 211.418 15.492 l 211.418 15.988 211.461\n"
                                                        " 16.449 211.551 16.879 c 211.637 17.301 211.781 17.668 211.977 17.984 c \n"
                                                        "212.172 18.289 212.43 18.535 212.742 18.715 c 213.055 18.891 213.434 18.977\n"
                                                        " 213.879 18.977 c 214.418 18.977 214.859 18.863 215.199 18.637 c 215.543\n"
                                                        " 18.402 215.785 18.047 215.93 17.566 c 218.824 17.816 l 218.691 18.152 218.508\n"
                                                        " 18.508 218.266 18.887 c 218.031 19.266 217.719 19.613 217.324 19.938 c \n"
                                                        "216.93 20.25 216.438 20.512 215.848 20.723 c 215.266 20.926 214.555 21.027\n"
                                                        " 213.719 21.027 c 213.719 10.703 m 213.406 10.703 213.109 10.758 212.832\n"
                                                        " 10.867 c 212.562 10.969 212.324 11.137 212.121 11.371 c 211.926 11.598 \n"
                                                        "211.766 11.891 211.641 12.258 c 211.516 12.621 211.449 13.059 211.434 13.57\n"
                                                        " c 216.023 13.57 l 215.965 12.617 215.734 11.902 215.336 11.43 c 214.934\n"
                                                        " 10.949 214.395 10.707 213.719 10.707 c 224.066 21.031 m 223.5 21.031 222.988\n"
                                                        " 20.953 222.535 20.801 c 222.09 20.641 221.711 20.41 221.398 20.113 c 221.086\n"
                                                        " 19.809 220.844 19.434 220.676 18.988 c 220.508 18.543 220.426 18.039 220.426\n"
                                                        " 17.469 c 220.426 16.77 220.547 16.184 220.785 15.711 c 221.031 15.23 221.367\n"
                                                        " 14.844 221.789 14.551 c 222.211 14.254 222.707 14.039 223.273 13.906 c \n"
                                                        "223.84 13.77 224.445 13.695 225.086 13.688 c 227.633 13.645 l 227.633 13.043\n"
                                                        " l 227.633 12.613 227.594 12.258 227.512 11.973 c 227.438 11.68 227.328 \n"
                                                        "11.445 227.184 11.262 c 227.039 11.078 226.855 10.953 226.637 10.879 c 226.426\n"
                                                        " 10.797 226.18 10.758 225.906 10.758 c 225.652 10.758 225.422 10.785 225.219\n"
                                                        " 10.836 c 225.023 10.887 224.852 10.977 224.707 11.109 c 224.562 11.234 \n"
                                                        "224.441 11.406 224.348 11.621 c 224.262 11.832 224.199 12.102 224.16 12.43\n"
                                                        " c 220.957 12.277 l 221.043 11.762 221.203 11.289 221.438 10.867 c 221.672\n"
                                                        " 10.438 221.992 10.066 222.398 9.754 c 222.812 9.441 223.32 9.199 223.918\n"
                                                        " 9.031 c 224.523 8.855 225.23 8.77 226.039 8.77 c 226.773 8.77 227.43 8.859\n"
                                                        " 228.008 9.043 c 228.582 9.227 229.07 9.5 229.473 9.863 c 229.875 10.219\n"
                                                        " 230.18 10.66 230.391 11.184 c 230.602 11.707 230.707 12.316 230.707 13.008\n"
                                                        " c 230.707 17.312 l 230.707 17.59 230.719 17.836 230.738 18.055 c 230.766\n"
                                                        " 18.273 230.816 18.457 230.879 18.613 c 230.953 18.758 231.051 18.871 231.176\n"
                                                        " 18.953 c 231.309 19.027 231.473 19.062 231.68 19.062 c 231.914 19.062 232.137\n"
                                                        " 19.039 232.355 18.996 c 232.355 20.656 l 232.172 20.699 232.008 20.738 \n"
                                                        "231.863 20.777 c 231.719 20.812 231.57 20.844 231.426 20.863 c 231.281 20.887\n"
                                                        " 231.125 20.902 230.957 20.918 c 230.797 20.934 230.605 20.941 230.391 20.941\n"
                                                        " c 229.617 20.941 229.047 20.754 228.676 20.375 c 228.312 19.996 228.094\n"
                                                        " 19.438 228.02 18.703 c 227.953 18.703 l 227.547 19.438 227.02 20.012 226.379\n"
                                                        " 20.418 c 225.746 20.824 224.973 21.031 224.062 21.031 c 227.637 15.34 m\n"
                                                        " 226.062 15.363 l 225.734 15.379 225.422 15.406 225.121 15.449 c 224.828\n"
                                                        " 15.484 224.57 15.57 224.344 15.699 c 224.125 15.824 223.949 16.004 223.82\n"
                                                        " 16.246 c 223.688 16.488 223.625 16.812 223.625 17.23 c 223.625 17.793 223.754\n"
                                                        " 18.211 224.008 18.488 c 224.27 18.758 224.617 18.895 225.047 18.891 c 225.441\n"
                                                        " 18.891 225.797 18.809 226.117 18.641 c 226.438 18.473 226.707 18.254 226.926\n"
                                                        " 17.984 c 227.152 17.707 227.328 17.391 227.449 17.035 c 227.574 16.68 227.637\n"
                                                        " 16.312 227.637 15.941 c 227.637 15.34 l 243.754 17.359 m 243.754 17.926\n"
                                                        " 243.633 18.438 243.395 18.891 c 243.16 19.344 242.82 19.727 242.367 20.051\n"
                                                        " c 241.914 20.363 241.363 20.609 240.707 20.781 c 240.051 20.949 239.305\n"
                                                        " 21.031 238.469 21.031 c 237.719 21.031 237.039 20.977 236.438 20.867 c \n"
                                                        "235.832 20.758 235.301 20.578 234.844 20.332 c 234.391 20.078 234.012 19.75\n"
                                                        " 233.707 19.348 c 233.402 18.945 233.172 18.453 233.02 17.863 c 235.719 \n"
                                                        "17.461 l 235.805 17.789 235.926 18.055 236.078 18.258 c 236.23 18.461 236.422\n"
                                                        " 18.617 236.645 18.727 c 236.871 18.836 237.133 18.91 237.43 18.945 c 237.734\n"
                                                        " 18.98 238.082 19 238.469 19 c 238.82 19 239.141 18.98 239.441 18.945 c \n"
                                                        "239.746 18.902 240.008 18.832 240.227 18.738 c 240.453 18.637 240.629 18.496\n"
                                                        " 240.75 18.324 c 240.875 18.141 240.938 17.918 240.938 17.648 c 240.938 \n"
                                                        "17.344 240.848 17.102 240.664 16.926 c 240.488 16.742 240.246 16.598 239.934\n"
                                                        " 16.488 c 239.629 16.371 239.262 16.273 238.84 16.191 c 238.426 16.105 237.98\n"
                                                        " 16.004 237.508 15.895 c 237.012 15.785 236.523 15.652 236.043 15.5 c 235.562\n"
                                                        " 15.348 235.133 15.141 234.754 14.879 c 234.375 14.617 234.07 14.285 233.836\n"
                                                        " 13.883 c 233.602 13.477 233.484 12.961 233.484 12.344 c 233.484 11.781 \n"
                                                        "233.594 11.285 233.812 10.848 c 234.031 10.402 234.352 10.027 234.773 9.723\n"
                                                        " c 235.195 9.41 235.715 9.172 236.336 9.012 c 236.961 8.844 237.68 8.762\n"
                                                        " 238.488 8.762 c 239.129 8.762 239.727 8.824 240.281 8.949 c 240.836 9.066\n"
                                                        " 241.332 9.254 241.766 9.516 c 242.203 9.77 242.566 10.098 242.859 10.5 \n"
                                                        "c 243.156 10.902 243.367 11.387 243.48 11.953 c 240.758 12.238 l 240.707\n"
                                                        " 11.953 240.617 11.723 240.484 11.539 c 240.352 11.352 240.188 11.199 239.992\n"
                                                        " 11.09 c 239.805 10.98 239.582 10.906 239.324 10.871 c 239.07 10.828 238.789\n"
                                                        " 10.805 238.484 10.805 c 237.758 10.805 237.211 10.898 236.844 11.09 c 236.48\n"
                                                        " 11.273 236.297 11.582 236.297 12.02 c 236.297 12.289 236.371 12.504 236.516\n"
                                                        " 12.664 c 236.668 12.824 236.879 12.961 237.148 13.066 c 237.426 13.168 \n"
                                                        "237.75 13.258 238.121 13.34 c 238.5 13.414 238.91 13.504 239.355 13.613 \n"
                                                        "c 239.902 13.73 240.438 13.867 240.961 14.027 c 241.492 14.18 241.961 14.395\n"
                                                        " 242.371 14.672 c 242.785 14.941 243.117 15.293 243.367 15.723 c 243.621\n"
                                                        " 16.152 243.75 16.699 243.75 17.363 c 251.082 21.035 m 250.23 21.035 249.461\n"
                                                        " 20.91 248.777 20.664 c 248.102 20.41 247.52 20.027 247.039 19.516 c 246.559\n"
                                                        " 19 246.191 18.355 245.934 17.582 c 245.68 16.801 245.551 15.891 245.551\n"
                                                        " 14.852 c 245.551 13.723 245.699 12.773 246 12 c 246.305 11.227 246.715 \n"
                                                        "10.605 247.223 10.133 c 247.738 9.652 248.332 9.305 249.004 9.094 c 249.676\n"
                                                        " 8.883 250.379 8.777 251.125 8.777 c 252.059 8.777 252.852 8.941 253.508\n"
                                                        " 9.27 c 254.172 9.59 254.715 10.043 255.137 10.625 c 255.559 11.207 255.867\n"
                                                        " 11.906 256.066 12.723 c 256.262 13.531 256.363 14.426 256.363 15.41 c 256.363\n"
                                                        " 15.496 l 248.781 15.496 l 248.781 15.992 248.824 16.453 248.914 16.883 \n"
                                                        "c 249 17.305 249.145 17.672 249.34 17.988 c 249.535 18.293 249.793 18.539\n"
                                                        " 250.105 18.719 c 250.418 18.895 250.797 18.98 251.242 18.98 c 251.781 18.98\n"
                                                        " 252.223 18.867 252.562 18.641 c 252.906 18.406 253.148 18.051 253.293 17.57\n"
                                                        " c 256.188 17.82 l 256.055 18.156 255.871 18.512 255.629 18.891 c 255.395\n"
                                                        " 19.27 255.082 19.617 254.688 19.941 c 254.293 20.254 253.801 20.516 253.211\n"
                                                        " 20.727 c 252.629 20.93 251.918 21.031 251.082 21.031 c 251.082 10.707 m\n"
                                                        " 250.77 10.707 250.473 10.762 250.195 10.871 c 249.926 10.973 249.688 11.141\n"
                                                        " 249.484 11.375 c 249.289 11.602 249.129 11.895 249.004 12.262 c 248.879\n"
                                                        " 12.625 248.812 13.062 248.797 13.574 c 253.387 13.574 l 253.328 12.621 \n"
                                                        "253.098 11.906 252.699 11.434 c 252.297 10.953 251.758 10.711 251.082 10.711\n"
                                                        " c B Q\n"
                                                        "Q q\n"
                                                        "0 0 268 26.484 re W n\n"
                                                        "0.74902 0 0 rg /a1 gs\n"
                                                        "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                                        "24.715 1.77 26.086 3.398 26.086 c 264.609 26.086 l 266.238 26.086 267.609\n"
                                                        " 24.715 267.609 23.086 c 267.609 3.398 l 267.609 1.77 266.238 0.398 264.609\n"
                                                        " 0.398 c h\n"
                                                        "3.867 3.844 m 264.164 3.844 l 264.164 22.617 l 3.867 22.617 l h\n"
                                                        "3.867 3.844 m f\n"
                                                        "Q q\n"
                                                        "1 1 1 RG /a1 gs\n"
                                                        "0.797243 w\n"
                                                        "1 J\n"
                                                        "1 j\n"
                                                        "[] 0.0 d\n"
                                                        "4 M q 1 0 0 1 0 0 cm\n"
                                                        "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                                        "24.715 1.77 26.086 3.398 26.086 c 264.609 26.086 l 266.238 26.086 267.609\n"
                                                        " 24.715 267.609 23.086 c 267.609 3.398 l 267.609 1.77 266.238 0.398 264.609\n"
                                                        " 0.398 c h\n"
                                                        "3.867 3.844 m 264.164 3.844 l 264.164 22.617 l 3.867 22.617 l h\n"
                                                        "3.867 3.844 m S Q\n"
                                                        "Q\n";

static Dict *getNotForPublicReleaseStampExtGStateDict(PDFDoc *doc)
{
    Dict *a0Dict = new Dict(doc->getXRef());
    a0Dict->add("CA", Object(0.588235));
    a0Dict->add("ca", Object(0.588235));

    Dict *a1Dict = new Dict(doc->getXRef());
    a1Dict->add("CA", Object(1));
    a1Dict->add("ca", Object(1));

    Dict *extGStateDict = new Dict(doc->getXRef());
    extGStateDict->add("a0", Object(a0Dict));
    extGStateDict->add("a1", Object(a1Dict));

    return extGStateDict;
}

#endif
