; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=i686-unknown-unknown -mattr=+avx,+xop | FileCheck %s --check-prefix=X32
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx,+xop | FileCheck %s --check-prefix=X64

define <16 x i8> @commute_fold_vpcomb(<16 x i8>* %a0, <16 x i8> %a1) {
; X32-LABEL: commute_fold_vpcomb:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomgtb (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomb:
; X64:       # %bb.0:
; X64-NEXT:    vpcomgtb (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <16 x i8>, <16 x i8>* %a0
  %2 = call <16 x i8> @llvm.x86.xop.vpcomb(<16 x i8> %1, <16 x i8> %a1, i8 0) ; vpcomltb
  ret <16 x i8> %2
}
declare <16 x i8> @llvm.x86.xop.vpcomb(<16 x i8>, <16 x i8>, i8) nounwind readnone

define <4 x i32> @commute_fold_vpcomd(<4 x i32>* %a0, <4 x i32> %a1) {
; X32-LABEL: commute_fold_vpcomd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomged (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomd:
; X64:       # %bb.0:
; X64-NEXT:    vpcomged (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpcomd(<4 x i32> %1, <4 x i32> %a1, i8 1) ; vpcomled
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpcomd(<4 x i32>, <4 x i32>, i8) nounwind readnone

define <2 x i64> @commute_fold_vpcomq(<2 x i64>* %a0, <2 x i64> %a1) {
; X32-LABEL: commute_fold_vpcomq:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomltq (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomq:
; X64:       # %bb.0:
; X64-NEXT:    vpcomltq (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <2 x i64>, <2 x i64>* %a0
  %2 = call <2 x i64> @llvm.x86.xop.vpcomq(<2 x i64> %1, <2 x i64> %a1, i8 2) ; vpcomgtq
  ret <2 x i64> %2
}
declare <2 x i64> @llvm.x86.xop.vpcomq(<2 x i64>, <2 x i64>, i8) nounwind readnone

define <16 x i8> @commute_fold_vpcomub(<16 x i8>* %a0, <16 x i8> %a1) {
; X32-LABEL: commute_fold_vpcomub:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomleub (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomub:
; X64:       # %bb.0:
; X64-NEXT:    vpcomleub (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <16 x i8>, <16 x i8>* %a0
  %2 = call <16 x i8> @llvm.x86.xop.vpcomub(<16 x i8> %1, <16 x i8> %a1, i8 3) ; vpcomgeub
  ret <16 x i8> %2
}
declare <16 x i8> @llvm.x86.xop.vpcomub(<16 x i8>, <16 x i8>, i8) nounwind readnone

define <4 x i32> @commute_fold_vpcomud(<4 x i32>* %a0, <4 x i32> %a1) {
; X32-LABEL: commute_fold_vpcomud:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomequd (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomud:
; X64:       # %bb.0:
; X64-NEXT:    vpcomequd (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpcomud(<4 x i32> %1, <4 x i32> %a1, i8 4) ; vpcomequd
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpcomud(<4 x i32>, <4 x i32>, i8) nounwind readnone

define <2 x i64> @commute_fold_vpcomuq(<2 x i64>* %a0, <2 x i64> %a1) {
; X32-LABEL: commute_fold_vpcomuq:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomnequq (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomuq:
; X64:       # %bb.0:
; X64-NEXT:    vpcomnequq (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <2 x i64>, <2 x i64>* %a0
  %2 = call <2 x i64> @llvm.x86.xop.vpcomuq(<2 x i64> %1, <2 x i64> %a1, i8 5) ; vpcomnequq
  ret <2 x i64> %2
}
declare <2 x i64> @llvm.x86.xop.vpcomuq(<2 x i64>, <2 x i64>, i8) nounwind readnone

define <8 x i16> @commute_fold_vpcomuw(<8 x i16>* %a0, <8 x i16> %a1) {
; X32-LABEL: commute_fold_vpcomuw:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomfalseuw (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomuw:
; X64:       # %bb.0:
; X64-NEXT:    vpcomfalseuw (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <8 x i16> @llvm.x86.xop.vpcomuw(<8 x i16> %1, <8 x i16> %a1, i8 6) ; vpcomfalseuw
  ret <8 x i16> %2
}
declare <8 x i16> @llvm.x86.xop.vpcomuw(<8 x i16>, <8 x i16>, i8) nounwind readnone

define <8 x i16> @commute_fold_vpcomw(<8 x i16>* %a0, <8 x i16> %a1) {
; X32-LABEL: commute_fold_vpcomw:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpcomtruew (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpcomw:
; X64:       # %bb.0:
; X64-NEXT:    vpcomtruew (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <8 x i16> @llvm.x86.xop.vpcomw(<8 x i16> %1, <8 x i16> %a1, i8 7) ; vpcomtruew
  ret <8 x i16> %2
}
declare <8 x i16> @llvm.x86.xop.vpcomw(<8 x i16>, <8 x i16>, i8) nounwind readnone

define <4 x i32> @commute_fold_vpmacsdd(<4 x i32>* %a0, <4 x i32> %a1, <4 x i32> %a2) {
; X32-LABEL: commute_fold_vpmacsdd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacsdd %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacsdd:
; X64:       # %bb.0:
; X64-NEXT:    vpmacsdd %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpmacsdd(<4 x i32> %1, <4 x i32> %a1, <4 x i32> %a2)
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpmacsdd(<4 x i32>, <4 x i32>, <4 x i32>) nounwind readnone

define <2 x i64> @commute_fold_vpmacsdqh(<4 x i32>* %a0, <4 x i32> %a1, <2 x i64> %a2) {
; X32-LABEL: commute_fold_vpmacsdqh:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacsdqh %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacsdqh:
; X64:       # %bb.0:
; X64-NEXT:    vpmacsdqh %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <2 x i64> @llvm.x86.xop.vpmacsdqh(<4 x i32> %1, <4 x i32> %a1, <2 x i64> %a2)
  ret <2 x i64> %2
}
declare <2 x i64> @llvm.x86.xop.vpmacsdqh(<4 x i32>, <4 x i32>, <2 x i64>) nounwind readnone

define <2 x i64> @commute_fold_vpmacsdql(<4 x i32>* %a0, <4 x i32> %a1, <2 x i64> %a2) {
; X32-LABEL: commute_fold_vpmacsdql:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacsdql %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacsdql:
; X64:       # %bb.0:
; X64-NEXT:    vpmacsdql %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <2 x i64> @llvm.x86.xop.vpmacsdql(<4 x i32> %1, <4 x i32> %a1, <2 x i64> %a2)
  ret <2 x i64> %2
}
declare <2 x i64> @llvm.x86.xop.vpmacsdql(<4 x i32>, <4 x i32>, <2 x i64>) nounwind readnone

define <4 x i32> @commute_fold_vpmacssdd(<4 x i32>* %a0, <4 x i32> %a1, <4 x i32> %a2) {
; X32-LABEL: commute_fold_vpmacssdd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacssdd %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacssdd:
; X64:       # %bb.0:
; X64-NEXT:    vpmacssdd %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpmacssdd(<4 x i32> %1, <4 x i32> %a1, <4 x i32> %a2)
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpmacssdd(<4 x i32>, <4 x i32>, <4 x i32>) nounwind readnone

define <2 x i64> @commute_fold_vpmacssdqh(<4 x i32>* %a0, <4 x i32> %a1, <2 x i64> %a2) {
; X32-LABEL: commute_fold_vpmacssdqh:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacssdqh %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacssdqh:
; X64:       # %bb.0:
; X64-NEXT:    vpmacssdqh %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <2 x i64> @llvm.x86.xop.vpmacssdqh(<4 x i32> %1, <4 x i32> %a1, <2 x i64> %a2)
  ret <2 x i64> %2
}
declare <2 x i64> @llvm.x86.xop.vpmacssdqh(<4 x i32>, <4 x i32>, <2 x i64>) nounwind readnone

define <2 x i64> @commute_fold_vpmacssdql(<4 x i32>* %a0, <4 x i32> %a1, <2 x i64> %a2) {
; X32-LABEL: commute_fold_vpmacssdql:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacssdql %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacssdql:
; X64:       # %bb.0:
; X64-NEXT:    vpmacssdql %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %a0
  %2 = call <2 x i64> @llvm.x86.xop.vpmacssdql(<4 x i32> %1, <4 x i32> %a1, <2 x i64> %a2)
  ret <2 x i64> %2
}
declare <2 x i64> @llvm.x86.xop.vpmacssdql(<4 x i32>, <4 x i32>, <2 x i64>) nounwind readnone

define <4 x i32> @commute_fold_vpmacsswd(<8 x i16>* %a0, <8 x i16> %a1, <4 x i32> %a2) {
; X32-LABEL: commute_fold_vpmacsswd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacsswd %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacsswd:
; X64:       # %bb.0:
; X64-NEXT:    vpmacsswd %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpmacsswd(<8 x i16> %1, <8 x i16> %a1, <4 x i32> %a2)
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpmacsswd(<8 x i16>, <8 x i16>, <4 x i32>) nounwind readnone

define <8 x i16> @commute_fold_vpmacssww(<8 x i16>* %a0, <8 x i16> %a1, <8 x i16> %a2) {
; X32-LABEL: commute_fold_vpmacssww:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacssww %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacssww:
; X64:       # %bb.0:
; X64-NEXT:    vpmacssww %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <8 x i16> @llvm.x86.xop.vpmacssww(<8 x i16> %1, <8 x i16> %a1, <8 x i16> %a2)
  ret <8 x i16> %2
}
declare <8 x i16> @llvm.x86.xop.vpmacssww(<8 x i16>, <8 x i16>, <8 x i16>) nounwind readnone

define <4 x i32> @commute_fold_vpmacswd(<8 x i16>* %a0, <8 x i16> %a1, <4 x i32> %a2) {
; X32-LABEL: commute_fold_vpmacswd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacswd %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacswd:
; X64:       # %bb.0:
; X64-NEXT:    vpmacswd %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpmacswd(<8 x i16> %1, <8 x i16> %a1, <4 x i32> %a2)
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpmacswd(<8 x i16>, <8 x i16>, <4 x i32>) nounwind readnone

define <8 x i16> @commute_fold_vpmacsww(<8 x i16>* %a0, <8 x i16> %a1, <8 x i16> %a2) {
; X32-LABEL: commute_fold_vpmacsww:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmacsww %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmacsww:
; X64:       # %bb.0:
; X64-NEXT:    vpmacsww %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <8 x i16> @llvm.x86.xop.vpmacsww(<8 x i16> %1, <8 x i16> %a1, <8 x i16> %a2)
  ret <8 x i16> %2
}
declare <8 x i16> @llvm.x86.xop.vpmacsww(<8 x i16>, <8 x i16>, <8 x i16>) nounwind readnone

define <4 x i32> @commute_fold_vpmadcsswd(<8 x i16>* %a0, <8 x i16> %a1, <4 x i32> %a2) {
; X32-LABEL: commute_fold_vpmadcsswd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmadcsswd %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmadcsswd:
; X64:       # %bb.0:
; X64-NEXT:    vpmadcsswd %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpmadcsswd(<8 x i16> %1, <8 x i16> %a1, <4 x i32> %a2)
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpmadcsswd(<8 x i16>, <8 x i16>, <4 x i32>) nounwind readnone

define <4 x i32> @commute_fold_vpmadcswd(<8 x i16>* %a0, <8 x i16> %a1, <4 x i32> %a2) {
; X32-LABEL: commute_fold_vpmadcswd:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vpmadcswd %xmm1, (%eax), %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: commute_fold_vpmadcswd:
; X64:       # %bb.0:
; X64-NEXT:    vpmadcswd %xmm1, (%rdi), %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = call <4 x i32> @llvm.x86.xop.vpmadcswd(<8 x i16> %1, <8 x i16> %a1, <4 x i32> %a2)
  ret <4 x i32> %2
}
declare <4 x i32> @llvm.x86.xop.vpmadcswd(<8 x i16>, <8 x i16>, <4 x i32>) nounwind readnone
