"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateMoveToRefactoringFileSuggestions = decorateMoveToRefactoringFileSuggestions;
function decorateMoveToRefactoringFileSuggestions(ls) {
    const getMoveToRefactoringFileSuggestions = ls.getMoveToRefactoringFileSuggestions;
    ls.getMoveToRefactoringFileSuggestions = (fileName, positionOrRange, preferences, triggerReason, kind) => {
        const program = ls.getProgram();
        if (!program) {
            return getMoveToRefactoringFileSuggestions(fileName, positionOrRange, preferences, triggerReason, kind);
        }
        const getSourceFiles = program.getSourceFiles;
        try {
            // typescript currently only allows js/ts files to be moved to.
            // Once there isn't a restriction anymore, we can remove this.
            program.getSourceFiles = () => getSourceFiles().filter((file) => !file.fileName.endsWith('.svelte'));
            return getMoveToRefactoringFileSuggestions(fileName, positionOrRange, preferences, triggerReason, kind);
        }
        finally {
            program.getSourceFiles = getSourceFiles;
        }
    };
}
//# sourceMappingURL=move-to-file.js.map