# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_image_description_v1 import WpImageDescriptionV1


class WpColorManagementSurfaceFeedbackV1(Interface):
    """Color management extension to a surface

    A :class:`WpColorManagementSurfaceFeedbackV1` allows the client to get the
    preferred image description of a surface.

    If the :class:`~pywayland.protocol.wayland.WlSurface` associated with this
    object is destroyed, the :class:`WpColorManagementSurfaceFeedbackV1` object
    becomes inert.
    """

    name = "wp_color_management_surface_feedback_v1"
    version = 1

    class error(enum.IntEnum):
        inert = 0
        unsupported_feature = 1


class WpColorManagementSurfaceFeedbackV1Proxy(Proxy[WpColorManagementSurfaceFeedbackV1]):
    interface = WpColorManagementSurfaceFeedbackV1

    @WpColorManagementSurfaceFeedbackV1.request()
    def destroy(self) -> None:
        """Destroy the color management interface for a surface

        Destroy the :class:`WpColorManagementSurfaceFeedbackV1` object.
        """
        self._marshal(0)
        self._destroy()

    @WpColorManagementSurfaceFeedbackV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionV1),
    )
    def get_preferred(self) -> Proxy[WpImageDescriptionV1]:
        """Get the preferred image description

        If this protocol object is inert, the protocol error inert is raised.

        The preferred image description represents the compositor's preferred
        color encoding for this :class:`~pywayland.protocol.wayland.WlSurface`
        at the current time. There might be performance and power advantages,
        as well as improved color reproduction, if the image description of a
        content update matches the preferred image description.

        This creates a new
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object for the currently preferred image description for the
        :class:`~pywayland.protocol.wayland.WlSurface`. The client should stop
        using and destroy the image descriptions created by earlier invocations
        of this request for the associated
        :class:`~pywayland.protocol.wayland.WlSurface`. This request is usually
        sent as a reaction to the preferred_changed event or when creating a
        :class:`WpColorManagementSurfaceFeedbackV1` object if the client is
        capable of adapting to image descriptions.

        The created
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object preserves the preferred image description of the
        :class:`~pywayland.protocol.wayland.WlSurface` from the time the object
        was created.

        The resulting image description object allows get_information request.

        If the image description is parametric, the client should set it on its
        :class:`~pywayland.protocol.wayland.WlSurface` only if the image
        description is an exact match with the client content. Particularly if
        everything else matches, but the target color volume is greater than
        what the client needs, the client should create its own parameric image
        description with its exact parameters.

        If the interface version is inadequate for the preferred image
        description, meaning that the client does not support all the events
        needed to deliver the crucial information, the resulting image
        description object shall immediately deliver the
        :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event with the low_version cause, otherwise the object shall
        immediately deliver the ready event.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        """
        image_description = self._marshal_constructor(1, WpImageDescriptionV1)
        return image_description

    @WpColorManagementSurfaceFeedbackV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionV1),
    )
    def get_preferred_parametric(self) -> Proxy[WpImageDescriptionV1]:
        """Get the preferred image description

        The same description as for get_preferred applies, except the returned
        image description is guaranteed to be parametric. This is meant for
        clients that can only deal with parametric image descriptions.

        If the compositor doesn't support parametric image descriptions, the
        unsupported_feature error is emitted.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        """
        image_description = self._marshal_constructor(2, WpImageDescriptionV1)
        return image_description


class WpColorManagementSurfaceFeedbackV1Resource(Resource):
    interface = WpColorManagementSurfaceFeedbackV1

    @WpColorManagementSurfaceFeedbackV1.event(
        Argument(ArgumentType.Uint),
    )
    def preferred_changed(self, identity: int) -> None:
        """The preferred image description changed

        The preferred image description is the one which likely has the most
        performance and/or quality benefits for the compositor if used by the
        client for its :class:`~pywayland.protocol.wayland.WlSurface` contents.
        This event is sent whenever the compositor changes the wl_surface's
        preferred image description.

        This event sends the identity of the new preferred state as the
        argument, so clients who are aware of the image description already can
        reuse it. Otherwise, if the client client wants to know what the
        preferred image description is, it shall use the get_preferred request.

        The preferred image description is not automatically used for anything.
        It is only a hint, and clients may set any valid image description with
        set_image_description, but there might be performance and color
        accuracy improvements by providing the
        :class:`~pywayland.protocol.wayland.WlSurface` contents in the
        preferred image description. Therefore clients that can, should render
        according to the preferred image description

        :param identity:
            image description id number
        :type identity:
            `ArgumentType.Uint`
        """
        self._post_event(0, identity)


class WpColorManagementSurfaceFeedbackV1Global(Global):
    interface = WpColorManagementSurfaceFeedbackV1


WpColorManagementSurfaceFeedbackV1._gen_c()
WpColorManagementSurfaceFeedbackV1.proxy_class = WpColorManagementSurfaceFeedbackV1Proxy
WpColorManagementSurfaceFeedbackV1.resource_class = WpColorManagementSurfaceFeedbackV1Resource
WpColorManagementSurfaceFeedbackV1.global_class = WpColorManagementSurfaceFeedbackV1Global
