'use strict';

var middlewareHostHeader = require('@aws-sdk/middleware-host-header');
var middlewareLogger = require('@aws-sdk/middleware-logger');
var middlewareRecursionDetection = require('@aws-sdk/middleware-recursion-detection');
var middlewareUserAgent = require('@aws-sdk/middleware-user-agent');
var configResolver = require('@smithy/config-resolver');
var core = require('@smithy/core');
var schema = require('@smithy/core/schema');
var middlewareContentLength = require('@smithy/middleware-content-length');
var middlewareEndpoint = require('@smithy/middleware-endpoint');
var middlewareRetry = require('@smithy/middleware-retry');
var smithyClient = require('@smithy/smithy-client');
var httpAuthSchemeProvider = require('./auth/httpAuthSchemeProvider');
var runtimeConfig = require('./runtimeConfig');
var regionConfigResolver = require('@aws-sdk/region-config-resolver');
var protocolHttp = require('@smithy/protocol-http');
var schemas_0 = require('./schemas/schemas_0');
var utilWaiter = require('@smithy/util-waiter');
var errors = require('./models/errors');
var CloudFrontServiceException = require('./models/CloudFrontServiceException');

const resolveClientEndpointParameters = (options) => {
    return Object.assign(options, {
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        defaultSigningName: "cloudfront",
    });
};
const commonParams = {
    UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
    Endpoint: { type: "builtInParams", name: "endpoint" },
    Region: { type: "builtInParams", name: "region" },
    UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
};

const getHttpAuthExtensionConfiguration = (runtimeConfig) => {
    const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
    let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
    let _credentials = runtimeConfig.credentials;
    return {
        setHttpAuthScheme(httpAuthScheme) {
            const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
            if (index === -1) {
                _httpAuthSchemes.push(httpAuthScheme);
            }
            else {
                _httpAuthSchemes.splice(index, 1, httpAuthScheme);
            }
        },
        httpAuthSchemes() {
            return _httpAuthSchemes;
        },
        setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
            _httpAuthSchemeProvider = httpAuthSchemeProvider;
        },
        httpAuthSchemeProvider() {
            return _httpAuthSchemeProvider;
        },
        setCredentials(credentials) {
            _credentials = credentials;
        },
        credentials() {
            return _credentials;
        },
    };
};
const resolveHttpAuthRuntimeConfig = (config) => {
    return {
        httpAuthSchemes: config.httpAuthSchemes(),
        httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
        credentials: config.credentials(),
    };
};

const resolveRuntimeExtensions = (runtimeConfig, extensions) => {
    const extensionConfiguration = Object.assign(regionConfigResolver.getAwsRegionExtensionConfiguration(runtimeConfig), smithyClient.getDefaultExtensionConfiguration(runtimeConfig), protocolHttp.getHttpHandlerExtensionConfiguration(runtimeConfig), getHttpAuthExtensionConfiguration(runtimeConfig));
    extensions.forEach((extension) => extension.configure(extensionConfiguration));
    return Object.assign(runtimeConfig, regionConfigResolver.resolveAwsRegionExtensionConfiguration(extensionConfiguration), smithyClient.resolveDefaultRuntimeConfig(extensionConfiguration), protocolHttp.resolveHttpHandlerRuntimeConfig(extensionConfiguration), resolveHttpAuthRuntimeConfig(extensionConfiguration));
};

class CloudFrontClient extends smithyClient.Client {
    config;
    constructor(...[configuration]) {
        const _config_0 = runtimeConfig.getRuntimeConfig(configuration || {});
        super(_config_0);
        this.initConfig = _config_0;
        const _config_1 = resolveClientEndpointParameters(_config_0);
        const _config_2 = middlewareUserAgent.resolveUserAgentConfig(_config_1);
        const _config_3 = middlewareRetry.resolveRetryConfig(_config_2);
        const _config_4 = configResolver.resolveRegionConfig(_config_3);
        const _config_5 = middlewareHostHeader.resolveHostHeaderConfig(_config_4);
        const _config_6 = middlewareEndpoint.resolveEndpointConfig(_config_5);
        const _config_7 = httpAuthSchemeProvider.resolveHttpAuthSchemeConfig(_config_6);
        const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
        this.config = _config_8;
        this.middlewareStack.use(schema.getSchemaSerdePlugin(this.config));
        this.middlewareStack.use(middlewareUserAgent.getUserAgentPlugin(this.config));
        this.middlewareStack.use(middlewareRetry.getRetryPlugin(this.config));
        this.middlewareStack.use(middlewareContentLength.getContentLengthPlugin(this.config));
        this.middlewareStack.use(middlewareHostHeader.getHostHeaderPlugin(this.config));
        this.middlewareStack.use(middlewareLogger.getLoggerPlugin(this.config));
        this.middlewareStack.use(middlewareRecursionDetection.getRecursionDetectionPlugin(this.config));
        this.middlewareStack.use(core.getHttpAuthSchemeEndpointRuleSetPlugin(this.config, {
            httpAuthSchemeParametersProvider: httpAuthSchemeProvider.defaultCloudFrontHttpAuthSchemeParametersProvider,
            identityProviderConfigProvider: async (config) => new core.DefaultIdentityProviderConfig({
                "aws.auth#sigv4": config.credentials,
            }),
        }));
        this.middlewareStack.use(core.getHttpSigningPlugin(this.config));
    }
    destroy() {
        super.destroy();
    }
}

class AssociateAliasCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "AssociateAlias", {})
    .n("CloudFrontClient", "AssociateAliasCommand")
    .sc(schemas_0.AssociateAlias$)
    .build() {
}

class AssociateDistributionTenantWebACLCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "AssociateDistributionTenantWebACL", {})
    .n("CloudFrontClient", "AssociateDistributionTenantWebACLCommand")
    .sc(schemas_0.AssociateDistributionTenantWebACL$)
    .build() {
}

class AssociateDistributionWebACLCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "AssociateDistributionWebACL", {})
    .n("CloudFrontClient", "AssociateDistributionWebACLCommand")
    .sc(schemas_0.AssociateDistributionWebACL$)
    .build() {
}

class CopyDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CopyDistribution", {})
    .n("CloudFrontClient", "CopyDistributionCommand")
    .sc(schemas_0.CopyDistribution$)
    .build() {
}

class CreateAnycastIpListCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateAnycastIpList", {})
    .n("CloudFrontClient", "CreateAnycastIpListCommand")
    .sc(schemas_0.CreateAnycastIpList$)
    .build() {
}

class CreateCachePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateCachePolicy", {})
    .n("CloudFrontClient", "CreateCachePolicyCommand")
    .sc(schemas_0.CreateCachePolicy$)
    .build() {
}

class CreateCloudFrontOriginAccessIdentityCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateCloudFrontOriginAccessIdentity", {})
    .n("CloudFrontClient", "CreateCloudFrontOriginAccessIdentityCommand")
    .sc(schemas_0.CreateCloudFrontOriginAccessIdentity$)
    .build() {
}

class CreateConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateConnectionFunction", {})
    .n("CloudFrontClient", "CreateConnectionFunctionCommand")
    .sc(schemas_0.CreateConnectionFunction$)
    .build() {
}

class CreateConnectionGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateConnectionGroup", {})
    .n("CloudFrontClient", "CreateConnectionGroupCommand")
    .sc(schemas_0.CreateConnectionGroup$)
    .build() {
}

class CreateContinuousDeploymentPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateContinuousDeploymentPolicy", {})
    .n("CloudFrontClient", "CreateContinuousDeploymentPolicyCommand")
    .sc(schemas_0.CreateContinuousDeploymentPolicy$)
    .build() {
}

class CreateDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateDistribution", {})
    .n("CloudFrontClient", "CreateDistributionCommand")
    .sc(schemas_0.CreateDistribution$)
    .build() {
}

class CreateDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateDistributionTenant", {})
    .n("CloudFrontClient", "CreateDistributionTenantCommand")
    .sc(schemas_0.CreateDistributionTenant$)
    .build() {
}

class CreateDistributionWithTagsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateDistributionWithTags", {})
    .n("CloudFrontClient", "CreateDistributionWithTagsCommand")
    .sc(schemas_0.CreateDistributionWithTags$)
    .build() {
}

class CreateFieldLevelEncryptionConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateFieldLevelEncryptionConfig", {})
    .n("CloudFrontClient", "CreateFieldLevelEncryptionConfigCommand")
    .sc(schemas_0.CreateFieldLevelEncryptionConfig$)
    .build() {
}

class CreateFieldLevelEncryptionProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateFieldLevelEncryptionProfile", {})
    .n("CloudFrontClient", "CreateFieldLevelEncryptionProfileCommand")
    .sc(schemas_0.CreateFieldLevelEncryptionProfile$)
    .build() {
}

class CreateFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateFunction", {})
    .n("CloudFrontClient", "CreateFunctionCommand")
    .sc(schemas_0.CreateFunction$)
    .build() {
}

class CreateInvalidationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateInvalidation", {})
    .n("CloudFrontClient", "CreateInvalidationCommand")
    .sc(schemas_0.CreateInvalidation$)
    .build() {
}

class CreateInvalidationForDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateInvalidationForDistributionTenant", {})
    .n("CloudFrontClient", "CreateInvalidationForDistributionTenantCommand")
    .sc(schemas_0.CreateInvalidationForDistributionTenant$)
    .build() {
}

class CreateKeyGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateKeyGroup", {})
    .n("CloudFrontClient", "CreateKeyGroupCommand")
    .sc(schemas_0.CreateKeyGroup$)
    .build() {
}

class CreateKeyValueStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateKeyValueStore", {})
    .n("CloudFrontClient", "CreateKeyValueStoreCommand")
    .sc(schemas_0.CreateKeyValueStore$)
    .build() {
}

class CreateMonitoringSubscriptionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateMonitoringSubscription", {})
    .n("CloudFrontClient", "CreateMonitoringSubscriptionCommand")
    .sc(schemas_0.CreateMonitoringSubscription$)
    .build() {
}

class CreateOriginAccessControlCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateOriginAccessControl", {})
    .n("CloudFrontClient", "CreateOriginAccessControlCommand")
    .sc(schemas_0.CreateOriginAccessControl$)
    .build() {
}

class CreateOriginRequestPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateOriginRequestPolicy", {})
    .n("CloudFrontClient", "CreateOriginRequestPolicyCommand")
    .sc(schemas_0.CreateOriginRequestPolicy$)
    .build() {
}

class CreatePublicKeyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreatePublicKey", {})
    .n("CloudFrontClient", "CreatePublicKeyCommand")
    .sc(schemas_0.CreatePublicKey$)
    .build() {
}

class CreateRealtimeLogConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateRealtimeLogConfig", {})
    .n("CloudFrontClient", "CreateRealtimeLogConfigCommand")
    .sc(schemas_0.CreateRealtimeLogConfig$)
    .build() {
}

class CreateResponseHeadersPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateResponseHeadersPolicy", {})
    .n("CloudFrontClient", "CreateResponseHeadersPolicyCommand")
    .sc(schemas_0.CreateResponseHeadersPolicy$)
    .build() {
}

class CreateStreamingDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateStreamingDistribution", {})
    .n("CloudFrontClient", "CreateStreamingDistributionCommand")
    .sc(schemas_0.CreateStreamingDistribution$)
    .build() {
}

class CreateStreamingDistributionWithTagsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateStreamingDistributionWithTags", {})
    .n("CloudFrontClient", "CreateStreamingDistributionWithTagsCommand")
    .sc(schemas_0.CreateStreamingDistributionWithTags$)
    .build() {
}

class CreateTrustStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateTrustStore", {})
    .n("CloudFrontClient", "CreateTrustStoreCommand")
    .sc(schemas_0.CreateTrustStore$)
    .build() {
}

class CreateVpcOriginCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "CreateVpcOrigin", {})
    .n("CloudFrontClient", "CreateVpcOriginCommand")
    .sc(schemas_0.CreateVpcOrigin$)
    .build() {
}

class DeleteAnycastIpListCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteAnycastIpList", {})
    .n("CloudFrontClient", "DeleteAnycastIpListCommand")
    .sc(schemas_0.DeleteAnycastIpList$)
    .build() {
}

class DeleteCachePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteCachePolicy", {})
    .n("CloudFrontClient", "DeleteCachePolicyCommand")
    .sc(schemas_0.DeleteCachePolicy$)
    .build() {
}

class DeleteCloudFrontOriginAccessIdentityCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteCloudFrontOriginAccessIdentity", {})
    .n("CloudFrontClient", "DeleteCloudFrontOriginAccessIdentityCommand")
    .sc(schemas_0.DeleteCloudFrontOriginAccessIdentity$)
    .build() {
}

class DeleteConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteConnectionFunction", {})
    .n("CloudFrontClient", "DeleteConnectionFunctionCommand")
    .sc(schemas_0.DeleteConnectionFunction$)
    .build() {
}

class DeleteConnectionGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteConnectionGroup", {})
    .n("CloudFrontClient", "DeleteConnectionGroupCommand")
    .sc(schemas_0.DeleteConnectionGroup$)
    .build() {
}

class DeleteContinuousDeploymentPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteContinuousDeploymentPolicy", {})
    .n("CloudFrontClient", "DeleteContinuousDeploymentPolicyCommand")
    .sc(schemas_0.DeleteContinuousDeploymentPolicy$)
    .build() {
}

class DeleteDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteDistribution", {})
    .n("CloudFrontClient", "DeleteDistributionCommand")
    .sc(schemas_0.DeleteDistribution$)
    .build() {
}

class DeleteDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteDistributionTenant", {})
    .n("CloudFrontClient", "DeleteDistributionTenantCommand")
    .sc(schemas_0.DeleteDistributionTenant$)
    .build() {
}

class DeleteFieldLevelEncryptionConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteFieldLevelEncryptionConfig", {})
    .n("CloudFrontClient", "DeleteFieldLevelEncryptionConfigCommand")
    .sc(schemas_0.DeleteFieldLevelEncryptionConfig$)
    .build() {
}

class DeleteFieldLevelEncryptionProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteFieldLevelEncryptionProfile", {})
    .n("CloudFrontClient", "DeleteFieldLevelEncryptionProfileCommand")
    .sc(schemas_0.DeleteFieldLevelEncryptionProfile$)
    .build() {
}

class DeleteFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteFunction", {})
    .n("CloudFrontClient", "DeleteFunctionCommand")
    .sc(schemas_0.DeleteFunction$)
    .build() {
}

class DeleteKeyGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteKeyGroup", {})
    .n("CloudFrontClient", "DeleteKeyGroupCommand")
    .sc(schemas_0.DeleteKeyGroup$)
    .build() {
}

class DeleteKeyValueStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteKeyValueStore", {})
    .n("CloudFrontClient", "DeleteKeyValueStoreCommand")
    .sc(schemas_0.DeleteKeyValueStore$)
    .build() {
}

class DeleteMonitoringSubscriptionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteMonitoringSubscription", {})
    .n("CloudFrontClient", "DeleteMonitoringSubscriptionCommand")
    .sc(schemas_0.DeleteMonitoringSubscription$)
    .build() {
}

class DeleteOriginAccessControlCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteOriginAccessControl", {})
    .n("CloudFrontClient", "DeleteOriginAccessControlCommand")
    .sc(schemas_0.DeleteOriginAccessControl$)
    .build() {
}

class DeleteOriginRequestPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteOriginRequestPolicy", {})
    .n("CloudFrontClient", "DeleteOriginRequestPolicyCommand")
    .sc(schemas_0.DeleteOriginRequestPolicy$)
    .build() {
}

class DeletePublicKeyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeletePublicKey", {})
    .n("CloudFrontClient", "DeletePublicKeyCommand")
    .sc(schemas_0.DeletePublicKey$)
    .build() {
}

class DeleteRealtimeLogConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteRealtimeLogConfig", {})
    .n("CloudFrontClient", "DeleteRealtimeLogConfigCommand")
    .sc(schemas_0.DeleteRealtimeLogConfig$)
    .build() {
}

class DeleteResourcePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteResourcePolicy", {})
    .n("CloudFrontClient", "DeleteResourcePolicyCommand")
    .sc(schemas_0.DeleteResourcePolicy$)
    .build() {
}

class DeleteResponseHeadersPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteResponseHeadersPolicy", {})
    .n("CloudFrontClient", "DeleteResponseHeadersPolicyCommand")
    .sc(schemas_0.DeleteResponseHeadersPolicy$)
    .build() {
}

class DeleteStreamingDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteStreamingDistribution", {})
    .n("CloudFrontClient", "DeleteStreamingDistributionCommand")
    .sc(schemas_0.DeleteStreamingDistribution$)
    .build() {
}

class DeleteTrustStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteTrustStore", {})
    .n("CloudFrontClient", "DeleteTrustStoreCommand")
    .sc(schemas_0.DeleteTrustStore$)
    .build() {
}

class DeleteVpcOriginCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DeleteVpcOrigin", {})
    .n("CloudFrontClient", "DeleteVpcOriginCommand")
    .sc(schemas_0.DeleteVpcOrigin$)
    .build() {
}

class DescribeConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DescribeConnectionFunction", {})
    .n("CloudFrontClient", "DescribeConnectionFunctionCommand")
    .sc(schemas_0.DescribeConnectionFunction$)
    .build() {
}

class DescribeFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DescribeFunction", {})
    .n("CloudFrontClient", "DescribeFunctionCommand")
    .sc(schemas_0.DescribeFunction$)
    .build() {
}

class DescribeKeyValueStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DescribeKeyValueStore", {})
    .n("CloudFrontClient", "DescribeKeyValueStoreCommand")
    .sc(schemas_0.DescribeKeyValueStore$)
    .build() {
}

class DisassociateDistributionTenantWebACLCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DisassociateDistributionTenantWebACL", {})
    .n("CloudFrontClient", "DisassociateDistributionTenantWebACLCommand")
    .sc(schemas_0.DisassociateDistributionTenantWebACL$)
    .build() {
}

class DisassociateDistributionWebACLCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "DisassociateDistributionWebACL", {})
    .n("CloudFrontClient", "DisassociateDistributionWebACLCommand")
    .sc(schemas_0.DisassociateDistributionWebACL$)
    .build() {
}

class GetAnycastIpListCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetAnycastIpList", {})
    .n("CloudFrontClient", "GetAnycastIpListCommand")
    .sc(schemas_0.GetAnycastIpList$)
    .build() {
}

class GetCachePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetCachePolicy", {})
    .n("CloudFrontClient", "GetCachePolicyCommand")
    .sc(schemas_0.GetCachePolicy$)
    .build() {
}

class GetCachePolicyConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetCachePolicyConfig", {})
    .n("CloudFrontClient", "GetCachePolicyConfigCommand")
    .sc(schemas_0.GetCachePolicyConfig$)
    .build() {
}

class GetCloudFrontOriginAccessIdentityCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetCloudFrontOriginAccessIdentity", {})
    .n("CloudFrontClient", "GetCloudFrontOriginAccessIdentityCommand")
    .sc(schemas_0.GetCloudFrontOriginAccessIdentity$)
    .build() {
}

class GetCloudFrontOriginAccessIdentityConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetCloudFrontOriginAccessIdentityConfig", {})
    .n("CloudFrontClient", "GetCloudFrontOriginAccessIdentityConfigCommand")
    .sc(schemas_0.GetCloudFrontOriginAccessIdentityConfig$)
    .build() {
}

class GetConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetConnectionFunction", {})
    .n("CloudFrontClient", "GetConnectionFunctionCommand")
    .sc(schemas_0.GetConnectionFunction$)
    .build() {
}

class GetConnectionGroupByRoutingEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetConnectionGroupByRoutingEndpoint", {})
    .n("CloudFrontClient", "GetConnectionGroupByRoutingEndpointCommand")
    .sc(schemas_0.GetConnectionGroupByRoutingEndpoint$)
    .build() {
}

class GetConnectionGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetConnectionGroup", {})
    .n("CloudFrontClient", "GetConnectionGroupCommand")
    .sc(schemas_0.GetConnectionGroup$)
    .build() {
}

class GetContinuousDeploymentPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetContinuousDeploymentPolicy", {})
    .n("CloudFrontClient", "GetContinuousDeploymentPolicyCommand")
    .sc(schemas_0.GetContinuousDeploymentPolicy$)
    .build() {
}

class GetContinuousDeploymentPolicyConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetContinuousDeploymentPolicyConfig", {})
    .n("CloudFrontClient", "GetContinuousDeploymentPolicyConfigCommand")
    .sc(schemas_0.GetContinuousDeploymentPolicyConfig$)
    .build() {
}

class GetDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetDistribution", {})
    .n("CloudFrontClient", "GetDistributionCommand")
    .sc(schemas_0.GetDistribution$)
    .build() {
}

class GetDistributionConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetDistributionConfig", {})
    .n("CloudFrontClient", "GetDistributionConfigCommand")
    .sc(schemas_0.GetDistributionConfig$)
    .build() {
}

class GetDistributionTenantByDomainCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetDistributionTenantByDomain", {})
    .n("CloudFrontClient", "GetDistributionTenantByDomainCommand")
    .sc(schemas_0.GetDistributionTenantByDomain$)
    .build() {
}

class GetDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetDistributionTenant", {})
    .n("CloudFrontClient", "GetDistributionTenantCommand")
    .sc(schemas_0.GetDistributionTenant$)
    .build() {
}

class GetFieldLevelEncryptionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetFieldLevelEncryption", {})
    .n("CloudFrontClient", "GetFieldLevelEncryptionCommand")
    .sc(schemas_0.GetFieldLevelEncryption$)
    .build() {
}

class GetFieldLevelEncryptionConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetFieldLevelEncryptionConfig", {})
    .n("CloudFrontClient", "GetFieldLevelEncryptionConfigCommand")
    .sc(schemas_0.GetFieldLevelEncryptionConfig$)
    .build() {
}

class GetFieldLevelEncryptionProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetFieldLevelEncryptionProfile", {})
    .n("CloudFrontClient", "GetFieldLevelEncryptionProfileCommand")
    .sc(schemas_0.GetFieldLevelEncryptionProfile$)
    .build() {
}

class GetFieldLevelEncryptionProfileConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetFieldLevelEncryptionProfileConfig", {})
    .n("CloudFrontClient", "GetFieldLevelEncryptionProfileConfigCommand")
    .sc(schemas_0.GetFieldLevelEncryptionProfileConfig$)
    .build() {
}

class GetFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetFunction", {})
    .n("CloudFrontClient", "GetFunctionCommand")
    .sc(schemas_0.GetFunction$)
    .build() {
}

class GetInvalidationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetInvalidation", {})
    .n("CloudFrontClient", "GetInvalidationCommand")
    .sc(schemas_0.GetInvalidation$)
    .build() {
}

class GetInvalidationForDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetInvalidationForDistributionTenant", {})
    .n("CloudFrontClient", "GetInvalidationForDistributionTenantCommand")
    .sc(schemas_0.GetInvalidationForDistributionTenant$)
    .build() {
}

class GetKeyGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetKeyGroup", {})
    .n("CloudFrontClient", "GetKeyGroupCommand")
    .sc(schemas_0.GetKeyGroup$)
    .build() {
}

class GetKeyGroupConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetKeyGroupConfig", {})
    .n("CloudFrontClient", "GetKeyGroupConfigCommand")
    .sc(schemas_0.GetKeyGroupConfig$)
    .build() {
}

class GetManagedCertificateDetailsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetManagedCertificateDetails", {})
    .n("CloudFrontClient", "GetManagedCertificateDetailsCommand")
    .sc(schemas_0.GetManagedCertificateDetails$)
    .build() {
}

class GetMonitoringSubscriptionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetMonitoringSubscription", {})
    .n("CloudFrontClient", "GetMonitoringSubscriptionCommand")
    .sc(schemas_0.GetMonitoringSubscription$)
    .build() {
}

class GetOriginAccessControlCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetOriginAccessControl", {})
    .n("CloudFrontClient", "GetOriginAccessControlCommand")
    .sc(schemas_0.GetOriginAccessControl$)
    .build() {
}

class GetOriginAccessControlConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetOriginAccessControlConfig", {})
    .n("CloudFrontClient", "GetOriginAccessControlConfigCommand")
    .sc(schemas_0.GetOriginAccessControlConfig$)
    .build() {
}

class GetOriginRequestPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetOriginRequestPolicy", {})
    .n("CloudFrontClient", "GetOriginRequestPolicyCommand")
    .sc(schemas_0.GetOriginRequestPolicy$)
    .build() {
}

class GetOriginRequestPolicyConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetOriginRequestPolicyConfig", {})
    .n("CloudFrontClient", "GetOriginRequestPolicyConfigCommand")
    .sc(schemas_0.GetOriginRequestPolicyConfig$)
    .build() {
}

class GetPublicKeyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetPublicKey", {})
    .n("CloudFrontClient", "GetPublicKeyCommand")
    .sc(schemas_0.GetPublicKey$)
    .build() {
}

class GetPublicKeyConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetPublicKeyConfig", {})
    .n("CloudFrontClient", "GetPublicKeyConfigCommand")
    .sc(schemas_0.GetPublicKeyConfig$)
    .build() {
}

class GetRealtimeLogConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetRealtimeLogConfig", {})
    .n("CloudFrontClient", "GetRealtimeLogConfigCommand")
    .sc(schemas_0.GetRealtimeLogConfig$)
    .build() {
}

class GetResourcePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetResourcePolicy", {})
    .n("CloudFrontClient", "GetResourcePolicyCommand")
    .sc(schemas_0.GetResourcePolicy$)
    .build() {
}

class GetResponseHeadersPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetResponseHeadersPolicy", {})
    .n("CloudFrontClient", "GetResponseHeadersPolicyCommand")
    .sc(schemas_0.GetResponseHeadersPolicy$)
    .build() {
}

class GetResponseHeadersPolicyConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetResponseHeadersPolicyConfig", {})
    .n("CloudFrontClient", "GetResponseHeadersPolicyConfigCommand")
    .sc(schemas_0.GetResponseHeadersPolicyConfig$)
    .build() {
}

class GetStreamingDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetStreamingDistribution", {})
    .n("CloudFrontClient", "GetStreamingDistributionCommand")
    .sc(schemas_0.GetStreamingDistribution$)
    .build() {
}

class GetStreamingDistributionConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetStreamingDistributionConfig", {})
    .n("CloudFrontClient", "GetStreamingDistributionConfigCommand")
    .sc(schemas_0.GetStreamingDistributionConfig$)
    .build() {
}

class GetTrustStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetTrustStore", {})
    .n("CloudFrontClient", "GetTrustStoreCommand")
    .sc(schemas_0.GetTrustStore$)
    .build() {
}

class GetVpcOriginCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "GetVpcOrigin", {})
    .n("CloudFrontClient", "GetVpcOriginCommand")
    .sc(schemas_0.GetVpcOrigin$)
    .build() {
}

class ListAnycastIpListsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListAnycastIpLists", {})
    .n("CloudFrontClient", "ListAnycastIpListsCommand")
    .sc(schemas_0.ListAnycastIpLists$)
    .build() {
}

class ListCachePoliciesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListCachePolicies", {})
    .n("CloudFrontClient", "ListCachePoliciesCommand")
    .sc(schemas_0.ListCachePolicies$)
    .build() {
}

class ListCloudFrontOriginAccessIdentitiesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListCloudFrontOriginAccessIdentities", {})
    .n("CloudFrontClient", "ListCloudFrontOriginAccessIdentitiesCommand")
    .sc(schemas_0.ListCloudFrontOriginAccessIdentities$)
    .build() {
}

class ListConflictingAliasesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListConflictingAliases", {})
    .n("CloudFrontClient", "ListConflictingAliasesCommand")
    .sc(schemas_0.ListConflictingAliases$)
    .build() {
}

class ListConnectionFunctionsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListConnectionFunctions", {})
    .n("CloudFrontClient", "ListConnectionFunctionsCommand")
    .sc(schemas_0.ListConnectionFunctions$)
    .build() {
}

class ListConnectionGroupsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListConnectionGroups", {})
    .n("CloudFrontClient", "ListConnectionGroupsCommand")
    .sc(schemas_0.ListConnectionGroups$)
    .build() {
}

class ListContinuousDeploymentPoliciesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListContinuousDeploymentPolicies", {})
    .n("CloudFrontClient", "ListContinuousDeploymentPoliciesCommand")
    .sc(schemas_0.ListContinuousDeploymentPolicies$)
    .build() {
}

class ListDistributionsByAnycastIpListIdCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByAnycastIpListId", {})
    .n("CloudFrontClient", "ListDistributionsByAnycastIpListIdCommand")
    .sc(schemas_0.ListDistributionsByAnycastIpListId$)
    .build() {
}

class ListDistributionsByCachePolicyIdCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByCachePolicyId", {})
    .n("CloudFrontClient", "ListDistributionsByCachePolicyIdCommand")
    .sc(schemas_0.ListDistributionsByCachePolicyId$)
    .build() {
}

class ListDistributionsByConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByConnectionFunction", {})
    .n("CloudFrontClient", "ListDistributionsByConnectionFunctionCommand")
    .sc(schemas_0.ListDistributionsByConnectionFunction$)
    .build() {
}

class ListDistributionsByConnectionModeCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByConnectionMode", {})
    .n("CloudFrontClient", "ListDistributionsByConnectionModeCommand")
    .sc(schemas_0.ListDistributionsByConnectionMode$)
    .build() {
}

class ListDistributionsByKeyGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByKeyGroup", {})
    .n("CloudFrontClient", "ListDistributionsByKeyGroupCommand")
    .sc(schemas_0.ListDistributionsByKeyGroup$)
    .build() {
}

class ListDistributionsByOriginRequestPolicyIdCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByOriginRequestPolicyId", {})
    .n("CloudFrontClient", "ListDistributionsByOriginRequestPolicyIdCommand")
    .sc(schemas_0.ListDistributionsByOriginRequestPolicyId$)
    .build() {
}

class ListDistributionsByOwnedResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByOwnedResource", {})
    .n("CloudFrontClient", "ListDistributionsByOwnedResourceCommand")
    .sc(schemas_0.ListDistributionsByOwnedResource$)
    .build() {
}

class ListDistributionsByRealtimeLogConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByRealtimeLogConfig", {})
    .n("CloudFrontClient", "ListDistributionsByRealtimeLogConfigCommand")
    .sc(schemas_0.ListDistributionsByRealtimeLogConfig$)
    .build() {
}

class ListDistributionsByResponseHeadersPolicyIdCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByResponseHeadersPolicyId", {})
    .n("CloudFrontClient", "ListDistributionsByResponseHeadersPolicyIdCommand")
    .sc(schemas_0.ListDistributionsByResponseHeadersPolicyId$)
    .build() {
}

class ListDistributionsByTrustStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByTrustStore", {})
    .n("CloudFrontClient", "ListDistributionsByTrustStoreCommand")
    .sc(schemas_0.ListDistributionsByTrustStore$)
    .build() {
}

class ListDistributionsByVpcOriginIdCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByVpcOriginId", {})
    .n("CloudFrontClient", "ListDistributionsByVpcOriginIdCommand")
    .sc(schemas_0.ListDistributionsByVpcOriginId$)
    .build() {
}

class ListDistributionsByWebACLIdCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByWebACLId", {})
    .n("CloudFrontClient", "ListDistributionsByWebACLIdCommand")
    .sc(schemas_0.ListDistributionsByWebACLId$)
    .build() {
}

class ListDistributionsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributions", {})
    .n("CloudFrontClient", "ListDistributionsCommand")
    .sc(schemas_0.ListDistributions$)
    .build() {
}

class ListDistributionTenantsByCustomizationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionTenantsByCustomization", {})
    .n("CloudFrontClient", "ListDistributionTenantsByCustomizationCommand")
    .sc(schemas_0.ListDistributionTenantsByCustomization$)
    .build() {
}

class ListDistributionTenantsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDistributionTenants", {})
    .n("CloudFrontClient", "ListDistributionTenantsCommand")
    .sc(schemas_0.ListDistributionTenants$)
    .build() {
}

class ListDomainConflictsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListDomainConflicts", {})
    .n("CloudFrontClient", "ListDomainConflictsCommand")
    .sc(schemas_0.ListDomainConflicts$)
    .build() {
}

class ListFieldLevelEncryptionConfigsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListFieldLevelEncryptionConfigs", {})
    .n("CloudFrontClient", "ListFieldLevelEncryptionConfigsCommand")
    .sc(schemas_0.ListFieldLevelEncryptionConfigs$)
    .build() {
}

class ListFieldLevelEncryptionProfilesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListFieldLevelEncryptionProfiles", {})
    .n("CloudFrontClient", "ListFieldLevelEncryptionProfilesCommand")
    .sc(schemas_0.ListFieldLevelEncryptionProfiles$)
    .build() {
}

class ListFunctionsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListFunctions", {})
    .n("CloudFrontClient", "ListFunctionsCommand")
    .sc(schemas_0.ListFunctions$)
    .build() {
}

class ListInvalidationsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListInvalidations", {})
    .n("CloudFrontClient", "ListInvalidationsCommand")
    .sc(schemas_0.ListInvalidations$)
    .build() {
}

class ListInvalidationsForDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListInvalidationsForDistributionTenant", {})
    .n("CloudFrontClient", "ListInvalidationsForDistributionTenantCommand")
    .sc(schemas_0.ListInvalidationsForDistributionTenant$)
    .build() {
}

class ListKeyGroupsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListKeyGroups", {})
    .n("CloudFrontClient", "ListKeyGroupsCommand")
    .sc(schemas_0.ListKeyGroups$)
    .build() {
}

class ListKeyValueStoresCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListKeyValueStores", {})
    .n("CloudFrontClient", "ListKeyValueStoresCommand")
    .sc(schemas_0.ListKeyValueStores$)
    .build() {
}

class ListOriginAccessControlsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListOriginAccessControls", {})
    .n("CloudFrontClient", "ListOriginAccessControlsCommand")
    .sc(schemas_0.ListOriginAccessControls$)
    .build() {
}

class ListOriginRequestPoliciesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListOriginRequestPolicies", {})
    .n("CloudFrontClient", "ListOriginRequestPoliciesCommand")
    .sc(schemas_0.ListOriginRequestPolicies$)
    .build() {
}

class ListPublicKeysCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListPublicKeys", {})
    .n("CloudFrontClient", "ListPublicKeysCommand")
    .sc(schemas_0.ListPublicKeys$)
    .build() {
}

class ListRealtimeLogConfigsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListRealtimeLogConfigs", {})
    .n("CloudFrontClient", "ListRealtimeLogConfigsCommand")
    .sc(schemas_0.ListRealtimeLogConfigs$)
    .build() {
}

class ListResponseHeadersPoliciesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListResponseHeadersPolicies", {})
    .n("CloudFrontClient", "ListResponseHeadersPoliciesCommand")
    .sc(schemas_0.ListResponseHeadersPolicies$)
    .build() {
}

class ListStreamingDistributionsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListStreamingDistributions", {})
    .n("CloudFrontClient", "ListStreamingDistributionsCommand")
    .sc(schemas_0.ListStreamingDistributions$)
    .build() {
}

class ListTagsForResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListTagsForResource", {})
    .n("CloudFrontClient", "ListTagsForResourceCommand")
    .sc(schemas_0.ListTagsForResource$)
    .build() {
}

class ListTrustStoresCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListTrustStores", {})
    .n("CloudFrontClient", "ListTrustStoresCommand")
    .sc(schemas_0.ListTrustStores$)
    .build() {
}

class ListVpcOriginsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "ListVpcOrigins", {})
    .n("CloudFrontClient", "ListVpcOriginsCommand")
    .sc(schemas_0.ListVpcOrigins$)
    .build() {
}

class PublishConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "PublishConnectionFunction", {})
    .n("CloudFrontClient", "PublishConnectionFunctionCommand")
    .sc(schemas_0.PublishConnectionFunction$)
    .build() {
}

class PublishFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "PublishFunction", {})
    .n("CloudFrontClient", "PublishFunctionCommand")
    .sc(schemas_0.PublishFunction$)
    .build() {
}

class PutResourcePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "PutResourcePolicy", {})
    .n("CloudFrontClient", "PutResourcePolicyCommand")
    .sc(schemas_0.PutResourcePolicy$)
    .build() {
}

class TagResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "TagResource", {})
    .n("CloudFrontClient", "TagResourceCommand")
    .sc(schemas_0.TagResource$)
    .build() {
}

class TestConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "TestConnectionFunction", {})
    .n("CloudFrontClient", "TestConnectionFunctionCommand")
    .sc(schemas_0.TestConnectionFunction$)
    .build() {
}

class TestFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "TestFunction", {})
    .n("CloudFrontClient", "TestFunctionCommand")
    .sc(schemas_0.TestFunction$)
    .build() {
}

class UntagResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UntagResource", {})
    .n("CloudFrontClient", "UntagResourceCommand")
    .sc(schemas_0.UntagResource$)
    .build() {
}

class UpdateAnycastIpListCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateAnycastIpList", {})
    .n("CloudFrontClient", "UpdateAnycastIpListCommand")
    .sc(schemas_0.UpdateAnycastIpList$)
    .build() {
}

class UpdateCachePolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateCachePolicy", {})
    .n("CloudFrontClient", "UpdateCachePolicyCommand")
    .sc(schemas_0.UpdateCachePolicy$)
    .build() {
}

class UpdateCloudFrontOriginAccessIdentityCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateCloudFrontOriginAccessIdentity", {})
    .n("CloudFrontClient", "UpdateCloudFrontOriginAccessIdentityCommand")
    .sc(schemas_0.UpdateCloudFrontOriginAccessIdentity$)
    .build() {
}

class UpdateConnectionFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateConnectionFunction", {})
    .n("CloudFrontClient", "UpdateConnectionFunctionCommand")
    .sc(schemas_0.UpdateConnectionFunction$)
    .build() {
}

class UpdateConnectionGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateConnectionGroup", {})
    .n("CloudFrontClient", "UpdateConnectionGroupCommand")
    .sc(schemas_0.UpdateConnectionGroup$)
    .build() {
}

class UpdateContinuousDeploymentPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateContinuousDeploymentPolicy", {})
    .n("CloudFrontClient", "UpdateContinuousDeploymentPolicyCommand")
    .sc(schemas_0.UpdateContinuousDeploymentPolicy$)
    .build() {
}

class UpdateDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateDistribution", {})
    .n("CloudFrontClient", "UpdateDistributionCommand")
    .sc(schemas_0.UpdateDistribution$)
    .build() {
}

class UpdateDistributionTenantCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateDistributionTenant", {})
    .n("CloudFrontClient", "UpdateDistributionTenantCommand")
    .sc(schemas_0.UpdateDistributionTenant$)
    .build() {
}

class UpdateDistributionWithStagingConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateDistributionWithStagingConfig", {})
    .n("CloudFrontClient", "UpdateDistributionWithStagingConfigCommand")
    .sc(schemas_0.UpdateDistributionWithStagingConfig$)
    .build() {
}

class UpdateDomainAssociationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateDomainAssociation", {})
    .n("CloudFrontClient", "UpdateDomainAssociationCommand")
    .sc(schemas_0.UpdateDomainAssociation$)
    .build() {
}

class UpdateFieldLevelEncryptionConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateFieldLevelEncryptionConfig", {})
    .n("CloudFrontClient", "UpdateFieldLevelEncryptionConfigCommand")
    .sc(schemas_0.UpdateFieldLevelEncryptionConfig$)
    .build() {
}

class UpdateFieldLevelEncryptionProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateFieldLevelEncryptionProfile", {})
    .n("CloudFrontClient", "UpdateFieldLevelEncryptionProfileCommand")
    .sc(schemas_0.UpdateFieldLevelEncryptionProfile$)
    .build() {
}

class UpdateFunctionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateFunction", {})
    .n("CloudFrontClient", "UpdateFunctionCommand")
    .sc(schemas_0.UpdateFunction$)
    .build() {
}

class UpdateKeyGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateKeyGroup", {})
    .n("CloudFrontClient", "UpdateKeyGroupCommand")
    .sc(schemas_0.UpdateKeyGroup$)
    .build() {
}

class UpdateKeyValueStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateKeyValueStore", {})
    .n("CloudFrontClient", "UpdateKeyValueStoreCommand")
    .sc(schemas_0.UpdateKeyValueStore$)
    .build() {
}

class UpdateOriginAccessControlCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateOriginAccessControl", {})
    .n("CloudFrontClient", "UpdateOriginAccessControlCommand")
    .sc(schemas_0.UpdateOriginAccessControl$)
    .build() {
}

class UpdateOriginRequestPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateOriginRequestPolicy", {})
    .n("CloudFrontClient", "UpdateOriginRequestPolicyCommand")
    .sc(schemas_0.UpdateOriginRequestPolicy$)
    .build() {
}

class UpdatePublicKeyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdatePublicKey", {})
    .n("CloudFrontClient", "UpdatePublicKeyCommand")
    .sc(schemas_0.UpdatePublicKey$)
    .build() {
}

class UpdateRealtimeLogConfigCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateRealtimeLogConfig", {})
    .n("CloudFrontClient", "UpdateRealtimeLogConfigCommand")
    .sc(schemas_0.UpdateRealtimeLogConfig$)
    .build() {
}

class UpdateResponseHeadersPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateResponseHeadersPolicy", {})
    .n("CloudFrontClient", "UpdateResponseHeadersPolicyCommand")
    .sc(schemas_0.UpdateResponseHeadersPolicy$)
    .build() {
}

class UpdateStreamingDistributionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateStreamingDistribution", {})
    .n("CloudFrontClient", "UpdateStreamingDistributionCommand")
    .sc(schemas_0.UpdateStreamingDistribution$)
    .build() {
}

class UpdateTrustStoreCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateTrustStore", {})
    .n("CloudFrontClient", "UpdateTrustStoreCommand")
    .sc(schemas_0.UpdateTrustStore$)
    .build() {
}

class UpdateVpcOriginCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "UpdateVpcOrigin", {})
    .n("CloudFrontClient", "UpdateVpcOriginCommand")
    .sc(schemas_0.UpdateVpcOrigin$)
    .build() {
}

class VerifyDnsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Cloudfront2020_05_31", "VerifyDnsConfiguration", {})
    .n("CloudFrontClient", "VerifyDnsConfigurationCommand")
    .sc(schemas_0.VerifyDnsConfiguration$)
    .build() {
}

const paginateListCloudFrontOriginAccessIdentities = core.createPaginator(CloudFrontClient, ListCloudFrontOriginAccessIdentitiesCommand, "Marker", "CloudFrontOriginAccessIdentityList.NextMarker", "MaxItems");

const paginateListConnectionFunctions = core.createPaginator(CloudFrontClient, ListConnectionFunctionsCommand, "Marker", "NextMarker", "MaxItems");

const paginateListConnectionGroups = core.createPaginator(CloudFrontClient, ListConnectionGroupsCommand, "Marker", "NextMarker", "MaxItems");

const paginateListDistributionsByConnectionFunction = core.createPaginator(CloudFrontClient, ListDistributionsByConnectionFunctionCommand, "Marker", "DistributionList.NextMarker", "MaxItems");

const paginateListDistributionsByConnectionMode = core.createPaginator(CloudFrontClient, ListDistributionsByConnectionModeCommand, "Marker", "DistributionList.NextMarker", "MaxItems");

const paginateListDistributionsByTrustStore = core.createPaginator(CloudFrontClient, ListDistributionsByTrustStoreCommand, "Marker", "DistributionList.NextMarker", "MaxItems");

const paginateListDistributions = core.createPaginator(CloudFrontClient, ListDistributionsCommand, "Marker", "DistributionList.NextMarker", "MaxItems");

const paginateListDistributionTenantsByCustomization = core.createPaginator(CloudFrontClient, ListDistributionTenantsByCustomizationCommand, "Marker", "NextMarker", "MaxItems");

const paginateListDistributionTenants = core.createPaginator(CloudFrontClient, ListDistributionTenantsCommand, "Marker", "NextMarker", "MaxItems");

const paginateListDomainConflicts = core.createPaginator(CloudFrontClient, ListDomainConflictsCommand, "Marker", "NextMarker", "MaxItems");

const paginateListInvalidationsForDistributionTenant = core.createPaginator(CloudFrontClient, ListInvalidationsForDistributionTenantCommand, "Marker", "InvalidationList.NextMarker", "MaxItems");

const paginateListInvalidations = core.createPaginator(CloudFrontClient, ListInvalidationsCommand, "Marker", "InvalidationList.NextMarker", "MaxItems");

const paginateListKeyValueStores = core.createPaginator(CloudFrontClient, ListKeyValueStoresCommand, "Marker", "KeyValueStoreList.NextMarker", "MaxItems");

const paginateListOriginAccessControls = core.createPaginator(CloudFrontClient, ListOriginAccessControlsCommand, "Marker", "OriginAccessControlList.NextMarker", "MaxItems");

const paginateListPublicKeys = core.createPaginator(CloudFrontClient, ListPublicKeysCommand, "Marker", "PublicKeyList.NextMarker", "MaxItems");

const paginateListStreamingDistributions = core.createPaginator(CloudFrontClient, ListStreamingDistributionsCommand, "Marker", "StreamingDistributionList.NextMarker", "MaxItems");

const paginateListTrustStores = core.createPaginator(CloudFrontClient, ListTrustStoresCommand, "Marker", "NextMarker", "MaxItems");

const checkState$3 = async (client, input) => {
    let reason;
    try {
        let result = await client.send(new GetDistributionCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.Distribution.Status;
            };
            if (returnComparator() === "Deployed") {
                return { state: utilWaiter.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForDistributionDeployed = async (params, input) => {
    const serviceDefaults = { minDelay: 60, maxDelay: 2100 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$3);
};
const waitUntilDistributionDeployed = async (params, input) => {
    const serviceDefaults = { minDelay: 60, maxDelay: 2100 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$3);
    return utilWaiter.checkExceptions(result);
};

const checkState$2 = async (client, input) => {
    let reason;
    try {
        let result = await client.send(new GetInvalidationCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.Invalidation.Status;
            };
            if (returnComparator() === "Completed") {
                return { state: utilWaiter.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForInvalidationCompleted = async (params, input) => {
    const serviceDefaults = { minDelay: 20, maxDelay: 600 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$2);
};
const waitUntilInvalidationCompleted = async (params, input) => {
    const serviceDefaults = { minDelay: 20, maxDelay: 600 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$2);
    return utilWaiter.checkExceptions(result);
};

const checkState$1 = async (client, input) => {
    let reason;
    try {
        let result = await client.send(new GetInvalidationForDistributionTenantCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.Invalidation.Status;
            };
            if (returnComparator() === "Completed") {
                return { state: utilWaiter.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForInvalidationForDistributionTenantCompleted = async (params, input) => {
    const serviceDefaults = { minDelay: 20, maxDelay: 600 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$1);
};
const waitUntilInvalidationForDistributionTenantCompleted = async (params, input) => {
    const serviceDefaults = { minDelay: 20, maxDelay: 600 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$1);
    return utilWaiter.checkExceptions(result);
};

const checkState = async (client, input) => {
    let reason;
    try {
        let result = await client.send(new GetStreamingDistributionCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.StreamingDistribution.Status;
            };
            if (returnComparator() === "Deployed") {
                return { state: utilWaiter.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForStreamingDistributionDeployed = async (params, input) => {
    const serviceDefaults = { minDelay: 60, maxDelay: 1500 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
const waitUntilStreamingDistributionDeployed = async (params, input) => {
    const serviceDefaults = { minDelay: 60, maxDelay: 1500 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return utilWaiter.checkExceptions(result);
};

const commands = {
    AssociateAliasCommand,
    AssociateDistributionTenantWebACLCommand,
    AssociateDistributionWebACLCommand,
    CopyDistributionCommand,
    CreateAnycastIpListCommand,
    CreateCachePolicyCommand,
    CreateCloudFrontOriginAccessIdentityCommand,
    CreateConnectionFunctionCommand,
    CreateConnectionGroupCommand,
    CreateContinuousDeploymentPolicyCommand,
    CreateDistributionCommand,
    CreateDistributionTenantCommand,
    CreateDistributionWithTagsCommand,
    CreateFieldLevelEncryptionConfigCommand,
    CreateFieldLevelEncryptionProfileCommand,
    CreateFunctionCommand,
    CreateInvalidationCommand,
    CreateInvalidationForDistributionTenantCommand,
    CreateKeyGroupCommand,
    CreateKeyValueStoreCommand,
    CreateMonitoringSubscriptionCommand,
    CreateOriginAccessControlCommand,
    CreateOriginRequestPolicyCommand,
    CreatePublicKeyCommand,
    CreateRealtimeLogConfigCommand,
    CreateResponseHeadersPolicyCommand,
    CreateStreamingDistributionCommand,
    CreateStreamingDistributionWithTagsCommand,
    CreateTrustStoreCommand,
    CreateVpcOriginCommand,
    DeleteAnycastIpListCommand,
    DeleteCachePolicyCommand,
    DeleteCloudFrontOriginAccessIdentityCommand,
    DeleteConnectionFunctionCommand,
    DeleteConnectionGroupCommand,
    DeleteContinuousDeploymentPolicyCommand,
    DeleteDistributionCommand,
    DeleteDistributionTenantCommand,
    DeleteFieldLevelEncryptionConfigCommand,
    DeleteFieldLevelEncryptionProfileCommand,
    DeleteFunctionCommand,
    DeleteKeyGroupCommand,
    DeleteKeyValueStoreCommand,
    DeleteMonitoringSubscriptionCommand,
    DeleteOriginAccessControlCommand,
    DeleteOriginRequestPolicyCommand,
    DeletePublicKeyCommand,
    DeleteRealtimeLogConfigCommand,
    DeleteResourcePolicyCommand,
    DeleteResponseHeadersPolicyCommand,
    DeleteStreamingDistributionCommand,
    DeleteTrustStoreCommand,
    DeleteVpcOriginCommand,
    DescribeConnectionFunctionCommand,
    DescribeFunctionCommand,
    DescribeKeyValueStoreCommand,
    DisassociateDistributionTenantWebACLCommand,
    DisassociateDistributionWebACLCommand,
    GetAnycastIpListCommand,
    GetCachePolicyCommand,
    GetCachePolicyConfigCommand,
    GetCloudFrontOriginAccessIdentityCommand,
    GetCloudFrontOriginAccessIdentityConfigCommand,
    GetConnectionFunctionCommand,
    GetConnectionGroupCommand,
    GetConnectionGroupByRoutingEndpointCommand,
    GetContinuousDeploymentPolicyCommand,
    GetContinuousDeploymentPolicyConfigCommand,
    GetDistributionCommand,
    GetDistributionConfigCommand,
    GetDistributionTenantCommand,
    GetDistributionTenantByDomainCommand,
    GetFieldLevelEncryptionCommand,
    GetFieldLevelEncryptionConfigCommand,
    GetFieldLevelEncryptionProfileCommand,
    GetFieldLevelEncryptionProfileConfigCommand,
    GetFunctionCommand,
    GetInvalidationCommand,
    GetInvalidationForDistributionTenantCommand,
    GetKeyGroupCommand,
    GetKeyGroupConfigCommand,
    GetManagedCertificateDetailsCommand,
    GetMonitoringSubscriptionCommand,
    GetOriginAccessControlCommand,
    GetOriginAccessControlConfigCommand,
    GetOriginRequestPolicyCommand,
    GetOriginRequestPolicyConfigCommand,
    GetPublicKeyCommand,
    GetPublicKeyConfigCommand,
    GetRealtimeLogConfigCommand,
    GetResourcePolicyCommand,
    GetResponseHeadersPolicyCommand,
    GetResponseHeadersPolicyConfigCommand,
    GetStreamingDistributionCommand,
    GetStreamingDistributionConfigCommand,
    GetTrustStoreCommand,
    GetVpcOriginCommand,
    ListAnycastIpListsCommand,
    ListCachePoliciesCommand,
    ListCloudFrontOriginAccessIdentitiesCommand,
    ListConflictingAliasesCommand,
    ListConnectionFunctionsCommand,
    ListConnectionGroupsCommand,
    ListContinuousDeploymentPoliciesCommand,
    ListDistributionsCommand,
    ListDistributionsByAnycastIpListIdCommand,
    ListDistributionsByCachePolicyIdCommand,
    ListDistributionsByConnectionFunctionCommand,
    ListDistributionsByConnectionModeCommand,
    ListDistributionsByKeyGroupCommand,
    ListDistributionsByOriginRequestPolicyIdCommand,
    ListDistributionsByOwnedResourceCommand,
    ListDistributionsByRealtimeLogConfigCommand,
    ListDistributionsByResponseHeadersPolicyIdCommand,
    ListDistributionsByTrustStoreCommand,
    ListDistributionsByVpcOriginIdCommand,
    ListDistributionsByWebACLIdCommand,
    ListDistributionTenantsCommand,
    ListDistributionTenantsByCustomizationCommand,
    ListDomainConflictsCommand,
    ListFieldLevelEncryptionConfigsCommand,
    ListFieldLevelEncryptionProfilesCommand,
    ListFunctionsCommand,
    ListInvalidationsCommand,
    ListInvalidationsForDistributionTenantCommand,
    ListKeyGroupsCommand,
    ListKeyValueStoresCommand,
    ListOriginAccessControlsCommand,
    ListOriginRequestPoliciesCommand,
    ListPublicKeysCommand,
    ListRealtimeLogConfigsCommand,
    ListResponseHeadersPoliciesCommand,
    ListStreamingDistributionsCommand,
    ListTagsForResourceCommand,
    ListTrustStoresCommand,
    ListVpcOriginsCommand,
    PublishConnectionFunctionCommand,
    PublishFunctionCommand,
    PutResourcePolicyCommand,
    TagResourceCommand,
    TestConnectionFunctionCommand,
    TestFunctionCommand,
    UntagResourceCommand,
    UpdateAnycastIpListCommand,
    UpdateCachePolicyCommand,
    UpdateCloudFrontOriginAccessIdentityCommand,
    UpdateConnectionFunctionCommand,
    UpdateConnectionGroupCommand,
    UpdateContinuousDeploymentPolicyCommand,
    UpdateDistributionCommand,
    UpdateDistributionTenantCommand,
    UpdateDistributionWithStagingConfigCommand,
    UpdateDomainAssociationCommand,
    UpdateFieldLevelEncryptionConfigCommand,
    UpdateFieldLevelEncryptionProfileCommand,
    UpdateFunctionCommand,
    UpdateKeyGroupCommand,
    UpdateKeyValueStoreCommand,
    UpdateOriginAccessControlCommand,
    UpdateOriginRequestPolicyCommand,
    UpdatePublicKeyCommand,
    UpdateRealtimeLogConfigCommand,
    UpdateResponseHeadersPolicyCommand,
    UpdateStreamingDistributionCommand,
    UpdateTrustStoreCommand,
    UpdateVpcOriginCommand,
    VerifyDnsConfigurationCommand,
};
const paginators = {
    paginateListCloudFrontOriginAccessIdentities,
    paginateListConnectionFunctions,
    paginateListConnectionGroups,
    paginateListDistributions,
    paginateListDistributionsByConnectionFunction,
    paginateListDistributionsByConnectionMode,
    paginateListDistributionsByTrustStore,
    paginateListDistributionTenants,
    paginateListDistributionTenantsByCustomization,
    paginateListDomainConflicts,
    paginateListInvalidations,
    paginateListInvalidationsForDistributionTenant,
    paginateListKeyValueStores,
    paginateListOriginAccessControls,
    paginateListPublicKeys,
    paginateListStreamingDistributions,
    paginateListTrustStores,
};
const waiters = {
    waitUntilDistributionDeployed,
    waitUntilInvalidationCompleted,
    waitUntilInvalidationForDistributionTenantCompleted,
    waitUntilStreamingDistributionDeployed,
};
class CloudFront extends CloudFrontClient {
}
smithyClient.createAggregatedClient(commands, CloudFront, { paginators, waiters });

const ResponseHeadersPolicyAccessControlAllowMethodsValues = {
    ALL: "ALL",
    DELETE: "DELETE",
    GET: "GET",
    HEAD: "HEAD",
    OPTIONS: "OPTIONS",
    PATCH: "PATCH",
    POST: "POST",
    PUT: "PUT",
};
const ICPRecordalStatus = {
    APPROVED: "APPROVED",
    PENDING: "PENDING",
    SUSPENDED: "SUSPENDED",
};
const Method = {
    DELETE: "DELETE",
    GET: "GET",
    HEAD: "HEAD",
    OPTIONS: "OPTIONS",
    PATCH: "PATCH",
    POST: "POST",
    PUT: "PUT",
};
const IpAddressType = {
    DualStack: "dualstack",
    Ipv4: "ipv4",
    Ipv6: "ipv6",
};
const IpamCidrStatus = {
    Advertised: "advertised",
    Advertising: "advertising",
    Deprovisioned: "deprovisioned",
    Deprovisioning: "deprovisioning",
    FailedAdvertise: "failed-advertise",
    FailedDeprovision: "failed-deprovision",
    FailedProvision: "failed-provision",
    FailedWithdraw: "failed-withdraw",
    Provisioned: "provisioned",
    Provisioning: "provisioning",
    Withdrawing: "withdrawing",
    Withdrawn: "withdrawn",
};
const ItemSelection = {
    all: "all",
    none: "none",
    whitelist: "whitelist",
};
const EventType = {
    origin_request: "origin-request",
    origin_response: "origin-response",
    viewer_request: "viewer-request",
    viewer_response: "viewer-response",
};
const ViewerProtocolPolicy = {
    allow_all: "allow-all",
    https_only: "https-only",
    redirect_to_https: "redirect-to-https",
};
const CachePolicyCookieBehavior = {
    all: "all",
    allExcept: "allExcept",
    none: "none",
    whitelist: "whitelist",
};
const CachePolicyHeaderBehavior = {
    none: "none",
    whitelist: "whitelist",
};
const CachePolicyQueryStringBehavior = {
    all: "all",
    allExcept: "allExcept",
    none: "none",
    whitelist: "whitelist",
};
const CachePolicyType = {
    custom: "custom",
    managed: "managed",
};
const CertificateSource = {
    acm: "acm",
    cloudfront: "cloudfront",
    iam: "iam",
};
const CertificateTransparencyLoggingPreference = {
    Disabled: "disabled",
    Enabled: "enabled",
};
const ConnectionMode = {
    Direct: "direct",
    TenantOnly: "tenant-only",
};
const HttpVersion = {
    http1_1: "http1.1",
    http2: "http2",
    http2and3: "http2and3",
    http3: "http3",
};
const OriginGroupSelectionCriteria = {
    Default: "default",
    MediaQualityBased: "media-quality-based",
};
const OriginProtocolPolicy = {
    http_only: "http-only",
    https_only: "https-only",
    match_viewer: "match-viewer",
};
const SslProtocol = {
    SSLv3: "SSLv3",
    TLSv1: "TLSv1",
    TLSv1_1: "TLSv1.1",
    TLSv1_2: "TLSv1.2",
};
const PriceClass = {
    None: "None",
    PriceClass_100: "PriceClass_100",
    PriceClass_200: "PriceClass_200",
    PriceClass_All: "PriceClass_All",
};
const GeoRestrictionType = {
    blacklist: "blacklist",
    none: "none",
    whitelist: "whitelist",
};
const MinimumProtocolVersion = {
    SSLv3: "SSLv3",
    TLSv1: "TLSv1",
    TLSv1_1_2016: "TLSv1.1_2016",
    TLSv1_2016: "TLSv1_2016",
    TLSv1_2_2018: "TLSv1.2_2018",
    TLSv1_2_2019: "TLSv1.2_2019",
    TLSv1_2_2021: "TLSv1.2_2021",
    TLSv1_2_2025: "TLSv1.2_2025",
    TLSv1_3_2025: "TLSv1.3_2025",
};
const SSLSupportMethod = {
    sni_only: "sni-only",
    static_ip: "static-ip",
    vip: "vip",
};
const ViewerMtlsMode = {
    Optional: "optional",
    Required: "required",
};
const FunctionRuntime = {
    cloudfront_js_1_0: "cloudfront-js-1.0",
    cloudfront_js_2_0: "cloudfront-js-2.0",
};
const FunctionStage = {
    DEVELOPMENT: "DEVELOPMENT",
    LIVE: "LIVE",
};
const ContinuousDeploymentPolicyType = {
    SingleHeader: "SingleHeader",
    SingleWeight: "SingleWeight",
};
const CustomizationActionType = {
    disable: "disable",
    override: "override",
};
const ValidationTokenHost = {
    CloudFront: "cloudfront",
    SelfHosted: "self-hosted",
};
const DomainStatus = {
    Active: "active",
    Inactive: "inactive",
};
const Format = {
    URLEncoded: "URLEncoded",
};
const ImportSourceType = {
    S3: "S3",
};
const RealtimeMetricsSubscriptionStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const OriginAccessControlOriginTypes = {
    lambda: "lambda",
    mediapackagev2: "mediapackagev2",
    mediastore: "mediastore",
    s3: "s3",
};
const OriginAccessControlSigningBehaviors = {
    always: "always",
    never: "never",
    no_override: "no-override",
};
const OriginAccessControlSigningProtocols = {
    sigv4: "sigv4",
};
const OriginRequestPolicyCookieBehavior = {
    all: "all",
    allExcept: "allExcept",
    none: "none",
    whitelist: "whitelist",
};
const OriginRequestPolicyHeaderBehavior = {
    allExcept: "allExcept",
    allViewer: "allViewer",
    allViewerAndWhitelistCloudFront: "allViewerAndWhitelistCloudFront",
    none: "none",
    whitelist: "whitelist",
};
const OriginRequestPolicyQueryStringBehavior = {
    all: "all",
    allExcept: "allExcept",
    none: "none",
    whitelist: "whitelist",
};
const FrameOptionsList = {
    DENY: "DENY",
    SAMEORIGIN: "SAMEORIGIN",
};
const ReferrerPolicyList = {
    no_referrer: "no-referrer",
    no_referrer_when_downgrade: "no-referrer-when-downgrade",
    origin: "origin",
    origin_when_cross_origin: "origin-when-cross-origin",
    same_origin: "same-origin",
    strict_origin: "strict-origin",
    strict_origin_when_cross_origin: "strict-origin-when-cross-origin",
    unsafe_url: "unsafe-url",
};
const TrustStoreStatus = {
    Active: "active",
    Failed: "failed",
    Pending: "pending",
};
const ManagedCertificateStatus = {
    Expired: "expired",
    Failed: "failed",
    Inactive: "inactive",
    Issued: "issued",
    PendingValidation: "pending-validation",
    Revoked: "revoked",
    ValidationTimedOut: "validation-timed-out",
};
const DistributionResourceType = {
    Distribution: "distribution",
    DistributionTenant: "distribution-tenant",
};
const OriginRequestPolicyType = {
    custom: "custom",
    managed: "managed",
};
const ResponseHeadersPolicyType = {
    custom: "custom",
    managed: "managed",
};
const DnsConfigurationStatus = {
    Invalid: "invalid-configuration",
    Unknown: "unknown-configuration",
    Valid: "valid-configuration",
};

Object.defineProperty(exports, "$Command", {
    enumerable: true,
    get: function () { return smithyClient.Command; }
});
Object.defineProperty(exports, "__Client", {
    enumerable: true,
    get: function () { return smithyClient.Client; }
});
Object.defineProperty(exports, "CloudFrontServiceException", {
    enumerable: true,
    get: function () { return CloudFrontServiceException.CloudFrontServiceException; }
});
exports.AssociateAliasCommand = AssociateAliasCommand;
exports.AssociateDistributionTenantWebACLCommand = AssociateDistributionTenantWebACLCommand;
exports.AssociateDistributionWebACLCommand = AssociateDistributionWebACLCommand;
exports.CachePolicyCookieBehavior = CachePolicyCookieBehavior;
exports.CachePolicyHeaderBehavior = CachePolicyHeaderBehavior;
exports.CachePolicyQueryStringBehavior = CachePolicyQueryStringBehavior;
exports.CachePolicyType = CachePolicyType;
exports.CertificateSource = CertificateSource;
exports.CertificateTransparencyLoggingPreference = CertificateTransparencyLoggingPreference;
exports.CloudFront = CloudFront;
exports.CloudFrontClient = CloudFrontClient;
exports.ConnectionMode = ConnectionMode;
exports.ContinuousDeploymentPolicyType = ContinuousDeploymentPolicyType;
exports.CopyDistributionCommand = CopyDistributionCommand;
exports.CreateAnycastIpListCommand = CreateAnycastIpListCommand;
exports.CreateCachePolicyCommand = CreateCachePolicyCommand;
exports.CreateCloudFrontOriginAccessIdentityCommand = CreateCloudFrontOriginAccessIdentityCommand;
exports.CreateConnectionFunctionCommand = CreateConnectionFunctionCommand;
exports.CreateConnectionGroupCommand = CreateConnectionGroupCommand;
exports.CreateContinuousDeploymentPolicyCommand = CreateContinuousDeploymentPolicyCommand;
exports.CreateDistributionCommand = CreateDistributionCommand;
exports.CreateDistributionTenantCommand = CreateDistributionTenantCommand;
exports.CreateDistributionWithTagsCommand = CreateDistributionWithTagsCommand;
exports.CreateFieldLevelEncryptionConfigCommand = CreateFieldLevelEncryptionConfigCommand;
exports.CreateFieldLevelEncryptionProfileCommand = CreateFieldLevelEncryptionProfileCommand;
exports.CreateFunctionCommand = CreateFunctionCommand;
exports.CreateInvalidationCommand = CreateInvalidationCommand;
exports.CreateInvalidationForDistributionTenantCommand = CreateInvalidationForDistributionTenantCommand;
exports.CreateKeyGroupCommand = CreateKeyGroupCommand;
exports.CreateKeyValueStoreCommand = CreateKeyValueStoreCommand;
exports.CreateMonitoringSubscriptionCommand = CreateMonitoringSubscriptionCommand;
exports.CreateOriginAccessControlCommand = CreateOriginAccessControlCommand;
exports.CreateOriginRequestPolicyCommand = CreateOriginRequestPolicyCommand;
exports.CreatePublicKeyCommand = CreatePublicKeyCommand;
exports.CreateRealtimeLogConfigCommand = CreateRealtimeLogConfigCommand;
exports.CreateResponseHeadersPolicyCommand = CreateResponseHeadersPolicyCommand;
exports.CreateStreamingDistributionCommand = CreateStreamingDistributionCommand;
exports.CreateStreamingDistributionWithTagsCommand = CreateStreamingDistributionWithTagsCommand;
exports.CreateTrustStoreCommand = CreateTrustStoreCommand;
exports.CreateVpcOriginCommand = CreateVpcOriginCommand;
exports.CustomizationActionType = CustomizationActionType;
exports.DeleteAnycastIpListCommand = DeleteAnycastIpListCommand;
exports.DeleteCachePolicyCommand = DeleteCachePolicyCommand;
exports.DeleteCloudFrontOriginAccessIdentityCommand = DeleteCloudFrontOriginAccessIdentityCommand;
exports.DeleteConnectionFunctionCommand = DeleteConnectionFunctionCommand;
exports.DeleteConnectionGroupCommand = DeleteConnectionGroupCommand;
exports.DeleteContinuousDeploymentPolicyCommand = DeleteContinuousDeploymentPolicyCommand;
exports.DeleteDistributionCommand = DeleteDistributionCommand;
exports.DeleteDistributionTenantCommand = DeleteDistributionTenantCommand;
exports.DeleteFieldLevelEncryptionConfigCommand = DeleteFieldLevelEncryptionConfigCommand;
exports.DeleteFieldLevelEncryptionProfileCommand = DeleteFieldLevelEncryptionProfileCommand;
exports.DeleteFunctionCommand = DeleteFunctionCommand;
exports.DeleteKeyGroupCommand = DeleteKeyGroupCommand;
exports.DeleteKeyValueStoreCommand = DeleteKeyValueStoreCommand;
exports.DeleteMonitoringSubscriptionCommand = DeleteMonitoringSubscriptionCommand;
exports.DeleteOriginAccessControlCommand = DeleteOriginAccessControlCommand;
exports.DeleteOriginRequestPolicyCommand = DeleteOriginRequestPolicyCommand;
exports.DeletePublicKeyCommand = DeletePublicKeyCommand;
exports.DeleteRealtimeLogConfigCommand = DeleteRealtimeLogConfigCommand;
exports.DeleteResourcePolicyCommand = DeleteResourcePolicyCommand;
exports.DeleteResponseHeadersPolicyCommand = DeleteResponseHeadersPolicyCommand;
exports.DeleteStreamingDistributionCommand = DeleteStreamingDistributionCommand;
exports.DeleteTrustStoreCommand = DeleteTrustStoreCommand;
exports.DeleteVpcOriginCommand = DeleteVpcOriginCommand;
exports.DescribeConnectionFunctionCommand = DescribeConnectionFunctionCommand;
exports.DescribeFunctionCommand = DescribeFunctionCommand;
exports.DescribeKeyValueStoreCommand = DescribeKeyValueStoreCommand;
exports.DisassociateDistributionTenantWebACLCommand = DisassociateDistributionTenantWebACLCommand;
exports.DisassociateDistributionWebACLCommand = DisassociateDistributionWebACLCommand;
exports.DistributionResourceType = DistributionResourceType;
exports.DnsConfigurationStatus = DnsConfigurationStatus;
exports.DomainStatus = DomainStatus;
exports.EventType = EventType;
exports.Format = Format;
exports.FrameOptionsList = FrameOptionsList;
exports.FunctionRuntime = FunctionRuntime;
exports.FunctionStage = FunctionStage;
exports.GeoRestrictionType = GeoRestrictionType;
exports.GetAnycastIpListCommand = GetAnycastIpListCommand;
exports.GetCachePolicyCommand = GetCachePolicyCommand;
exports.GetCachePolicyConfigCommand = GetCachePolicyConfigCommand;
exports.GetCloudFrontOriginAccessIdentityCommand = GetCloudFrontOriginAccessIdentityCommand;
exports.GetCloudFrontOriginAccessIdentityConfigCommand = GetCloudFrontOriginAccessIdentityConfigCommand;
exports.GetConnectionFunctionCommand = GetConnectionFunctionCommand;
exports.GetConnectionGroupByRoutingEndpointCommand = GetConnectionGroupByRoutingEndpointCommand;
exports.GetConnectionGroupCommand = GetConnectionGroupCommand;
exports.GetContinuousDeploymentPolicyCommand = GetContinuousDeploymentPolicyCommand;
exports.GetContinuousDeploymentPolicyConfigCommand = GetContinuousDeploymentPolicyConfigCommand;
exports.GetDistributionCommand = GetDistributionCommand;
exports.GetDistributionConfigCommand = GetDistributionConfigCommand;
exports.GetDistributionTenantByDomainCommand = GetDistributionTenantByDomainCommand;
exports.GetDistributionTenantCommand = GetDistributionTenantCommand;
exports.GetFieldLevelEncryptionCommand = GetFieldLevelEncryptionCommand;
exports.GetFieldLevelEncryptionConfigCommand = GetFieldLevelEncryptionConfigCommand;
exports.GetFieldLevelEncryptionProfileCommand = GetFieldLevelEncryptionProfileCommand;
exports.GetFieldLevelEncryptionProfileConfigCommand = GetFieldLevelEncryptionProfileConfigCommand;
exports.GetFunctionCommand = GetFunctionCommand;
exports.GetInvalidationCommand = GetInvalidationCommand;
exports.GetInvalidationForDistributionTenantCommand = GetInvalidationForDistributionTenantCommand;
exports.GetKeyGroupCommand = GetKeyGroupCommand;
exports.GetKeyGroupConfigCommand = GetKeyGroupConfigCommand;
exports.GetManagedCertificateDetailsCommand = GetManagedCertificateDetailsCommand;
exports.GetMonitoringSubscriptionCommand = GetMonitoringSubscriptionCommand;
exports.GetOriginAccessControlCommand = GetOriginAccessControlCommand;
exports.GetOriginAccessControlConfigCommand = GetOriginAccessControlConfigCommand;
exports.GetOriginRequestPolicyCommand = GetOriginRequestPolicyCommand;
exports.GetOriginRequestPolicyConfigCommand = GetOriginRequestPolicyConfigCommand;
exports.GetPublicKeyCommand = GetPublicKeyCommand;
exports.GetPublicKeyConfigCommand = GetPublicKeyConfigCommand;
exports.GetRealtimeLogConfigCommand = GetRealtimeLogConfigCommand;
exports.GetResourcePolicyCommand = GetResourcePolicyCommand;
exports.GetResponseHeadersPolicyCommand = GetResponseHeadersPolicyCommand;
exports.GetResponseHeadersPolicyConfigCommand = GetResponseHeadersPolicyConfigCommand;
exports.GetStreamingDistributionCommand = GetStreamingDistributionCommand;
exports.GetStreamingDistributionConfigCommand = GetStreamingDistributionConfigCommand;
exports.GetTrustStoreCommand = GetTrustStoreCommand;
exports.GetVpcOriginCommand = GetVpcOriginCommand;
exports.HttpVersion = HttpVersion;
exports.ICPRecordalStatus = ICPRecordalStatus;
exports.ImportSourceType = ImportSourceType;
exports.IpAddressType = IpAddressType;
exports.IpamCidrStatus = IpamCidrStatus;
exports.ItemSelection = ItemSelection;
exports.ListAnycastIpListsCommand = ListAnycastIpListsCommand;
exports.ListCachePoliciesCommand = ListCachePoliciesCommand;
exports.ListCloudFrontOriginAccessIdentitiesCommand = ListCloudFrontOriginAccessIdentitiesCommand;
exports.ListConflictingAliasesCommand = ListConflictingAliasesCommand;
exports.ListConnectionFunctionsCommand = ListConnectionFunctionsCommand;
exports.ListConnectionGroupsCommand = ListConnectionGroupsCommand;
exports.ListContinuousDeploymentPoliciesCommand = ListContinuousDeploymentPoliciesCommand;
exports.ListDistributionTenantsByCustomizationCommand = ListDistributionTenantsByCustomizationCommand;
exports.ListDistributionTenantsCommand = ListDistributionTenantsCommand;
exports.ListDistributionsByAnycastIpListIdCommand = ListDistributionsByAnycastIpListIdCommand;
exports.ListDistributionsByCachePolicyIdCommand = ListDistributionsByCachePolicyIdCommand;
exports.ListDistributionsByConnectionFunctionCommand = ListDistributionsByConnectionFunctionCommand;
exports.ListDistributionsByConnectionModeCommand = ListDistributionsByConnectionModeCommand;
exports.ListDistributionsByKeyGroupCommand = ListDistributionsByKeyGroupCommand;
exports.ListDistributionsByOriginRequestPolicyIdCommand = ListDistributionsByOriginRequestPolicyIdCommand;
exports.ListDistributionsByOwnedResourceCommand = ListDistributionsByOwnedResourceCommand;
exports.ListDistributionsByRealtimeLogConfigCommand = ListDistributionsByRealtimeLogConfigCommand;
exports.ListDistributionsByResponseHeadersPolicyIdCommand = ListDistributionsByResponseHeadersPolicyIdCommand;
exports.ListDistributionsByTrustStoreCommand = ListDistributionsByTrustStoreCommand;
exports.ListDistributionsByVpcOriginIdCommand = ListDistributionsByVpcOriginIdCommand;
exports.ListDistributionsByWebACLIdCommand = ListDistributionsByWebACLIdCommand;
exports.ListDistributionsCommand = ListDistributionsCommand;
exports.ListDomainConflictsCommand = ListDomainConflictsCommand;
exports.ListFieldLevelEncryptionConfigsCommand = ListFieldLevelEncryptionConfigsCommand;
exports.ListFieldLevelEncryptionProfilesCommand = ListFieldLevelEncryptionProfilesCommand;
exports.ListFunctionsCommand = ListFunctionsCommand;
exports.ListInvalidationsCommand = ListInvalidationsCommand;
exports.ListInvalidationsForDistributionTenantCommand = ListInvalidationsForDistributionTenantCommand;
exports.ListKeyGroupsCommand = ListKeyGroupsCommand;
exports.ListKeyValueStoresCommand = ListKeyValueStoresCommand;
exports.ListOriginAccessControlsCommand = ListOriginAccessControlsCommand;
exports.ListOriginRequestPoliciesCommand = ListOriginRequestPoliciesCommand;
exports.ListPublicKeysCommand = ListPublicKeysCommand;
exports.ListRealtimeLogConfigsCommand = ListRealtimeLogConfigsCommand;
exports.ListResponseHeadersPoliciesCommand = ListResponseHeadersPoliciesCommand;
exports.ListStreamingDistributionsCommand = ListStreamingDistributionsCommand;
exports.ListTagsForResourceCommand = ListTagsForResourceCommand;
exports.ListTrustStoresCommand = ListTrustStoresCommand;
exports.ListVpcOriginsCommand = ListVpcOriginsCommand;
exports.ManagedCertificateStatus = ManagedCertificateStatus;
exports.Method = Method;
exports.MinimumProtocolVersion = MinimumProtocolVersion;
exports.OriginAccessControlOriginTypes = OriginAccessControlOriginTypes;
exports.OriginAccessControlSigningBehaviors = OriginAccessControlSigningBehaviors;
exports.OriginAccessControlSigningProtocols = OriginAccessControlSigningProtocols;
exports.OriginGroupSelectionCriteria = OriginGroupSelectionCriteria;
exports.OriginProtocolPolicy = OriginProtocolPolicy;
exports.OriginRequestPolicyCookieBehavior = OriginRequestPolicyCookieBehavior;
exports.OriginRequestPolicyHeaderBehavior = OriginRequestPolicyHeaderBehavior;
exports.OriginRequestPolicyQueryStringBehavior = OriginRequestPolicyQueryStringBehavior;
exports.OriginRequestPolicyType = OriginRequestPolicyType;
exports.PriceClass = PriceClass;
exports.PublishConnectionFunctionCommand = PublishConnectionFunctionCommand;
exports.PublishFunctionCommand = PublishFunctionCommand;
exports.PutResourcePolicyCommand = PutResourcePolicyCommand;
exports.RealtimeMetricsSubscriptionStatus = RealtimeMetricsSubscriptionStatus;
exports.ReferrerPolicyList = ReferrerPolicyList;
exports.ResponseHeadersPolicyAccessControlAllowMethodsValues = ResponseHeadersPolicyAccessControlAllowMethodsValues;
exports.ResponseHeadersPolicyType = ResponseHeadersPolicyType;
exports.SSLSupportMethod = SSLSupportMethod;
exports.SslProtocol = SslProtocol;
exports.TagResourceCommand = TagResourceCommand;
exports.TestConnectionFunctionCommand = TestConnectionFunctionCommand;
exports.TestFunctionCommand = TestFunctionCommand;
exports.TrustStoreStatus = TrustStoreStatus;
exports.UntagResourceCommand = UntagResourceCommand;
exports.UpdateAnycastIpListCommand = UpdateAnycastIpListCommand;
exports.UpdateCachePolicyCommand = UpdateCachePolicyCommand;
exports.UpdateCloudFrontOriginAccessIdentityCommand = UpdateCloudFrontOriginAccessIdentityCommand;
exports.UpdateConnectionFunctionCommand = UpdateConnectionFunctionCommand;
exports.UpdateConnectionGroupCommand = UpdateConnectionGroupCommand;
exports.UpdateContinuousDeploymentPolicyCommand = UpdateContinuousDeploymentPolicyCommand;
exports.UpdateDistributionCommand = UpdateDistributionCommand;
exports.UpdateDistributionTenantCommand = UpdateDistributionTenantCommand;
exports.UpdateDistributionWithStagingConfigCommand = UpdateDistributionWithStagingConfigCommand;
exports.UpdateDomainAssociationCommand = UpdateDomainAssociationCommand;
exports.UpdateFieldLevelEncryptionConfigCommand = UpdateFieldLevelEncryptionConfigCommand;
exports.UpdateFieldLevelEncryptionProfileCommand = UpdateFieldLevelEncryptionProfileCommand;
exports.UpdateFunctionCommand = UpdateFunctionCommand;
exports.UpdateKeyGroupCommand = UpdateKeyGroupCommand;
exports.UpdateKeyValueStoreCommand = UpdateKeyValueStoreCommand;
exports.UpdateOriginAccessControlCommand = UpdateOriginAccessControlCommand;
exports.UpdateOriginRequestPolicyCommand = UpdateOriginRequestPolicyCommand;
exports.UpdatePublicKeyCommand = UpdatePublicKeyCommand;
exports.UpdateRealtimeLogConfigCommand = UpdateRealtimeLogConfigCommand;
exports.UpdateResponseHeadersPolicyCommand = UpdateResponseHeadersPolicyCommand;
exports.UpdateStreamingDistributionCommand = UpdateStreamingDistributionCommand;
exports.UpdateTrustStoreCommand = UpdateTrustStoreCommand;
exports.UpdateVpcOriginCommand = UpdateVpcOriginCommand;
exports.ValidationTokenHost = ValidationTokenHost;
exports.VerifyDnsConfigurationCommand = VerifyDnsConfigurationCommand;
exports.ViewerMtlsMode = ViewerMtlsMode;
exports.ViewerProtocolPolicy = ViewerProtocolPolicy;
exports.paginateListCloudFrontOriginAccessIdentities = paginateListCloudFrontOriginAccessIdentities;
exports.paginateListConnectionFunctions = paginateListConnectionFunctions;
exports.paginateListConnectionGroups = paginateListConnectionGroups;
exports.paginateListDistributionTenants = paginateListDistributionTenants;
exports.paginateListDistributionTenantsByCustomization = paginateListDistributionTenantsByCustomization;
exports.paginateListDistributions = paginateListDistributions;
exports.paginateListDistributionsByConnectionFunction = paginateListDistributionsByConnectionFunction;
exports.paginateListDistributionsByConnectionMode = paginateListDistributionsByConnectionMode;
exports.paginateListDistributionsByTrustStore = paginateListDistributionsByTrustStore;
exports.paginateListDomainConflicts = paginateListDomainConflicts;
exports.paginateListInvalidations = paginateListInvalidations;
exports.paginateListInvalidationsForDistributionTenant = paginateListInvalidationsForDistributionTenant;
exports.paginateListKeyValueStores = paginateListKeyValueStores;
exports.paginateListOriginAccessControls = paginateListOriginAccessControls;
exports.paginateListPublicKeys = paginateListPublicKeys;
exports.paginateListStreamingDistributions = paginateListStreamingDistributions;
exports.paginateListTrustStores = paginateListTrustStores;
exports.waitForDistributionDeployed = waitForDistributionDeployed;
exports.waitForInvalidationCompleted = waitForInvalidationCompleted;
exports.waitForInvalidationForDistributionTenantCompleted = waitForInvalidationForDistributionTenantCompleted;
exports.waitForStreamingDistributionDeployed = waitForStreamingDistributionDeployed;
exports.waitUntilDistributionDeployed = waitUntilDistributionDeployed;
exports.waitUntilInvalidationCompleted = waitUntilInvalidationCompleted;
exports.waitUntilInvalidationForDistributionTenantCompleted = waitUntilInvalidationForDistributionTenantCompleted;
exports.waitUntilStreamingDistributionDeployed = waitUntilStreamingDistributionDeployed;
Object.keys(schemas_0).forEach(function (k) {
    if (k !== 'default' && !Object.prototype.hasOwnProperty.call(exports, k)) Object.defineProperty(exports, k, {
        enumerable: true,
        get: function () { return schemas_0[k]; }
    });
});
Object.keys(errors).forEach(function (k) {
    if (k !== 'default' && !Object.prototype.hasOwnProperty.call(exports, k)) Object.defineProperty(exports, k, {
        enumerable: true,
        get: function () { return errors[k]; }
    });
});
