/**
 * ./src/classes/utils.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 *
 * Refactored Utils class - imports from modular utilities
 */
import IOsRelease from '../interfaces/i-os-release.js';
/**
 * Utils: general porpourse utils
 * @remarks all the utilities
 */
export default class Utils {
    /**
     * address
     */
    static address(): string;
    static broadcast(): string;
    /**
     * chpasswdPath
     * @returns
     */
    static chpasswdPath(): string;
    /**
     * cidr
     */
    static cidr(): string;
    /**
     *
     * @param cmd
     */
    static commandExists(cmd: string): boolean;
    /**
     *
     * @param msg
     */
    static customConfirm(msg?: string): Promise<boolean>;
    /**
     *
     * @param msg
     */
    static customConfirmAbort(msg?: string): Promise<any>;
    /**
     *
     * @param msg
     */
    static customConfirmCompanion(msg?: string): Promise<any>;
    static debug(cmd?: string, procContinue?: boolean): Promise<void>;
    static error(msg?: string): void;
    /**
     *
     * @returns flag
     */
    static flag(): string;
    /**
     *
     * @param bytes
     * @param decimals
     * @returns
     */
    static formatBytes(bytes: number, decimals?: number): string;
    /**
     *
     * @param date
     */
    static formatDate(date: Date): string;
    /**
     * @returns gateway
     */
    static gateway(): string;
    /**
     * Get author name
     */
    static getAuthorName(): string;
    /**
     * Return the Debian version
     * @returns {number} Versione di Debian
     */
    static getDebianVersion(): number;
    /**
     * dns
     */
    static getDns(): string[];
    /**
     * getDomain
     */
    static getDomain(): string;
    /**
     * return the short name of the package: eggs
     * @returns eggs
     */
    static getFriendName(): string;
    /**
     * Estimate the linuxfs dimension
     * (Refactored to use native FS instead of dd/od)
     * @returns {number} GB
     */
    static getLiveRootSpace(type?: string): number;
    static getOsRelease(): IOsRelease;
    /**
     * return the name of the package: penguins-eggs
     * @returns penguins-eggs
     */
    static getPackageName(): string;
    /**
     * return the version of the package
     * @returns version example 8.0.0
     */
    static getPackageVersion(): string;
    /**
     * Return postfix
     * @param basename
     * @returns eggName
     */
    static getPostfix(): string;
    /**
     *
     * @param prefix
     * @param backup
     * @returns
     */
    static getPrefix(prefix: string, backup?: boolean): string;
    /**
     * Return the primary user's name
     */
    static getPrimaryUser(): Promise<string>;
    /**
     * Count the eggs present in the nest
     * @returns {number} Numero degli snapshot presenti
     */
    static getSnapshotCount(snapshot_dir?: string): number;
    /**
     * Get the syze of the snapshot
     * @returns {string} grandezza dello snapshot in Byte
     */
    static getSnapshotSize(snapshot_dir?: string): number;
    /**
     * Calculate the space used on the disk
     * @returns {void}
     */
    static getUsedSpace(): number;
    /**
     * return the name of network device
     */
    static iface(): Promise<string>;
    static info(msg?: string): void;
    /**
     * @deprecated Use Kernel.initramfs() instead
     */
    static initrdImg(kernel?: string): string;
    /**
     * isAppImage
     */
    static isAppImage(): boolean;
    /**
     *
     * @param device
     * @returns
     */
    static isBlockDevice(device?: string): boolean;
    /**
     * Detect if running inside a standard chroot environment
     * (Distinguishes chroot from Containers/Host)
     */
    static isChroot(): boolean;
    /**
     * Detect if running inside a container (Docker or LXC)
     */
    static isContainer(): boolean;
    /**
     * Return true if i686 architecture
     * @remarks to move in Utils
     * @returns {boolean} true se l'architettura è i686
     */
    static isi686(): boolean;
    /**
     * Return true if live system
     * @returns {boolean} isLive
     */
    static isLive(): boolean;
    /**
     * Ritorna vero se path è un mountpoint
     * @param path
     */
    static isMountpoint(path?: string): boolean;
    /**
     * Controlla se è un pacchetto npm
     */
    static isNpmPackage(): boolean;
    /**
     * Check if the system uses OpenRC
     */
    static isOpenRc(): boolean;
    /**
     * Controlla se è un pacchetto deb
     * /usr/lib/penguins-eggs/bin/node
     */
    static isPackage(): boolean;
    /**
     * return true if eggs run as root
     * @returns isRoot
     */
    static isRoot(command?: string): boolean;
    /**
     * Controlla se è un pacchetto sorgente
     */
    static isSources(): boolean;
    /**
     * Check if the system uses Systemd
     */
    static isSystemd(): boolean;
    /**
     * Check if the system uses SysVinit
     */
    static isSysvinit(): boolean;
    /**
     * get the kernel version
     */
    static kernelVersion(): string;
    /**
     * Usata da pacman e config credo non serva affatto
     */
    static machineId(): string;
    /**
     * netmask
     */
    static netmask(): string;
    /**
     *
     */
    static pressKeyToExit(warning?: string, procContinue?: boolean): Promise<void>;
    /**
     *
     */
    static rootPenguin(): string;
    /**
     *
     * @param file
     * @param search
     * @returns value
     */
    static searchOnFile(file?: string, search?: string): string;
    /**
     *
     * @param verbose
     */
    static setEcho(verbose?: boolean): object;
    static sleep(ms?: number): Promise<void>;
    /**
     * Restituisce il prefisso della iso
     * @param distroId
     * @param codenameId
     */
    static snapshotPrefix(distroId: string, codenameId: string): string;
    /**
     * Custom function to sort object keys
     * @param obj
     * @returns
     */
    static sortObjectKeys(obj: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
    static success(msg?: string): void;
    /**
     * titles
     * Penguin's are gettings alive!
     */
    static titles(command?: string): void;
    /**
     * uefiArch
     * @returns arch
     */
    static uefiArch(): string;
    /**
     * i386-pc,
     * i386-efi,
     * x86_64-efi,
     * arm64-efi,
     *
     * ATTEMZIONE: install efibootmgr
     *
     * Fedora/RHEL have i386-pc
     */
    static uefiFormat(): string;
    /**
     *
     * @param command
     */
    static useRoot(command?: string): void;
    /**
     *
     * @returns
     */
    static usrLibPath(): string;
    /**
     * restituisce uuid
     * @param device
     */
    static uuid(device: string): string;
    /**
     *
     * @param device
     * @returns
     */
    static uuidGen(): string;
    static vmlinuz(kernel?: string): string;
    /**
     *
     * @param volid
     */
    static VolidTrim(volid?: string): string;
    /**
     *
     * @returns wardrobe
     */
    static wardrobe(): Promise<string>;
    /**
     *
     * @param msg
     */
    static warning(msg?: string): void;
    /**
     * write a file
     * @param file
     * @param text
     */
    static write(file: string, text: string): void;
    /**
     *
     * @param file
     * @param cmd
     */
    static writeX(file: string, cmd: string): void;
    /**
     *
     * @param file
     * @param cmd
     */
    static writeXs(file: string, cmds: string[]): void;
}
