/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.wssecurity.AttributedString;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObjectUnmarshaller;
import org.w3c.dom.Attr;

public class AttributedStringUnmarshaller
extends AbstractWSSecurityObjectUnmarshaller {
    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        AttributedString attributedString = (AttributedString)xmlObject;
        QName attribQName = QNameSupport.constructQName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix());
        if (AttributedString.WSU_ID_ATTR_NAME.equals(attribQName)) {
            attributedString.setWSUId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else {
            XMLObjectSupport.unmarshallToAttributeMap(attributedString.getUnknownAttributes(), attribute);
        }
    }

    @Override
    protected void processElementContent(@Nonnull XMLObject xmlObject, @Nonnull String elementContent) {
        AttributedString attributedString = (AttributedString)xmlObject;
        attributedString.setValue(elementContent);
    }
}

