/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.rerank;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.core.action.ActionListener;
import org.opensearch.neuralsearch.processor.rerank.RerankProcessor;
import org.opensearch.neuralsearch.processor.rerank.RerankType;
import org.opensearch.neuralsearch.processor.rerank.context.ContextSourceFetcher;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.profile.SearchProfileShardResults;

public abstract class RescoringRerankProcessor
extends RerankProcessor {
    public RescoringRerankProcessor(RerankType type, String description, String tag, boolean ignoreFailure, List<ContextSourceFetcher> contextSourceFetchers) {
        super(type, description, tag, ignoreFailure, contextSourceFetchers);
    }

    public abstract void rescoreSearchResponse(SearchResponse var1, Map<String, Object> var2, ActionListener<List<Float>> var3);

    @Override
    public void rerank(SearchResponse searchResponse, Map<String, Object> rerankingContext, ActionListener<SearchResponse> listener) {
        try {
            if (searchResponse.getHits().getTotalHits().value() == 0L) {
                listener.onResponse((Object)searchResponse);
                return;
            }
            this.rescoreSearchResponse(searchResponse, rerankingContext, (ActionListener<List<Float>>)ActionListener.wrap(scores -> {
                SearchHit[] hits = searchResponse.getHits().getHits();
                if (scores == null) {
                    throw new IllegalStateException("scores cannot be null");
                }
                if (hits.length != scores.size()) {
                    throw new IllegalStateException("scores and hits are not the same length");
                }
                for (int i = 0; i < hits.length; ++i) {
                    hits[i].score(((Float)scores.get(i)).floatValue());
                }
                Collections.sort(Arrays.asList(hits), (hit1, hit2) -> Float.compare(hit2.getScore(), hit1.getScore()));
                SearchHits newHits = new SearchHits(hits, searchResponse.getHits().getTotalHits(), hits[0].getScore(), searchResponse.getHits().getSortFields(), searchResponse.getHits().getCollapseField(), searchResponse.getHits().getCollapseValues());
                SearchResponseSections newInternalResponse = new SearchResponseSections(newHits, searchResponse.getAggregations(), searchResponse.getSuggest(), searchResponse.isTimedOut(), searchResponse.isTerminatedEarly(), new SearchProfileShardResults(searchResponse.getProfileResults()), searchResponse.getNumReducePhases(), searchResponse.getInternalResponse().getSearchExtBuilders());
                SearchResponse newResponse = new SearchResponse(newInternalResponse, searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), searchResponse.getTook().millis(), searchResponse.getPhaseTook(), searchResponse.getShardFailures(), searchResponse.getClusters(), searchResponse.pointInTimeId());
                listener.onResponse((Object)newResponse);
            }, e -> listener.onFailure(e)));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }
}

