/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryAction;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryInput;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLUpdateMemoryAction
extends BaseRestHandler {
    private static final String ML_UPDATE_MEMORY_ACTION = "ml_update_memory_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateMemoryAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_MEMORY_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/{memory_type}/{memory_id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        MLUpdateMemoryRequest mlUpdateMemoryRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUpdateMemoryAction.INSTANCE, (ActionRequest)mlUpdateMemoryRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLUpdateMemoryRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new IllegalArgumentException("Update memory request has empty body");
        }
        String memoryContainerId = RestActionUtils.getParameterId(request, "memory_container_id");
        String memoryTypeStr = RestActionUtils.getParameterId(request, "memory_type");
        MemoryType memoryType = MemoryType.fromString((String)memoryTypeStr);
        String memoryId = RestActionUtils.getParameterId(request, "memory_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLUpdateMemoryInput mlUpdateMemoryInput = MLUpdateMemoryInput.parse((XContentParser)parser);
        return MLUpdateMemoryRequest.builder().memoryContainerId(memoryContainerId).memoryType(memoryType).memoryId(memoryId).mlUpdateMemoryInput(mlUpdateMemoryInput).build();
    }
}

