"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class PolicyService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend Put Policy API
     */
    _defineProperty(this, "putPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        let method = "ism.putPolicy";
        let params = {
          policyId: id,
          ifSeqNo: seqNo,
          ifPrimaryTerm: primaryTerm,
          body: JSON.stringify(request.body)
        };
        if (seqNo === undefined || primaryTerm === undefined) {
          method = "ism.createPolicy";
          params = {
            policyId: id,
            body: JSON.stringify(request.body)
          };
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const putPolicyResponse = await callWithRequest(method, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: putPolicyResponse
          }
        });
      } catch (err) {
        console.error("Index Management - PolicyService - putPolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Delete Policy API
     */
    _defineProperty(this, "deletePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deletePolicyResponse = await callWithRequest("ism.deletePolicy", params);
        if (deletePolicyResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deletePolicyResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        console.error("Index Management - PolicyService - deletePolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Get Policy API
     */
    _defineProperty(this, "getPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getPolicy", params);
        const policy = _lodash.default.get(getResponse, "policy", null);
        const seqNo = _lodash.default.get(getResponse, "_seq_no");
        const primaryTerm = _lodash.default.get(getResponse, "_primary_term");
        if (policy) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                id,
                seqNo: seqNo,
                primaryTerm: primaryTerm,
                policy: policy
              }
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load policy"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - PolicyService - getPolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getPolicies", async (context, request, response) => {
      try {
        const {
          from = 0,
          size = 20,
          search,
          sortDirection = "desc",
          sortField = "id"
        } = request.query;
        const policySorts = {
          id: "policy.policy_id.keyword",
          "policy.policy.description": "policy.description.keyword",
          "policy.policy.last_updated_time": "policy.last_updated_time"
        };
        const params = {
          from,
          size,
          sortOrder: sortDirection,
          sortField: policySorts[sortField] || policySorts.id,
          queryString: search.trim() ? `*${search.trim().split(" ").join("* *")}*` : "*"
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getPolicies", params);
        const policies = getResponse.policies.map(p => ({
          seqNo: p._seq_no,
          primaryTerm: p._primary_term,
          id: p._id,
          policy: p.policy
        }));
        const totalPolicies = getResponse.total_policies;
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              policies: policies,
              totalPolicies
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                policies: [],
                totalPolicies: 0
              }
            }
          });
        }
        console.error("Index Management - PolicyService - getPolicies", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = PolicyService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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