/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.routing;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.plus.Version;
import net.osmand.plus.routing.RouteCalculationParams;
import net.osmand.plus.routing.RouteCalculationResult;
import net.osmand.plus.routing.RouteDirectionInfo;
import net.osmand.router.GeneralRouter;
import net.osmand.router.PrecalculatedRouteDirection;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.router.TurnType;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RouteProvider {
    private static final Log log = PlatformUtil.getLog(RouteProvider.class);
    private static final String OSMAND_ROUTER = "OsmAndRouter";

    private static Location createLocation(GPXUtilities.WptPt pt) {
        Location loc = new Location("OsmandRouteProvider");
        loc.setLatitude(pt.lat);
        loc.setLongitude(pt.lon);
        loc.setSpeed((float)pt.speed);
        if (!Double.isNaN(pt.ele)) {
            loc.setAltitude(pt.ele);
        }
        loc.setTime(pt.time);
        if (!Double.isNaN(pt.hdop)) {
            loc.setAccuracy((float)pt.hdop);
        }
        return loc;
    }

    public RouteCalculationResult calculateRouteImpl(RouteCalculationParams params) {
        long time = System.currentTimeMillis();
        if (params.start != null && params.end != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Start finding route from " + params.start + " to " + params.end + " using " + params.type.getName()));
            }
            try {
                boolean calcGPXRoute;
                boolean bl = calcGPXRoute = params.gpxRoute != null && !params.gpxRoute.points.isEmpty();
                RouteCalculationResult res = calcGPXRoute && !params.gpxRoute.calculateOsmAndRoute ? this.calculateGpxRoute(params) : (params.type == RouteService.OSMAND ? this.findVectorMapsRoute(params, calcGPXRoute) : (params.type == RouteService.YOURS ? this.findYOURSRoute(params) : (params.type == RouteService.OSRM ? this.findOSRMRoute(params) : (params.type == RouteService.STRAIGHT ? this.findStraightRoute(params) : new RouteCalculationResult("Selected route service is not available")))));
                if (log.isInfoEnabled()) {
                    log.info((Object)("Finding route contained " + res.getImmutableAllLocations().size() + " points for " + (System.currentTimeMillis() - time) + " ms"));
                }
                return res;
            }
            catch (IOException e) {
                log.error((Object)"Failed to find route ", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)"Failed to find route ", (Throwable)e);
            }
            catch (SAXException e) {
                log.error((Object)"Failed to find route ", (Throwable)e);
            }
        }
        return new RouteCalculationResult(null);
    }

    public RouteCalculationResult recalculatePartOfflineRoute(RouteCalculationResult res, RouteCalculationParams params) {
        RouteCalculationResult rcr = params.previousToRecalculate;
        ArrayList<Location> locs = new ArrayList<Location>(rcr.getRouteLocations());
        try {
            int[] startI = new int[]{0};
            int[] endI = new int[]{locs.size()};
            locs = this.findStartAndEndLocationsFromRoute(locs, params.start, params.end, startI, endI);
            List<RouteDirectionInfo> directions = this.calcDirections(startI, endI, rcr.getRouteDirections());
            this.insertInitialSegment(params, locs, directions, true);
            res = new RouteCalculationResult(locs, directions, params, null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return res;
    }

    private RouteCalculationResult calculateGpxRoute(RouteCalculationParams routeParams) throws IOException {
        GPXRouteParams gpxParams = routeParams.gpxRoute;
        if (routeParams.gpxRoute.useIntermediatePointsRTE) {
            return this.calculateOsmAndRouteWithIntermediatePoints(routeParams, gpxParams.points);
        }
        int[] startI = new int[]{0};
        int[] endI = new int[]{gpxParams.points.size()};
        List<Location> gpxRoute = routeParams.gpxRoute.passWholeRoute ? gpxParams.points : this.findStartAndEndLocationsFromRoute(gpxParams.points, routeParams.start, routeParams.end, startI, endI);
        List<RouteDirectionInfo> inputDirections = gpxParams.directions;
        List<RouteDirectionInfo> gpxDirections = this.calcDirections(startI, endI, inputDirections);
        boolean calculateOsmAndRouteParts = gpxParams.calculateOsmAndRouteParts;
        this.insertInitialSegment(routeParams, gpxRoute, gpxDirections, calculateOsmAndRouteParts);
        this.insertFinalSegment(routeParams, gpxRoute, gpxDirections, calculateOsmAndRouteParts);
        for (RouteDirectionInfo info : gpxDirections) {
            info.distance = 0;
            info.afterLeftTime = 0;
        }
        RouteCalculationResult res = new RouteCalculationResult(gpxRoute, gpxDirections, routeParams, gpxParams == null ? null : gpxParams.wpt);
        return res;
    }

    private RouteCalculationResult calculateOsmAndRouteWithIntermediatePoints(RouteCalculationParams routeParams, List<Location> intermediates) throws IOException {
        int i;
        RouteCalculationParams rp = new RouteCalculationParams();
        rp.calculationProgress = routeParams.calculationProgress;
        rp.ctx = routeParams.ctx;
        rp.mode = routeParams.mode;
        rp.start = routeParams.start;
        rp.end = routeParams.end;
        rp.leftSide = routeParams.leftSide;
        rp.type = routeParams.type;
        rp.fast = routeParams.fast;
        rp.onlyStartPointChanged = routeParams.onlyStartPointChanged;
        rp.previousToRecalculate = routeParams.previousToRecalculate;
        rp.intermediates = new ArrayList<LatLon>();
        int closest = 0;
        double maxDist = Double.POSITIVE_INFINITY;
        for (i = 0; i < intermediates.size(); ++i) {
            Location loc = intermediates.get(i);
            double dist = MapUtils.getDistance(loc.getLatitude(), loc.getLongitude(), rp.start.getLatitude(), rp.start.getLongitude());
            if (!(dist <= maxDist)) continue;
            closest = i;
            maxDist = dist;
        }
        for (i = closest; i < intermediates.size(); ++i) {
            Location w = intermediates.get(i);
            rp.intermediates.add(new LatLon(w.getLatitude(), w.getLongitude()));
        }
        return this.findVectorMapsRoute(rp, false);
    }

    private List<RouteDirectionInfo> calcDirections(int[] startI, int[] endI, List<RouteDirectionInfo> inputDirections) {
        ArrayList<RouteDirectionInfo> directions = new ArrayList<RouteDirectionInfo>();
        if (inputDirections != null) {
            for (RouteDirectionInfo info : inputDirections) {
                if (info.routePointOffset < startI[0] || info.routePointOffset >= endI[0]) continue;
                RouteDirectionInfo ch = new RouteDirectionInfo(info.getAverageSpeed(), info.getTurnType());
                ch.routePointOffset = info.routePointOffset - startI[0];
                if (info.routeEndPointOffset != 0) {
                    ch.routeEndPointOffset = info.routeEndPointOffset - startI[0];
                }
                ch.setDescriptionRoute(info.getDescriptionRoutePart());
                directions.add(ch);
            }
        }
        return directions;
    }

    private void insertFinalSegment(RouteCalculationParams routeParams, List<Location> points, List<RouteDirectionInfo> directions, boolean calculateOsmAndRouteParts) {
        if (points.size() > 0) {
            Location routeEnd = points.get(points.size() - 1);
            LatLon e = routeEnd == null ? null : new LatLon(routeEnd.getLatitude(), routeEnd.getLongitude());
            LatLon finalEnd = routeParams.end;
            if (finalEnd != null && MapUtils.getDistance(finalEnd, e) > 60.0) {
                List<RouteDirectionInfo> dt;
                List<Object> loct;
                RouteCalculationResult newRes = null;
                if (calculateOsmAndRouteParts) {
                    newRes = this.findOfflineRouteSegment(routeParams, routeEnd, finalEnd);
                }
                if (newRes != null && newRes.isCalculated()) {
                    loct = newRes.getImmutableAllLocations();
                    dt = newRes.getImmutableAllDirections();
                } else {
                    loct = new ArrayList();
                    Location l = new Location("");
                    l.setLatitude(finalEnd.getLatitude());
                    l.setLongitude(finalEnd.getLongitude());
                    loct.add(l);
                    dt = new ArrayList<RouteDirectionInfo>();
                }
                for (RouteDirectionInfo i : dt) {
                    i.routePointOffset += points.size();
                }
                points.addAll(loct);
                directions.addAll(dt);
            }
        }
    }

    public void insertInitialSegment(RouteCalculationParams routeParams, List<Location> points, List<RouteDirectionInfo> directions, boolean calculateOsmAndRouteParts) {
        Location realStart = routeParams.start;
        if (realStart != null && points.size() > 0 && realStart.distanceTo(points.get(0)) > 60.0f) {
            List<RouteDirectionInfo> dt;
            List<Object> loct;
            Location trackStart = points.get(0);
            RouteCalculationResult newRes = null;
            if (calculateOsmAndRouteParts) {
                LatLon end = new LatLon(trackStart.getLatitude(), trackStart.getLongitude());
                newRes = this.findOfflineRouteSegment(routeParams, realStart, end);
            }
            if (newRes != null && newRes.isCalculated()) {
                loct = newRes.getImmutableAllLocations();
                dt = newRes.getImmutableAllDirections();
            } else {
                loct = new ArrayList<Location>();
                loct.add(realStart);
                dt = new ArrayList<RouteDirectionInfo>();
            }
            points.addAll(0, loct);
            directions.addAll(0, dt);
            for (int i = dt.size(); i < directions.size(); ++i) {
                directions.get((int)i).routePointOffset += loct.size();
            }
        }
    }

    private RouteCalculationResult findOfflineRouteSegment(RouteCalculationParams rParams, Location start, LatLon end) {
        RouteCalculationParams newParams = new RouteCalculationParams();
        newParams.start = start;
        newParams.end = end;
        newParams.ctx = rParams.ctx;
        newParams.calculationProgress = rParams.calculationProgress;
        newParams.mode = rParams.mode;
        newParams.type = RouteService.OSMAND;
        newParams.leftSide = rParams.leftSide;
        RouteCalculationResult newRes = null;
        try {
            newRes = this.findVectorMapsRoute(newParams, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newRes;
    }

    private ArrayList<Location> findStartAndEndLocationsFromRoute(List<Location> route, Location startLoc, LatLon endLoc, int[] startI, int[] endI) {
        float minDist = 2.1474836E9f;
        int start = 0;
        int end = route.size();
        if (startLoc != null) {
            for (int i = 0; i < route.size(); ++i) {
                float d = route.get(i).distanceTo(startLoc);
                if (!(d < minDist)) continue;
                start = i;
                minDist = d;
            }
        } else {
            startLoc = route.get(0);
        }
        Location l = new Location("temp");
        l.setLatitude(endLoc.getLatitude());
        l.setLongitude(endLoc.getLongitude());
        minDist = 2.1474836E9f;
        for (int i = route.size() - 1; i >= start; --i) {
            float d = route.get(i).distanceTo(l);
            if (!(d < minDist)) continue;
            end = i + 1;
            minDist = d - 40.0f;
        }
        ArrayList<Location> sublist = new ArrayList<Location>(route.subList(start, end));
        if (startI != null) {
            startI[0] = start;
        }
        if (endI != null) {
            endI[0] = end;
        }
        return sublist;
    }

    protected String getString(OsmWindow ctx, int resId) {
        if (ctx == null) {
            return "";
        }
        return ctx.getString(resId);
    }

    protected RouteCalculationResult findYOURSRoute(RouteCalculationParams params) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        ArrayList<Location> res = new ArrayList<Location>();
        StringBuilder uri = new StringBuilder();
        uri.append("http://www.yournavigation.org/api/1.0/gosmore.php?format=kml");
        uri.append("&flat=").append(params.start.getLatitude());
        uri.append("&flon=").append(params.start.getLongitude());
        uri.append("&tlat=").append(params.end.getLatitude());
        uri.append("&tlon=").append(params.end.getLongitude());
        if (params.mode.isDerivedRoutingFrom(ApplicationMode.BICYCLE)) {
            uri.append("&v=bicycle");
        } else if (params.mode.isDerivedRoutingFrom(ApplicationMode.PEDESTRIAN)) {
            uri.append("&v=foot");
        } else if (params.mode.isDerivedRoutingFrom(ApplicationMode.CAR)) {
            uri.append("&v=motorcar");
        } else {
            return this.applicationModeNotSupported(params);
        }
        uri.append("&fast=").append(params.fast ? "1" : "0").append("&layer=mapnik");
        log.info((Object)("URL route " + uri));
        HttpURLConnection connection = NetworkUtils.getHttpURLConnection(uri.toString());
        connection.setRequestProperty("User-Agent", Version.getFullVersion(params.ctx));
        DocumentBuilder dom = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dom.parse(connection.getInputStream());
        NodeList list = doc.getElementsByTagName("coordinates");
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String str = item.getFirstChild().getNodeValue();
            if (str == null) continue;
            int st = 0;
            int next = 0;
            while ((next = str.indexOf(10, st)) != -1) {
                String coordinate = str.substring(st, next + 1);
                int s = coordinate.indexOf(44);
                if (s != -1) {
                    try {
                        double lon = Double.parseDouble(coordinate.substring(0, s));
                        double lat = Double.parseDouble(coordinate.substring(s + 1));
                        Location l = new Location("router");
                        l.setLatitude(lat);
                        l.setLongitude(lon);
                        res.add(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                st = next + 1;
            }
        }
        if (list.getLength() == 0 && doc.getChildNodes().getLength() == 1) {
            Node item = doc.getChildNodes().item(0);
            return new RouteCalculationResult(item.getNodeValue());
        }
        params.intermediates = null;
        return new RouteCalculationResult(res, null, params, null);
    }

    protected RouteCalculationResult findVectorMapsRoute(RouteCalculationParams params, boolean calcGPXRoute) throws IOException {
        int bottomY;
        int leftX;
        BinaryMapIndexReader[] files = params.ctx.getResourceManager().getRoutingMapFiles();
        RoutePlannerFrontEnd router = new RoutePlannerFrontEnd(false);
        OsmandSettings settings = params.ctx.getSettings();
        router.setUseFastRecalculation(settings.USE_FAST_RECALCULATION.get());
        RoutingConfiguration.Builder config = params.ctx.getDefaultRoutingConfig();
        GeneralRouter generalRouter = OsmWindow.getRouter(config, params.mode);
        if (generalRouter == null) {
            return this.applicationModeNotSupported(params);
        }
        RoutingConfiguration cf = this.initOsmAndRoutingConfig(config, params, settings, generalRouter);
        if (cf == null) {
            return this.applicationModeNotSupported(params);
        }
        PrecalculatedRouteDirection precalculated = null;
        if (calcGPXRoute) {
            ArrayList<Location> sublist = this.findStartAndEndLocationsFromRoute(params.gpxRoute.points, params.start, params.end, null, null);
            LatLon[] latLon = new LatLon[sublist.size()];
            for (int k = 0; k < latLon.length; ++k) {
                latLon[k] = new LatLon(sublist.get(k).getLatitude(), sublist.get(k).getLongitude());
            }
            precalculated = PrecalculatedRouteDirection.build(latLon, generalRouter.getMaxDefaultSpeed());
            precalculated.setFollowNext(true);
        }
        int rightX = leftX = MapUtils.get31TileNumberX(params.start.getLongitude());
        int topY = bottomY = MapUtils.get31TileNumberY(params.start.getLatitude());
        if (params.intermediates != null) {
            for (LatLon l : params.intermediates) {
                leftX = Math.min(MapUtils.get31TileNumberX(l.getLongitude()), leftX);
                rightX = Math.max(MapUtils.get31TileNumberX(l.getLongitude()), rightX);
                bottomY = Math.max(MapUtils.get31TileNumberY(l.getLatitude()), bottomY);
                topY = Math.min(MapUtils.get31TileNumberY(l.getLatitude()), topY);
            }
        }
        LatLon l = params.end;
        leftX = Math.min(MapUtils.get31TileNumberX(l.getLongitude()), leftX);
        rightX = Math.max(MapUtils.get31TileNumberX(l.getLongitude()), rightX);
        bottomY = Math.max(MapUtils.get31TileNumberY(l.getLatitude()), bottomY);
        topY = Math.min(MapUtils.get31TileNumberY(l.getLatitude()), topY);
        RoutingContext ctx = router.buildRoutingContext(cf, files, RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
        RoutingContext complexCtx = null;
        boolean complex = params.mode.isDerivedRoutingFrom(ApplicationMode.CAR) && settings.DISABLE_COMPLEX_ROUTING.get() == false && precalculated == null;
        ctx.leftSideNavigation = params.leftSide;
        ctx.calculationProgress = params.calculationProgress;
        if (params.previousToRecalculate != null && params.onlyStartPointChanged) {
            int currentRoute = params.previousToRecalculate.getCurrentRoute();
            List<RouteSegmentResult> originalRoute = params.previousToRecalculate.getOriginalRoute();
            if (originalRoute != null && currentRoute < originalRoute.size()) {
                ctx.previouslyCalculatedRoute = originalRoute.subList(currentRoute, originalRoute.size());
            }
        }
        if (complex && router.getRecalculationEnd(ctx) != null) {
            complex = false;
        }
        if (complex) {
            complexCtx = router.buildRoutingContext(cf, files, RoutePlannerFrontEnd.RouteCalculationMode.COMPLEX);
            complexCtx.calculationProgress = params.calculationProgress;
            complexCtx.leftSideNavigation = params.leftSide;
            complexCtx.previouslyCalculatedRoute = ctx.previouslyCalculatedRoute;
        }
        LatLon st = new LatLon(params.start.getLatitude(), params.start.getLongitude());
        LatLon en = new LatLon(params.end.getLatitude(), params.end.getLongitude());
        ArrayList<LatLon> inters = new ArrayList();
        if (params.intermediates != null) {
            inters = new ArrayList<LatLon>(params.intermediates);
        }
        return this.calcOfflineRouteImpl(params, router, ctx, complexCtx, st, en, inters, precalculated);
    }

    private RoutingConfiguration initOsmAndRoutingConfig(RoutingConfiguration.Builder config, RouteCalculationParams params, OsmandSettings settings, GeneralRouter generalRouter) throws IOException, FileNotFoundException {
        GeneralRouter.GeneralRouterProfile p;
        if (params.mode.isDerivedRoutingFrom(ApplicationMode.BICYCLE)) {
            p = GeneralRouter.GeneralRouterProfile.BICYCLE;
        } else if (params.mode.isDerivedRoutingFrom(ApplicationMode.PEDESTRIAN)) {
            p = GeneralRouter.GeneralRouterProfile.PEDESTRIAN;
        } else if (params.mode.isDerivedRoutingFrom(ApplicationMode.CAR)) {
            p = GeneralRouter.GeneralRouterProfile.CAR;
        } else {
            return null;
        }
        LinkedHashMap<String, String> paramsR = new LinkedHashMap<String, String>();
        for (Map.Entry<String, GeneralRouter.RoutingParameter> e : generalRouter.getParameters().entrySet()) {
            String vl;
            String key = e.getKey();
            GeneralRouter.RoutingParameter pr = e.getValue();
            if (key.equals("short_way")) {
                Boolean bool = settings.FAST_ROUTE_MODE.getModeValue(params.mode) == false;
                vl = bool != false ? "true" : null;
            } else {
                OsmandSettings.CommonPreference<Boolean> pref;
                Boolean bool;
                vl = pr.getType() == GeneralRouter.RoutingParameterType.BOOLEAN ? ((bool = (pref = settings.getCustomRoutingBooleanProperty(key)).getModeValue(params.mode)) != false ? "true" : null) : settings.getCustomRoutingProperty(key, "").getModeValue(params.mode);
            }
            if (vl == null || vl.length() <= 0) continue;
            paramsR.put(key, vl);
        }
        float mb = 1048576.0f;
        Runtime rt = Runtime.getRuntime();
        int memoryLimit = (int)(0.95 * (double)(rt.maxMemory() - rt.totalMemory() + rt.freeMemory()) / (double)mb);
        log.warn((Object)("Use " + memoryLimit + " MB Free " + (float)rt.freeMemory() / mb + " of " + (float)rt.totalMemory() / mb + " max " + (float)rt.maxMemory() / mb));
        RoutingConfiguration cf = config.build(p.name().toLowerCase(), params.start.hasBearing() ? Double.valueOf((double)params.start.getBearing() / 180.0 * Math.PI) : null, memoryLimit, paramsR);
        return cf;
    }

    private RouteCalculationResult calcOfflineRouteImpl(final RouteCalculationParams params, RoutePlannerFrontEnd router, RoutingContext ctx, RoutingContext complexCtx, LatLon st, LatLon en, List<LatLon> inters, PrecalculatedRouteDirection precalculated) throws IOException {
        try {
            List<RouteSegmentResult> result;
            if (complexCtx != null) {
                try {
                    result = router.searchRoute(complexCtx, st, en, inters, precalculated);
                    ctx = complexCtx;
                }
                catch (RuntimeException e) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(params.ctx.getDrawPanel(), params.ctx.getString(1278) + " " + e.getMessage());
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    result = router.searchRoute(ctx, st, en, inters);
                }
            } else {
                result = router.searchRoute(ctx, st, en, inters);
            }
            if (result == null || result.isEmpty()) {
                if (ctx.calculationProgress.segmentNotFound == 0) {
                    return new RouteCalculationResult(params.ctx.getString(936));
                }
                if (ctx.calculationProgress.segmentNotFound == inters.size() + 1) {
                    return new RouteCalculationResult(params.ctx.getString(1034));
                }
                if (ctx.calculationProgress.segmentNotFound > 0) {
                    return new RouteCalculationResult(params.ctx.getString(1035, "'" + ctx.calculationProgress.segmentNotFound + "'"));
                }
                if (ctx.calculationProgress.directSegmentQueueSize == 0) {
                    return new RouteCalculationResult("Route can not be found from start point (" + ctx.calculationProgress.distanceFromBegin / 1000.0f + " km)");
                }
                if (ctx.calculationProgress.reverseSegmentQueueSize == 0) {
                    return new RouteCalculationResult("Route can not be found from end point (" + ctx.calculationProgress.distanceFromEnd / 1000.0f + " km)");
                }
                if (ctx.calculationProgress.isCancelled) {
                    return this.interrupted();
                }
                return this.emptyResult();
            }
            RouteCalculationResult res = new RouteCalculationResult(result, params.start, params.end, params.intermediates, params.ctx, params.leftSide, ctx.routingTime, params.gpxRoute == null ? null : params.gpxRoute.wpt);
            return res;
        }
        catch (RuntimeException e) {
            return new RouteCalculationResult(e.getMessage());
        }
        catch (InterruptedException e) {
            return this.interrupted();
        }
        catch (OutOfMemoryError e) {
            int max = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
            int avl = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
            String s = " (" + avl + " MB available of " + max + ") ";
            return new RouteCalculationResult("Not enough process memory " + s);
        }
    }

    private RouteCalculationResult applicationModeNotSupported(RouteCalculationParams params) {
        return new RouteCalculationResult("Application mode '" + params.mode.toHumanStringCtx() + "'is not supported.");
    }

    private RouteCalculationResult interrupted() {
        return new RouteCalculationResult("Route calculation was interrupted");
    }

    private RouteCalculationResult emptyResult() {
        return new RouteCalculationResult("Empty result");
    }

    private static List<RouteDirectionInfo> parseOsmAndGPXRoute(List<Location> res, GPXUtilities.GPXFile gpxFile, boolean osmandRouter, boolean leftSide, float defSpeed) {
        ArrayList<RouteDirectionInfo> directions = null;
        if (!osmandRouter) {
            for (GPXUtilities.WptPt pt : gpxFile.points) {
                res.add(RouteProvider.createLocation(pt));
            }
        } else {
            for (GPXUtilities.Track tr : gpxFile.tracks) {
                for (GPXUtilities.TrkSegment ts : tr.segments) {
                    for (GPXUtilities.WptPt p : ts.points) {
                        res.add(RouteProvider.createLocation(p));
                    }
                }
            }
        }
        float[] distanceToEnd = new float[res.size()];
        for (int i = res.size() - 2; i >= 0; --i) {
            distanceToEnd[i] = distanceToEnd[i + 1] + res.get(i).distanceTo(res.get(i + 1));
        }
        GPXUtilities.Route route = null;
        if (gpxFile.routes.size() > 0) {
            route = gpxFile.routes.get(0);
        }
        RouteDirectionInfo previous = null;
        if (route != null && route.points.size() > 0) {
            directions = new ArrayList<RouteDirectionInfo>();
            Iterator<GPXUtilities.WptPt> iterator = route.points.iterator();
            while (iterator.hasNext()) {
                GPXUtilities.WptPt item = iterator.next();
                try {
                    String stype;
                    String stime = item.getExtensionsToRead().get("time");
                    int time = 0;
                    if (stime != null) {
                        time = Integer.parseInt(stime);
                    }
                    int offset = Integer.parseInt(item.getExtensionsToRead().get("offset"));
                    if (directions.size() > 0) {
                        RouteDirectionInfo last = (RouteDirectionInfo)directions.get(directions.size() - 1);
                        last.setAverageSpeed((distanceToEnd[last.routePointOffset] - distanceToEnd[offset]) / last.getAverageSpeed());
                        last.distance = (int)(distanceToEnd[last.routePointOffset] - distanceToEnd[offset]);
                    }
                    float avgSpeed = time;
                    if (!iterator.hasNext() && time > 0) {
                        avgSpeed = distanceToEnd[offset] / (float)time;
                    }
                    TurnType turnType = (stype = item.getExtensionsToRead().get("turn")) != null ? TurnType.fromString(stype.toUpperCase(), leftSide) : TurnType.straight();
                    String sturn = item.getExtensionsToRead().get("turn-angle");
                    if (sturn != null) {
                        turnType.setTurnAngle((float)Double.parseDouble(sturn));
                    }
                    RouteDirectionInfo dirInfo = new RouteDirectionInfo(avgSpeed, turnType);
                    dirInfo.setDescriptionRoute(item.desc);
                    dirInfo.routePointOffset = offset;
                    if (previous != null && 1 != previous.getTurnType().getValue() && !osmandRouter && previous.routePointOffset > 0) {
                        float paz = res.get(previous.routePointOffset - 1).bearingTo(res.get(previous.routePointOffset));
                        float caz = previous.getTurnType().isRoundAbout() && dirInfo.routePointOffset < res.size() - 1 ? res.get(dirInfo.routePointOffset).bearingTo(res.get(dirInfo.routePointOffset + 1)) : res.get(dirInfo.routePointOffset - 1).bearingTo(res.get(dirInfo.routePointOffset));
                        float angle = caz - paz;
                        if (angle < 0.0f) {
                            angle += 360.0f;
                        } else if (angle > 360.0f) {
                            angle -= 360.0f;
                        }
                        angle += 75.0f;
                        if (previous.getTurnType().getTurnAngle() < 0.5f) {
                            previous.getTurnType().setTurnAngle(angle);
                        }
                    }
                    directions.add(dirInfo);
                    previous = dirInfo;
                }
                catch (NumberFormatException e) {
                    log.info((Object)"Exception", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.info((Object)"Exception", (Throwable)e);
                }
            }
        }
        if (previous != null && 1 != previous.getTurnType().getValue() && previous.routePointOffset > 0 && previous.routePointOffset < res.size() - 1) {
            float paz = res.get(previous.routePointOffset - 1).bearingTo(res.get(previous.routePointOffset));
            float caz = res.get(previous.routePointOffset).bearingTo(res.get(res.size() - 1));
            float angle = caz - paz;
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            if (previous.getTurnType().getTurnAngle() < 0.5f) {
                previous.getTurnType().setTurnAngle(angle);
            }
        }
        return directions;
    }

    protected RouteCalculationResult findORSRoute(RouteCalculationParams params) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        ArrayList<Location> res = new ArrayList<Location>();
        String rpref = "Fastest";
        if (params.mode.isDerivedRoutingFrom(ApplicationMode.PEDESTRIAN)) {
            rpref = "Pedestrian";
        } else if (params.mode.isDerivedRoutingFrom(ApplicationMode.BICYCLE)) {
            rpref = "Bicycle";
        } else if (params.mode.isDerivedRoutingFrom(ApplicationMode.CAR)) {
            if (!params.fast) {
                rpref = "Shortest";
            }
        } else {
            return this.applicationModeNotSupported(params);
        }
        StringBuilder request = new StringBuilder();
        request.append("http://openls.geog.uni-heidelberg.de/osm/eu/routing?").append("start=").append(params.start.getLongitude()).append(',').append(params.start.getLatitude()).append("&end=").append(params.end.getLongitude()).append(',').append(params.end.getLatitude()).append("&preference=").append(rpref);
        log.info((Object)("URL route " + request));
        HttpURLConnection connection = NetworkUtils.getHttpURLConnection(request.toString());
        connection.setRequestProperty("User-Agent", Version.getFullVersion(params.ctx));
        DocumentBuilder dom = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dom.parse(connection.getInputStream());
        NodeList list = doc.getElementsByTagName("xls:RouteGeometry");
        for (int i = 0; i < list.getLength(); ++i) {
            NodeList poslist = ((Element)list.item(i)).getElementsByTagName("gml:pos");
            for (int j = 0; j < poslist.getLength(); ++j) {
                String text = poslist.item(j).getFirstChild().getNodeValue();
                int s = text.indexOf(32);
                try {
                    double lon = Double.parseDouble(text.substring(0, s));
                    double lat = Double.parseDouble(text.substring(s + 1));
                    Location l = new Location("router");
                    l.setLatitude(lat);
                    l.setLongitude(lon);
                    res.add(l);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (list.getLength() == 0 && doc.getChildNodes().getLength() == 1) {
            Node item = doc.getChildNodes().item(0);
            return new RouteCalculationResult(item.getNodeValue());
        }
        params.intermediates = null;
        return new RouteCalculationResult(res, null, params, null);
    }

    public GPXUtilities.GPXFile createOsmandRouterGPX(RouteCalculationResult srcRoute, OsmWindow ctx) {
        TargetPointsHelper helper = ctx.getTargetPointsHelper();
        int currentRoute = srcRoute.currentRoute;
        List<Location> routeNodes = srcRoute.getImmutableAllLocations();
        List<RouteDirectionInfo> directionInfo = srcRoute.getImmutableAllDirections();
        int currentDirectionInfo = srcRoute.currentDirectionInfo;
        GPXUtilities.GPXFile gpx = new GPXUtilities.GPXFile();
        gpx.author = OSMAND_ROUTER;
        GPXUtilities.Track track = new GPXUtilities.Track();
        gpx.tracks.add(track);
        GPXUtilities.TrkSegment trkSegment = new GPXUtilities.TrkSegment();
        track.segments.add(trkSegment);
        int cRoute = currentRoute;
        int cDirInfo = currentDirectionInfo;
        GPXUtilities.WptPt startpoint = new GPXUtilities.WptPt();
        TargetPointsHelper.TargetPoint sc = helper.getPointToStart();
        if (sc != null) {
            startpoint.lon = sc.getLongitude();
            startpoint.lat = sc.getLatitude();
            trkSegment.points.add(startpoint);
        }
        for (int i = cRoute; i < routeNodes.size(); ++i) {
            Location loc = routeNodes.get(i);
            GPXUtilities.WptPt pt = new GPXUtilities.WptPt();
            pt.lat = loc.getLatitude();
            pt.lon = loc.getLongitude();
            if (loc.hasSpeed()) {
                pt.speed = loc.getSpeed();
            }
            if (loc.hasAltitude()) {
                pt.ele = loc.getAltitude();
            }
            if (loc.hasAccuracy()) {
                pt.hdop = loc.getAccuracy();
            }
            trkSegment.points.add(pt);
        }
        GPXUtilities.Route route = new GPXUtilities.Route();
        gpx.routes.add(route);
        for (int i = cDirInfo; i < directionInfo.size(); ++i) {
            RouteDirectionInfo dirInfo = directionInfo.get(i);
            if (dirInfo.routePointOffset < cRoute) continue;
            Location loc = routeNodes.get(dirInfo.routePointOffset);
            GPXUtilities.WptPt pt = new GPXUtilities.WptPt();
            pt.lat = loc.getLatitude();
            pt.lon = loc.getLongitude();
            pt.desc = dirInfo.getDescriptionRoute(ctx);
            Map<String, String> extensions = pt.getExtensionsToWrite();
            extensions.put("time", dirInfo.getExpectedTime() + "");
            int turnType = dirInfo.getTurnType().getValue();
            if (1 != turnType) {
                extensions.put("turn", dirInfo.getTurnType().toXmlString());
                extensions.put("turn-angle", dirInfo.getTurnType().getTurnAngle() + "");
            }
            extensions.put("offset", dirInfo.routePointOffset - cRoute + "");
            route.points.add(pt);
        }
        List<TargetPointsHelper.TargetPoint> ps = helper.getIntermediatePointsWithTarget();
        for (int k = 0; k < ps.size(); ++k) {
            GPXUtilities.WptPt pt = new GPXUtilities.WptPt();
            pt.lat = ps.get(k).getLatitude();
            pt.lon = ps.get(k).getLongitude();
            if (k < ps.size()) {
                pt.name = ps.get(k).getOnlyName() + "";
                if (k == ps.size() - 1) {
                    String target = ctx.getString(1178, "");
                    if (pt.name.startsWith(target)) {
                        pt.name = ctx.getString(1178, pt.name);
                    }
                } else {
                    String prefix = k + 1 + ". ";
                    if (Algorithms.isEmpty(pt.name)) {
                        pt.name = ctx.getString(1038, pt.name);
                    }
                    if (pt.name.startsWith(prefix)) {
                        pt.name = prefix + pt.name;
                    }
                }
                pt.desc = pt.name;
            }
            gpx.points.add(pt);
        }
        return gpx;
    }

    private void appendOSRMLoc(StringBuilder uri, LatLon il) {
        uri.append("&loc=").append(String.valueOf(il.getLatitude()));
        uri.append(",").append(String.valueOf(il.getLongitude()));
    }

    protected RouteCalculationResult findOSRMRoute(RouteCalculationParams params) throws MalformedURLException, IOException {
        String s;
        ArrayList<Location> res = new ArrayList<Location>();
        StringBuilder uri = new StringBuilder();
        String scheme = "";
        scheme = "http";
        uri.append(scheme + "://router.project-osrm.org/viaroute?alt=false");
        uri.append("&loc=").append(String.valueOf(params.start.getLatitude()));
        uri.append(",").append(String.valueOf(params.start.getLongitude()));
        if (params.intermediates != null && params.intermediates.size() > 0) {
            for (LatLon il : params.intermediates) {
                this.appendOSRMLoc(uri, il);
            }
        }
        this.appendOSRMLoc(uri, params.end);
        uri.append("&compression=false");
        log.info((Object)("URL route " + uri));
        HttpURLConnection connection = NetworkUtils.getHttpURLConnection(uri.toString());
        connection.setRequestProperty("User-Agent", Version.getFullVersion(params.ctx));
        StringBuilder content = new StringBuilder();
        BufferedReader rs = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((s = rs.readLine()) != null) {
            content.append(s);
        }
        try {
            JSONObject obj = new JSONObject(content.toString());
            int status = obj.getInt("status");
            if (status == 200) {
                JSONArray routeGeometry = obj.getJSONArray("route_geometry");
                for (int i = 0; i < routeGeometry.length(); ++i) {
                    double latitude = routeGeometry.getJSONArray(i).getDouble(0);
                    double longitude = routeGeometry.getJSONArray(i).getDouble(1);
                    Location loc = new Location("OsmandRouteProvider");
                    loc.setLatitude(latitude);
                    loc.setLongitude(longitude);
                    res.add(loc);
                }
            } else {
                new RouteCalculationResult(params.ctx.getString(1046));
            }
        }
        catch (JSONException e) {
            log.error((Object)("JSON Parsing went wrong. Content: " + content.toString()), (Throwable)e);
        }
        params.intermediates = null;
        return new RouteCalculationResult(res, null, params, null);
    }

    private RouteCalculationResult findStraightRoute(RouteCalculationParams params) {
        double[] lats = new double[]{params.start.getLatitude(), params.end.getLatitude()};
        double[] lons = new double[]{params.start.getLongitude(), params.end.getLongitude()};
        List<LatLon> intermediates = params.intermediates;
        ArrayList<Location> dots = new ArrayList<Location>();
        Location location = new Location(String.valueOf("start"));
        location.setLatitude(lats[0]);
        location.setLongitude(lons[0]);
        if (intermediates != null) {
            for (int i = 0; i < intermediates.size(); ++i) {
                location = new Location(String.valueOf(i));
                location.setLatitude(intermediates.get(i).getLatitude());
                location.setLongitude(intermediates.get(i).getLongitude());
                dots.add(location);
            }
        }
        location = new Location(String.valueOf("end"));
        location.setLatitude(lats[1]);
        location.setLongitude(lons[1]);
        dots.add(location);
        return new RouteCalculationResult(dots, null, params, null);
    }

    public static class GPXRouteParams {
        List<Location> points = new ArrayList<Location>();
        List<RouteDirectionInfo> directions;
        boolean calculateOsmAndRoute;
        boolean passWholeRoute;
        boolean calculateOsmAndRouteParts;
        boolean useIntermediatePointsRTE;
        private List<LocationPoint> wpt;

        public List<Location> getPoints() {
            return this.points;
        }

        public Location getStartPointForRoute() {
            if (!this.points.isEmpty()) {
                return this.points.get(0);
            }
            return null;
        }

        public Location getEndPointForRoute() {
            if (!this.points.isEmpty()) {
                return this.points.get(this.points.size());
            }
            return null;
        }

        public LatLon getLastPoint() {
            if (!this.points.isEmpty()) {
                Location l = this.points.get(this.points.size() - 1);
                LatLon point = new LatLon(l.getLatitude(), l.getLongitude());
                return point;
            }
            return null;
        }

        public GPXRouteParams prepareGPXFile(GPXRouteParamsBuilder builder) {
            GPXUtilities.GPXFile file = builder.file;
            boolean reverse = builder.reverse;
            this.passWholeRoute = builder.passWholeRoute;
            this.calculateOsmAndRouteParts = builder.calculateOsmAndRouteParts;
            this.useIntermediatePointsRTE = builder.useIntermediatePointsRTE;
            builder.calculateOsmAndRoute = false;
            if (!file.points.isEmpty()) {
                this.wpt = new ArrayList<GPXUtilities.WptPt>(file.points);
            }
            if (file.isCloudmadeRouteFile() || RouteProvider.OSMAND_ROUTER.equals(file.author)) {
                this.directions = RouteProvider.parseOsmAndGPXRoute(this.points, file, RouteProvider.OSMAND_ROUTER.equals(file.author), builder.leftSide, 10.0f);
                if (reverse) {
                    this.directions = null;
                    Collections.reverse(this.points);
                }
            } else {
                if (!this.useIntermediatePointsRTE) {
                    for (GPXUtilities.Track tr : file.tracks) {
                        for (GPXUtilities.TrkSegment tkSeg : tr.segments) {
                            for (GPXUtilities.WptPt pt : tkSeg.points) {
                                this.points.add(RouteProvider.createLocation(pt));
                            }
                        }
                    }
                }
                if (this.points.isEmpty()) {
                    for (GPXUtilities.Route rte : file.routes) {
                        for (GPXUtilities.WptPt pt : rte.points) {
                            this.points.add(RouteProvider.createLocation(pt));
                        }
                    }
                }
                if (reverse) {
                    Collections.reverse(this.points);
                }
            }
            return this;
        }
    }

    public static class GPXRouteParamsBuilder {
        boolean calculateOsmAndRoute = false;
        private final GPXUtilities.GPXFile file;
        private boolean reverse;
        private boolean leftSide;
        private boolean passWholeRoute;
        private boolean calculateOsmAndRouteParts;
        private boolean useIntermediatePointsRTE;

        public GPXRouteParamsBuilder(GPXUtilities.GPXFile file, OsmandSettings settings) {
            this.leftSide = settings.DRIVING_REGION.get().leftHandDriving;
            this.file = file;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public boolean isCalculateOsmAndRouteParts() {
            return this.calculateOsmAndRouteParts;
        }

        public void setCalculateOsmAndRouteParts(boolean calculateOsmAndRouteParts) {
            this.calculateOsmAndRouteParts = calculateOsmAndRouteParts;
        }

        public void setUseIntermediatePointsRTE(boolean useIntermediatePointsRTE) {
            this.useIntermediatePointsRTE = useIntermediatePointsRTE;
        }

        public boolean isUseIntermediatePointsRTE() {
            return this.useIntermediatePointsRTE;
        }

        public boolean isCalculateOsmAndRoute() {
            return this.calculateOsmAndRoute;
        }

        public void setCalculateOsmAndRoute(boolean calculateOsmAndRoute) {
            this.calculateOsmAndRoute = calculateOsmAndRoute;
        }

        public void setPassWholeRoute(boolean passWholeRoute) {
            this.passWholeRoute = passWholeRoute;
        }

        public boolean isPassWholeRoute() {
            return this.passWholeRoute;
        }

        public GPXRouteParams build(Location start, OsmandSettings settings) {
            GPXRouteParams res = new GPXRouteParams();
            res.prepareGPXFile(this);
            return res;
        }

        public void setReverse(boolean reverse) {
            this.reverse = reverse;
        }

        public GPXUtilities.GPXFile getFile() {
            return this.file;
        }

        public List<Location> getPoints() {
            GPXRouteParams copy = new GPXRouteParams();
            copy.prepareGPXFile(this);
            return copy.getPoints();
        }
    }

    public static enum RouteService {
        OSMAND("OsmAnd (offline)"),
        YOURS("YOURS"),
        OSRM("OSRM (only car)"),
        BROUTER("BRouter (offline)"),
        STRAIGHT("Straight line");

        private final String name;

        private RouteService(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOnline() {
            return this != OSMAND && this != BROUTER;
        }

        public boolean isAvailable(OsmWindow ctx) {
            return this != BROUTER;
        }

        public static RouteService[] getAvailableRouters(OsmWindow ctx) {
            ArrayList<RouteService> list = new ArrayList<RouteService>();
            for (RouteService r : RouteService.values()) {
                if (!r.isAvailable(ctx)) continue;
                list.add(r);
            }
            return list.toArray(new RouteService[list.size()]);
        }
    }
}

