/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tuple.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleBasicEntityIdentifierMapping;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleBasicValuedModelPart;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleEmbeddableValuedModelPart;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleEmbeddedEntityIdentifierMapping;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleEntityValuedModelPart;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleNonAggregatedEntityIdentifierMapping;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleType;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleTableGroupProducer
implements TableGroupProducer,
MappingType {
    private final String aliasStem;
    private final JavaType<?> javaTypeDescriptor;
    private final Map<String, ModelPart> modelParts;
    private final Set<String> compatibleTableExpressions;
    private final SqlTypedMapping[] sqlTypedMappings;
    private final int jdbcTypeCount;

    public AnonymousTupleTableGroupProducer(AnonymousTupleType<?> tupleType, String aliasStem, SqlTypedMapping[] sqlTypedMappings, FromClauseAccess fromClauseAccess) {
        ModelPart modelPart;
        this.aliasStem = aliasStem;
        this.javaTypeDescriptor = tupleType.getExpressibleJavaType();
        HashSet<String> compatibleTableExpressions = new HashSet<String>();
        this.sqlTypedMappings = sqlTypedMappings;
        compatibleTableExpressions.add("");
        int componentCount = tupleType.componentCount();
        LinkedHashMap<String, ModelPart> modelParts = CollectionHelper.linkedMapOfSize(componentCount);
        int selectionIndex = 0;
        for (int i = 0; i < componentCount && selectionIndex < sqlTypedMappings.length; selectionIndex += modelPart.getJdbcTypeCount(), ++i) {
            SqmBindableType<?> expressible = tupleType.get(i);
            SqmDomainType sqmType = expressible.getSqmType();
            String partName = tupleType.getComponentName(i);
            if (expressible instanceof PluralPersistentAttribute || !(sqmType instanceof BasicType)) {
                TableGroup tableGroup = fromClauseAccess.findTableGroup(tupleType.getComponentSourcePath(i));
                modelPart = AnonymousTupleTableGroupProducer.createModelPart(this, expressible, sqmType, sqlTypedMappings, selectionIndex, partName, partName, tableGroup == null ? null : this.getModelPart(tableGroup), compatibleTableExpressions, modelParts.size());
            } else {
                SqlTypedMapping sqlTypedMapping = sqlTypedMappings[selectionIndex];
                if (sqlTypedMapping instanceof SelectableMapping) {
                    SelectableMapping selectable = (SelectableMapping)sqlTypedMapping;
                    modelPart = new AnonymousTupleBasicValuedModelPart(this, partName, selectable, expressible, modelParts.size());
                    compatibleTableExpressions.add(selectable.getContainingTableExpression());
                } else {
                    modelPart = new AnonymousTupleBasicValuedModelPart(this, partName, partName, expressible, sqlTypedMappings[selectionIndex].getJdbcMapping(), modelParts.size());
                }
            }
            modelParts.put(partName, modelPart);
        }
        this.modelParts = modelParts;
        this.compatibleTableExpressions = compatibleTableExpressions;
        this.jdbcTypeCount = selectionIndex;
    }

    private ModelPart getModelPart(TableGroup tableGroup) {
        if (tableGroup instanceof PluralTableGroup) {
            tableGroup = ((PluralTableGroup)tableGroup).getElementTableGroup();
        }
        if (tableGroup instanceof LazyTableGroup && ((LazyTableGroup)tableGroup).getUnderlyingTableGroup() != null) {
            return ((LazyTableGroup)tableGroup).getUnderlyingTableGroup().getModelPart();
        }
        return tableGroup.getModelPart();
    }

    public static ModelPart createModelPart(MappingType mappingType, SqmExpressible<?> sqmExpressible, DomainType<?> domainType, SqlTypedMapping[] sqlTypedMappings, int selectionIndex, String selectionExpression, String partName, ModelPart existingModelPart, Set<String> compatibleTableExpressions, int fetchableIndex) {
        if (domainType instanceof EntityDomainType) {
            EntityIdentifierMapping newIdentifierMapping;
            EntityDomainType entityDomainType = (EntityDomainType)domainType;
            EntityValuedModelPart existingModelPartContainer = (EntityValuedModelPart)existingModelPart;
            EntityIdentifierMapping identifierMapping = existingModelPartContainer.getEntityMappingType().getIdentifierMapping();
            if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
                if (identifierMapping.getPartMappingType() instanceof ManagedMappingType) {
                    ManagedDomainType sqmPathType = (ManagedDomainType)entityDomainType.getIdentifierDescriptor().getPathType();
                    newIdentifierMapping = new AnonymousTupleEmbeddedEntityIdentifierMapping(sqmExpressible, sqlTypedMappings, selectionIndex, selectionExpression + "_" + identifierMapping.getAttributeName(), compatibleTableExpressions, sqmPathType.getAttributes(), domainType, (CompositeIdentifierMapping)identifierMapping);
                } else {
                    SqlTypedMapping sqlTypedMapping = sqlTypedMappings[selectionIndex];
                    if (sqlTypedMapping instanceof SelectableMapping) {
                        SelectableMapping selectable = (SelectableMapping)sqlTypedMapping;
                        newIdentifierMapping = new AnonymousTupleBasicEntityIdentifierMapping(mappingType, selectable, sqmExpressible, (BasicEntityIdentifierMapping)identifierMapping);
                        compatibleTableExpressions.add(selectable.getContainingTableExpression());
                    } else {
                        newIdentifierMapping = new AnonymousTupleBasicEntityIdentifierMapping(mappingType, selectionExpression + "_" + identifierMapping.getAttributeName(), sqmExpressible, sqlTypedMappings[selectionIndex].getJdbcMapping(), (BasicEntityIdentifierMapping)identifierMapping);
                    }
                }
            } else {
                ManagedDomainType sqmPathType = (ManagedDomainType)entityDomainType.getIdentifierDescriptor().getPathType();
                newIdentifierMapping = new AnonymousTupleNonAggregatedEntityIdentifierMapping(sqmExpressible, sqlTypedMappings, selectionIndex, selectionExpression, compatibleTableExpressions, sqmPathType.getAttributes(), domainType, selectionExpression, (NonAggregatedIdentifierMapping)identifierMapping);
            }
            if (existingModelPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)existingModelPart;
                compatibleTableExpressions.add(toOneAttributeMapping.getIdentifyingColumnsTableExpression());
            }
            return new AnonymousTupleEntityValuedModelPart(newIdentifierMapping, domainType, existingModelPartContainer, fetchableIndex);
        }
        if (domainType instanceof ManagedDomainType) {
            ManagedDomainType managedDomainType = (ManagedDomainType)domainType;
            return new AnonymousTupleEmbeddableValuedModelPart(sqmExpressible, sqlTypedMappings, selectionIndex, selectionExpression, compatibleTableExpressions, managedDomainType.getAttributes(), domainType, selectionExpression, (EmbeddableValuedModelPart)existingModelPart, fetchableIndex);
        }
        SqlTypedMapping sqlTypedMapping = sqlTypedMappings[selectionIndex];
        if (sqlTypedMapping instanceof SelectableMapping) {
            SelectableMapping selectable = (SelectableMapping)sqlTypedMapping;
            compatibleTableExpressions.add(selectable.getContainingTableExpression());
            return new AnonymousTupleBasicValuedModelPart(mappingType, partName, selectable, sqmExpressible, fetchableIndex);
        }
        return new AnonymousTupleBasicValuedModelPart(mappingType, partName, selectionExpression, sqmExpressible, sqlTypedMappings[selectionIndex].getJdbcMapping(), fetchableIndex);
    }

    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.modelParts.size());
        this.forEachSelectable((index, selectableMapping) -> columnNames.add(selectableMapping.getSelectionExpression()));
        return columnNames;
    }

    public Set<String> getCompatibleTableExpressions() {
        return this.compatibleTableExpressions;
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.javaTypeDescriptor;
    }

    @Override
    public String getPartName() {
        return null;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return null;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.modelParts.get(name);
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        int i = 0;
        for (Map.Entry<String, ModelPart> entry : this.modelParts.entrySet()) {
            consumer.accept(i++, entry.getValue());
        }
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        for (ModelPart modelPart : this.modelParts.values()) {
            consumer.accept(modelPart);
        }
    }

    public Map<String, ModelPart> getModelParts() {
        return this.modelParts;
    }

    @Override
    public String getSqlAliasStem() {
        return this.aliasStem;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.javaTypeDescriptor;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        int originalOffset = offset;
        for (ModelPart modelPart : this.modelParts.values()) {
            offset += modelPart.forEachSelectable(offset, consumer);
        }
        return offset - originalOffset;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.sqlTypedMappings[index].getJdbcMapping();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int getJdbcTypeCount() {
        return this.jdbcTypeCount;
    }
}

