/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public class TransactionStatusConnector {
    private String _pid;
    private Uid _pidUid;
    private TransactionStatusManagerItem _tsmi = null;
    private boolean _tsmFound = false;
    private int _attempts_to_recreate_tsmi = 0;
    private int _max_attempts_to_recreate_tsmi = 3;
    private int _attempts_to_establish_connection = 0;
    private int _max_attempts_to_establish_connection = 3;
    private Socket _connector_socket;
    private int _socket_timeout_in_msecs = 1000;
    private BufferedReader _from_server;
    private PrintWriter _to_server;
    private boolean _dead = false;
    private boolean _testMode = false;

    public TransactionStatusConnector(String pid, Uid pidUid) {
        this._pid = pid;
        this._pidUid = pidUid;
    }

    public boolean test(TransactionStatusManagerItem tsmi) {
        this._testMode = true;
        this._tsmi = tsmi;
        boolean ok = this.establishConnection();
        if (!ok) {
            this.setDeadTSM();
        }
        return ok;
    }

    public void delete() {
        if (this._dead) {
            TransactionStatusManagerItem.removeThis(this._pidUid);
        } else {
            tsLogger.i18NLogger.warn_recovery_TransactionStatusConnector_1();
        }
    }

    public boolean isDead() {
        return this._dead;
    }

    public int getTransactionStatus(String transaction_type, Uid tranUid) {
        int status = 9;
        if (!this._dead) {
            if (!this._tsmFound) {
                this._tsmFound = this.recreateTransactionStatusManagerItem();
                if (this._tsmFound) {
                    this._tsmFound = this.establishConnection();
                }
            }
            if (this._tsmFound) {
                try {
                    this._to_server.println(transaction_type);
                    this._to_server.println(tranUid.toString());
                    this._to_server.flush();
                    String server_data = this._from_server.readLine();
                    status = Integer.parseInt(server_data);
                }
                catch (IOException ex) {
                    tsLogger.i18NLogger.warn_recovery_TransactionStatusConnector_2();
                    this._tsmFound = false;
                }
                catch (Exception other) {
                    tsLogger.i18NLogger.warn_recovery_TransactionStatusConnector_3();
                    this._tsmFound = false;
                }
            }
        }
        return status;
    }

    private void setDeadTSM() {
        this._dead = true;
        if (this._tsmi != null) {
            this._tsmi.markAsDead();
        }
    }

    private boolean establishConnection() {
        boolean connectionEstablished = false;
        if (this._tsmi != null) {
            try {
                String serverHost = this._tsmi.host();
                int serverPort = this._tsmi.port();
                this._connector_socket = new Socket(serverHost, serverPort);
                this._connector_socket.setSoTimeout(this._socket_timeout_in_msecs);
                this._from_server = new BufferedReader(new InputStreamReader(this._connector_socket.getInputStream(), StandardCharsets.UTF_8));
                this._to_server = new PrintWriter(new OutputStreamWriter(this._connector_socket.getOutputStream(), StandardCharsets.UTF_8));
                String server_pid = this._from_server.readLine();
                if (Utility.hexStringToInt(server_pid) == Utility.hexStringToInt(this._pid)) {
                    if (!this._testMode) {
                        this._to_server.println("OK");
                        this._to_server.flush();
                        tsLogger.i18NLogger.info_recovery_TransactionStatusConnector_4(this._pid, serverHost, Integer.toString(serverPort), this._connector_socket.toString());
                    } else {
                        this._to_server.println("TEST");
                        this._to_server.flush();
                        this._connector_socket.close();
                    }
                    connectionEstablished = true;
                } else {
                    this._to_server.println("DEAD");
                    this._to_server.flush();
                    this._connector_socket.close();
                    this.setDeadTSM();
                    tsLogger.i18NLogger.info_recovery_TransactionStatusConnector_5(this._pid);
                }
            }
            catch (IOException ex) {
                tsLogger.i18NLogger.info_recovery_TransactionStatusConnector_6();
            }
            int n = this._attempts_to_establish_connection = connectionEstablished ? 0 : this._attempts_to_establish_connection + 1;
            if (this._attempts_to_establish_connection > this._max_attempts_to_establish_connection) {
                this.setDeadTSM();
            }
        }
        return connectionEstablished;
    }

    private boolean recreateTransactionStatusManagerItem() {
        boolean tsmiFound = false;
        if (this._tsmi == null) {
            try {
                this._tsmi = TransactionStatusManagerItem.recreate(this._pidUid);
                tsmiFound = true;
                this._attempts_to_recreate_tsmi = 0;
            }
            catch (Exception ex) {
                if (++this._attempts_to_recreate_tsmi > this._max_attempts_to_recreate_tsmi) {
                    this.setDeadTSM();
                }
                this._tsmi = null;
            }
        }
        return tsmiFound;
    }
}

