/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.RealmModel;

public class AmrUtils {
    private static final Logger logger = Logger.getLogger(AmrUtils.class);

    public static List<String> getAuthenticationExecutionReferences(Map<String, Integer> executions, RealmModel realmModel) {
        return executions.entrySet().stream().map(entry -> {
            try {
                Map config = realmModel.getAuthenticatorConfigById(realmModel.getAuthenticationExecutionById((String)entry.getKey()).getAuthenticatorConfig()).getConfig();
                if (AmrUtils.isAmrValid(config, (Integer)entry.getValue())) {
                    return (String)config.get("default.reference.value");
                }
            }
            catch (NullPointerException e) {
                return null;
            }
            return null;
        }).filter(ref -> ref != null && !ref.isEmpty()).collect(Collectors.toList());
    }

    public static boolean isAmrValid(Map<String, String> config, Integer authTime) {
        try {
            int maxAge = Integer.parseInt(config.getOrDefault("default.reference.maxAge", "0"));
            return authTime + maxAge >= Time.currentTime();
        }
        catch (NumberFormatException e) {
            logger.warnf("invalid authentication execution max age '%s'", (Object)config.get("default.reference.maxAge"));
            return false;
        }
    }
}

