/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.streams;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsGroupCommandOptions
extends CommandDefaultOptions {
    public static final Logger LOGGER = LoggerFactory.getLogger(StreamsGroupCommandOptions.class);
    public static final String BOOTSTRAP_SERVER_DOC = "REQUIRED: The server(s) to connect to.";
    public static final String GROUP_DOC = "The streams group we wish to act on.";
    private static final String INPUT_TOPIC_DOC = "The topic whose streams group information should be deleted or topic whose should be included in the reset offset process. In `reset-offsets` case, partitions can be specified using this format: `topic1:0,1,2`, where 0,1,2 are the partition to be included in the process. Reset-offsets also supports multiple topic inputs. All types of topics are supported.";
    private static final String ALL_INPUT_TOPICS_DOC = "Consider all input topics assigned to a group in the `reset-offsets` and `delete-offsets` process. Only input topics are supported.";
    public static final String LIST_DOC = "List all streams groups.";
    public static final String DESCRIBE_DOC = "Describe streams group and list offset lag related to given group.";
    private static final String ALL_GROUPS_DOC = "Apply to all streams groups.";
    private static final String DELETE_DOC = "Pass in groups to delete topic partition offsets and ownership information over the entire streams group. For instance --group g1 --group g2";
    public static final String TIMEOUT_MS_DOC = "The timeout that can be set for some use cases. For example, it can be used when describing the group to specify the maximum amount of time in milliseconds to wait before the group stabilizes.";
    public static final String COMMAND_CONFIG_DOC = "Property file containing configs to be passed to Admin Client.";
    public static final String STATE_DOC = "When specified with '--list', it displays the state of all groups. It can also be used to list groups with specific states. Valid values are Empty, NotReady, Stable, Assigning, Reconciling, and Dead.";
    public static final String MEMBERS_DOC = "Describe members of the group. This option may be used with the '--describe' option only.";
    public static final String OFFSETS_DOC = "Describe the group and list all topic partitions in the group along with their offset information.This is the default sub-action and may be used with the '--describe' option only.";
    public static final String VERBOSE_DOC = "Use with --describe --state  to show group epoch and target assignment epoch.\nUse with --describe --members to show for each member the member epoch, target assignment epoch, current assignment, target assignment, and whether member is still using the classic rebalance protocol.\nUse with --describe --offsets  and --describe  to show leader epochs for each partition.";
    private static final String DELETE_OFFSETS_DOC = "Delete offsets of streams group. Supports one streams group at the time, and multiple topics.";
    public final OptionSpec<String> bootstrapServerOpt;
    public final OptionSpec<String> groupOpt;
    public final OptionSpec<String> inputTopicOpt;
    public final OptionSpec<Void> allInputTopicsOpt;
    public final OptionSpec<Void> listOpt;
    public final OptionSpec<Void> describeOpt;
    public final OptionSpec<Void> allGroupsOpt;
    public final OptionSpec<Void> deleteOpt;
    public final OptionSpec<Void> deleteOffsetsOpt;
    public final OptionSpec<Long> timeoutMsOpt;
    public final OptionSpec<String> commandConfigOpt;
    public final OptionSpec<String> stateOpt;
    public final OptionSpec<Void> membersOpt;
    public final OptionSpec<Void> offsetsOpt;
    public final OptionSpec<Void> verboseOpt;
    final Set<OptionSpec<?>> allDeleteOffsetsOpts;
    final Set<OptionSpec<?>> allGroupSelectionScopeOpts;
    final Set<OptionSpec<?>> allStreamsGroupLevelOpts;

    public static StreamsGroupCommandOptions fromArgs(String[] args) {
        StreamsGroupCommandOptions opts = new StreamsGroupCommandOptions(args);
        opts.checkArgs();
        return opts;
    }

    public StreamsGroupCommandOptions(String[] args) {
        super(args);
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", BOOTSTRAP_SERVER_DOC).withRequiredArg().describedAs("server to connect to").ofType(String.class);
        this.groupOpt = this.parser.accepts("group", GROUP_DOC).withRequiredArg().describedAs("streams group").ofType(String.class);
        this.inputTopicOpt = this.parser.accepts("input-topic", INPUT_TOPIC_DOC).withRequiredArg().describedAs("topic").ofType(String.class);
        this.allInputTopicsOpt = this.parser.accepts("all-input-topics", ALL_INPUT_TOPICS_DOC);
        this.listOpt = this.parser.accepts("list", LIST_DOC);
        this.describeOpt = this.parser.accepts("describe", DESCRIBE_DOC);
        this.allGroupsOpt = this.parser.accepts("all-groups", ALL_GROUPS_DOC);
        this.deleteOpt = this.parser.accepts("delete", DELETE_DOC);
        this.deleteOffsetsOpt = this.parser.accepts("delete-offsets", DELETE_OFFSETS_DOC);
        this.timeoutMsOpt = this.parser.accepts("timeout", TIMEOUT_MS_DOC).availableIf(this.describeOpt, new OptionSpec[0]).withRequiredArg().describedAs("timeout (ms)").ofType(Long.class).defaultsTo((Object)5000L, (Object[])new Long[0]);
        this.commandConfigOpt = this.parser.accepts("command-config", COMMAND_CONFIG_DOC).withRequiredArg().describedAs("command config property file").ofType(String.class);
        this.stateOpt = this.parser.accepts("state", STATE_DOC).availableIf(this.listOpt, new OptionSpec[]{this.describeOpt}).withOptionalArg().ofType(String.class);
        this.membersOpt = this.parser.accepts("members", MEMBERS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.offsetsOpt = this.parser.accepts("offsets", OFFSETS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.verboseOpt = this.parser.accepts("verbose", VERBOSE_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.options = this.parser.parse(args);
        this.allDeleteOffsetsOpts = new HashSet<OptionSpec>(Arrays.asList(this.inputTopicOpt, this.allInputTopicsOpt));
        this.allStreamsGroupLevelOpts = new HashSet<OptionSpec>(Arrays.asList(this.listOpt, this.describeOpt, this.deleteOpt));
        this.allGroupSelectionScopeOpts = new HashSet<OptionSpec>(Arrays.asList(this.groupOpt, this.allGroupsOpt));
    }

    public void checkArgs() {
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to list, or describe streams groups.");
        CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
        if (this.options.has(this.describeOpt)) {
            this.checkDescribeArgs();
        } else if (this.options.has(this.timeoutMsOpt)) {
            LOGGER.debug("Option " + String.valueOf(this.timeoutMsOpt) + " is applicable only when " + String.valueOf(this.describeOpt) + " is used.");
        }
        if (this.options.has(this.deleteOffsetsOpt)) {
            this.checkDeleteOffsetsArgs();
        }
        if (this.options.has(this.deleteOpt) && !this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.listOpt, (OptionSpec[])new OptionSpec[]{this.membersOpt, this.offsetsOpt});
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.groupOpt, ToolsUtils.minus(this.allStreamsGroupLevelOpts, this.describeOpt, this.deleteOpt));
    }

    private void checkDescribeArgs() {
        List<OptionSpec> mutuallyExclusiveOpts = Arrays.asList(this.membersOpt, this.offsetsOpt, this.stateOpt);
        if (mutuallyExclusiveOpts.stream().mapToInt(o -> this.options.has(o) ? 1 : 0).sum() > 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes at most one of these options: " + mutuallyExclusiveOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        if (this.options.has(this.stateOpt) && this.options.valueOf(this.stateOpt) != null) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " does not take a value for " + String.valueOf(this.stateOpt)));
        }
    }

    private void checkDeleteOffsetsArgs() {
        if (!this.options.has(this.inputTopicOpt) && !this.options.has(this.allInputTopicsOpt) || !this.options.has(this.groupOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOffsetsOpt) + " takes the " + String.valueOf(this.groupOpt) + " and one of these options: " + this.allDeleteOffsetsOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        if (this.options.valuesOf(this.groupOpt).size() > 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOffsetsOpt) + " supports only one " + String.valueOf(this.groupOpt) + " at a time, but found: " + String.valueOf(this.options.valuesOf(this.groupOpt))));
        }
    }
}

