/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.ShareGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.server.common.TopicIdPartition;

public class SimpleAssignor
implements ShareGroupPartitionAssignor {
    private static final String SIMPLE_ASSIGNOR_NAME = "simple";

    public String name() {
        return SIMPLE_ASSIGNOR_NAME;
    }

    public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        if (groupSpec.memberIds().isEmpty()) {
            return new GroupAssignment(Map.of());
        }
        if (groupSpec.subscriptionType().equals((Object)SubscriptionType.HOMOGENEOUS)) {
            return this.assignHomogeneous(groupSpec, subscribedTopicDescriber);
        }
        return this.assignHeterogeneous(groupSpec, subscribedTopicDescriber);
    }

    private GroupAssignment assignHomogeneous(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        Set subscribedTopicIds = groupSpec.memberSubscription((String)groupSpec.memberIds().iterator().next()).subscribedTopicIds();
        if (subscribedTopicIds.isEmpty()) {
            return new GroupAssignment(Map.of());
        }
        List<TopicIdPartition> targetPartitions = this.computeTargetPartitions(groupSpec, subscribedTopicIds, subscribedTopicDescriber);
        Map<TopicIdPartition, List<String>> currentAssignment = this.currentAssignment(groupSpec);
        return this.newAssignmentHomogeneous(groupSpec, subscribedTopicIds, targetPartitions, currentAssignment);
    }

    private GroupAssignment assignHeterogeneous(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        HashMap<String, List<TopicIdPartition>> memberToPartitionsSubscription = new HashMap<String, List<TopicIdPartition>>();
        for (String memberId : groupSpec.memberIds()) {
            MemberSubscription spec = groupSpec.memberSubscription(memberId);
            if (spec.subscribedTopicIds().isEmpty()) continue;
            List<TopicIdPartition> targetPartitions = this.computeTargetPartitions(groupSpec, spec.subscribedTopicIds(), subscribedTopicDescriber);
            memberToPartitionsSubscription.put(memberId, targetPartitions);
        }
        Map<TopicIdPartition, List<String>> currentAssignment = this.currentAssignment(groupSpec);
        return this.newAssignmentHeterogeneous(groupSpec, memberToPartitionsSubscription, currentAssignment);
    }

    private Map<TopicIdPartition, List<String>> currentAssignment(GroupSpec groupSpec) {
        HashMap<TopicIdPartition, List<String>> assignment = new HashMap<TopicIdPartition, List<String>>();
        for (String member : groupSpec.memberIds()) {
            Map assignedTopicPartitions = groupSpec.memberAssignment(member).partitions();
            assignedTopicPartitions.forEach((topicId, partitions) -> partitions.forEach(partition -> assignment.computeIfAbsent(new TopicIdPartition(topicId, partition.intValue()), k -> new ArrayList()).add(member)));
        }
        return assignment;
    }

    private GroupAssignment newAssignmentHomogeneous(GroupSpec groupSpec, Set<Uuid> subscribedTopicIds, List<TopicIdPartition> targetPartitions, Map<TopicIdPartition, List<String>> currentAssignment) {
        int numGroupMembers = groupSpec.memberIds().size();
        int numTargetPartitions = targetPartitions.size();
        int desiredAssignmentCount = (numTargetPartitions + numGroupMembers - 1) / numGroupMembers;
        HashMap<TopicIdPartition, List<String>> newAssignment = SimpleAssignor.newHashMap(numTargetPartitions);
        this.memberHashAssignment(groupSpec.memberIds(), targetPartitions, newAssignment);
        HashMap<String, Set<TopicIdPartition>> finalAssignment = SimpleAssignor.newHashMap(numGroupMembers);
        HashMap finalAssignmentByPartition = SimpleAssignor.newHashMap(numTargetPartitions);
        newAssignment.forEach((targetPartition, members) -> members.forEach(member -> {
            finalAssignment.computeIfAbsent((String)member, k -> new HashSet()).add(targetPartition);
            finalAssignmentByPartition.computeIfAbsent(targetPartition, k -> new HashSet()).add(member);
        }));
        currentAssignment.forEach((targetPartition, members) -> {
            if (subscribedTopicIds.contains(targetPartition.topicId())) {
                members.forEach(member -> {
                    Set memberPartitions;
                    if (groupSpec.memberIds().contains(member) && (memberPartitions = finalAssignment.computeIfAbsent((String)member, k -> new HashSet())).size() < desiredAssignmentCount && !newAssignment.containsKey(targetPartition)) {
                        memberPartitions.add(targetPartition);
                        finalAssignmentByPartition.computeIfAbsent(targetPartition, k -> new HashSet()).add(member);
                    }
                });
            }
        });
        List<TopicIdPartition> unassignedPartitions = targetPartitions.stream().filter(targetPartition -> !finalAssignmentByPartition.containsKey(targetPartition)).toList();
        this.roundRobinAssignmentWithCount(groupSpec.memberIds(), unassignedPartitions, finalAssignment, desiredAssignmentCount);
        return this.groupAssignment(finalAssignment, groupSpec.memberIds());
    }

    private GroupAssignment newAssignmentHeterogeneous(GroupSpec groupSpec, Map<String, List<TopicIdPartition>> memberToPartitionsSubscription, Map<TopicIdPartition, List<String>> currentAssignment) {
        int numGroupMembers = groupSpec.memberIds().size();
        LinkedHashSet targetPartitions = new LinkedHashSet();
        memberToPartitionsSubscription.values().forEach(targetPartitions::addAll);
        HashMap topicToMemberSubscription = new HashMap();
        memberToPartitionsSubscription.forEach((member, partitions) -> partitions.forEach(partition -> topicToMemberSubscription.computeIfAbsent(partition.topicId(), k -> new LinkedHashSet()).add(member)));
        HashMap<TopicIdPartition, List> newAssignment = new HashMap<TopicIdPartition, List>();
        memberToPartitionsSubscription.forEach((member, partitions) -> this.memberHashAssignment((Collection<String>)List.of(member), (List<TopicIdPartition>)partitions, (Map<TopicIdPartition, List<String>>)newAssignment));
        LinkedHashSet assignedPartitions = new LinkedHashSet(newAssignment.keySet());
        HashMap unassignedPartitions = new HashMap();
        targetPartitions.forEach(targetPartition -> {
            if (!assignedPartitions.contains(targetPartition) && !currentAssignment.containsKey(targetPartition)) {
                unassignedPartitions.computeIfAbsent(targetPartition.topicId(), k -> new ArrayList()).add(targetPartition);
            }
        });
        unassignedPartitions.keySet().forEach(unassignedTopic -> this.roundRobinAssignment((Collection)topicToMemberSubscription.get(unassignedTopic), (List)unassignedPartitions.get(unassignedTopic), newAssignment));
        HashMap<String, Set<TopicIdPartition>> finalAssignment = SimpleAssignor.newHashMap(numGroupMembers);
        newAssignment.forEach((targetPartition, members) -> members.forEach(member -> finalAssignment.computeIfAbsent((String)member, k -> new HashSet()).add(targetPartition)));
        currentAssignment.forEach((topicIdPartition, members) -> members.forEach(member -> {
            if (topicToMemberSubscription.getOrDefault(topicIdPartition.topicId(), Set.of()).contains(member) && !newAssignment.containsKey(topicIdPartition)) {
                finalAssignment.computeIfAbsent((String)member, k -> new HashSet()).add(topicIdPartition);
            }
        }));
        return this.groupAssignment(finalAssignment, groupSpec.memberIds());
    }

    void memberHashAssignment(Collection<String> memberIds, List<TopicIdPartition> partitionsToAssign, Map<TopicIdPartition, List<String>> assignment) {
        if (!partitionsToAssign.isEmpty()) {
            for (String memberId : memberIds) {
                int topicPartitionIndex = Math.abs(memberId.hashCode() % partitionsToAssign.size());
                TopicIdPartition topicPartition = partitionsToAssign.get(topicPartitionIndex);
                assignment.computeIfAbsent(topicPartition, k -> new ArrayList()).add(memberId);
            }
        }
    }

    void roundRobinAssignment(Collection<String> memberIds, List<TopicIdPartition> partitionsToAssign, Map<TopicIdPartition, List<String>> assignment) {
        Iterator<String> memberIdIterator = memberIds.iterator();
        for (TopicIdPartition topicPartition : partitionsToAssign) {
            if (!memberIdIterator.hasNext()) {
                memberIdIterator = memberIds.iterator();
            }
            String memberId = memberIdIterator.next();
            assignment.computeIfAbsent(topicPartition, k -> new ArrayList()).add(memberId);
        }
    }

    void roundRobinAssignmentWithCount(Collection<String> memberIds, List<TopicIdPartition> partitionsToAssign, Map<String, Set<TopicIdPartition>> assignment, int desiredAssignmentCount) {
        LinkedHashSet<String> memberIdsCopy = new LinkedHashSet<String>(memberIds);
        Iterator memberIdIterator = memberIdsCopy.iterator();
        ListIterator<TopicIdPartition> partitionListIterator = partitionsToAssign.listIterator();
        while (partitionListIterator.hasNext()) {
            String memberId;
            Set memberPartitions;
            TopicIdPartition partition = partitionListIterator.next();
            if (!memberIdIterator.hasNext()) {
                memberIdIterator = memberIdsCopy.iterator();
                if (memberIdsCopy.isEmpty()) {
                    throw new PartitionAssignorException("Inconsistent number of member IDs");
                }
            }
            if ((memberPartitions = assignment.computeIfAbsent(memberId = (String)memberIdIterator.next(), k -> new HashSet())).size() <= desiredAssignmentCount) {
                memberPartitions.add(partition);
                continue;
            }
            memberIdIterator.remove();
            partitionListIterator.previous();
        }
    }

    private List<TopicIdPartition> computeTargetPartitions(GroupSpec groupSpec, Set<Uuid> subscribedTopicIds, SubscribedTopicDescriber subscribedTopicDescriber) {
        ArrayList<TopicIdPartition> targetPartitions = new ArrayList<TopicIdPartition>();
        subscribedTopicIds.forEach(topicId -> {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            if (numPartitions == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + String.valueOf(topicId) + " which doesn't exist in the topic metadata.");
            }
            for (int partition = 0; partition < numPartitions; ++partition) {
                if (!groupSpec.isPartitionAssignable(topicId, partition)) continue;
                targetPartitions.add(new TopicIdPartition(topicId, partition));
            }
        });
        return targetPartitions;
    }

    private GroupAssignment groupAssignment(Map<String, Set<TopicIdPartition>> assignmentByMember, Collection<String> allGroupMembers) {
        HashMap<String, MemberAssignmentImpl> members = new HashMap<String, MemberAssignmentImpl>();
        for (Map.Entry<String, Set<TopicIdPartition>> entry : assignmentByMember.entrySet()) {
            HashMap<Uuid, Set<Integer>> targetPartitions = new HashMap<Uuid, Set<Integer>>();
            entry.getValue().forEach(targetPartition -> targetPartitions.computeIfAbsent(targetPartition.topicId(), k -> new HashSet()).add(targetPartition.partitionId()));
            members.put(entry.getKey(), new MemberAssignmentImpl(targetPartitions));
        }
        allGroupMembers.forEach(member -> {
            if (!members.containsKey(member)) {
                members.put((String)member, new MemberAssignmentImpl(new HashMap<Uuid, Set<Integer>>()));
            }
        });
        return new GroupAssignment(members);
    }

    private static <K, V> HashMap<K, V> newHashMap(int numMappings) {
        return new HashMap((int)((float)(numMappings + 1) / 0.75f + 1.0f));
    }
}

