/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.util.BatchFileReader;
import org.apache.kafka.metadata.util.BatchFileWriter;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class BootstrapDirectory {
    public static final String BINARY_BOOTSTRAP_FILENAME = "bootstrap.checkpoint";
    private final String directoryPath;

    public BootstrapDirectory(String directoryPath) {
        this.directoryPath = Objects.requireNonNull(directoryPath);
    }

    public BootstrapMetadata read() throws Exception {
        Path path = Paths.get(this.directoryPath, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            if (Files.exists(path, new LinkOption[0])) {
                throw new RuntimeException("Path " + this.directoryPath + " exists, but is not a directory.");
            }
            throw new RuntimeException("No such directory as " + this.directoryPath);
        }
        Path binaryBootstrapPath = Paths.get(this.directoryPath, BINARY_BOOTSTRAP_FILENAME);
        if (!Files.exists(binaryBootstrapPath, new LinkOption[0])) {
            return this.readFromConfiguration();
        }
        return this.readFromBinaryFile(binaryBootstrapPath.toString());
    }

    BootstrapMetadata readFromConfiguration() {
        return BootstrapMetadata.fromVersion(MetadataVersion.latestProduction(), "the default bootstrap");
    }

    BootstrapMetadata readFromBinaryFile(String binaryPath) throws Exception {
        ArrayList records = new ArrayList();
        try (BatchFileReader reader = new BatchFileReader.Builder().setPath(binaryPath).build();){
            while (reader.hasNext()) {
                BatchFileReader.BatchAndType batchAndType = reader.next();
                if (batchAndType.isControl()) continue;
                records.addAll(batchAndType.batch().records());
            }
        }
        return BootstrapMetadata.fromRecords(Collections.unmodifiableList(records), "the binary bootstrap metadata file: " + binaryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryFile(BootstrapMetadata bootstrapMetadata) throws IOException {
        if (!Files.isDirectory(Paths.get(this.directoryPath, new String[0]), new LinkOption[0])) {
            throw new RuntimeException("No such directory as " + this.directoryPath);
        }
        Path tempPath = Paths.get(this.directoryPath, "bootstrap.checkpoint.tmp");
        Files.deleteIfExists(tempPath);
        try {
            try (BatchFileWriter writer = BatchFileWriter.open(tempPath);){
                for (ApiMessageAndVersion message : bootstrapMetadata.records()) {
                    writer.append(message);
                }
            }
            Files.move(tempPath, Paths.get(this.directoryPath, BINARY_BOOTSTRAP_FILENAME), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempPath);
        }
    }
}

