/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import javax.swing.table.AbstractTableModel;
import org.jsampler.JSI18n;
import org.jsampler.OrchestraListModel;
import org.jsampler.OrchestraModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.OrchestraAdapter;
import org.jsampler.event.OrchestraEvent;

public class OrchestraTableModel
extends AbstractTableModel {
    private final OrchestraListModel orchestraListModel;
    private final Handler eventHandler = new Handler();

    public OrchestraTableModel(OrchestraListModel orchestraListModel) {
        if (orchestraListModel == null) {
            throw new IllegalArgumentException("orchestraListModel should be non-null!");
        }
        this.orchestraListModel = orchestraListModel;
        orchestraListModel.addOrchestraListListener(this.getHandler());
        for (int i = 0; i < orchestraListModel.getOrchestraCount(); ++i) {
            orchestraListModel.getOrchestra(i).addOrchestraListener(this.getHandler());
        }
        orchestraListModel.addOrchestraListListener(this.getHandler());
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.orchestraListModel.getOrchestraCount();
    }

    @Override
    public String getColumnName(int n) {
        return JSI18n.i18n.getLabel("OrchestraTableModel.orchestras");
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.orchestraListModel.getOrchestra(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.orchestraListModel.getOrchestra(n).setName(object.toString());
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public OrchestraListModel getOrchestraListModel() {
        return this.orchestraListModel;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    extends OrchestraAdapter
    implements ListListener<OrchestraModel> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<OrchestraModel> listEvent) {
            listEvent.getEntry().addOrchestraListener(OrchestraTableModel.this.getHandler());
            OrchestraTableModel.this.fireTableDataChanged();
        }

        @Override
        public void entryRemoved(ListEvent<OrchestraModel> listEvent) {
            listEvent.getEntry().removeOrchestraListener(OrchestraTableModel.this.getHandler());
            OrchestraTableModel.this.fireTableDataChanged();
        }

        @Override
        public void nameChanged(OrchestraEvent orchestraEvent) {
            OrchestraModel orchestraModel = (OrchestraModel)orchestraEvent.getSource();
            int n = OrchestraTableModel.this.orchestraListModel.getOrchestraIndex(orchestraModel);
            OrchestraTableModel.this.fireTableRowsUpdated(n, n);
        }

        @Override
        public void descriptionChanged(OrchestraEvent orchestraEvent) {
        }
    }
}

