/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationConstraint;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.BuildOperationQueueFailure;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationState;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.work.WorkerLimits;
import org.jspecify.annotations.Nullable;

public class DefaultBuildOperationExecutor
implements BuildOperationExecutor,
Stoppable {
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final BuildOperationRunner runner;
    private final BuildOperationQueueFactory buildOperationQueueFactory;
    private final Map<BuildOperationConstraint, ManagedExecutor> managedExecutors = new HashMap<BuildOperationConstraint, ManagedExecutor>();
    private final CurrentBuildOperationRef currentBuildOperationRef;

    public DefaultBuildOperationExecutor(BuildOperationRunner buildOperationRunner, CurrentBuildOperationRef currentBuildOperationRef, BuildOperationQueueFactory buildOperationQueueFactory, ExecutorFactory executorFactory, WorkerLimits workerLimits) {
        this.runner = buildOperationRunner;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.buildOperationQueueFactory = buildOperationQueueFactory;
        this.managedExecutors.put(BuildOperationConstraint.MAX_WORKERS, executorFactory.create("Build operations", workerLimits.getMaxWorkerCount()));
        this.managedExecutors.put(BuildOperationConstraint.UNCONSTRAINED, executorFactory.create("Unconstrained build operations", workerLimits.getMaxWorkerCount() * 10));
    }

    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAll(schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.executeInParallel(false, RunnableBuildOperation::run, schedulingAction, buildOperationConstraint);
    }

    public <O extends RunnableBuildOperation> void runAllWithAccessToProjectState(Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAllWithAccessToProjectState(schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    public <O extends RunnableBuildOperation> void runAllWithAccessToProjectState(Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.executeInParallel(true, RunnableBuildOperation::run, schedulingAction, buildOperationConstraint);
    }

    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAll(worker, schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.executeInParallel(false, worker, schedulingAction, buildOperationConstraint);
    }

    private @Nullable BuildOperationState getCurrentBuildOperation() {
        return (BuildOperationState)this.currentBuildOperationRef.get();
    }

    private <O extends BuildOperation> void executeInParallel(boolean allowAccessToProjectState, BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> queueAction, BuildOperationConstraint buildOperationConstraint) {
        ManagedExecutor executor = this.managedExecutors.get(buildOperationConstraint);
        BuildOperationQueue queue = this.buildOperationQueueFactory.create(executor, allowAccessToProjectState, operation -> this.runner.execute(operation, worker), this.getCurrentBuildOperation());
        ArrayList<GradleException> failures = new ArrayList<GradleException>();
        try {
            queueAction.execute(queue);
        }
        catch (Exception e) {
            failures.add((GradleException)new BuildOperationQueueFailure("There was a failure while populating the build operation queue: " + e.getMessage(), (Throwable)e));
            queue.cancel();
        }
        try {
            queue.waitForCompletion();
        }
        catch (MultipleBuildOperationFailures e) {
            failures.add((GradleException)((Object)e));
        }
        if (failures.size() == 1) {
            throw (GradleException)((Object)failures.get(0));
        }
        if (failures.size() > 1) {
            throw new DefaultMultiCauseException(DefaultBuildOperationExecutor.formatMultipleFailureMessage(failures), failures);
        }
    }

    private static String formatMultipleFailureMessage(List<GradleException> failures) {
        return failures.stream().map(Throwable::getMessage).collect(Collectors.joining(LINE_SEPARATOR + "AND" + LINE_SEPARATOR));
    }

    public void stop() {
        for (ManagedExecutor pool : this.managedExecutors.values()) {
            pool.stop();
        }
    }
}

