/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import tim.prune.function.filesleuth.data.Date;

public class DateRange {
    private final Date _dateFrom;
    private final Date _dateTo;
    public static final DateRange EMPTY_RANGE = new DateRange(null, null);
    public static final DateRange INVALID_RANGE = new DateRange(null, new Date(-1, -1, -1));

    public DateRange(Date date, Date date2) {
        boolean bl = date == null || date2 == null || date2.isAfter(date);
        this._dateFrom = bl ? date : date2;
        this._dateTo = bl ? date2 : date;
    }

    public static DateRange parseValues(int n, int n2, int n3) {
        return DateRange.parseValues(n, n2, n3, n, n2, n3);
    }

    public static DateRange parseValues(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 1000 || n > 9999 || n4 < 1000 || n4 > 9999) {
            return null;
        }
        if (n2 <= 0 && n3 <= 0 && n5 <= 0 && n6 <= 0) {
            return new DateRange(new Date(n, 1, 1), new Date(n4, 12, 31));
        }
        if (n2 > 0 && n3 <= 0 && n5 > 0 && n6 <= 0) {
            int n7 = Date.getDaysInMonth(n4, n5);
            return new DateRange(new Date(n, n2, 1), new Date(n4, n5, n7));
        }
        if (n2 > 0 && n3 > 0 && n5 > 0 && n6 > 0) {
            return new DateRange(new Date(n, n2, n3), new Date(n4, n5, n6));
        }
        return null;
    }

    public static DateRange parseString(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.isEmpty()) {
            return EMPTY_RANGE;
        }
        if (string2.length() < 4) {
            return INVALID_RANGE;
        }
        if (string2.length() == 4) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 1000) {
                    return new DateRange(new Date(n, 1, 1), new Date(n, 12, 31));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.length() == 7 && Date.isSeparator(string2.charAt(4))) {
            try {
                int n = Integer.parseInt(string2.substring(0, 4));
                int n2 = Integer.parseInt(string2.substring(5));
                if (n >= 1000 && n2 >= 1 && n2 <= 12) {
                    return new DateRange(new Date(n, n2, 1), new Date(n, n2, Date.getDaysInMonth(n, n2)));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.length() == 10 && Date.isSeparator(string2.charAt(4)) && Date.isSeparator(string2.charAt(7))) {
            Date date = Date.parseString(string2);
            if (date != null) {
                return new DateRange(date, date);
            }
        } else if (string2.length() >= 21) {
            return DateRange.parseDatePair(string2);
        }
        return INVALID_RANGE;
    }

    public boolean isEmpty() {
        return this._dateFrom == null;
    }

    public boolean isValid() {
        return this != INVALID_RANGE && this._dateFrom != null && this._dateFrom.isValid() && this._dateTo != null && this._dateTo.isValid();
    }

    public Date getDateFrom() {
        return this._dateFrom;
    }

    public Date getDateTo() {
        return this._dateTo;
    }

    public boolean isYearMonthDay() {
        return this.toShortString().length() <= 10;
    }

    private static DateRange parseDatePair(String string) {
        Date date = Date.parseString(string.substring(0, 10));
        if (date == null || !date.isValid()) {
            return INVALID_RANGE;
        }
        int n = string.length() - 10;
        int n2 = 11;
        while (n2 < n) {
            if (!Date.isSeparator(string.charAt(n2))) {
                return INVALID_RANGE;
            }
            ++n2;
        }
        Date date2 = Date.parseString(string.substring(n));
        if (date2 == null || !date2.isValid()) {
            return INVALID_RANGE;
        }
        if (date.isAfter(date2)) {
            return new DateRange(date2, date);
        }
        return new DateRange(date, date2);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        if (this._dateFrom.equals(this._dateTo)) {
            return this._dateFrom.toString();
        }
        return String.format("%s - %s", this._dateFrom.toString(), this._dateTo.toString());
    }

    public String toShortString() {
        if (this.isEmpty()) {
            return "";
        }
        int n = this._dateFrom.getYear();
        if (this._dateFrom.getYear() == this._dateTo.getYear()) {
            if (this._dateFrom.getMonth() == 1 && this._dateTo.getMonth() == 12 && this._dateFrom.getDay() == 1 && this._dateTo.getDay() == 31) {
                return "" + n;
            }
            int n2 = this._dateFrom.getMonth();
            if (n2 >= 1 && n2 == this._dateTo.getMonth() && this._dateFrom.getDay() == 1 && this._dateTo.getDay() == Date.getDaysInMonth(n, n2)) {
                return String.format("%d-%02d", n, n2);
            }
            if (this._dateFrom.equals(this._dateTo)) {
                return this._dateFrom.toString();
            }
        }
        return this.toString();
    }

    public boolean contains(Date date) {
        if (this.isEmpty()) {
            return true;
        }
        if (date == null) {
            return false;
        }
        if (this._dateFrom.isAfter(date)) {
            return false;
        }
        return this._dateTo == null || !date.isAfter(this._dateTo);
    }

    public boolean overlaps(DateRange dateRange) {
        if (this.isEmpty()) {
            return true;
        }
        if (dateRange == null || dateRange.isEmpty()) {
            return false;
        }
        return !this._dateFrom.isAfter(dateRange._dateTo) && !dateRange._dateFrom.isAfter(this._dateTo);
    }

    public boolean equals(DateRange dateRange) {
        if (this.isEmpty()) {
            return dateRange == null || dateRange.isEmpty();
        }
        return this._dateFrom.equals(dateRange._dateFrom) && this._dateTo.equals(dateRange._dateTo);
    }

    public boolean equals(Object object) {
        DateRange dateRange = object instanceof DateRange ? (DateRange)object : null;
        return this.equals(dateRange);
    }

    public boolean includes(DateRange dateRange) {
        if (this.isEmpty()) {
            return dateRange == null || dateRange.isEmpty();
        }
        if (dateRange == null || dateRange.isEmpty()) {
            return true;
        }
        return !this._dateFrom.isAfter(dateRange._dateFrom) && !dateRange._dateTo.isAfter(this._dateTo);
    }
}

