/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.awt.GridLayout;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.Distance;
import tim.prune.data.Unit;
import tim.prune.function.comparesegments.PointData;
import tim.prune.function.comparesegments.PointSequence;
import tim.prune.function.comparesegments.SegmentData;
import tim.prune.gui.DisplayUtils;

public class SegmentsPanel
extends JPanel {
    private JLabel _segStartDate1 = null;
    private JLabel _segStartDate2 = null;
    private JLabel _segStartTime1 = null;
    private JLabel _segStartTime2 = null;
    private JLabel _numPoints1 = null;
    private JLabel _numPoints2 = null;
    private JLabel _distance1 = null;
    private JLabel _distance2 = null;
    private JLabel _duration1 = null;
    private JLabel _duration2 = null;

    public SegmentsPanel() {
        this.setLayout(new GridLayout(0, 3, 6, 2));
        this.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.comparesegments.segments")));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.comparesegments.startdate")) + ": ");
        jLabel.setHorizontalAlignment(4);
        this.add(jLabel);
        this._segStartDate1 = new JLabel("2000-01-01");
        this.add(this._segStartDate1);
        this._segStartDate2 = new JLabel("2002-02-02");
        this.add(this._segStartDate2);
        jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.comparesegments.starttime")) + ": ");
        jLabel.setHorizontalAlignment(4);
        this.add(jLabel);
        this._segStartTime1 = new JLabel("10:12:14");
        this.add(this._segStartTime1);
        this._segStartTime2 = new JLabel("10:12:14");
        this.add(this._segStartTime2);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("details.track.points")) + ": ");
        jLabel2.setHorizontalAlignment(4);
        this.add(jLabel2);
        this._numPoints1 = new JLabel("1234");
        this.add(this._numPoints1);
        this._numPoints2 = new JLabel("2341");
        this.add(this._numPoints2);
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + ": ");
        jLabel3.setHorizontalAlignment(4);
        this.add(jLabel3);
        this._distance1 = new JLabel("11.9 km");
        this.add(this._distance1);
        this._distance2 = new JLabel("12.9 km");
        this.add(this._distance2);
        JLabel jLabel4 = new JLabel(String.valueOf(I18nManager.getText("fieldname.duration")) + ": ");
        jLabel4.setHorizontalAlignment(4);
        this.add(jLabel4);
        this._duration1 = new JLabel("11m 12s");
        this.add(this._duration1);
        this._duration2 = new JLabel("12m 13s");
        this.add(this._duration2);
    }

    public void setDetails(SegmentData segmentData, SegmentData segmentData2, Config config) {
        TimeZone timeZone = TimezoneHelper.getSelectedTimezone(config);
        PointSequence pointSequence = segmentData.getPoints();
        SegmentsPanel.setDate(pointSequence, this._segStartDate1, timeZone);
        SegmentsPanel.setTime(pointSequence, this._segStartTime1, timeZone);
        SegmentsPanel.setNumPoints(pointSequence, this._numPoints1);
        PointSequence pointSequence2 = segmentData2.getPoints();
        SegmentsPanel.setDate(pointSequence2, this._segStartDate2, timeZone);
        SegmentsPanel.setTime(pointSequence2, this._segStartTime2, timeZone);
        SegmentsPanel.setNumPoints(pointSequence2, this._numPoints2);
        Unit unit = config.getUnitSet().getDistanceUnit();
        String string = I18nManager.getText(unit.getShortnameKey());
        PointData pointData = pointSequence.getLastPoint();
        SegmentsPanel.setDistance(pointData, unit, string, this._distance1);
        PointData pointData2 = pointSequence2.getLastPoint();
        SegmentsPanel.setDistance(pointData2, unit, string, this._distance2);
        SegmentsPanel.setDuration(pointSequence.getFirstPoint(), pointData, this._duration1);
        SegmentsPanel.setDuration(pointSequence2.getFirstPoint(), pointData2, this._duration2);
    }

    private static void setDate(PointSequence pointSequence, JLabel jLabel, TimeZone timeZone) {
        jLabel.setText(pointSequence.getFirstTimestamp().getDateText(timeZone));
    }

    private static void setTime(PointSequence pointSequence, JLabel jLabel, TimeZone timeZone) {
        jLabel.setText(pointSequence.getFirstTimestamp().getTimeText(timeZone));
    }

    private static void setNumPoints(PointSequence pointSequence, JLabel jLabel) {
        jLabel.setText("" + pointSequence.getNumPoints());
    }

    private static void setDistance(PointData pointData, Unit unit, String string, JLabel jLabel) {
        double d = Distance.convertRadiansToDistance(pointData._distanceToHereRadians, unit);
        jLabel.setText(String.valueOf(DisplayUtils.roundedNumber(d)) + " " + string);
    }

    private static void setDuration(PointData pointData, PointData pointData2, JLabel jLabel) {
        long l = pointData2._point.getTimestamp().getSecondsSince(pointData._point.getTimestamp());
        jLabel.setText(DisplayUtils.buildDurationString(l));
    }
}

