/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import java.util.List;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.CutAndMoveCmd;
import tim.prune.cmd.PointFlag;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.TimeSensitiveFunction;

public class CutAndMoveFunction
extends TimeSensitiveFunction {
    public CutAndMoveFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "menu.range.cutandmove";
    }

    @Override
    public void begin() {
        if (!this.confirmTimestampMangling()) {
            return;
        }
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        int n3 = this._app.getTrackInfo().getSelection().getCurrentPointIndex();
        if (n < 0 || n2 <= n || n3 < 0 || n3 >= n && n3 <= n2) {
            return;
        }
        Track track = this._app.getTrackInfo().getTrack();
        this._app.execute(this.makeCommand(track, n, n2, n3));
        this._app.getTrackInfo().getSelection().clearAll();
        this._app.getTrackInfo().selectPoint(n3);
    }

    public Command makeCommand(Track track, int n, int n2, int n3) {
        List<Integer> list = CutAndMoveFunction.makeNewOrdering(track.getNumPoints(), n, n2, n3);
        DataPoint dataPoint = track.getNextTrackPoint(n);
        DataPoint dataPoint2 = track.getNextTrackPoint(n2 + 1);
        DataPoint dataPoint3 = track.getPoint(n3);
        List<PointFlag> list2 = List.of(new PointFlag(dataPoint, true), new PointFlag(dataPoint2, true), new PointFlag(dataPoint3, true));
        CutAndMoveCmd cutAndMoveCmd = new CutAndMoveCmd(list, list2);
        cutAndMoveCmd.setDescription(this.getName());
        cutAndMoveCmd.setConfirmText(I18nManager.getText("confirm.cutandmove"));
        return cutAndMoveCmd;
    }

    private static List<Integer> makeNewOrdering(int n, int n2, int n3, int n4) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = 0;
        while (n5 < n4) {
            if (n5 < n2 || n5 > n3) {
                arrayList.add(n5);
            }
            ++n5;
        }
        n5 = n2;
        while (n5 <= n3) {
            arrayList.add(n5);
            ++n5;
        }
        n5 = n4;
        while (n5 < n) {
            if (n5 < n2 || n5 > n3) {
                arrayList.add(n5);
            }
            ++n5;
        }
        return arrayList;
    }
}

