from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

CROATIAN_LANG_MODEL = {
    40: {  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        33: SequenceLikelihood.POSITIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    38: {  # 'B'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    48: {  # 'C'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    33: {  # 'D'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.LIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.POSITIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.LIKELY,  # 'ž'
    },
    45: {  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.POSITIVE,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    49: {  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    44: {  # 'G'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    30: {  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.POSITIVE,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    39: {  # 'I'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.LIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.LIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.LIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    46: {  # 'J'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    36: {  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    47: {  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    35: {  # 'M'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    29: {  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.LIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    32: {  # 'O'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.LIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.LIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    26: {  # 'P'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    62: {  # 'Q'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    43: {  # 'R'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.POSITIVE,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    27: {  # 'S'
        40: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        48: SequenceLikelihood.LIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.LIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    37: {  # 'T'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    34: {  # 'U'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.LIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    41: {  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.LIKELY,  # 'D'
        45: SequenceLikelihood.LIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.LIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    55: {  # 'W'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    58: {  # 'X'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    59: {  # 'Y'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    42: {  # 'Z'
        40: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.LIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    1: {  # 'a'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.POSITIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    19: {  # 'b'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    22: {  # 'c'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    13: {  # 'd'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.LIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    3: {  # 'e'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.POSITIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    31: {  # 'f'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    18: {  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    25: {  # 'h'
        40: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    2: {  # 'i'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.POSITIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.POSITIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    6: {  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    11: {  # 'k'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.LIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    14: {  # 'l'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.LIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    15: {  # 'm'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.LIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.LIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    5: {  # 'n'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.LIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.LIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.LIKELY,  # 'ž'
    },
    4: {  # 'o'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.POSITIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    16: {  # 'p'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.LIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    61: {  # 'q'
        40: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    8: {  # 'r'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.LIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.POSITIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    9: {  # 's'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    7: {  # 't'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    10: {  # 'u'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.POSITIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.POSITIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    12: {  # 'v'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.LIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.POSITIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    54: {  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    56: {  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    51: {  # 'y'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    17: {  # 'z'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.UNLIKELY,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.UNLIKELY,  # 'q'
        8: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    60: {  # 'Ć'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    21: {  # 'ć'
        40: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    53: {  # 'Č'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    20: {  # 'č'
        40: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    57: {  # 'Đ'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        6: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        14: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    28: {  # 'đ'
        40: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    50: {  # 'Š'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.LIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.UNLIKELY,  # 'č'
        57: SequenceLikelihood.UNLIKELY,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.UNLIKELY,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    23: {  # 'š'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.NEGATIVE,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.NEGATIVE,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        14: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.POSITIVE,  # 'ć'
        53: SequenceLikelihood.UNLIKELY,  # 'Č'
        20: SequenceLikelihood.LIKELY,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    52: {  # 'Ž'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        48: SequenceLikelihood.UNLIKELY,  # 'C'
        33: SequenceLikelihood.UNLIKELY,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.UNLIKELY,  # 'H'
        39: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        29: SequenceLikelihood.UNLIKELY,  # 'N'
        32: SequenceLikelihood.UNLIKELY,  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        13: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        6: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.NEGATIVE,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.NEGATIVE,  # 'đ'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        23: SequenceLikelihood.NEGATIVE,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    24: {  # 'ž'
        40: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        48: SequenceLikelihood.NEGATIVE,  # 'C'
        33: SequenceLikelihood.NEGATIVE,  # 'D'
        45: SequenceLikelihood.UNLIKELY,  # 'E'
        49: SequenceLikelihood.NEGATIVE,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        30: SequenceLikelihood.NEGATIVE,  # 'H'
        39: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'K'
        47: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        29: SequenceLikelihood.NEGATIVE,  # 'N'
        32: SequenceLikelihood.NEGATIVE,  # 'O'
        26: SequenceLikelihood.NEGATIVE,  # 'P'
        62: SequenceLikelihood.NEGATIVE,  # 'Q'
        43: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        34: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        55: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        42: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        13: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        6: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        14: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        61: SequenceLikelihood.NEGATIVE,  # 'q'
        8: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        12: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'Ć'
        21: SequenceLikelihood.UNLIKELY,  # 'ć'
        53: SequenceLikelihood.NEGATIVE,  # 'Č'
        20: SequenceLikelihood.NEGATIVE,  # 'č'
        57: SequenceLikelihood.NEGATIVE,  # 'Đ'
        28: SequenceLikelihood.UNLIKELY,  # 'đ'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        23: SequenceLikelihood.UNLIKELY,  # 'š'
        52: SequenceLikelihood.NEGATIVE,  # 'Ž'
        24: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
}

# Character Mapping Table(s):
CP852_CROATIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 40,  # 'A'
    66: 38,  # 'B'
    67: 48,  # 'C'
    68: 33,  # 'D'
    69: 45,  # 'E'
    70: 49,  # 'F'
    71: 44,  # 'G'
    72: 30,  # 'H'
    73: 39,  # 'I'
    74: 46,  # 'J'
    75: 36,  # 'K'
    76: 47,  # 'L'
    77: 35,  # 'M'
    78: 29,  # 'N'
    79: 32,  # 'O'
    80: 26,  # 'P'
    81: 62,  # 'Q'
    82: 43,  # 'R'
    83: 27,  # 'S'
    84: 37,  # 'T'
    85: 34,  # 'U'
    86: 41,  # 'V'
    87: 55,  # 'W'
    88: 58,  # 'X'
    89: 59,  # 'Y'
    90: 42,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 22,  # 'c'
    100: 13,  # 'd'
    101: 3,  # 'e'
    102: 31,  # 'f'
    103: 18,  # 'g'
    104: 25,  # 'h'
    105: 2,  # 'i'
    106: 6,  # 'j'
    107: 11,  # 'k'
    108: 14,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 61,  # 'q'
    114: 8,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 12,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 51,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'ů'
    134: 21,  # 'ć'
    135: 0,  # 'ç'
    136: 0,  # 'ł'
    137: 0,  # 'ë'
    138: 0,  # 'Ő'
    139: 0,  # 'ő'
    140: 0,  # 'î'
    141: 0,  # 'Ź'
    142: 0,  # 'Ä'
    143: 60,  # 'Ć'
    144: 0,  # 'É'
    145: 0,  # 'Ĺ'
    146: 0,  # 'ĺ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'Ľ'
    150: 0,  # 'ľ'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'Ť'
    156: 0,  # 'ť'
    157: 0,  # 'Ł'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 20,  # 'č'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'Ą'
    165: 0,  # 'ą'
    166: 52,  # 'Ž'
    167: 24,  # 'ž'
    168: 0,  # 'Ę'
    169: 0,  # 'ę'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: 0,  # 'ź'
    172: 53,  # 'Č'
    173: 0,  # 'ş'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'Ě'
    184: 0,  # 'Ş'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Ż'
    190: 0,  # 'ż'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ă'
    199: 0,  # 'ă'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 28,  # 'đ'
    209: 57,  # 'Đ'
    210: 0,  # 'Ď'
    211: 0,  # 'Ë'
    212: 0,  # 'ď'
    213: 0,  # 'Ň'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'ě'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 0,  # 'Ţ'
    222: 0,  # 'Ů'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ń'
    228: 0,  # 'ń'
    229: 0,  # 'ň'
    230: 50,  # 'Š'
    231: 23,  # 'š'
    232: 0,  # 'Ŕ'
    233: 0,  # 'Ú'
    234: 0,  # 'ŕ'
    235: 0,  # 'Ű'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: 0,  # 'ţ'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '˝'
    242: CharacterCategory.SYMBOL,  # '˛'
    243: 0,  # 'ˇ'
    244: CharacterCategory.SYMBOL,  # '˘'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: 0,  # 'ű'
    252: 0,  # 'Ř'
    253: 0,  # 'ř'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP852_CROATIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP852",
    language="Croatian",
    char_to_order_map=CP852_CROATIAN_CHAR_TO_ORDER,
    language_model=CROATIAN_LANG_MODEL,
    typical_positive_ratio=0.9896619147584043,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĆćČčĐđŠšŽž",
)

ISO_8859_2_CROATIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 40,  # 'A'
    66: 38,  # 'B'
    67: 48,  # 'C'
    68: 33,  # 'D'
    69: 45,  # 'E'
    70: 49,  # 'F'
    71: 44,  # 'G'
    72: 30,  # 'H'
    73: 39,  # 'I'
    74: 46,  # 'J'
    75: 36,  # 'K'
    76: 47,  # 'L'
    77: 35,  # 'M'
    78: 29,  # 'N'
    79: 32,  # 'O'
    80: 26,  # 'P'
    81: 62,  # 'Q'
    82: 43,  # 'R'
    83: 27,  # 'S'
    84: 37,  # 'T'
    85: 34,  # 'U'
    86: 41,  # 'V'
    87: 55,  # 'W'
    88: 58,  # 'X'
    89: 59,  # 'Y'
    90: 42,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 22,  # 'c'
    100: 13,  # 'd'
    101: 3,  # 'e'
    102: 31,  # 'f'
    103: 18,  # 'g'
    104: 25,  # 'h'
    105: 2,  # 'i'
    106: 6,  # 'j'
    107: 11,  # 'k'
    108: 14,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 61,  # 'q'
    114: 8,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 12,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 51,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ľ'
    166: 0,  # 'Ś'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 50,  # 'Š'
    170: 0,  # 'Ş'
    171: 0,  # 'Ť'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 52,  # 'Ž'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ľ'
    182: 0,  # 'ś'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 23,  # 'š'
    186: 0,  # 'ş'
    187: 0,  # 'ť'
    188: 0,  # 'ź'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 24,  # 'ž'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 60,  # 'Ć'
    199: 0,  # 'Ç'
    200: 53,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ď'
    208: 57,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ň'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 0,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 21,  # 'ć'
    231: 0,  # 'ç'
    232: 20,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ď'
    240: 28,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ň'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 0,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_2_CROATIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-2",
    language="Croatian",
    char_to_order_map=ISO_8859_2_CROATIAN_CHAR_TO_ORDER,
    language_model=CROATIAN_LANG_MODEL,
    typical_positive_ratio=0.9896619147584043,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĆćČčĐđŠšŽž",
)

ISO_8859_16_CROATIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 40,  # 'A'
    66: 38,  # 'B'
    67: 48,  # 'C'
    68: 33,  # 'D'
    69: 45,  # 'E'
    70: 49,  # 'F'
    71: 44,  # 'G'
    72: 30,  # 'H'
    73: 39,  # 'I'
    74: 46,  # 'J'
    75: 36,  # 'K'
    76: 47,  # 'L'
    77: 35,  # 'M'
    78: 29,  # 'N'
    79: 32,  # 'O'
    80: 26,  # 'P'
    81: 62,  # 'Q'
    82: 43,  # 'R'
    83: 27,  # 'S'
    84: 37,  # 'T'
    85: 34,  # 'U'
    86: 41,  # 'V'
    87: 55,  # 'W'
    88: 58,  # 'X'
    89: 59,  # 'Y'
    90: 42,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 22,  # 'c'
    100: 13,  # 'd'
    101: 3,  # 'e'
    102: 31,  # 'f'
    103: 18,  # 'g'
    104: 25,  # 'h'
    105: 2,  # 'i'
    106: 6,  # 'j'
    107: 11,  # 'k'
    108: 14,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 61,  # 'q'
    114: 8,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 12,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 51,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ą'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '„'
    166: 50,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 23,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ș'
    171: CharacterCategory.SYMBOL,  # '«'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'ź'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 53,  # 'Č'
    179: 0,  # 'ł'
    180: 52,  # 'Ž'
    181: CharacterCategory.SYMBOL,  # '”'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 24,  # 'ž'
    185: 20,  # 'č'
    186: 0,  # 'ș'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 60,  # 'Ć'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 57,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: 0,  # 'Ś'
    216: 0,  # 'Ű'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ę'
    222: 0,  # 'Ț'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 21,  # 'ć'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 28,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: 0,  # 'ś'
    248: 0,  # 'ű'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ę'
    254: 0,  # 'ț'
    255: 0,  # 'ÿ'
}

ISO_8859_16_CROATIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-16",
    language="Croatian",
    char_to_order_map=ISO_8859_16_CROATIAN_CHAR_TO_ORDER,
    language_model=CROATIAN_LANG_MODEL,
    typical_positive_ratio=0.9896619147584043,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĆćČčĐđŠšŽž",
)

MACLATIN2_CROATIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 40,  # 'A'
    66: 38,  # 'B'
    67: 48,  # 'C'
    68: 33,  # 'D'
    69: 45,  # 'E'
    70: 49,  # 'F'
    71: 44,  # 'G'
    72: 30,  # 'H'
    73: 39,  # 'I'
    74: 46,  # 'J'
    75: 36,  # 'K'
    76: 47,  # 'L'
    77: 35,  # 'M'
    78: 29,  # 'N'
    79: 32,  # 'O'
    80: 26,  # 'P'
    81: 62,  # 'Q'
    82: 43,  # 'R'
    83: 27,  # 'S'
    84: 37,  # 'T'
    85: 34,  # 'U'
    86: 41,  # 'V'
    87: 55,  # 'W'
    88: 58,  # 'X'
    89: 59,  # 'Y'
    90: 42,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 22,  # 'c'
    100: 13,  # 'd'
    101: 3,  # 'e'
    102: 31,  # 'f'
    103: 18,  # 'g'
    104: 25,  # 'h'
    105: 2,  # 'i'
    106: 6,  # 'j'
    107: 11,  # 'k'
    108: 14,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 61,  # 'q'
    114: 8,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 12,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 51,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Ā'
    130: 0,  # 'ā'
    131: 0,  # 'É'
    132: 0,  # 'Ą'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 0,  # 'ą'
    137: 53,  # 'Č'
    138: 0,  # 'ä'
    139: 20,  # 'č'
    140: 60,  # 'Ć'
    141: 21,  # 'ć'
    142: 0,  # 'é'
    143: 0,  # 'Ź'
    144: 0,  # 'ź'
    145: 0,  # 'Ď'
    146: 0,  # 'í'
    147: 0,  # 'ď'
    148: 0,  # 'Ē'
    149: 0,  # 'ē'
    150: 0,  # 'Ė'
    151: 0,  # 'ó'
    152: 0,  # 'ė'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 0,  # 'Ě'
    158: 0,  # 'ě'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ę'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'ę'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'ģ'
    175: 0,  # 'Į'
    176: 0,  # 'į'
    177: 0,  # 'Ī'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'ī'
    181: 0,  # 'Ķ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: 0,  # 'ł'
    185: 0,  # 'Ļ'
    186: 0,  # 'ļ'
    187: 0,  # 'Ľ'
    188: 0,  # 'ľ'
    189: 0,  # 'Ĺ'
    190: 0,  # 'ĺ'
    191: 0,  # 'Ņ'
    192: 0,  # 'ņ'
    193: 0,  # 'Ń'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ń'
    197: 0,  # 'Ň'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'ň'
    204: 0,  # 'Ő'
    205: 0,  # 'Õ'
    206: 0,  # 'ő'
    207: 0,  # 'Ō'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ō'
    217: 0,  # 'Ŕ'
    218: 0,  # 'ŕ'
    219: 0,  # 'Ř'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ř'
    223: 0,  # 'Ŗ'
    224: 0,  # 'ŗ'
    225: 50,  # 'Š'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: 23,  # 'š'
    229: 0,  # 'Ś'
    230: 0,  # 'ś'
    231: 0,  # 'Á'
    232: 0,  # 'Ť'
    233: 0,  # 'ť'
    234: 0,  # 'Í'
    235: 52,  # 'Ž'
    236: 24,  # 'ž'
    237: 0,  # 'Ū'
    238: 0,  # 'Ó'
    239: 0,  # 'Ô'
    240: 0,  # 'ū'
    241: 0,  # 'Ů'
    242: 0,  # 'Ú'
    243: 0,  # 'ů'
    244: 0,  # 'Ű'
    245: 0,  # 'ű'
    246: 0,  # 'Ų'
    247: 0,  # 'ų'
    248: 0,  # 'Ý'
    249: 0,  # 'ý'
    250: 0,  # 'ķ'
    251: 0,  # 'Ż'
    252: 0,  # 'Ł'
    253: 0,  # 'ż'
    254: 0,  # 'Ģ'
    255: 0,  # 'ˇ'
}

MACLATIN2_CROATIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacLatin2",
    language="Croatian",
    char_to_order_map=MACLATIN2_CROATIAN_CHAR_TO_ORDER,
    language_model=CROATIAN_LANG_MODEL,
    typical_positive_ratio=0.9897226576201978,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĆćČčĐđŠšŽž",
)

WINDOWS_1250_CROATIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 40,  # 'A'
    66: 38,  # 'B'
    67: 48,  # 'C'
    68: 33,  # 'D'
    69: 45,  # 'E'
    70: 49,  # 'F'
    71: 44,  # 'G'
    72: 30,  # 'H'
    73: 39,  # 'I'
    74: 46,  # 'J'
    75: 36,  # 'K'
    76: 47,  # 'L'
    77: 35,  # 'M'
    78: 29,  # 'N'
    79: 32,  # 'O'
    80: 26,  # 'P'
    81: 62,  # 'Q'
    82: 43,  # 'R'
    83: 27,  # 'S'
    84: 37,  # 'T'
    85: 34,  # 'U'
    86: 41,  # 'V'
    87: 55,  # 'W'
    88: 58,  # 'X'
    89: 59,  # 'Y'
    90: 42,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 22,  # 'c'
    100: 13,  # 'd'
    101: 3,  # 'e'
    102: 31,  # 'f'
    103: 18,  # 'g'
    104: 25,  # 'h'
    105: 2,  # 'i'
    106: 6,  # 'j'
    107: 11,  # 'k'
    108: 14,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 61,  # 'q'
    114: 8,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 12,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 51,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 50,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Ś'
    141: 0,  # 'Ť'
    142: 52,  # 'Ž'
    143: 0,  # 'Ź'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 23,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'ś'
    157: 0,  # 'ť'
    158: 24,  # 'ž'
    159: 0,  # 'ź'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'ˇ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ą'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ş'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ą'
    186: 0,  # 'ş'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Ľ'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ľ'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 60,  # 'Ć'
    199: 0,  # 'Ç'
    200: 53,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ď'
    208: 57,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ň'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 0,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 21,  # 'ć'
    231: 0,  # 'ç'
    232: 20,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ď'
    240: 28,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ň'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 0,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1250_CROATIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1250",
    language="Croatian",
    char_to_order_map=WINDOWS_1250_CROATIAN_CHAR_TO_ORDER,
    language_model=CROATIAN_LANG_MODEL,
    typical_positive_ratio=0.9896619147584043,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĆćČčĐđŠšŽž",
)
