/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.PseudoCylindricalProjection;

public class LoximuthalProjection
extends PseudoCylindricalProjection {
    private static final double FC = 0.9213177319235613;
    private static final double RP = 0.3183098861837907;
    private static final double EPS = 1.0E-8;
    private double phi1 = Math.toRadians(40.0);
    private double cosphi1 = Math.cos(this.phi1);
    private double tanphi1 = Math.tan(0.7853981633974483 + 0.5 * this.phi1);

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double x;
        double y = lpphi - this.phi1;
        x = y < 1.0E-8 ? lplam * this.cosphi1 : (Math.abs(x = 0.7853981633974483 + 0.5 * lpphi) < 1.0E-8 || Math.abs(Math.abs(x) - 1.5707963267948966) < 1.0E-8 ? 0.0 : lplam * y / Math.log(Math.tan(x) / this.tanphi1));
        out.x = x;
        out.y = y;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double longitude;
        double latitude = xyy + this.phi1;
        longitude = Math.abs(xyy) < 1.0E-8 ? xyx / this.cosphi1 : (Math.abs(longitude = 0.7853981633974483 + 0.5 * xyy) < 1.0E-8 || Math.abs(Math.abs(xyx) - 1.5707963267948966) < 1.0E-8 ? 0.0 : xyx * Math.log(Math.tan(longitude) / this.tanphi1) / xyy);
        out.x = longitude;
        out.y = latitude;
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Loximuthal";
    }
}

