/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlushCallback;
import software.amazon.awssdk.crt.eventstream.MessageType;

public class ServerConnection
extends CrtResource {
    CompletableFuture<Integer> closedFuture = new CompletableFuture();

    ServerConnection(long connectionPtr) {
        ServerConnection.acquire(connectionPtr);
        this.acquireNativeHandle(connectionPtr);
    }

    public boolean isConnectionOpen() {
        if (this.isNull()) {
            return false;
        }
        return ServerConnection.isOpen(this.getNativeHandle());
    }

    public void closeConnection(int shutdownError) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        ServerConnection.closeConnection(this.getNativeHandle(), shutdownError);
    }

    public CompletableFuture<Void> sendProtocolMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        final CompletableFuture<Void> messageFlush = new CompletableFuture<Void>();
        this.sendProtocolMessage(headers, payload, messageType, messageFlags, new MessageFlushCallback(){

            @Override
            public void onCallbackInvoked(int errorCode) {
                if (errorCode == 0) {
                    messageFlush.complete(null);
                } else {
                    messageFlush.completeExceptionally(new CrtRuntimeException(errorCode));
                }
            }
        });
        return messageFlush;
    }

    public void sendProtocolMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags, MessageFlushCallback callback) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        byte[] headersBuf = headers != null ? Header.marshallHeadersForJNI(headers) : null;
        int result = ServerConnection.sendProtocolMessage(this.getNativeHandle(), headersBuf, payload, messageType.getEnumValue(), messageFlags, callback);
        if (result != 0) {
            int errorCode = CRT.awsLastError();
            throw new CrtRuntimeException(errorCode);
        }
    }

    public CompletableFuture<Integer> getClosedFuture() {
        return this.closedFuture;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ServerConnection.release(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native void acquire(long var0);

    private static native void release(long var0);

    private static native void closeConnection(long var0, int var2);

    private static native boolean isOpen(long var0);

    private static native int sendProtocolMessage(long var0, byte[] var2, byte[] var3, int var4, int var5, MessageFlushCallback var6);
}

