/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContainerTokenIdentifier
extends TokenIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTokenIdentifier.class);
    public static final Text KIND = new Text("ContainerToken");
    private YarnSecurityTokenProtos.ContainerTokenIdentifierProto proto;

    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime) {
        this(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, null, "", ContainerType.TASK);
    }

    @Deprecated
    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext) {
        this(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, logAggregationContext, "");
    }

    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext, String nodeLabelExpression) {
        this(containerID, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, logAggregationContext, nodeLabelExpression, ContainerType.TASK);
    }

    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext, String nodeLabelExpression, ContainerType containerType) {
        this(containerID, 0, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, logAggregationContext, nodeLabelExpression, containerType, ExecutionType.GUARANTEED, -1L, null);
    }

    public ContainerTokenIdentifier(ContainerId containerID, int containerVersion, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext, String nodeLabelExpression, ContainerType containerType, ExecutionType executionType) {
        this(containerID, containerVersion, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, logAggregationContext, nodeLabelExpression, containerType, executionType, -1L, null);
    }

    public ContainerTokenIdentifier(ContainerId containerID, int containerVersion, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext, String nodeLabelExpression, ContainerType containerType, ExecutionType executionType, long allocationRequestId) {
        this(containerID, containerVersion, hostName, appSubmitter, r, expiryTimeStamp, masterKeyId, rmIdentifier, priority, creationTime, logAggregationContext, nodeLabelExpression, containerType, executionType, allocationRequestId, null);
    }

    public ContainerTokenIdentifier(ContainerId containerID, int containerVersion, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext, String nodeLabelExpression, ContainerType containerType, ExecutionType executionType, long allocationRequestId, Set<String> allocationTags) {
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.newBuilder();
        if (containerID != null) {
            builder.setContainerId(((ContainerIdPBImpl)containerID).getProto());
        }
        builder.setVersion(containerVersion);
        builder.setNmHostAddr(hostName);
        builder.setAppSubmitter(appSubmitter);
        if (r != null) {
            builder.setResource(ProtoUtils.convertToProtoFormat(r));
        }
        builder.setExpiryTimeStamp(expiryTimeStamp);
        builder.setMasterKeyId(masterKeyId);
        builder.setRmIdentifier(rmIdentifier);
        if (priority != null) {
            builder.setPriority(((PriorityPBImpl)priority).getProto());
        }
        builder.setCreationTime(creationTime);
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)logAggregationContext).getProto());
        }
        if (nodeLabelExpression != null) {
            builder.setNodeLabelExpression(nodeLabelExpression);
        }
        builder.setContainerType(this.convertToProtoFormat(containerType));
        builder.setExecutionType(this.convertToProtoFormat(executionType));
        builder.setAllocationRequestId(allocationRequestId);
        if (allocationTags != null) {
            builder.addAllAllocationTags(allocationTags);
        }
        this.proto = builder.build();
    }

    public ContainerTokenIdentifier() {
    }

    public ContainerId getContainerID() {
        if (!this.proto.hasContainerId()) {
            return null;
        }
        return new ContainerIdPBImpl(this.proto.getContainerId());
    }

    public String getApplicationSubmitter() {
        return this.proto.getAppSubmitter();
    }

    public String getNmHostAddress() {
        return this.proto.getNmHostAddr();
    }

    public Resource getResource() {
        if (!this.proto.hasResource()) {
            return null;
        }
        return new ResourcePBImpl(this.proto.getResource());
    }

    public long getExpiryTimeStamp() {
        return this.proto.getExpiryTimeStamp();
    }

    public int getMasterKeyId() {
        return this.proto.getMasterKeyId();
    }

    public Priority getPriority() {
        if (!this.proto.hasPriority()) {
            return null;
        }
        return new PriorityPBImpl(this.proto.getPriority());
    }

    public long getCreationTime() {
        return this.proto.getCreationTime();
    }

    public long getRMIdentifier() {
        return this.proto.getRmIdentifier();
    }

    public ContainerType getContainerType() {
        if (!this.proto.hasContainerType()) {
            return ContainerType.TASK;
        }
        return this.convertFromProtoFormat(this.proto.getContainerType());
    }

    public ExecutionType getExecutionType() {
        if (!this.proto.hasExecutionType()) {
            return ExecutionType.GUARANTEED;
        }
        return this.convertFromProtoFormat(this.proto.getExecutionType());
    }

    public YarnSecurityTokenProtos.ContainerTokenIdentifierProto getProto() {
        return this.proto;
    }

    public LogAggregationContext getLogAggregationContext() {
        if (!this.proto.hasLogAggregationContext()) {
            return null;
        }
        return new LogAggregationContextPBImpl(this.proto.getLogAggregationContext());
    }

    public long getAllocationRequestId() {
        return this.proto.getAllocationRequestId();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        LOG.debug("Writing ContainerTokenIdentifier to RPC layer: {}", (Object)this);
        out.write(this.proto.toByteArray());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        byte[] data = IOUtils.readFullyToByteArray(in);
        try {
            this.proto = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Recovering old formatted token");
            this.readFieldsInOldFormat(new DataInputStream(new ByteArrayInputStream(data)));
        }
    }

    private void readFieldsInOldFormat(DataInputStream in) throws IOException {
        YarnSecurityTokenProtos.ContainerTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.newBuilder();
        builder.setNodeLabelExpression("");
        builder.setContainerType(ProtoUtils.convertToProtoFormat(ContainerType.TASK));
        builder.setExecutionType(ProtoUtils.convertToProtoFormat(ExecutionType.GUARANTEED));
        builder.setAllocationRequestId(-1L);
        builder.setVersion(0);
        ApplicationId applicationId = ApplicationId.newInstance(in.readLong(), in.readInt());
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance(applicationId, in.readInt());
        ContainerId containerId = ContainerId.newContainerId(applicationAttemptId, in.readLong());
        builder.setContainerId(ProtoUtils.convertToProtoFormat(containerId));
        builder.setNmHostAddr(in.readUTF());
        builder.setAppSubmitter(in.readUTF());
        int memory = in.readInt();
        int vCores = in.readInt();
        Resource resource = Resource.newInstance(memory, vCores);
        builder.setResource(ProtoUtils.convertToProtoFormat(resource));
        builder.setExpiryTimeStamp(in.readLong());
        builder.setMasterKeyId(in.readInt());
        builder.setRmIdentifier(in.readLong());
        Priority priority = Priority.newInstance(in.readInt());
        builder.setPriority(((PriorityPBImpl)priority).getProto());
        builder.setCreationTime(in.readLong());
        int logAggregationSize = -1;
        try {
            logAggregationSize = in.readInt();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (logAggregationSize != -1) {
            byte[] bytes = new byte[logAggregationSize];
            in.readFully(bytes);
            builder.setLogAggregationContext(YarnProtos.LogAggregationContextProto.parseFrom(bytes));
        }
        this.proto = builder.build();
    }

    @Override
    public Text getKind() {
        return KIND;
    }

    @Override
    public UserGroupInformation getUser() {
        String containerId = null;
        if (this.proto.hasContainerId()) {
            containerId = new ContainerIdPBImpl(this.proto.getContainerId()).toString();
        }
        return UserGroupInformation.createRemoteUser(containerId);
    }

    public int getVersion() {
        if (this.proto.hasVersion()) {
            return this.proto.getVersion();
        }
        return 0;
    }

    public String getNodeLabelExpression() {
        if (this.proto.hasNodeLabelExpression()) {
            return this.proto.getNodeLabelExpression();
        }
        return "";
    }

    public Set<String> getAllcationTags() {
        if (this.proto.getAllocationTagsList() != null) {
            return new HashSet<String>((Collection<String>)this.proto.getAllocationTagsList());
        }
        return Collections.emptySet();
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerTokenIdentifier)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private YarnProtos.ContainerTypeProto convertToProtoFormat(ContainerType containerType) {
        return ProtoUtils.convertToProtoFormat(containerType);
    }

    private ContainerType convertFromProtoFormat(YarnProtos.ContainerTypeProto containerType) {
        return ProtoUtils.convertFromProtoFormat(containerType);
    }

    private YarnProtos.ExecutionTypeProto convertToProtoFormat(ExecutionType executionType) {
        return ProtoUtils.convertToProtoFormat(executionType);
    }

    private ExecutionType convertFromProtoFormat(YarnProtos.ExecutionTypeProto executionType) {
        return ProtoUtils.convertFromProtoFormat(executionType);
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND;
        }
    }
}

