/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import org.opensearch.common.Nullable;
import org.opensearch.common.concurrent.CompletableContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpResponse;
import org.opensearch.transport.netty4.Netty4TcpChannel;

public class Netty4HttpChannel
implements HttpChannel {
    private static final InetSocketAddress NO_SOCKET_ADDRESS = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
    private static final String CHANNEL_PROPERTY = "channel";
    private static final String SSL_ENGINE_PROPERTY = "ssl_engine";
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private final ChannelPipeline inboundPipeline;
    private final AttributeKey<SSLEngine> sslEngineKey;

    Netty4HttpChannel(Channel channel) {
        this(channel, null, null);
    }

    Netty4HttpChannel(Channel channel, AttributeKey<SSLEngine> sslEngineKey) {
        this(channel, null, sslEngineKey);
    }

    Netty4HttpChannel(Channel channel, ChannelPipeline inboundPipeline) {
        this(channel, inboundPipeline, null);
    }

    Netty4HttpChannel(Channel channel, ChannelPipeline inboundPipeline, AttributeKey<SSLEngine> sslEngineKey) {
        this.channel = channel;
        this.inboundPipeline = inboundPipeline;
        this.sslEngineKey = sslEngineKey;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
    }

    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.channel.writeAndFlush((Object)response, Netty4TcpChannel.addPromise(listener, this.channel));
    }

    public InetSocketAddress getLocalAddress() {
        SocketAddress socketAddress = this.channel.localAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            return isa;
        }
        return this.getAddressFromParent(this.channel, Channel::localAddress);
    }

    public InetSocketAddress getRemoteAddress() {
        SocketAddress socketAddress = this.channel.remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            return isa;
        }
        InetSocketAddress address = this.getAddressFromParent(this.channel, Channel::remoteAddress);
        if (address == null && this.channel.remoteAddress() != null) {
            return NO_SOCKET_ADDRESS;
        }
        return address;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    @Nullable
    public ChannelPipeline inboundPipeline() {
        return this.inboundPipeline;
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public <T> Optional<T> get(String name, Class<T> clazz) {
        ChannelHandler handler;
        if (CHANNEL_PROPERTY.equalsIgnoreCase(name) && clazz.isAssignableFrom(Channel.class)) {
            return Optional.of(this.getNettyChannel());
        }
        if (this.sslEngineKey != null && SSL_ENGINE_PROPERTY.equalsIgnoreCase(name) && clazz.isAssignableFrom(SSLEngine.class)) {
            SSLEngine engine = (SSLEngine)this.channel.attr(this.sslEngineKey).get();
            if (engine == null && this.channel.parent() != null) {
                engine = (SSLEngine)this.channel.parent().attr(this.sslEngineKey).get();
            }
            if (engine != null) {
                return Optional.of(engine);
            }
        }
        if ((handler = this.getNettyChannel().pipeline().get(name)) == null && this.inboundPipeline() != null) {
            handler = this.inboundPipeline().get(name);
        }
        if (handler != null && clazz.isInstance(handler)) {
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + String.valueOf(this.getLocalAddress()) + ", remoteAddress=" + String.valueOf(this.getRemoteAddress()) + "}";
    }

    private InetSocketAddress getAddressFromParent(Channel channel, Function<Channel, SocketAddress> socketAddressSupplier) {
        Channel parent = channel.parent();
        if (parent != null) {
            SocketAddress socketAddress = socketAddressSupplier.apply(parent);
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                return isa;
            }
            return this.getAddressFromParent(parent, socketAddressSupplier);
        }
        return null;
    }
}

