/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.session;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLCreateSessionInput
implements ToXContentObject,
Writeable {
    private String sessionId;
    private String ownerId;
    private String summary;
    private Map<String, Object> metadata;
    private Map<String, Object> agents;
    private Map<String, Object> additionalInfo;
    private Map<String, String> namespace;
    private String tenantId;
    private String memoryContainerId;

    public MLCreateSessionInput(String sessionId, String ownerId, String summary, Map<String, Object> metadata, Map<String, Object> agents, Map<String, Object> additionalInfo, Map<String, String> namespace, String tenantId, String memoryContainerId) {
        this.sessionId = sessionId;
        this.ownerId = ownerId;
        this.summary = summary;
        this.metadata = metadata;
        this.agents = agents;
        this.additionalInfo = additionalInfo;
        this.namespace = namespace;
        this.tenantId = tenantId;
        this.memoryContainerId = memoryContainerId;
    }

    public MLCreateSessionInput(StreamInput in) throws IOException {
        this.sessionId = in.readOptionalString();
        this.ownerId = in.readOptionalString();
        this.summary = in.readOptionalString();
        if (in.readBoolean()) {
            this.metadata = in.readMap();
        }
        if (in.readBoolean()) {
            this.agents = in.readMap();
        }
        if (in.readBoolean()) {
            this.additionalInfo = in.readMap();
        }
        if (in.readBoolean()) {
            this.namespace = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.tenantId = in.readOptionalString();
        this.memoryContainerId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.sessionId);
        out.writeOptionalString(this.ownerId);
        out.writeOptionalString(this.summary);
        if (this.metadata != null) {
            out.writeBoolean(true);
            out.writeMap(this.metadata);
        } else {
            out.writeBoolean(false);
        }
        if (this.agents != null) {
            out.writeBoolean(true);
            out.writeMap(this.agents);
        } else {
            out.writeBoolean(false);
        }
        if (this.additionalInfo != null) {
            out.writeBoolean(true);
            out.writeMap(this.additionalInfo);
        } else {
            out.writeBoolean(false);
        }
        if (this.namespace != null) {
            out.writeBoolean(true);
            out.writeMap(this.namespace, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
        out.writeOptionalString(this.memoryContainerId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.sessionId != null) {
            builder.field("session_id", this.sessionId);
        }
        if (this.ownerId != null) {
            builder.field("owner_id", this.ownerId);
        }
        if (this.summary != null) {
            builder.field("summary", this.summary);
        }
        if (this.metadata != null) {
            builder.field("metadata", this.metadata);
        }
        if (this.metadata != null) {
            builder.field("agents", this.agents);
        }
        if (this.additionalInfo != null) {
            builder.field("additional_info", this.additionalInfo);
        }
        if (this.namespace != null) {
            builder.field("namespace", this.namespace);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLCreateSessionInput parse(XContentParser parser) throws IOException {
        String sessionId = null;
        String ownerId = null;
        String summary = null;
        Map metadata = null;
        Map agents = null;
        Map additionalInfo = null;
        Map namespace = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "session_id": {
                    sessionId = parser.text();
                    continue block20;
                }
                case "owner_id": {
                    ownerId = parser.text();
                    continue block20;
                }
                case "summary": {
                    summary = parser.text();
                    continue block20;
                }
                case "metadata": {
                    metadata = parser.map();
                    continue block20;
                }
                case "agents": {
                    agents = parser.map();
                    continue block20;
                }
                case "additional_info": {
                    additionalInfo = parser.map();
                    continue block20;
                }
                case "namespace": {
                    namespace = parser.mapStrings();
                    continue block20;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return MLCreateSessionInput.builder().sessionId(sessionId).ownerId(ownerId).summary(summary).metadata(metadata).agents(agents).additionalInfo(additionalInfo).namespace(namespace).tenantId(tenantId).build();
    }

    @Generated
    public static MLCreateSessionInputBuilder builder() {
        return new MLCreateSessionInputBuilder();
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, Object> getAgents() {
        return this.agents;
    }

    @Generated
    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public Map<String, String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setAgents(Map<String, Object> agents) {
        this.agents = agents;
    }

    @Generated
    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Generated
    public void setNamespace(Map<String, String> namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public static class MLCreateSessionInputBuilder {
        @Generated
        private String sessionId;
        @Generated
        private String ownerId;
        @Generated
        private String summary;
        @Generated
        private Map<String, Object> metadata;
        @Generated
        private Map<String, Object> agents;
        @Generated
        private Map<String, Object> additionalInfo;
        @Generated
        private Map<String, String> namespace;
        @Generated
        private String tenantId;
        @Generated
        private String memoryContainerId;

        @Generated
        MLCreateSessionInputBuilder() {
        }

        @Generated
        public MLCreateSessionInputBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder agents(Map<String, Object> agents) {
            this.agents = agents;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder additionalInfo(Map<String, Object> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder namespace(Map<String, String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLCreateSessionInputBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLCreateSessionInput build() {
            return new MLCreateSessionInput(this.sessionId, this.ownerId, this.summary, this.metadata, this.agents, this.additionalInfo, this.namespace, this.tenantId, this.memoryContainerId);
        }

        @Generated
        public String toString() {
            return "MLCreateSessionInput.MLCreateSessionInputBuilder(sessionId=" + this.sessionId + ", ownerId=" + this.ownerId + ", summary=" + this.summary + ", metadata=" + String.valueOf(this.metadata) + ", agents=" + String.valueOf(this.agents) + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ", namespace=" + String.valueOf(this.namespace) + ", tenantId=" + this.tenantId + ", memoryContainerId=" + this.memoryContainerId + ")";
        }
    }
}

