/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.streaming;

import java.util.Collection;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Setting;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.streaming.FlushMode;
import org.opensearch.search.streaming.StreamingCostMetrics;

@ExperimentalApi
public final class FlushModeResolver {
    public static final Setting<Integer> STREAMING_AGGREGATION_MIN_SEGMENT_SIZE_SETTING = Setting.intSetting("index.aggregation.streaming.min_segment_size", 1000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> STREAMING_MAX_ESTIMATED_BUCKET_COUNT = Setting.longSetting("search.aggregations.streaming.max_estimated_bucket_count", 100000L, 1L, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> STREAMING_MIN_CARDINALITY_RATIO = Setting.doubleSetting("search.aggregations.streaming.min_cardinality_ratio", 0.01, 0.0, 1.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Long> STREAMING_MIN_ESTIMATED_BUCKET_COUNT = Setting.longSetting("search.aggregations.streaming.min_estimated_bucket_count", 1000L, 1L, Setting.Property.NodeScope, Setting.Property.Dynamic);

    private FlushModeResolver() {
    }

    public static FlushMode decideFlushMode(StreamingCostMetrics metrics, FlushMode defaultMode, long maxBucketCount) {
        if (!metrics.streamable()) {
            return defaultMode;
        }
        if ((long)metrics.topNSize() <= maxBucketCount) {
            return FlushMode.PER_SEGMENT;
        }
        return defaultMode;
    }

    public static boolean isStreamable(AggregatorFactories.Builder aggregations) {
        if (aggregations == null || aggregations.count() == 0) {
            return false;
        }
        Collection<AggregationBuilder> topLevelAggs = aggregations.getAggregatorFactories();
        for (AggregationBuilder agg : topLevelAggs) {
            if (FlushModeResolver.isTopLevelStreamable(agg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTopLevelStreamable(AggregationBuilder agg) {
        if (!(agg instanceof TermsAggregationBuilder)) {
            return false;
        }
        Collection<AggregationBuilder> subAggs = agg.getSubAggregations();
        for (AggregationBuilder subAgg : subAggs) {
            if (FlushModeResolver.isSubAggregationStreamable(subAgg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSubAggregationStreamable(AggregationBuilder agg) {
        if (agg instanceof TermsAggregationBuilder) {
            for (AggregationBuilder nestedAgg : agg.getSubAggregations()) {
                if (FlushModeResolver.isMetricAggregation(nestedAgg)) continue;
                return false;
            }
            return true;
        }
        return FlushModeResolver.isMetricAggregation(agg);
    }

    private static boolean isMetricAggregation(AggregationBuilder agg) {
        return agg instanceof CardinalityAggregationBuilder || agg instanceof MaxAggregationBuilder || agg instanceof MinAggregationBuilder || agg instanceof SumAggregationBuilder;
    }
}

